/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.persistence.editor.completion;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.font.TextAttribute;
import java.text.AttributedString;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class CCPaintComponent
extends JPanel {
    static final String COLUMN_ICON = "org/netbeans/modules/j2ee/persistence/editor/completion/resources/column.gif";
    static final String TABLE_ICON = "org/netbeans/modules/j2ee/persistence/editor/completion/resources/table.gif";
    static final String NOCONNECTION_ICON = "org/netbeans/modules/j2ee/persistence/editor/completion/resources/connectionDisconnected.gif";
    static final String CONNECTION_ICON = "org/netbeans/modules/j2ee/persistence/ui/resources/connection.gif";
    static final String PU_ICON = "org/netbeans/modules/j2ee/persistence/ui/resources/EntityNodeIcon.gif";
    private static final int ICON_WIDTH = 16;
    private static final int ICON_TEXT_GAP = 5;
    protected int drawX;
    protected int drawY;
    protected int drawHeight;
    private Font drawFont;
    private int fontHeight;
    private int ascent;
    private Map widths;
    private FontMetrics fontMetrics;
    private boolean isSelected;
    private boolean isDeprecated;
    private static final String THROWS = " throws ";
    private static final String[] frequentWords = new String[]{"", " ", "[]", "(", ")", ", ", "String", " throws "};
    public static final Color KEYWORD_COLOR = Color.darkGray;
    public static final Color TYPE_COLOR = Color.black;
    static final Color ENCLOSING_CALL_COLOR = Color.gray;
    static final Color ACTIVE_PARAMETER_COLOR = Color.black;

    public CCPaintComponent() {
        this.setOpaque(true);
        this.setBorder(BorderFactory.createEmptyBorder(0, 3, 0, 3));
    }

    protected void setSelected(boolean isSelected) {
        this.isSelected = isSelected;
    }

    protected void setDeprecated(boolean isDeprecated) {
        this.isDeprecated = isDeprecated;
    }

    protected boolean isSelected() {
        return this.isSelected;
    }

    protected boolean isDeprecated() {
        return this.isDeprecated;
    }

    @Override
    public void paintComponent(Graphics g) {
        g.setColor(this.getBackground());
        Rectangle r = g.getClipBounds();
        g.fillRect(r.x, r.y, r.width, r.height);
        this.draw(g);
    }

    protected void draw(Graphics g) {
    }

    protected void drawIcon(Graphics g, Icon icon) {
        Insets i = this.getInsets();
        if (i != null) {
            this.drawX = i.left;
            this.drawY = i.top;
        } else {
            this.drawX = 0;
            this.drawY = 0;
        }
        if (icon != null) {
            if (g != null) {
                icon.paintIcon(this, g, this.drawX, this.drawY);
            }
            this.drawHeight = Math.max(this.fontHeight, icon.getIconHeight());
        } else {
            this.drawHeight = this.fontHeight;
        }
        this.drawX += 21;
        if (i != null) {
            this.drawHeight += i.bottom;
        }
        this.drawHeight += this.drawY;
        this.drawY += this.ascent;
    }

    protected void drawString(Graphics g, String s) {
        this.drawString(g, s, false);
    }

    protected void drawString(Graphics g, String s, boolean strike) {
        if (g != null) {
            g.setColor(this.getForeground());
        }
        this.drawStringToGraphics(g, s, null, strike);
    }

    protected void drawString(Graphics g, String s, Color c) {
        if (g != null) {
            g.setColor(this.getColor(s, c));
        }
        this.drawStringToGraphics(g, s);
    }

    protected void drawString(Graphics g, String s, Color c, Font font, boolean strike) {
        if (g != null) {
            g.setColor(this.getColor(s, c));
            g.setFont(font);
        }
        this.drawStringToGraphics(g, s, font, strike);
        if (g != null) {
            g.setFont(this.drawFont);
        }
    }

    protected void drawTypeName(Graphics g, String s, Color c) {
        if (g == null) {
            this.drawString(g, "   ");
            this.drawString(g, s, c);
        } else {
            int spaceWidth;
            int w = this.getWidth() - this.getWidth(s) - this.drawX;
            if (w > (spaceWidth = this.getWidth(" ")) * 2) {
                this.drawX = this.getWidth() - 2 * spaceWidth - this.getWidth(s);
            } else {
                this.drawX = this.getWidth() - 2 * spaceWidth - this.getWidth(s) - this.getWidth("...   ");
                g.setColor(this.getBackground());
                g.fillRect(this.drawX, 0, this.getWidth() - this.drawX, this.getHeight());
                this.drawString(g, "...   ", c);
            }
            this.drawString(g, s, c);
        }
    }

    protected void drawStringToGraphics(Graphics g, String s) {
        this.drawStringToGraphics(g, s, null, false);
    }

    protected void drawStringToGraphics(Graphics g, String s, Font font, boolean strike) {
        if (g != null) {
            if (!strike) {
                g.drawString(s, this.drawX, this.drawY);
            } else {
                Graphics2D g2 = (Graphics2D)g;
                AttributedString strikeText = new AttributedString(s);
                strikeText.addAttribute(TextAttribute.STRIKETHROUGH, TextAttribute.STRIKETHROUGH_ON);
                strikeText.addAttribute(TextAttribute.FONT, g.getFont());
                g2.drawString(strikeText.getIterator(), this.drawX, this.drawY);
            }
        }
        this.drawX += this.getWidth(s, font);
    }

    protected int getWidth(String s) {
        Integer i = (Integer)this.widths.get(s);
        if (i != null) {
            return i;
        }
        if (s == null) {
            s = "";
        }
        return this.fontMetrics.stringWidth(s);
    }

    protected int getWidth(String s, Font font) {
        if (font == null) {
            return this.getWidth(s);
        }
        return this.getFontMetrics(font).stringWidth(s);
    }

    protected Color getColor(String s, Color defaultColor) {
        return this.isSelected ? this.getForeground() : defaultColor;
    }

    private void storeWidth(String s) {
        this.fontMetrics.stringWidth(s);
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        this.fontMetrics = this.getFontMetrics(font);
        this.fontHeight = this.fontMetrics.getHeight();
        this.ascent = this.fontMetrics.getAscent();
        if (this.widths != null) {
            this.widths.clear();
        } else {
            this.widths = new HashMap();
        }
        for (int i = 0; i < frequentWords.length; ++i) {
            this.storeWidth(frequentWords[i]);
        }
        this.drawFont = font;
    }

    protected Font getDrawFont() {
        return this.drawFont;
    }

    @Override
    public Dimension getPreferredSize() {
        this.draw(null);
        Insets i = this.getInsets();
        if (i != null) {
            this.drawX += i.right;
        }
        if (this.drawX > this.getMaximumSize().width) {
            this.drawX = this.getMaximumSize().width;
        }
        return new Dimension(this.drawX, this.drawHeight);
    }

    public static final class AddConnectionItemPaintComponent
    extends NbStringPaintComponent {
        @Override
        protected void draw(Graphics g) {
            this.drawIcon(g, new ImageIcon(Utilities.loadImage((String)CCPaintComponent.CONNECTION_ICON)));
            this.drawString(g, NbBundle.getMessage(CCPaintComponent.class, (String)"LBL_AddConnection"), Color.BLACK, this.getDrawFont().deriveFont(1), false);
        }
    }

    public static final class ColumnElementPaintComponent
    extends NbStringPaintComponent {
        private String tableName;
        private String columnName;

        public void setContent(String columnName, String tableName) {
            this.tableName = tableName;
            this.columnName = columnName;
        }

        @Override
        protected void draw(Graphics g) {
            this.drawIcon(g, new ImageIcon(Utilities.loadImage((String)CCPaintComponent.COLUMN_ICON)));
            this.drawString(g, this.tableName + ".", Color.BLACK);
            this.drawString(g, this.columnName, Color.BLACK, this.getDrawFont().deriveFont(1), false);
        }
    }

    public static final class DBElementPaintComponent
    extends NbStringPaintComponent {
    }

    public static final class EntityPropertyElementPaintComponent
    extends NbStringPaintComponent {
        private String elName;

        public void setContent(String elName) {
            this.elName = elName;
        }

        @Override
        protected void draw(Graphics g) {
            this.drawIcon(g, new ImageIcon(Utilities.loadImage((String)CCPaintComponent.PU_ICON)));
            this.drawString(g, this.elName, Color.BLACK, this.getDrawFont().deriveFont(1), false);
        }
    }

    public static final class NamedQueryNameElementPaintComponent
    extends NbStringPaintComponent {
        private String puName;

        public void setContent(String puName) {
            this.puName = puName;
        }

        @Override
        protected void draw(Graphics g) {
            this.drawIcon(g, new ImageIcon(Utilities.loadImage((String)CCPaintComponent.PU_ICON)));
            this.drawString(g, this.puName, Color.BLACK, this.getDrawFont().deriveFont(1), false);
        }
    }

    public static class NbStringPaintComponent
    extends CCPaintComponent {
        private String str;

        public void setString(String str) {
            this.str = str;
        }

        @Override
        protected void draw(Graphics g) {
            this.drawIcon(g, null);
            this.drawString(g, this.str, TYPE_COLOR);
        }
    }

    public static final class NoConnectionItemPaintComponent
    extends NbStringPaintComponent {
        @Override
        protected void draw(Graphics g) {
            this.drawIcon(g, new ImageIcon(Utilities.loadImage((String)CCPaintComponent.NOCONNECTION_ICON)));
            this.drawString(g, NbBundle.getMessage(CCPaintComponent.class, (String)"LBL_ConnectToDatabase"), Color.RED, this.getDrawFont().deriveFont(1), false);
        }
    }

    public static final class PersistenceUnitElementPaintComponent
    extends NbStringPaintComponent {
        private String puName;

        public void setContent(String puName) {
            this.puName = puName;
        }

        @Override
        protected void draw(Graphics g) {
            this.drawIcon(g, new ImageIcon(Utilities.loadImage((String)CCPaintComponent.PU_ICON)));
            this.drawString(g, this.puName, Color.BLACK, this.getDrawFont().deriveFont(1), false);
        }
    }

    public static final class TableElementPaintComponent
    extends NbStringPaintComponent {
        private String tableName;

        public void setContent(String tableName) {
            this.tableName = tableName;
        }

        @Override
        protected void draw(Graphics g) {
            this.drawIcon(g, new ImageIcon(Utilities.loadImage((String)CCPaintComponent.TABLE_ICON)));
            this.drawString(g, this.tableName, Color.BLACK, this.getDrawFont().deriveFont(1), false);
        }
    }
}

