/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dbschema;

import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import org.netbeans.modules.dbschema.DBElement;
import org.netbeans.modules.dbschema.DBException;
import org.netbeans.modules.dbschema.DBIdentifier;
import org.netbeans.modules.dbschema.DBMemoryCollection;
import org.netbeans.modules.dbschema.SchemaElementUtil;
import org.netbeans.modules.dbschema.TableElement;
import org.netbeans.modules.dbschema.migration.archiver.XMLInputStream;
import org.netbeans.modules.dbschema.migration.archiver.XMLOutputStream;
import org.netbeans.modules.dbschema.util.IDEUtil;
import org.netbeans.modules.dbschema.util.NameUtil;
import org.openide.nodes.Node;

public class SchemaElement
extends DBElement
implements Node.Cookie {
    public static final int STATUS_NOT = 0;
    public static final int STATUS_ERROR = 1;
    public static final int STATUS_PARTIAL = 2;
    public static final int STATUS_OK = 3;
    public static final int CURRENT_VERSION_NO = 2;
    private int versionNo;
    protected static Map schemaCache = new HashMap();
    private static SchemaElement lastSchema;

    public SchemaElement() {
        this(new Memory());
    }

    public SchemaElement(Impl impl) {
        super(impl);
    }

    final Impl getSchemaImpl() {
        return (Impl)this.getElementImpl();
    }

    public boolean isCompatibleVersion() {
        return this.getVersionNo() == 2;
    }

    public int getVersionNo() {
        return this.versionNo;
    }

    public void setVersionNo(int versionNo) {
        this.versionNo = versionNo;
    }

    protected static SchemaElement getLastSchema() {
        return lastSchema;
    }

    protected static void setLastSchema(SchemaElement last) {
        lastSchema = last;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeFromCache(String name) {
        Map map = schemaCache;
        synchronized (map) {
            if (SchemaElement.getLastSchema() != null && SchemaElement.getLastSchema().getName().getFullName().equals(name)) {
                SchemaElement.setLastSchema(null);
            }
            schemaCache.remove(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addToCache(SchemaElement schema) {
        Map map = schemaCache;
        synchronized (map) {
            schemaCache.put(schema.getName().getFullName(), schema);
            SchemaElement.setLastSchema(schema);
        }
    }

    public static SchemaElement forName(String name, Object obj) {
        if (IDEUtil.isIDERunning()) {
            return SchemaElementUtil.forName(name, obj);
        }
        if (obj == null) {
            return SchemaElement.forNameInternal(name, SchemaElement.class.getClassLoader());
        }
        if (obj instanceof ClassLoader) {
            return SchemaElement.forNameInternal(name, (ClassLoader)obj);
        }
        throw new UnsupportedOperationException("Cannot lookup schema " + name + " in context of type " + obj.getClass() + " expected ClassLoader or null.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private static SchemaElement forNameInternal(String name, ClassLoader cl) {
        SchemaElement se = SchemaElement.getLastSchema();
        if (se != null && se.getName().getFullName().equals(name)) {
            return se;
        }
        Map map = schemaCache;
        // MONITORENTER : map
        se = (SchemaElement)schemaCache.get(name);
        if (se != null) {
            // MONITOREXIT : map
            return se;
        }
        InputStream is = cl.getResourceAsStream(NameUtil.getSchemaResourceName(name));
        if (is != null) {
            try {
                XMLInputStream i = new XMLInputStream(is);
                se = (SchemaElement)i.readObject();
                if (!se.isCompatibleVersion()) {
                    String message = MessageFormat.format(ResourceBundle.getBundle("org.netbeans.modules.dbschema.resources.Bundle").getString("PreviousVersion"), name);
                    System.out.println(message);
                }
                i.close();
                se.setName(DBIdentifier.create(name));
                SchemaElement.addToCache(se);
                TableElement[] tables = se.getTables();
                int size = tables != null ? tables.length : 0;
                for (int j = 0; j < size; ++j) {
                    tables[j].setDeclaringSchema(se);
                }
                return se;
            }
            catch (Exception exc) {
                if (!Boolean.getBoolean("netbeans.debug.exceptions")) return se;
                System.out.println(ResourceBundle.getBundle("org.netbeans.modules.dbschema.resources.Bundle").getString("SchemaNotFound"));
                return se;
            }
        } else if (Boolean.getBoolean("netbeans.debug.exceptions")) {
            System.out.println(ResourceBundle.getBundle("org.netbeans.modules.dbschema.resources.Bundle").getString("SchemaNotFound"));
        }
        // MONITOREXIT : map
        return se;
    }

    public static SchemaElement forName(String name) {
        return SchemaElement.forName(name, null);
    }

    public int getStatus() {
        return this.getSchemaImpl().getStatus();
    }

    public void setSchema(DBIdentifier schema) throws DBException {
        this.getSchemaImpl().setSchema(schema);
    }

    public DBIdentifier getSchema() {
        return this.getSchemaImpl().getSchema();
    }

    public void setCatalog(DBIdentifier catalog) throws DBException {
        this.getSchemaImpl().setCatalog(catalog);
    }

    public DBIdentifier getCatalog() {
        return this.getSchemaImpl().getCatalog();
    }

    public void addTable(TableElement el) throws DBException {
        this.addTables(new TableElement[]{el});
    }

    public void addTables(TableElement[] els) throws DBException {
        for (int i = 0; i < els.length; ++i) {
            if (this.getTable(els[i].getName()) != null) {
                this.throwAddException("FMT_EXC_AddTable", els[i]);
            }
            if (els[i].getDeclaringSchema() != null) continue;
            els[i].setDeclaringSchema(this);
        }
        this.getSchemaImpl().changeTables(els, 1);
    }

    public void removeTable(TableElement el) throws DBException {
        this.removeTables(new TableElement[]{el});
    }

    public void removeTables(TableElement[] els) throws DBException {
        this.getSchemaImpl().changeTables(els, -1);
    }

    public void setTables(TableElement[] els) throws DBException {
        if (els == null) {
            throw new NullPointerException(ResourceBundle.getBundle("org.netbeans.modules.dbschema.resources.Bundle").getString("NullTables"));
        }
        this.getSchemaImpl().changeTables(els, 0);
    }

    public TableElement[] getTables() {
        return this.getSchemaImpl().getTables();
    }

    public TableElement getTable(DBIdentifier name) {
        return this.getSchemaImpl().getTable(name);
    }

    private void throwAddException(String formatKey, TableElement element) throws DBException {
        String msg = element.getName().getName();
        throw new DBException(msg);
    }

    public String getUrl() {
        return this.getSchemaImpl().getUrl();
    }

    public void setUrl(String url) throws DBException {
        this.getSchemaImpl().setUrl(url);
    }

    public String getUsername() {
        return this.getSchemaImpl().getUsername();
    }

    public void setUsername(String username) throws DBException {
        this.getSchemaImpl().setUsername(username);
    }

    public String getDriver() {
        return this.getSchemaImpl().getDriver();
    }

    public void setDriver(String driver) {
        this.getSchemaImpl().setDriver(driver);
    }

    public String getDatabaseProductName() {
        return this.getSchemaImpl().getDatabaseProductName();
    }

    public void setDatabaseProductName(String databaseProductName) throws DBException {
        this.getSchemaImpl().setDatabaseProductName(databaseProductName);
    }

    public String getDatabaseProductVersion() {
        return this.getSchemaImpl().getDatabaseProductVersion();
    }

    public void setDatabaseProductVersion(String databaseProductVersion) throws DBException {
        this.getSchemaImpl().setDatabaseProductVersion(databaseProductVersion);
    }

    public String getDriverName() {
        return this.getSchemaImpl().getDriverName();
    }

    public void setDriverName(String driverName) throws DBException {
        this.getSchemaImpl().setDriverName(driverName);
    }

    public String getDriverVersion() {
        return this.getSchemaImpl().getDriverVersion();
    }

    public void setDriverVersion(String driverVersion) throws DBException {
        this.getSchemaImpl().setDriverVersion(driverVersion);
    }

    public void save(String filename) {
        this.setVersionNo(2);
        try {
            FileOutputStream s = new FileOutputStream(filename);
            XMLOutputStream o = new XMLOutputStream(s);
            o.writeObject(this);
            o.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void save(OutputStream s) {
        this.setVersionNo(2);
        try {
            XMLOutputStream o = new XMLOutputStream(s);
            o.writeObject(this);
            o.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static interface Impl
    extends DBElement.Impl {
        public int getStatus();

        public void setSchema(DBIdentifier var1) throws DBException;

        public DBIdentifier getSchema();

        public void setCatalog(DBIdentifier var1) throws DBException;

        public DBIdentifier getCatalog();

        public void changeTables(TableElement[] var1, int var2) throws DBException;

        public TableElement[] getTables();

        public TableElement getTable(DBIdentifier var1);

        public String getUrl();

        public void setUrl(String var1) throws DBException;

        public String getUsername();

        public void setUsername(String var1) throws DBException;

        public String getDriver();

        public void setDriver(String var1);

        public String getDatabaseProductName();

        public void setDatabaseProductName(String var1) throws DBException;

        public String getDatabaseProductVersion();

        public void setDatabaseProductVersion(String var1) throws DBException;

        public String getDriverName();

        public void setDriverName(String var1) throws DBException;

        public String getDriverVersion();

        public void setDriverVersion(String var1) throws DBException;
    }

    static final class Memory
    extends DBElement.Memory
    implements Impl {
        private DBMemoryCollection.Table tables;
        private DBIdentifier _catalog;
        private DBIdentifier _schema;
        private int _status;
        private String _url;
        private String _username;
        private String _driver;
        private String _databaseProductName;
        private String _databaseProductVersion;
        private String _driverName;
        private String _driverVersion;

        public Memory() {
        }

        public Memory(SchemaElement el) {
            super(el);
            this._catalog = el.getCatalog();
            this._schema = el.getSchema();
            this._status = el.getStatus();
            this._url = el.getUrl();
            this._username = el.getUsername();
            this._driver = el.getDriver();
            this._databaseProductName = el.getDatabaseProductName();
            this._databaseProductVersion = el.getDatabaseProductVersion();
            this._driverName = el.getDriverName();
            this._driverVersion = el.getDriverVersion();
        }

        public void copyFrom(SchemaElement copyFrom) throws DBException {
            this.changeTables(copyFrom.getTables(), 0);
        }

        @Override
        public synchronized void changeTables(TableElement[] elems, int action) throws DBException {
            this.initTables();
            this.tables.change(elems, action);
        }

        @Override
        public synchronized TableElement[] getTables() {
            this.initTables();
            return (TableElement[])this.tables.getElements();
        }

        @Override
        public synchronized TableElement getTable(DBIdentifier name) {
            this.initTables();
            return (TableElement)this.tables.getElement(name);
        }

        void initTables() {
            if (this.tables == null) {
                this.tables = new DBMemoryCollection.Table(this);
            }
        }

        final SchemaElement getSchemaElement() {
            return (SchemaElement)this._element;
        }

        @Override
        public int getStatus() {
            return this._status;
        }

        @Override
        public void setSchema(DBIdentifier id) throws DBException {
            DBIdentifier old = this._schema;
            this._schema = id;
            this.firePropertyChange("schema", old, id);
        }

        @Override
        public DBIdentifier getSchema() {
            if (this._schema == null) {
                this._schema = DBIdentifier.create("");
            }
            return this._schema;
        }

        @Override
        public void setCatalog(DBIdentifier id) throws DBException {
            DBIdentifier old = this._catalog;
            this._catalog = id;
            this.firePropertyChange("catalog", old, id);
        }

        @Override
        public DBIdentifier getCatalog() {
            if (this._catalog == null) {
                this._catalog = DBIdentifier.create("");
            }
            return this._catalog;
        }

        @Override
        public String getUrl() {
            return this._url;
        }

        @Override
        public void setUrl(String url) throws DBException {
            this._url = url;
        }

        @Override
        public String getUsername() {
            return this._username;
        }

        @Override
        public void setUsername(String username) throws DBException {
            this._username = username;
        }

        @Override
        public String getDriver() {
            return this._driverName;
        }

        @Override
        public void setDriver(String driver) {
            this._driver = driver;
        }

        @Override
        public String getDatabaseProductName() {
            return this._databaseProductName;
        }

        @Override
        public void setDatabaseProductName(String databaseProductName) throws DBException {
            this._databaseProductName = databaseProductName;
        }

        @Override
        public String getDatabaseProductVersion() {
            return this._databaseProductVersion;
        }

        @Override
        public void setDatabaseProductVersion(String databaseProductVersion) throws DBException {
            this._databaseProductVersion = databaseProductVersion;
        }

        @Override
        public String getDriverName() {
            return this._driverName;
        }

        @Override
        public void setDriverName(String driverName) throws DBException {
            this._driverName = driverName;
        }

        @Override
        public String getDriverVersion() {
            return this._driverVersion;
        }

        @Override
        public void setDriverVersion(String driverVersion) throws DBException {
            this._driverVersion = driverVersion;
        }
    }
}

