/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.earproject.ui;

import java.awt.Image;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.Action;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.queries.VisibilityQuery;
import org.netbeans.modules.j2ee.spi.ejbjar.support.J2eeProjectView;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.openide.actions.FindAction;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.ChangeableDataFilter;
import org.openide.loaders.DataFilter;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.ChangeSupport;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;

class ArchiveViews {
    private ArchiveViews() {
    }

    private static final class DocBaseNode
    extends FilterNode {
        private static final DataFilter VISIBILITY_QUERY_FILTER = new VisibilityQueryDataFilter();
        private final Image CONFIGURATION_FILES_BADGE = ImageUtilities.loadImage((String)"org/netbeans/modules/j2ee/earproject/ui/resources/archive.gif", (boolean)true);

        public DocBaseNode(DataFolder folder) {
            super(folder.getNodeDelegate(), folder.createNodeChildren(VISIBILITY_QUERY_FILTER));
        }

        public Image getIcon(int type) {
            return this.computeIcon(false, type);
        }

        public Image getOpenedIcon(int type) {
            return this.computeIcon(true, type);
        }

        private Image computeIcon(boolean opened, int type) {
            Node folderNode = this.getOriginal();
            Image image = opened ? folderNode.getOpenedIcon(type) : folderNode.getIcon(type);
            return ImageUtilities.mergeImages((Image)image, (Image)this.CONFIGURATION_FILES_BADGE, (int)7, (int)7);
        }

        public boolean canCopy() {
            return false;
        }

        public boolean canCut() {
            return false;
        }

        public boolean canRename() {
            return false;
        }

        public boolean canDestroy() {
            return false;
        }

        public Action[] getActions(boolean context) {
            return new Action[]{SystemAction.get(FindAction.class)};
        }

        public String getDisplayName() {
            return NbBundle.getMessage(ArchiveViews.class, (String)"LBL_Node_DocBase");
        }
    }

    static final class LogicalViewChildren
    extends Children.Keys<String>
    implements FileChangeListener {
        private static final String KEY_DOC_BASE = "docBase";
        private static final String KEY_SETUP_DIR = "setupDir";
        private final Project project;
        private final AntProjectHelper helper;
        private final PropertyEvaluator evaluator;
        private final FileObject projectDir;

        public LogicalViewChildren(Project project, AntProjectHelper helper, PropertyEvaluator evaluator) {
            assert (project != null);
            this.project = project;
            assert (helper != null);
            this.helper = helper;
            this.projectDir = helper.getProjectDirectory();
            this.evaluator = evaluator;
        }

        protected void addNotify() {
            super.addNotify();
            this.projectDir.addFileChangeListener(FileUtil.weakFileChangeListener((FileChangeListener)this, (Object)this.projectDir));
            this.createNodes();
        }

        private void createNodes() {
            ArrayList<String> keys = new ArrayList<String>();
            DataFolder docBaseDir = this.getFolder("meta.inf");
            if (docBaseDir != null) {
                keys.add(KEY_DOC_BASE);
            }
            keys.add(KEY_SETUP_DIR);
            this.setKeys(keys);
        }

        protected void removeNotify() {
            this.setKeys(Collections.emptySet());
            this.projectDir.removeFileChangeListener((FileChangeListener)this);
            super.removeNotify();
        }

        protected Node[] createNodes(String key) {
            Node[] nodeArray;
            DocBaseNode n = null;
            if (key == KEY_DOC_BASE) {
                n = new DocBaseNode(this.getFolder("meta.inf"));
            } else if (key == KEY_SETUP_DIR) {
                n = J2eeProjectView.createServerResourcesNode((Project)this.project);
            }
            if (n == null) {
                nodeArray = new Node[]{};
            } else {
                Node[] nodeArray2 = new Node[1];
                nodeArray = nodeArray2;
                nodeArray2[0] = n;
            }
            return nodeArray;
        }

        private DataFolder getFolder(String propName) {
            FileObject fo;
            String prop = this.evaluator.getProperty(propName);
            if (prop != null && (fo = this.helper.resolveFileObject(prop)) != null && fo.isValid() && fo.isFolder()) {
                DataFolder df = DataFolder.findFolder((FileObject)fo);
                return df;
            }
            return null;
        }

        public void fileAttributeChanged(FileAttributeEvent fe) {
        }

        public void fileChanged(FileEvent fe) {
        }

        public void fileDataCreated(FileEvent fe) {
        }

        public void fileDeleted(FileEvent fe) {
            this.createNodes();
        }

        public void fileFolderCreated(FileEvent fe) {
            this.createNodes();
        }

        public void fileRenamed(FileRenameEvent fe) {
            this.createNodes();
        }
    }

    private static final class VisibilityQueryDataFilter
    implements ChangeListener,
    ChangeableDataFilter {
        private static final long serialVersionUID = 1L;
        final ChangeSupport changeSupport = new ChangeSupport((Object)this);

        public VisibilityQueryDataFilter() {
            VisibilityQuery.getDefault().addChangeListener((ChangeListener)this);
        }

        public boolean acceptDataObject(DataObject obj) {
            FileObject fo = obj.getPrimaryFile();
            return VisibilityQuery.getDefault().isVisible(fo);
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            this.changeSupport.fireChange();
        }

        public void addChangeListener(ChangeListener listener) {
            this.changeSupport.addChangeListener(listener);
        }

        public void removeChangeListener(ChangeListener listener) {
            this.changeSupport.removeChangeListener(listener);
        }
    }
}

