/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.earproject;

import java.util.HashMap;
import java.util.Map;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public enum ModuleType {
    WEB(NbBundle.getMessage(ModuleType.class, (String)"CTL_WebModule")),
    EJB(NbBundle.getMessage(ModuleType.class, (String)"CTL_EjbModule")),
    CLIENT(NbBundle.getMessage(ModuleType.class, (String)"CTL_ClientModule"));

    private final String description;
    private static final Map<String, ModuleType> DEFAULT_DD;

    private ModuleType(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public static Map<FileObject, ModuleType> detectModules(FileObject appRoot) {
        HashMap<FileObject, ModuleType> descriptors = new HashMap<FileObject, ModuleType>();
        for (FileObject subprojectRoot : appRoot.getChildren()) {
            ModuleType type;
            if (!subprojectRoot.isFolder() || (type = ModuleType.detectModuleType(subprojectRoot)) == null) continue;
            descriptors.put(subprojectRoot, type);
        }
        return descriptors;
    }

    public static ModuleType detectModuleType(FileObject moduleRoot) {
        ModuleType result = null;
        for (Map.Entry<String, ModuleType> entry : DEFAULT_DD.entrySet()) {
            FileObject ddFO = moduleRoot.getFileObject(entry.getKey());
            if (ddFO == null || !ddFO.isData()) continue;
            result = entry.getValue();
        }
        return result;
    }

    static {
        DEFAULT_DD = new HashMap<String, ModuleType>();
        DEFAULT_DD.put("web/WEB-INF/web.xml", WEB);
        DEFAULT_DD.put("src/conf/ejb-jar.xml", EJB);
        DEFAULT_DD.put("src/conf/application-client.xml", CLIENT);
    }
}

