/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.csl.core;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.netbeans.modules.csl.api.Error;
import org.netbeans.modules.csl.api.Severity;
import org.netbeans.modules.csl.core.ErrorFilterQuery;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.parsing.spi.indexing.Context;
import org.netbeans.modules.parsing.spi.indexing.EmbeddingIndexer;
import org.netbeans.modules.parsing.spi.indexing.EmbeddingIndexerFactory;
import org.netbeans.modules.parsing.spi.indexing.ErrorsCache;
import org.netbeans.modules.parsing.spi.indexing.Indexable;

public final class TLIndexerFactory
extends EmbeddingIndexerFactory {
    private static final Logger LOG = Logger.getLogger(TLIndexerFactory.class.getName());
    public static final String INDEXER_NAME = "TLIndexer";
    public static final int INDEXER_VERSION = 5;
    public static final String FIELD_GROUP_NAME = "groupName";
    public static final String FIELD_DESCRIPTION = "description";
    public static final String FIELD_LINE_NUMBER = "lineNumber";
    private static final Map<Indexable, Collection<SimpleError>> errors = new IdentityHashMap<Indexable, Collection<SimpleError>>();
    private static final Map<Indexable, List<Integer>> lineStartOffsetsCache = new IdentityHashMap<Indexable, List<Integer>>();
    private static final ErrorConvertorImpl DUMMY = new ErrorConvertorImpl(Collections.<Integer>emptyList());

    public boolean scanStarted(Context context) {
        return true;
    }

    public void scanFinished(Context context) {
        if (!context.checkForEditorModifications()) {
            TLIndexerFactory.commitErrors(context.getRootURI(), errors, lineStartOffsetsCache);
        }
    }

    private static void commitErrors(URL root, Map<Indexable, Collection<SimpleError>> errors, Map<Indexable, List<Integer>> lineStartOffsetsCache) {
        for (Map.Entry<Indexable, Collection<SimpleError>> e : errors.entrySet()) {
            ErrorsCache.setErrors((URL)root, (Indexable)e.getKey(), (Iterable)e.getValue(), (ErrorsCache.Convertor)new ErrorConvertorImpl(lineStartOffsetsCache.get(e.getKey())));
        }
        errors.clear();
        lineStartOffsetsCache.clear();
    }

    public synchronized EmbeddingIndexer createIndexer(Indexable indexable, Snapshot snapshot) {
        assert (errors != null);
        assert (lineStartOffsetsCache != null);
        return new TLIndexer(errors, lineStartOffsetsCache);
    }

    public void filesDeleted(Iterable<? extends Indexable> deleted, Context context) {
        for (Indexable indexable : deleted) {
            ErrorsCache.setErrors((URL)context.getRootURI(), (Indexable)indexable, Collections.emptyList(), (ErrorsCache.Convertor)DUMMY);
        }
    }

    public void rootsRemoved(Iterable<? extends URL> removedRoots) {
    }

    public void filesDirty(Iterable<? extends Indexable> dirty, Context context) {
    }

    public String getIndexerName() {
        return INDEXER_NAME;
    }

    public int getIndexVersion() {
        return 5;
    }

    private static SimpleError simplify(Error error) {
        return new SimpleError(error.getDisplayName(), error.getDescription(), error.getStartPosition(), error.getSeverity(), error instanceof Error.Badging && ((Error.Badging)error).showExplorerBadge());
    }

    private static final class ErrorConvertorImpl
    implements ErrorsCache.Convertor<SimpleError> {
        private final List<Integer> lineStartOffsets;

        public ErrorConvertorImpl(List<Integer> lineStartOffsets) {
            this.lineStartOffsets = lineStartOffsets;
        }

        public ErrorsCache.ErrorKind getKind(SimpleError error) {
            if (error.getSeverity() == Severity.WARNING) {
                return ErrorsCache.ErrorKind.WARNING;
            }
            if (error.isBadging()) {
                return ErrorsCache.ErrorKind.ERROR;
            }
            return ErrorsCache.ErrorKind.ERROR_NO_BADGE;
        }

        public int getLineNumber(SimpleError error) {
            int originalOffset = error.getStartPosition();
            int lineNumber = 1;
            if (originalOffset >= 0) {
                int idx = Collections.binarySearch(this.lineStartOffsets, originalOffset);
                if (idx < 0) {
                    int ln = -idx - 1;
                    assert (ln >= 1 && ln <= this.lineStartOffsets.size()) : "idx=" + idx + ", lineNumber=" + ln + ", lineStartOffsets.size()=" + this.lineStartOffsets.size();
                    if (ln >= 1 && ln <= this.lineStartOffsets.size()) {
                        lineNumber = ln;
                    }
                } else {
                    lineNumber = idx + 1;
                }
            }
            return lineNumber;
        }

        public String getMessage(SimpleError error) {
            return error.getDisplayName();
        }
    }

    private static class SimpleError {
        private String displayName;
        private String description;
        private int startPosition;
        private Severity severity;
        private boolean isBadging;

        public SimpleError(String displayName, String description, int startPosition, Severity severity, boolean isBadging) {
            this.displayName = displayName;
            this.description = description;
            this.startPosition = startPosition;
            this.severity = severity;
            this.isBadging = isBadging;
        }

        public String getDescription() {
            return this.description;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public Severity getSeverity() {
            return this.severity;
        }

        public int getStartPosition() {
            return this.startPosition;
        }

        public boolean isBadging() {
            return this.isBadging;
        }
    }

    private static final class TLIndexer
    extends EmbeddingIndexer {
        private final Map<Indexable, Collection<SimpleError>> errors;
        private final Map<Indexable, List<Integer>> lineStartOffsetsCache;

        public TLIndexer(Map<Indexable, Collection<SimpleError>> errors, Map<Indexable, List<Integer>> lineStartOffsetsCache) {
            this.errors = errors;
            this.lineStartOffsetsCache = lineStartOffsetsCache;
        }

        protected void index(Indexable indexable, Parser.Result parserResult, Context context) {
            Collection<SimpleError> storedErrors;
            if (context.checkForEditorModifications()) {
                return;
            }
            ParserResult gsfParserResult = (ParserResult)parserResult;
            if (!this.errors.containsKey(indexable)) {
                TLIndexerFactory.commitErrors(context.getRootURI(), this.errors, this.lineStartOffsetsCache);
            }
            if ((storedErrors = this.errors.get(indexable)) == null) {
                storedErrors = new LinkedList<SimpleError>();
                this.errors.put(indexable, storedErrors);
            }
            if (this.errors == null) {
                return;
            }
            List<Integer> lineStartOffsets = this.lineStartOffsetsCache.get(indexable);
            if (lineStartOffsets == null) {
                this.lineStartOffsetsCache.put(indexable, TLIndexer.getLineStartOffsets(gsfParserResult.getSnapshot().getSource()));
            }
            List<? extends Error> filteredErrors = ErrorFilterQuery.getFilteredErrors(gsfParserResult, "tasklist");
            ArrayList<SimpleError> simplifiedErrors = new ArrayList<SimpleError>();
            for (Error error : filteredErrors) {
                simplifiedErrors.add(TLIndexerFactory.simplify(error));
            }
            storedErrors.addAll(simplifiedErrors);
        }

        private static List<Integer> getLineStartOffsets(Source source) {
            ArrayList<Integer> lineStartOffsets = new ArrayList<Integer>();
            lineStartOffsets.add(0);
            CharSequence text = source.createSnapshot().getText();
            for (int i = 0; i < text.length(); ++i) {
                if (text.charAt(i) != '\n') continue;
                lineStartOffsets.add(i + 1);
            }
            return lineStartOffsets;
        }
    }
}

