/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.i18n.wizard;

import java.awt.Component;
import java.awt.Dimension;
import java.util.Map;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.modules.i18n.wizard.SourceData;
import org.openide.WizardDescriptor;
import org.openide.loaders.DataObject;

final class I18nWizardDescriptor
extends WizardDescriptor {
    public static final Dimension PREFERRED_DIMENSION = new Dimension(500, 300);
    private final WizardDescriptor.Iterator<Settings> panels;
    private final Settings settings;

    private I18nWizardDescriptor(WizardDescriptor.Iterator<Settings> panels, Settings settings) {
        super(panels, (Object)settings);
        this.panels = panels;
        this.settings = settings;
    }

    static WizardDescriptor createI18nWizardDescriptor(WizardDescriptor.Iterator<Settings> panels, Settings settings) {
        return new I18nWizardDescriptor(panels, settings);
    }

    public static abstract class Panel
    implements WizardDescriptor.Panel<Settings> {
        private Component component;
        private ChangeListener changeListener;
        private Settings settings = null;

        public final synchronized Component getComponent() {
            if (this.component == null) {
                this.component = this.createComponent();
            }
            return this.component;
        }

        protected abstract Component createComponent();

        public boolean isValid() {
            return true;
        }

        public void readSettings(Settings settings) {
            this.settings = settings;
        }

        public void storeSettings(Settings settings) {
        }

        public void addChangeListener(ChangeListener listener) {
            this.changeListener = listener;
        }

        public void removeChangeListener(ChangeListener listener) {
            if (this.changeListener != null && this.changeListener == listener) {
                this.changeListener = null;
            }
        }

        public final void fireStateChanged() {
            if (this.changeListener != null) {
                this.changeListener.stateChanged(new ChangeEvent(this));
            }
        }

        public Project getProject() {
            return this.settings.project;
        }

        public Map<DataObject, SourceData> getMap() {
            return this.settings.map;
        }
    }

    public static class Settings {
        public Map<DataObject, SourceData> map;
        public Project project;

        public Settings(Map<DataObject, SourceData> map, Project project) {
            this.map = map;
            this.project = project;
        }
    }
}

