/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.el.hints;

import com.sun.el.parser.AstIdentifier;
import com.sun.el.parser.AstString;
import com.sun.el.parser.Node;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.netbeans.modules.csl.api.Hint;
import org.netbeans.modules.csl.api.Rule;
import org.netbeans.modules.csl.api.RuleContext;
import org.netbeans.modules.web.el.CompilationContext;
import org.netbeans.modules.web.el.ELElement;
import org.netbeans.modules.web.el.ELParserResult;
import org.netbeans.modules.web.el.Pair;
import org.netbeans.modules.web.el.ResourceBundles;
import org.netbeans.modules.web.el.hints.ELHintsProvider;
import org.netbeans.modules.web.el.hints.ELRule;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public final class ResourceBundleKeys
extends ELRule {
    private ResourceBundles resourceBundles;

    public Set<?> getKinds() {
        return Collections.singleton(ELHintsProvider.Kind.DEFAULT);
    }

    public boolean appliesTo(RuleContext context) {
        FileObject fo = context.parserResult.getSnapshot().getSource().getFileObject();
        if (fo == null) {
            return false;
        }
        this.resourceBundles = ResourceBundles.get(fo);
        return this.resourceBundles.canHaveBundles();
    }

    @Override
    public boolean getDefaultEnabled() {
        return true;
    }

    @Override
    protected void run(CompilationContext info, RuleContext context, List<Hint> result) {
        ELParserResult elResult = (ELParserResult)context.parserResult;
        for (ELElement each : elResult.getElements()) {
            if (!each.isValid()) continue;
            for (Pair<AstIdentifier, AstString> pair : this.resourceBundles.collectKeys(each.getNode(), info.context())) {
                if (this.resourceBundles.isValidKey(((AstIdentifier)pair.first).getImage(), ((AstString)pair.second).getString())) continue;
                Hint hint = new Hint((Rule)this, NbBundle.getMessage(ResourceBundleKeys.class, (String)"ResourceBundleKeys_Unknown", (Object)((AstString)pair.second).getString()), elResult.getFileObject(), each.getOriginalOffset((Node)pair.second), Collections.emptyList(), 200);
                result.add(hint);
            }
        }
    }
}

