/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.el;

import com.sun.el.parser.AstDotSuffix;
import com.sun.el.parser.AstFalse;
import com.sun.el.parser.AstFloatingPoint;
import com.sun.el.parser.AstIdentifier;
import com.sun.el.parser.AstInteger;
import com.sun.el.parser.AstMethodArguments;
import com.sun.el.parser.AstString;
import com.sun.el.parser.AstTrue;
import com.sun.el.parser.Node;
import com.sun.el.parser.NodeVisitor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.el.ELException;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Parameterizable;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.util.ElementFilter;
import org.netbeans.api.java.source.TypeUtilities;
import org.netbeans.modules.web.el.CompilationContext;
import org.netbeans.modules.web.el.ELElement;
import org.netbeans.modules.web.el.ELParser;
import org.netbeans.modules.web.el.ELPreprocessor;
import org.netbeans.modules.web.el.ELVariableResolvers;
import org.netbeans.modules.web.el.NodeUtil;
import org.netbeans.modules.web.el.ResourceBundles;
import org.netbeans.modules.web.el.refactoring.RefactoringUtil;
import org.netbeans.modules.web.el.spi.ELPlugin;
import org.netbeans.modules.web.el.spi.ELVariableResolver;
import org.netbeans.modules.web.el.spi.Function;
import org.netbeans.modules.web.el.spi.ImplicitObject;
import org.netbeans.modules.web.el.spi.ImplicitObjectType;
import org.openide.filesystems.FileObject;

public final class ELTypeUtilities {
    private static final String FACES_CONTEXT_CLASS = "javax.faces.context.FacesContext";
    private static final String UI_COMPONENT_CLASS = "javax.faces.component.UIComponent";
    private static final Map<Class<? extends Node>, Set<TypeKind>> TYPES = new HashMap<Class<? extends Node>, Set<TypeKind>>();

    private static void put(Class<? extends Node> node, TypeKind ... kinds) {
        HashSet<TypeKind> kindSet = new HashSet<TypeKind>();
        kindSet.addAll(Arrays.asList(kinds));
        TYPES.put(node, kindSet);
    }

    private ELTypeUtilities() {
    }

    public static String getTypeNameFor(CompilationContext info, Element element) {
        TypeMirror tm = ELTypeUtilities.getTypeMirrorFor(info, element);
        return ((Object)info.info().getTypeUtilities().getTypeName(tm, new TypeUtilities.TypeNameOptions[0])).toString();
    }

    public static Element getTypeFor(CompilationContext info, Element element) {
        TypeMirror tm = ELTypeUtilities.getTypeMirrorFor(info, element);
        return info.info().getTypes().asElement(tm);
    }

    public static List<Element> getSuperTypesFor(CompilationContext info, Element element) {
        return ELTypeUtilities.getSuperTypesFor(info, element, null, null);
    }

    public static List<Element> getSuperTypesFor(CompilationContext info, Element element, ELElement elElement, List<Node> rootToNode) {
        TypeMirror tm = ELTypeUtilities.getTypeMirrorFor(info, element, elElement, rootToNode);
        ArrayList<Element> types = new ArrayList<Element>();
        TypeMirror mirror = tm;
        while (mirror.getKind() == TypeKind.DECLARED) {
            Element el = info.info().getTypes().asElement(mirror);
            types.add(el);
            if (el.getKind() != ElementKind.CLASS) break;
            TypeElement tel = (TypeElement)el;
            mirror = tel.getSuperclass();
        }
        return types;
    }

    public static Element resolveElement(CompilationContext info, ELElement elem, Node target) {
        TypeResolverVisitor typeResolver = new TypeResolverVisitor(info, elem, target);
        elem.getNode().accept((NodeVisitor)typeResolver);
        return typeResolver.getResult();
    }

    public static TypeMirror getReturnType(CompilationContext info, ExecutableElement method) {
        return ELTypeUtilities.getReturnType(info, method, null, null);
    }

    public static TypeMirror getReturnType(CompilationContext info, ExecutableElement method, ELElement elElement, List<Node> rootToNode) {
        TypeKind returnTypeKind = method.getReturnType().getKind();
        if (returnTypeKind.isPrimitive()) {
            return info.info().getTypes().getPrimitiveType(returnTypeKind);
        }
        if (returnTypeKind == TypeKind.VOID) {
            return info.info().getTypes().getNoType(returnTypeKind);
        }
        if (returnTypeKind == TypeKind.TYPEVAR && rootToNode != null && elElement != null) {
            return ELTypeUtilities.getReturnTypeForGenericClass(info, method, elElement, rootToNode);
        }
        return method.getReturnType();
    }

    public static TypeMirror getReturnTypeForGenericClass(CompilationContext info, ExecutableElement method, ELElement elElement, List<Node> rootToNode) {
        Node node = null;
        for (int i = rootToNode.size() - 1; i > 0 && !((node = rootToNode.get(i)) instanceof AstIdentifier); --i) {
        }
        if (node != null) {
            TypeMirror type = ELTypeUtilities.resolveElement(info, elElement, node).asType();
            TypeMirror directSupertype = info.info().getTypes().directSupertypes(type).get(0);
            if (directSupertype instanceof DeclaredType) {
                DeclaredType declaredType = (DeclaredType)directSupertype;
                int indexOfTypeArgument = -1;
                List<? extends TypeMirror> typeArguments = declaredType.getTypeArguments();
                for (Element element : declaredType.asElement().getEnclosedElements()) {
                    if (!method.equals(element)) continue;
                    TypeMirror returnType = ((ExecutableElement)element).getReturnType();
                    indexOfTypeArgument = info.info().getElementUtilities().enclosingTypeElement((Element)method).getTypeParameters().indexOf(((TypeVariable)returnType).asElement());
                    break;
                }
                if (indexOfTypeArgument != -1 && indexOfTypeArgument < typeArguments.size()) {
                    return typeArguments.get(indexOfTypeArgument);
                }
            }
        }
        return method.getReturnType();
    }

    private static List<Node> getMethodParameters(Node methodNode) {
        assert (NodeUtil.isMethodCall(methodNode));
        if (methodNode.jjtGetNumChildren() == 0) {
            return Collections.emptyList();
        }
        Node firstChild = methodNode.jjtGetChild(0);
        if (!(firstChild instanceof AstMethodArguments)) {
            return Collections.emptyList();
        }
        ArrayList<Node> parameters = new ArrayList<Node>();
        for (int i = 0; i < firstChild.jjtGetNumChildren(); ++i) {
            parameters.add(firstChild.jjtGetChild(i));
        }
        return parameters;
    }

    public static boolean isSameMethod(CompilationContext info, Node methodNode, ExecutableElement method) {
        String image = methodNode.getImage();
        String methodName = method.getSimpleName().toString();
        if (image == null) {
            return false;
        }
        int methodParams = method.getParameters().size();
        if (NodeUtil.isMethodCall(methodNode) && (methodName.equals(image) || RefactoringUtil.getPropertyName(methodName).equals(image))) {
            List<Node> parameters = ELTypeUtilities.getMethodParameters(methodNode);
            int methodNodeParams = parameters.size();
            if (method.isVarArgs()) {
                return methodParams == 1 ? true : methodNodeParams >= methodParams;
            }
            return method.getParameters().size() == methodNodeParams && ELTypeUtilities.haveSameParameters(info, methodNode, method);
        }
        if (methodNode instanceof AstDotSuffix && (methodName.equals(image) || RefactoringUtil.getPropertyName(methodName).equals(image))) {
            if (ELTypeUtilities.isValidatorMethod(info, method)) {
                return true;
            }
            return method.isVarArgs() ? method.getParameters().size() == 1 : method.getParameters().isEmpty();
        }
        return false;
    }

    public static TypeElement getElementForType(CompilationContext info, String clazz) {
        return info.info().getElements().getTypeElement(clazz);
    }

    public static List<String> getParameterNames(CompilationContext info, ExecutableElement method) {
        ArrayList<String> result = new ArrayList<String>();
        for (VariableElement variableElement : method.getParameters()) {
            result.add(variableElement.getSimpleName().toString());
        }
        return result;
    }

    public static String getParametersAsString(CompilationContext info, ExecutableElement method) {
        StringBuilder result = new StringBuilder();
        for (VariableElement variableElement : method.getParameters()) {
            if (result.length() > 0) {
                result.append(",");
            }
            String type = ((Object)info.info().getTypeUtilities().getTypeName(variableElement.asType(), new TypeUtilities.TypeNameOptions[0])).toString();
            result.append(type);
            result.append(" ");
            result.append(variableElement.getSimpleName().toString());
        }
        if (result.length() > 0) {
            result.insert(0, "(");
            result.append(")");
        }
        return result.toString();
    }

    public static Collection<ImplicitObject> getImplicitObjects(CompilationContext info) {
        return ELPlugin.Query.getImplicitObjects(info.file());
    }

    public static Collection<Function> getELFunctions(CompilationContext info) {
        return ELPlugin.Query.getFunctions(info.file());
    }

    public static boolean isScopeObject(CompilationContext info, Node target) {
        if (!(target instanceof AstIdentifier)) {
            return false;
        }
        for (ImplicitObject each : ELTypeUtilities.getImplicitObjects(info)) {
            if (each.getType() != ImplicitObjectType.SCOPE_TYPE || !each.getName().equals(target.getImage())) continue;
            return true;
        }
        return false;
    }

    public static boolean isRawObjectReference(CompilationContext info, Node target) {
        do {
            if (!(target instanceof AstIdentifier)) continue;
            for (ImplicitObject each : ELTypeUtilities.getImplicitObjects(info)) {
                if (each.getType() != ImplicitObjectType.RAW || !each.getName().equals(target.getImage())) continue;
                return true;
            }
        } while ((target = NodeUtil.getSiblingBefore(target)) != null);
        return false;
    }

    public static boolean isResourceBundleVar(CompilationContext info, Node target) {
        if (!(target instanceof AstIdentifier)) {
            return false;
        }
        ResourceBundles resourceBundles = ResourceBundles.get(info.file());
        if (!resourceBundles.canHaveBundles()) {
            return false;
        }
        String bundleVar = target.getImage();
        return resourceBundles.isResourceBundleIdentifier(bundleVar, info.context());
    }

    private static TypeMirror getTypeMirrorFor(CompilationContext info, Element element) {
        return ELTypeUtilities.getTypeMirrorFor(info, element, null, null);
    }

    private static TypeMirror getTypeMirrorFor(CompilationContext info, Element element, ELElement elElement, List<Node> rootToNode) {
        if (element.getKind() == ElementKind.METHOD) {
            return ELTypeUtilities.getReturnType(info, (ExecutableElement)element, elElement, rootToNode);
        }
        return element.asType();
    }

    private static boolean isValidatorMethod(CompilationContext info, ExecutableElement method) {
        if (method.getParameters().size() != 3) {
            return false;
        }
        VariableElement param1 = method.getParameters().get(0);
        VariableElement param2 = method.getParameters().get(1);
        CharSequence param1Type = ELTypeUtilities.getTypeName(info, param1.asType());
        CharSequence param2Type = ELTypeUtilities.getTypeName(info, param2.asType());
        return FACES_CONTEXT_CLASS.equals(param1Type) && UI_COMPONENT_CLASS.equals(param2Type);
    }

    private static CharSequence getTypeName(CompilationContext info, TypeMirror type) {
        return info.info().getTypeUtilities().getTypeName(type, new TypeUtilities.TypeNameOptions[]{TypeUtilities.TypeNameOptions.PRINT_FQN});
    }

    private static boolean haveSameParameters(CompilationContext info, Node methodNode, ExecutableElement method) {
        List<Node> methodNodeParameters = ELTypeUtilities.getMethodParameters(methodNode);
        for (int i = 0; i < methodNodeParameters.size(); ++i) {
            Node paramNode = methodNodeParameters.get(i);
            if (ELTypeUtilities.isSameType(info, paramNode, method.getParameters().get(i))) continue;
            return false;
        }
        return true;
    }

    private static boolean isSameType(CompilationContext info, Node paramNode, VariableElement param) {
        TypeKind paramKind = param.asType().getKind();
        if (!paramKind.isPrimitive()) {
            try {
                PrimitiveType unboxedType = info.info().getTypes().unboxedType(param.asType());
                paramKind = unboxedType.getKind();
            }
            catch (IllegalArgumentException iae) {
                // empty catch block
            }
        }
        if (TYPES.containsKey(paramNode.getClass())) {
            return TYPES.get(paramNode.getClass()).contains((Object)paramKind);
        }
        if (paramNode instanceof AstString) {
            CharSequence typeName = info.info().getTypeUtilities().getTypeName(param.asType(), new TypeUtilities.TypeNameOptions[]{TypeUtilities.TypeNameOptions.PRINT_FQN});
            return String.class.getName().contentEquals(typeName);
        }
        return true;
    }

    private static ExecutableElement getElementForProperty(CompilationContext info, Node property, Element enclosing) {
        for (Element element : ELTypeUtilities.getSuperTypesFor(info, enclosing)) {
            for (ExecutableElement each : ElementFilter.methodsIn(element.getEnclosedElements())) {
                if (!each.getModifiers().contains((Object)Modifier.PUBLIC) || !ELTypeUtilities.isSameMethod(info, property, each)) continue;
                return each;
            }
        }
        return null;
    }

    private static Element getIdentifierType(CompilationContext info, AstIdentifier identifier, ELElement element) {
        String tempClass = null;
        for (ImplicitObject implicitObject : ELTypeUtilities.getImplicitObjects(info)) {
            if (!implicitObject.getName().equals(identifier.getImage())) continue;
            if (implicitObject.getClazz() == null || implicitObject.getClazz().isEmpty()) break;
            tempClass = implicitObject.getClazz();
            break;
        }
        if (tempClass == null) {
            tempClass = ELVariableResolvers.findBeanClass(info, identifier.getImage(), element.getSnapshot().getSource().getFileObject());
        }
        if (tempClass != null) {
            return info.info().getElements().getTypeElement(tempClass);
        }
        int offset = element.getOriginalOffset().getStart() + identifier.startOffset();
        List<ELVariableResolver.VariableInfo> vis = ELVariableResolvers.getVariables(info, element.getSnapshot(), offset);
        for (ELVariableResolver.VariableInfo vi : vis) {
            if (!identifier.getImage().equals(vi.name)) continue;
            try {
                ELPreprocessor elp = new ELPreprocessor(vi.expression, new String[][][]{ELPreprocessor.XML_ENTITY_REFS_CONVERSION_TABLE});
                Node expressionNode = ELParser.parse(elp);
                if (expressionNode == null) continue;
                return ELTypeUtilities.getReferredType(info, expressionNode, element.getSnapshot().getSource().getFileObject());
            }
            catch (ELException e) {
            }
        }
        return null;
    }

    public static Element getReferredType(CompilationContext info, ELVariableResolver.VariableInfo vi, FileObject context) {
        if (vi.clazz != null) {
            return info.info().getElements().getTypeElement(vi.clazz);
        }
        assert (vi.expression != null);
        try {
            ELPreprocessor elp = new ELPreprocessor(vi.expression, new String[][][]{ELPreprocessor.XML_ENTITY_REFS_CONVERSION_TABLE});
            Node expressionNode = ELParser.parse(elp);
            if (expressionNode != null) {
                return ELTypeUtilities.getReferredType(info, expressionNode, context);
            }
        }
        catch (ELException eLException) {
            // empty catch block
        }
        return null;
    }

    public static Element getReferredType(final CompilationContext info, Node expression, final FileObject context) {
        final Element[] result = new Element[1];
        expression.accept(new NodeVisitor(){

            public void visit(Node node) throws ELException {
                if (node instanceof AstIdentifier) {
                    Node parent = node.jjtGetParent();
                    String beanClass = ELVariableResolvers.findBeanClass(info, node.getImage(), context);
                    if (beanClass == null) {
                        return;
                    }
                    Element enclosing = info.info().getElements().getTypeElement(beanClass);
                    if (enclosing == null) {
                        return;
                    }
                    ExecutableElement method = null;
                    Node current = parent;
                    for (int i = 0; i < parent.jjtGetNumChildren(); ++i) {
                        current = parent.jjtGetChild(i);
                        if (!(current instanceof AstDotSuffix) && !NodeUtil.isMethodCall(current) || (method = ELTypeUtilities.getElementForProperty(info, current, enclosing)) == null) continue;
                        enclosing = info.info().getTypes().asElement(ELTypeUtilities.getReturnType(info, method));
                    }
                    if (method == null) {
                        return;
                    }
                    TypeMirror returnType = ELTypeUtilities.getReturnType(info, method);
                    if (returnType.getKind() == TypeKind.DECLARED) {
                        if (ELTypeUtilities.isSubtypeOf(info, returnType, "java.lang.Iterable")) {
                            List<? extends TypeMirror> typeArguments = ((DeclaredType)returnType).getTypeArguments();
                            Iterator<? extends TypeMirror> i$ = typeArguments.iterator();
                            if (i$.hasNext()) {
                                TypeMirror arg = i$.next();
                                result[0] = info.info().getTypes().asElement(arg);
                                return;
                            }
                            result[0] = info.info().getTypes().asElement(returnType);
                        }
                    } else if (returnType.getKind() == TypeKind.ARRAY) {
                        TypeMirror componentType = ((ArrayType)returnType).getComponentType();
                        result[0] = info.info().getTypes().asElement(componentType);
                    }
                }
            }
        });
        return result[0];
    }

    private static boolean isSubtypeOf(CompilationContext info, TypeMirror tm, CharSequence typeName) {
        TypeElement element = info.info().getElements().getTypeElement(typeName);
        if (element == null) {
            return false;
        }
        TypeMirror type = element.asType();
        TypeMirror erasedType = info.info().getTypes().erasure(type);
        TypeMirror tmErasure = info.info().getTypes().erasure(tm);
        return info.info().getTypes().isSubtype(tmErasure, erasedType);
    }

    private static TypeElement getTypeFor(CompilationContext info, String clazz) {
        return info.info().getElements().getTypeElement(clazz);
    }

    static {
        ELTypeUtilities.put(AstFloatingPoint.class, TypeKind.FLOAT, TypeKind.DOUBLE);
        ELTypeUtilities.put(AstTrue.class, TypeKind.BOOLEAN);
        ELTypeUtilities.put(AstFalse.class, TypeKind.BOOLEAN);
        ELTypeUtilities.put(AstInteger.class, TypeKind.INT, TypeKind.SHORT, TypeKind.LONG);
    }

    private static class TypeResolverVisitor
    implements NodeVisitor {
        private final ELElement elem;
        private final Node target;
        private Element result;
        private CompilationContext info;

        public TypeResolverVisitor(CompilationContext info, ELElement elem, Node target) {
            this.info = info;
            this.elem = elem;
            this.target = target;
        }

        public Element getResult() {
            return this.result;
        }

        public void visit(Node node) {
            Element enclosing = null;
            if (node instanceof AstIdentifier && (enclosing = ELTypeUtilities.getIdentifierType(this.info, (AstIdentifier)node, this.elem)) != null) {
                if (node.equals(this.target)) {
                    this.result = enclosing;
                    return;
                }
                Node parent = node.jjtGetParent();
                for (int i = 0; i < parent.jjtGetNumChildren(); ++i) {
                    Node child = parent.jjtGetChild(i);
                    if (!(child instanceof AstDotSuffix) && !NodeUtil.isMethodCall(child)) continue;
                    Parameterizable propertyType = ELTypeUtilities.getElementForProperty(this.info, child, enclosing);
                    if (propertyType == null && i > 0 && ELTypeUtilities.isScopeObject(this.info, parent.jjtGetChild(i - 1))) {
                        String clazz = ELVariableResolvers.findBeanClass(this.info, child.getImage(), this.elem.getSnapshot().getSource().getFileObject());
                        if (clazz == null) {
                            return;
                        }
                        propertyType = ELTypeUtilities.getTypeFor(this.info, clazz);
                    }
                    if (propertyType == null) {
                        return;
                    }
                    if (child.equals(this.target)) {
                        this.result = propertyType;
                        continue;
                    }
                    if (propertyType.getKind() == ElementKind.METHOD) {
                        ExecutableElement method = propertyType;
                        enclosing = this.info.info().getTypes().asElement(ELTypeUtilities.getReturnType(this.info, method));
                        if (enclosing != null) continue;
                        return;
                    }
                    enclosing = propertyType;
                }
            }
        }
    }
}

