/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.el;

import com.sun.el.parser.AstDotSuffix;
import com.sun.el.parser.AstIdentifier;
import com.sun.el.parser.Node;
import com.sun.el.parser.NodeVisitor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.ELException;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.parsing.spi.indexing.Context;
import org.netbeans.modules.parsing.spi.indexing.EmbeddingIndexer;
import org.netbeans.modules.parsing.spi.indexing.EmbeddingIndexerFactory;
import org.netbeans.modules.parsing.spi.indexing.Indexable;
import org.netbeans.modules.parsing.spi.indexing.support.IndexDocument;
import org.netbeans.modules.parsing.spi.indexing.support.IndexingSupport;
import org.netbeans.modules.web.el.ELElement;
import org.netbeans.modules.web.el.ELParserResult;
import org.netbeans.modules.web.el.NodeUtil;
import org.netbeans.modules.web.el.spi.ELPlugin;

public final class ELIndexer
extends EmbeddingIndexer {
    private static final Logger LOGGER = Logger.getLogger(ELIndexer.class.getName());

    protected void index(Indexable indexable, Parser.Result parserResult, Context context) {
        IndexingSupport support;
        ELParserResult elResult = (ELParserResult)parserResult;
        if (!elResult.hasElements()) {
            return;
        }
        try {
            support = IndexingSupport.getInstance((Context)context);
        }
        catch (IOException ioe) {
            LOGGER.log(Level.WARNING, null, ioe);
            return;
        }
        new Analyzer(elResult, support).analyze();
    }

    private static class Analyzer
    implements NodeVisitor {
        private final ELParserResult parserResult;
        private final IndexingSupport support;
        private final List<IndexDocument> documents = new ArrayList<IndexDocument>();

        public Analyzer(ELParserResult parserResult, IndexingSupport support) {
            this.parserResult = parserResult;
            this.support = support;
        }

        void analyze() {
            for (ELElement each : this.parserResult.getElements()) {
                if (!each.isValid()) continue;
                IndexDocument doc = this.support.createDocument(this.parserResult.getFileObject());
                this.documents.add(doc);
                doc.addPair("expression", each.getExpression().getPreprocessedExpression(), true, true);
                each.getNode().accept((NodeVisitor)this);
                this.support.addDocument(doc);
            }
        }

        private IndexDocument getCurrent() {
            assert (!this.documents.isEmpty()) : "No current document";
            return this.documents.get(this.documents.size() - 1);
        }

        public List<IndexDocument> getDocuments() {
            return this.documents;
        }

        public void visit(Node node) throws ELException {
            if (node instanceof AstIdentifier) {
                String identifier = ((AstIdentifier)node).getImage();
                this.getCurrent().addPair("identifier", identifier, true, true);
            } else if (NodeUtil.isMethodCall(node)) {
                String method = node.getImage();
                this.getCurrent().addPair("method", method, true, true);
            } else if (node instanceof AstDotSuffix) {
                String property = ((AstDotSuffix)node).getImage();
                this.getCurrent().addPair("property", property, true, true);
            }
        }
    }

    public static final class Factory
    extends EmbeddingIndexerFactory {
        static final String NAME = "EL";
        static final int VERSION = 1;
        private static Collection<String> INDEXABLE_MIMETYPES;

        private static synchronized Collection<String> getIndexableMimeTypes() {
            if (INDEXABLE_MIMETYPES == null) {
                INDEXABLE_MIMETYPES = new ArrayList<String>();
                for (ELPlugin eLPlugin : ELPlugin.Query.getELPlugins()) {
                    INDEXABLE_MIMETYPES.addAll(eLPlugin.getMimeTypes());
                }
            }
            return INDEXABLE_MIMETYPES;
        }

        public EmbeddingIndexer createIndexer(Indexable indexable, Snapshot snapshot) {
            if (Factory.isIndexable(indexable, snapshot)) {
                return new ELIndexer();
            }
            return null;
        }

        private static boolean isIndexable(Indexable indexable, Snapshot snapshot) {
            return Factory.getIndexableMimeTypes().contains(indexable.getMimeType());
        }

        public void filesDeleted(Iterable<? extends Indexable> deleted, Context context) {
        }

        public void filesDirty(Iterable<? extends Indexable> dirty, Context context) {
        }

        public String getIndexerName() {
            return NAME;
        }

        public int getIndexVersion() {
            return 1;
        }
    }

    public static final class Fields {
        public static final String SEPARATOR = "|";
        public static final String EXPRESSION = "expression";
        public static final String IDENTIFIER = "identifier";
        public static final String IDENTIFIER_FULL_EXPRESSION = "identifier_full_expression";
        public static final String PROPERTY = "property";
        public static final String PROPERTY_OWNER = "property_owner";
        public static final String PROPERTY_FULL_EXPRESSION = "property_full_expression";
        public static final String METHOD = "method";
        public static final String METHOD_FULL_EXPRESSION = "method_full_expression";

        static String encode(String ... values) {
            StringBuilder result = new StringBuilder();
            for (int i = 0; i < values.length; ++i) {
                result.append(values[i]);
                if (i + 1 >= values.length) continue;
                result.append(SEPARATOR);
            }
            return result.toString();
        }

        public static String[] split(String field) {
            return field.split("\\|");
        }
    }
}

