/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.search;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.prefs.Preferences;
import org.netbeans.modules.editor.lib2.search.EditorFindSupport;
import org.openide.util.NbPreferences;

public class SearchPropertiesSupport {
    private static final String PREFS_NODE = "SearchProperties";
    private static SearchPropertiesSupport instance = null;
    private static Preferences prefs;
    private static final String SEARCH_ID = "searchprops";
    private static SearchProperties searchProps;
    private static final String REPLACE_ID = "replaceprops";
    private static SearchProperties replaceProps;
    private static final List<String> editorfindSupportConstants;

    private SearchPropertiesSupport() {
        prefs = NbPreferences.forModule(SearchPropertiesSupport.class).node(PREFS_NODE);
    }

    private static SearchPropertiesSupport getInstance() {
        if (instance == null) {
            instance = new SearchPropertiesSupport();
        }
        return instance;
    }

    private Preferences getPrefs() {
        return prefs;
    }

    public static SearchProperties getSearchProperties() {
        if (searchProps == null) {
            searchProps = SearchPropertiesSupport.createDefaultSearchProperties();
        }
        return searchProps;
    }

    public static SearchProperties getReplaceProperties() {
        if (replaceProps == null) {
            replaceProps = SearchPropertiesSupport.createDefaultReplaceProperties();
        }
        return replaceProps;
    }

    private static SearchProperties createDefaultSearchProperties() {
        Map props = EditorFindSupport.getInstance().createDefaultFindProperties();
        for (String constant : editorfindSupportConstants) {
            props.put(constant, Boolean.parseBoolean(SearchPropertiesSupport.getInstance().getPrefs().get(SEARCH_ID + constant, props.get(constant).toString())));
        }
        return new SearchProperties(props, SEARCH_ID);
    }

    private static SearchProperties createDefaultReplaceProperties() {
        Map props = EditorFindSupport.getInstance().createDefaultFindProperties();
        props.put("find-match-case", Boolean.TRUE);
        for (String constant : editorfindSupportConstants) {
            props.put(constant, Boolean.parseBoolean(SearchPropertiesSupport.getInstance().getPrefs().get(REPLACE_ID + constant, props.get(constant).toString())));
        }
        return new SearchProperties(props, REPLACE_ID);
    }

    static {
        editorfindSupportConstants = Arrays.asList("find-match-case", "find-whole-words", "find-reg-exp", "find-wrap-search", "find-preserve-case");
    }

    public static class SearchProperties {
        private Map<String, Object> props;
        private String id;

        private SearchProperties(Map<String, Object> props, String identification) {
            this.props = props;
            this.id = identification;
        }

        public void setProperty(String editorFindSupportProperty, Object value) {
            if (editorFindSupportProperty.equals("find-highlight-search")) {
                EditorFindSupport.getInstance().putFindProperty(editorFindSupportProperty, value);
            }
            this.props.put(editorFindSupportProperty, value);
            SearchPropertiesSupport.getInstance().getPrefs().put(this.id + editorFindSupportProperty, value.toString());
        }

        public Object getProperty(String editorFindSupportProperty) {
            this.props.put("find-highlight-search", EditorFindSupport.getInstance().getFindProperty("find-highlight-search"));
            return this.props.get(editorFindSupportProperty);
        }

        public Map<String, Object> getProperties() {
            this.props.put("find-highlight-search", EditorFindSupport.getInstance().getFindProperty("find-highlight-search"));
            return this.props;
        }
    }
}

