/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.search;

import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.openide.util.ImageUtilities;

public class SearchExpandMenu {
    private static final Insets BUTTON_INSETS = new Insets(2, 1, 0, 1);
    private final List<JComponent> inBar = new ArrayList<JComponent>();
    private final LinkedList<JComponent> inPopup = new LinkedList();
    private final List<Component> barOrder = new ArrayList<Component>();
    private boolean isPopupShown = false;
    private final JButton expandButton;
    private final JPopupMenu expandPopup;
    private final JPanel padding;
    private int popupHeight;

    public SearchExpandMenu(int popupHeight) {
        this.popupHeight = popupHeight;
        this.expandButton = this.createExpandButton();
        this.expandPopup = this.createExpandPopup(this.expandButton);
        this.expandButton.setVisible(true);
        this.padding = new JPanel();
        this.padding.setOpaque(false);
    }

    public JButton getExpandButton() {
        return this.expandButton;
    }

    public JPanel getPadding() {
        return this.padding;
    }

    public void addToInbar(JComponent component) {
        this.inBar.add(component);
    }

    public void addAllToBarOrder(Collection<? extends Component> c) {
        this.barOrder.addAll(c);
    }

    private JButton createExpandButton() {
        JButton expButton = new JButton(ImageUtilities.loadImageIcon((String)"org/netbeans/modules/editor/resources/find_expand.png", (boolean)false));
        expButton.setMargin(BUTTON_INSETS);
        expButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean state = !SearchExpandMenu.this.isPopupShown;
                SearchExpandMenu.this.isPopupShown = state;
                if (state) {
                    SearchExpandMenu.this.showExpandedMenu();
                } else {
                    SearchExpandMenu.this.hideExpandedMenu();
                }
            }
        });
        return expButton;
    }

    private JPopupMenu createExpandPopup(final JButton expButton) {
        JPopupMenu expPopup = new JPopupMenu();
        expPopup.setLayout(new GridLayout(0, 1));
        expPopup.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
                if (expButton.getMousePosition() == null) {
                    expButton.setContentAreaFilled(false);
                    expButton.setBorderPainted(false);
                    SearchExpandMenu.this.isPopupShown = false;
                }
            }
        });
        return expPopup;
    }

    void computeLayout(JPanel jpanel) {
        int parentWidth = jpanel.getParent().getWidth();
        int totalWidth = 0;
        for (Component c : jpanel.getComponents()) {
            if (c == this.padding) continue;
            totalWidth += c.getPreferredSize().width;
        }
        boolean change = false;
        if (totalWidth <= parentWidth) {
            while (!this.inPopup.isEmpty()) {
                JComponent c = this.inPopup.getFirst();
                if ((totalWidth += c.getPreferredSize().width) <= parentWidth) {
                    this.inPopup.removeFirst();
                    this.inBar.add(c);
                    this.expandPopup.remove(c);
                    c.setOpaque(false);
                    jpanel.add((Component)c, this.barOrder.indexOf(c));
                    change = true;
                    continue;
                }
                break;
            }
        } else {
            while (totalWidth > parentWidth && !this.inBar.isEmpty()) {
                JComponent c = this.inBar.remove(this.inBar.size() - 1);
                this.inPopup.addFirst(c);
                jpanel.remove(c);
                this.expandPopup.add((Component)c, 0);
                c.setOpaque(true);
                totalWidth -= c.getPreferredSize().width;
                change = true;
            }
        }
        if (change) {
            if (this.inPopup.isEmpty()) {
                jpanel.remove(this.expandButton);
                this.expandButton.setVisible(false);
            } else if (this.getComponentIndexIn(this.expandButton, jpanel) < 0) {
                jpanel.add((Component)this.expandButton, this.getComponentIndexIn(this.padding, jpanel));
                this.expandButton.setVisible(true);
            }
            jpanel.revalidate();
            this.expandPopup.invalidate();
            this.expandPopup.validate();
        }
    }

    private void showExpandedMenu() {
        if (!this.inPopup.isEmpty() && !this.expandPopup.isVisible()) {
            Insets ins = this.expandPopup.getInsets();
            this.expandPopup.show(this.expandButton, 0, -(this.popupHeight * this.inPopup.size() + ins.top + ins.bottom));
        }
    }

    private void hideExpandedMenu() {
        if (this.expandPopup.isVisible()) {
            this.expandPopup.setVisible(false);
        }
    }

    private int getComponentIndexIn(Component c, JPanel jpanel) {
        Component[] comps = jpanel.getComponents();
        for (int i = 0; i < comps.length; ++i) {
            if (c != comps[i]) continue;
            return i;
        }
        return -1;
    }
}

