/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.search;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.MutableComboBoxModel;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Keymap;
import org.netbeans.api.editor.EditorRegistry;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.MultiKeymap;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.editor.lib2.search.EditorFindSupport;
import org.netbeans.modules.editor.search.ReplaceBar;
import org.netbeans.modules.editor.search.SearchComboBox;
import org.netbeans.modules.editor.search.SearchComboBoxEditor;
import org.netbeans.modules.editor.search.SearchExpandMenu;
import org.netbeans.modules.editor.search.SearchPropertiesSupport;
import org.openide.awt.CloseButtonFactory;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;

public final class SearchBar
extends JPanel
implements PropertyChangeListener {
    private static SearchBar searchbarInstance = null;
    private static final Logger LOG = Logger.getLogger(SearchBar.class.getName());
    private static final Insets BUTTON_INSETS = new Insets(2, 1, 0, 1);
    private static final Color NOT_FOUND = Color.RED.darker();
    private static final Color INVALID_REGEXP = Color.red;
    private static final int SEARCH_DELAY_TIME_LONG = 300;
    private static final int SEARCH_DELAY_TIME_SHORT = 20;
    private static final Color DEFAULT_FG_COLOR = UIManager.getColor("textText");
    private WeakReference<JTextComponent> actualTextComponent;
    private List<PropertyChangeListener> actualComponentListeners = new LinkedList<PropertyChangeListener>();
    private FocusAdapter focusAdapterForComponent;
    private PropertyChangeListener propertyChangeListenerForComponent;
    private final JLabel findLabel;
    private final JComboBox incSearchComboBox;
    private final JTextComponent incSearchTextField;
    private final DocumentListener incSearchTextFieldListener;
    private boolean hadFocusOnIncSearchTextField = false;
    private final JButton findNextButton;
    private final JButton findPreviousButton;
    private final JCheckBox matchCaseCheckBox;
    private final JCheckBox wholeWordsCheckBox;
    private final JCheckBox regexpCheckBox;
    private final JCheckBox highlightCheckBox;
    private final JCheckBox wrapAroundCheckBox;
    private final JButton closeButton;
    private final SearchExpandMenu expandMenu;
    private SearchPropertiesSupport.SearchProperties searchProps = SearchPropertiesSupport.getSearchProperties();
    private boolean popupMenuWasCanceled = false;
    private Rectangle actualViewPort;
    private boolean highlightCanceled = false;
    private boolean whenOpenedWasNotVisible = false;
    private static final String DEFAULT_PROFILE = "NetBeans";
    private static final String FATTR_CURRENT_KEYMAP_PROFILE = "currentKeymap";
    private static final String KEYMAPS_FOLDER = "Keymaps";

    public static SearchBar getInstance() {
        if (searchbarInstance == null) {
            searchbarInstance = new SearchBar();
        }
        return searchbarInstance;
    }

    public static SearchBar getInstance(JTextComponent component) {
        SearchBar searchbarIns = SearchBar.getInstance();
        if (searchbarIns.getActualTextComponent() != component) {
            searchbarIns.setActualTextComponent(component);
        }
        return searchbarIns;
    }

    private SearchBar() {
        this.addEscapeKeystrokeFocusBackTo(this);
        this.setLayout(new BoxLayout(this, 2));
        this.setFocusCycleRoot(true);
        Color bgColor = this.getBackground();
        bgColor = new Color(Math.max(0, bgColor.getRed() - 20), Math.max(0, bgColor.getGreen() - 20), Math.max(0, bgColor.getBlue() - 20));
        this.setBackground(bgColor);
        this.setForeground(DEFAULT_FG_COLOR);
        this.add(Box.createHorizontalStrut(8));
        SearchComboBox scb = new SearchComboBox();
        this.incSearchComboBox = scb;
        scb.getEditor().getEditorComponent().setBackground(bgColor);
        this.incSearchComboBox.setFocusable(false);
        this.incSearchComboBox.addPopupMenuListener(new SearchPopupMenuListener());
        this.incSearchTextField = scb.getEditorPane();
        this.incSearchTextField.setToolTipText(NbBundle.getMessage(SearchBar.class, (String)"TOOLTIP_IncrementalSearchText"));
        this.incSearchTextFieldListener = this.createIncSearchTextFieldListener(this.incSearchTextField);
        this.incSearchTextField.getDocument().addDocumentListener(this.incSearchTextFieldListener);
        this.addEnterKeystrokeFindNextTo(this.incSearchTextField);
        this.addShiftEnterKeystrokeFindPreviousTo(this.incSearchTextField);
        if (this.getCurrentKeyMapProfile().startsWith("Emacs")) {
            this.emacsProfileFix(this.incSearchTextField);
        }
        this.incSearchTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                if (ReplaceBar.getInstance(SearchBar.getInstance()).isVisible()) {
                    ReplaceBar.getInstance(SearchBar.getInstance()).getReplaceTextField().select(0, 0);
                }
                SearchBar.this.hadFocusOnIncSearchTextField = true;
                SearchBar.this.incSearchTextField.selectAll();
            }
        });
        this.findLabel = new JLabel();
        Mnemonics.setLocalizedText((JLabel)this.findLabel, (String)NbBundle.getMessage(SearchBar.class, (String)"CTL_Find"));
        this.findLabel.setLabelFor(this.incSearchTextField);
        this.add(this.findLabel);
        this.add(this.incSearchComboBox);
        JToolBar.Separator leftSeparator = new JToolBar.Separator();
        leftSeparator.setOrientation(1);
        this.add(leftSeparator);
        this.findPreviousButton = this.createFindButton("org/netbeans/modules/editor/resources/find_previous.png", "CTL_FindPrevious");
        this.findPreviousButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchBar.this.findPrevious();
            }
        });
        this.add(this.findPreviousButton);
        this.findNextButton = this.createFindButton("org/netbeans/modules/editor/resources/find_next.png", "CTL_FindNext");
        this.findNextButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchBar.this.findNext();
            }
        });
        this.add(this.findNextButton);
        JToolBar.Separator rightSeparator = new JToolBar.Separator();
        rightSeparator.setOrientation(1);
        this.add(rightSeparator);
        this.matchCaseCheckBox = this.createCheckBox("CTL_MatchCase", "find-match-case");
        this.add(this.matchCaseCheckBox);
        this.wholeWordsCheckBox = this.createCheckBox("CTL_WholeWords", "find-whole-words");
        this.add(this.wholeWordsCheckBox);
        this.regexpCheckBox = this.createRegExpCheckBox("CTL_Regexp", "find-reg-exp");
        this.add(this.regexpCheckBox);
        this.highlightCheckBox = this.createCheckBox("CTL_Highlight", "find-highlight-search");
        this.add(this.highlightCheckBox);
        EditorFindSupport.getInstance().addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)EditorFindSupport.getInstance()));
        this.wrapAroundCheckBox = this.createCheckBox("CTL_WrapAround", "find-wrap-search");
        this.add(this.wrapAroundCheckBox);
        this.selectCheckBoxes();
        this.expandMenu = new SearchExpandMenu(this.matchCaseCheckBox.getHeight());
        JButton expButton = this.expandMenu.getExpandButton();
        expButton.setMnemonic(NbBundle.getMessage(SearchBar.class, (String)"CTL_ExpandButton_Mnemonic").charAt(0));
        expButton.setToolTipText(NbBundle.getMessage(SearchBar.class, (String)"TOOLTIP_ExpandButton"));
        this.add(expButton);
        this.add(this.expandMenu.getPadding());
        this.closeButton = this.createCloseButton();
        this.add(this.closeButton);
        this.makeBarExpandable(this.expandMenu);
        this.setVisible(false);
        SearchBar.usageLogging();
    }

    private static void usageLogging() {
        Logger logger = Logger.getLogger("org.netbeans.ui.metrics.editor");
        LogRecord rec = new LogRecord(Level.INFO, "USG_SEARCH_TYPE");
        Preferences prefs = (Preferences)MimeLookup.getLookup((MimePath)MimePath.EMPTY).lookup(Preferences.class);
        rec.setParameters(new Object[]{prefs.get("editor-search-type", "default")});
        rec.setLoggerName(logger.getName());
        logger.log(rec);
    }

    private void makeBarExpandable(SearchExpandMenu expMenu) {
        expMenu.addToInbar(this.matchCaseCheckBox);
        expMenu.addToInbar(this.wholeWordsCheckBox);
        expMenu.addToInbar(this.regexpCheckBox);
        expMenu.addToInbar(this.highlightCheckBox);
        expMenu.addToInbar(this.wrapAroundCheckBox);
        expMenu.addAllToBarOrder(Arrays.asList(this.getComponents()));
        this.remove(this.getExpandButton());
        this.getExpandButton().setVisible(false);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt == null || evt.getPropertyName() == null || evt.getPropertyName().equals("find-highlight-search")) {
            Boolean value = (Boolean)EditorFindSupport.getInstance().getFindProperty("find-highlight-search");
            this.highlightCheckBox.setSelected(value == null ? false : value);
        }
    }

    void updateIncSearchComboBoxHistory(String incrementalSearchText) {
        EditorFindSupport.getInstance().addToHistory(new EditorFindSupport.SPW(incrementalSearchText, this.wholeWordsCheckBox.isSelected(), this.matchCaseCheckBox.isSelected(), this.regexpCheckBox.isSelected()));
        this.incSearchTextField.getDocument().removeDocumentListener(this.incSearchTextFieldListener);
        for (int i = this.incSearchComboBox.getItemCount() - 1; i >= 0; --i) {
            String item = (String)this.incSearchComboBox.getItemAt(i);
            if (!item.equals(incrementalSearchText)) continue;
            this.incSearchComboBox.removeItemAt(i);
        }
        ((MutableComboBoxModel)this.incSearchComboBox.getModel()).insertElementAt(incrementalSearchText, 0);
        this.incSearchComboBox.setSelectedIndex(0);
        this.incSearchTextField.getDocument().addDocumentListener(this.incSearchTextFieldListener);
    }

    private FocusAdapter createFocusAdapterForComponent() {
        return new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                if (e.getOppositeComponent() instanceof JRootPane) {
                    return;
                }
                SearchBar.this.hadFocusOnIncSearchTextField = false;
                if (SearchBar.isClosingSearchType() && !ReplaceBar.getInstance(SearchBar.getInstance()).isVisible()) {
                    SearchBar.this.looseFocus();
                }
            }
        };
    }

    private PropertyChangeListener createPropertyChangeListenerForComponent() {
        PropertyChangeListener pcl = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt == null || !"keymap".equals(evt.getPropertyName())) {
                    return;
                }
                JTextComponent lastFocusedComponent = EditorRegistry.lastFocusedComponent();
                if (lastFocusedComponent == null) {
                    return;
                }
                Keymap keymap = lastFocusedComponent.getKeymap();
                if (keymap instanceof MultiKeymap) {
                    Action[] actions;
                    MultiKeymap multiKeymap = (MultiKeymap)keymap;
                    for (Action action : actions = lastFocusedComponent.getActions()) {
                        String actionName = (String)action.getValue("Name");
                        if (actionName == null) {
                            LOG.log(Level.WARNING, "SearchBar: Null Action.NAME property of action: {0}\n", action);
                            continue;
                        }
                        if (actionName.equals("incremental-search-forward") || actionName.equals("find-next")) {
                            this.keystrokeForSearchAction(multiKeymap, action, new AbstractAction(){

                                @Override
                                public void actionPerformed(ActionEvent e) {
                                    SearchBar.this.findNext();
                                }
                            });
                            continue;
                        }
                        if (!actionName.equals("incremental-search-backward") && !actionName.equals("find-previous")) continue;
                        this.keystrokeForSearchAction(multiKeymap, action, new AbstractAction(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                SearchBar.this.findPrevious();
                            }
                        });
                    }
                }
            }

            private void keystrokeForSearchAction(MultiKeymap multiKeymap, Action searchAction, AbstractAction newSearchAction) {
                KeyStroke[] keyStrokes = multiKeymap.getKeyStrokesForAction(searchAction);
                if (keyStrokes != null) {
                    InputMap inputMap = SearchBar.this.getInputMap(1);
                    for (KeyStroke ks : keyStrokes) {
                        LOG.log(Level.FINE, "found {1} search action, {0}", new Object[]{ks, searchAction.getValue("Name")});
                        inputMap.put(ks, (String)searchAction.getValue("Name"));
                    }
                    SearchBar.this.getActionMap().put((String)searchAction.getValue("Name"), newSearchAction);
                }
            }
        };
        pcl.propertyChange(new PropertyChangeEvent(this, "keymap", null, null));
        return pcl;
    }

    private void addShiftEnterKeystrokeFindPreviousTo(JTextComponent incSearchTextField) {
        incSearchTextField.getInputMap().put(KeyStroke.getKeyStroke(10, 1, true), "incremental-find-previous");
        incSearchTextField.getActionMap().put("incremental-find-previous", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchBar.this.findPrevious();
            }
        });
    }

    private void addEnterKeystrokeFindNextTo(JTextComponent incSearchTextField) {
        incSearchTextField.getInputMap().put(KeyStroke.getKeyStroke(10, 0, true), "incremental-find-next");
        incSearchTextField.getActionMap().put("incremental-find-next", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchBar.this.findNext();
                if (SearchBar.isClosingSearchType() && !ReplaceBar.getInstance(SearchBar.getInstance()).isVisible()) {
                    SearchBar.this.looseFocus();
                }
            }
        });
    }

    private DocumentListener createIncSearchTextFieldListener(final JTextComponent incSearchTextField) {
        final Timer searchDelayTimer = new Timer(300, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchBar.this.incrementalSearch();
            }
        });
        searchDelayTimer.setRepeats(false);
        return new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                if (incSearchTextField.getText().length() > 3) {
                    searchDelayTimer.setInitialDelay(20);
                }
                searchDelayTimer.restart();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                if (incSearchTextField.getText().length() <= 3) {
                    searchDelayTimer.setInitialDelay(300);
                }
                searchDelayTimer.restart();
            }
        };
    }

    private JButton createCloseButton() {
        JButton button = CloseButtonFactory.createBigCloseButton();
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchBar.this.looseFocus();
            }
        });
        button.setToolTipText(NbBundle.getMessage(SearchBar.class, (String)"TOOLTIP_CloseIncrementalSearchSidebar"));
        return button;
    }

    private JCheckBox createRegExpCheckBox(String resName, final String findConstant) {
        JCheckBox regExpCheckBox = new JCheckBox(){

            @Override
            public void setSelected(boolean b) {
                super.setSelected(b);
                SearchBar.this.wholeWordsCheckBox.setEnabled(!SearchBar.this.regexpCheckBox.isSelected());
            }
        };
        regExpCheckBox.setOpaque(false);
        Mnemonics.setLocalizedText((AbstractButton)regExpCheckBox, (String)NbBundle.getMessage(SearchBar.class, (String)resName));
        regExpCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchBar.this.switchFindSupportValue(findConstant);
                SearchBar.this.wholeWordsCheckBox.setEnabled(!SearchBar.this.regexpCheckBox.isSelected());
                SearchBar.this.incrementalSearch();
            }
        });
        regExpCheckBox.setMargin(BUTTON_INSETS);
        regExpCheckBox.setFocusable(false);
        return regExpCheckBox;
    }

    JCheckBox createCheckBox(String resName, final String findConstant) {
        JCheckBox checkBox = new JCheckBox();
        checkBox.setOpaque(false);
        Mnemonics.setLocalizedText((AbstractButton)checkBox, (String)NbBundle.getMessage(SearchBar.class, (String)resName));
        checkBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchBar.this.switchFindSupportValue(findConstant);
                SearchBar.this.incrementalSearch();
            }
        });
        checkBox.setMargin(BUTTON_INSETS);
        checkBox.setFocusable(false);
        return checkBox;
    }

    private void selectCheckBoxes() {
        this.wholeWordsCheckBox.setSelected(this.getFindSupportValue("find-whole-words"));
        this.wholeWordsCheckBox.setEnabled(!this.getRegExp());
        this.matchCaseCheckBox.setSelected(this.getFindSupportValue("find-match-case"));
        this.regexpCheckBox.setSelected(this.getRegExp());
        this.highlightCheckBox.setSelected(this.getFindSupportValue("find-highlight-search"));
        this.wrapAroundCheckBox.setSelected(this.getFindSupportValue("find-wrap-search"));
    }

    private JButton createFindButton(String imageIcon, String resName) {
        JButton button = new JButton(ImageUtilities.loadImageIcon((String)imageIcon, (boolean)false));
        Mnemonics.setLocalizedText((AbstractButton)button, (String)NbBundle.getMessage(SearchBar.class, (String)resName));
        button.setMargin(BUTTON_INSETS);
        return button;
    }

    private void emacsProfileFix(JTextComponent incSearchTextField) {
        String actionName = "caret-begin-line";
        class JumpOutOfSearchAction
        extends AbstractAction {
            private String actionName;

            public JumpOutOfSearchAction(String n) {
                this.actionName = n;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchBar.this.looseFocus();
                if (SearchBar.this.getActualTextComponent() != null) {
                    ActionEvent ev = new ActionEvent(SearchBar.this.getActualTextComponent(), e.getID(), e.getActionCommand(), e.getModifiers());
                    Action action = SearchBar.this.getActualTextComponent().getActionMap().get(this.actionName);
                    action.actionPerformed(ev);
                }
            }
        }
        JumpOutOfSearchAction a1 = new JumpOutOfSearchAction(actionName);
        incSearchTextField.getActionMap().put(actionName, a1);
        actionName = "caret-end-line";
        JumpOutOfSearchAction a2 = new JumpOutOfSearchAction(actionName);
        incSearchTextField.getActionMap().put(actionName, a2);
        incSearchTextField.getInputMap().put(KeyStroke.getKeyStroke(80, 2, false), "caret-up-alt");
        actionName = "caret-up";
        JumpOutOfSearchAction a3 = new JumpOutOfSearchAction(actionName);
        incSearchTextField.getActionMap().put("caret-up-alt", a3);
        incSearchTextField.getInputMap().put(KeyStroke.getKeyStroke(78, 2, false), "caret-down-alt");
        actionName = "caret-down";
        JumpOutOfSearchAction a4 = new JumpOutOfSearchAction(actionName);
        incSearchTextField.getActionMap().put("caret-down-alt", a4);
    }

    private String getCurrentKeyMapProfile() {
        Object o;
        String currentKeyMapProfile = null;
        FileObject fo = FileUtil.getConfigFile((String)KEYMAPS_FOLDER);
        if (fo != null && (o = fo.getAttribute(FATTR_CURRENT_KEYMAP_PROFILE)) instanceof String) {
            currentKeyMapProfile = (String)o;
        }
        if (currentKeyMapProfile == null) {
            currentKeyMapProfile = DEFAULT_PROFILE;
        }
        return currentKeyMapProfile;
    }

    @Override
    public Dimension getPreferredSize() {
        this.expandMenu.computeLayout(this);
        return super.getPreferredSize();
    }

    @Override
    public String getName() {
        return "editorSearchBar";
    }

    void addEscapeKeystrokeFocusBackTo(JComponent component) {
        component.getInputMap(1).put(KeyStroke.getKeyStroke(27, 0, true), "loose-focus");
        component.getActionMap().put("loose-focus", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!SearchBar.this.popupMenuWasCanceled) {
                    SearchBar.this.looseFocus();
                    if (SearchBar.isClosingSearchType()) {
                        SearchBar.this.getActualTextComponent().scrollRectToVisible(SearchBar.this.actualViewPort);
                    }
                } else {
                    SearchBar.this.popupMenuWasCanceled = false;
                }
            }
        });
    }

    private static boolean isClosingSearchType() {
        Preferences prefs = (Preferences)MimeLookup.getLookup((MimePath)MimePath.EMPTY).lookup(Preferences.class);
        return prefs.get("editor-search-type", "default").equals("closing");
    }

    public void gainFocus() {
        String lastSearch = "";
        if (!SearchBar.isClosingSearchType()) {
            lastSearch = this.incSearchTextField.getText();
        }
        this.incSearchTextField.getDocument().removeDocumentListener(this.incSearchTextFieldListener);
        SearchComboBoxEditor.changeToOneLineEditorPane((JEditorPane)this.incSearchTextField);
        this.addEnterKeystrokeFindNextTo(this.incSearchTextField);
        this.incSearchTextField.getDocument().addDocumentListener(this.incSearchTextFieldListener);
        MutableComboBoxModel comboBoxModelIncSearch = (MutableComboBoxModel)this.incSearchComboBox.getModel();
        for (int i = comboBoxModelIncSearch.getSize() - 1; i >= 0; --i) {
            comboBoxModelIncSearch.removeElementAt(i);
        }
        for (EditorFindSupport.SPW spw : EditorFindSupport.getInstance().getHistory()) {
            comboBoxModelIncSearch.addElement(spw.getSearchExpression());
        }
        if (!SearchBar.isClosingSearchType()) {
            this.incSearchTextField.setText(lastSearch);
        }
        if (!this.isVisible() && SearchBar.isClosingSearchType()) {
            this.whenOpenedWasNotVisible = true;
        }
        if (this.whenOpenedWasNotVisible) {
            this.incSearchTextField.setText("");
            this.whenOpenedWasNotVisible = false;
        }
        this.hadFocusOnIncSearchTextField = true;
        this.setVisible(true);
        this.initBlockSearch();
        EditorFindSupport.getInstance().setFocusedTextComponent(this.getActualTextComponent());
        this.incSearchTextField.requestFocusInWindow();
        if (this.incSearchTextField.getText().length() > 0) {
            this.incSearchTextField.selectAll();
            this.findPreviousButton.setEnabled(true);
            this.findNextButton.setEnabled(true);
        } else {
            this.findPreviousButton.setEnabled(false);
            this.findNextButton.setEnabled(false);
        }
        this.actualViewPort = this.getActualTextComponent().getVisibleRect();
        if (!SearchBar.isClosingSearchType() && this.highlightCanceled) {
            this.searchProps.setProperty("find-highlight-search", Boolean.TRUE);
            this.highlightCanceled = false;
        }
    }

    public void looseFocus() {
        this.hadFocusOnIncSearchTextField = false;
        if (!this.isVisible()) {
            return;
        }
        EditorFindSupport.getInstance().setBlockSearchHighlight(0, 0);
        EditorFindSupport.getInstance().incSearchReset();
        EditorFindSupport.getInstance().setFocusedTextComponent(null);
        if (this.getActualTextComponent() != null) {
            Utilities.setStatusText((JTextComponent)this.getActualTextComponent(), (String)"");
            this.getActualTextComponent().requestFocusInWindow();
        }
        this.setVisible(false);
        if (!SearchBar.isClosingSearchType() && this.getFindSupportValue("find-highlight-search")) {
            this.searchProps.setProperty("find-highlight-search", Boolean.FALSE);
            this.highlightCanceled = true;
        }
    }

    private void incrementalSearch() {
        if (this.getActualTextComponent() == null) {
            return;
        }
        String incrementalSearchText = this.incSearchTextField.getText();
        boolean empty = incrementalSearchText.length() <= 0;
        this.findPreviousButton.setEnabled(!empty);
        this.findNextButton.setEnabled(!empty);
        ReplaceBar.getInstance(this).getReplaceButton().setEnabled(!empty);
        ReplaceBar.getInstance(this).getReplaceAllButton().setEnabled(!empty);
        EditorFindSupport findSupport = EditorFindSupport.getInstance();
        findSupport.putFindProperties(this.getSearchProperties());
        int caretPosition = this.getActualTextComponent().getSelectionStart();
        if (SearchBar.isClosingSearchType()) {
            caretPosition = this.getActualTextComponent().getCaretPosition();
        }
        if (this.regexpCheckBox.isSelected()) {
            Pattern pattern;
            String patternErrorMsg = null;
            try {
                pattern = Pattern.compile(incrementalSearchText);
            }
            catch (PatternSyntaxException e) {
                pattern = null;
                patternErrorMsg = e.getDescription();
            }
            if (pattern != null) {
                this.incSearchTextField.setForeground(DEFAULT_FG_COLOR);
                Utilities.setStatusText((JTextComponent)this.getActualTextComponent(), (String)"", (int)900);
            } else {
                this.incSearchTextField.setForeground(INVALID_REGEXP);
                Utilities.setStatusBoldText((JTextComponent)this.getActualTextComponent(), (String)NbBundle.getMessage(SearchBar.class, (String)"incremental-search-invalid-regexp", (Object)patternErrorMsg));
            }
        } else if (findSupport.incSearch(this.searchProps.getProperties(), caretPosition) || empty) {
            this.incSearchTextField.setForeground(DEFAULT_FG_COLOR);
            Utilities.setStatusText((JTextComponent)this.getActualTextComponent(), (String)"", (int)900);
        } else {
            this.incSearchTextField.setForeground(NOT_FOUND);
            Utilities.setStatusText((JTextComponent)this.getActualTextComponent(), (String)NbBundle.getMessage(SearchBar.class, (String)"incremental-search-not-found", (Object)incrementalSearchText), (int)900);
            Toolkit.getDefaultToolkit().beep();
        }
    }

    void findNext() {
        this.find(true);
    }

    void findPrevious() {
        this.find(false);
    }

    private void find(boolean next) {
        String incrementalSearchText = this.incSearchTextField.getText();
        boolean empty = incrementalSearchText.length() <= 0;
        this.updateIncSearchComboBoxHistory(incrementalSearchText);
        EditorFindSupport findSupport = EditorFindSupport.getInstance();
        Map<String, Object> actualfindProps = this.getSearchProperties();
        findSupport.putFindProperties(actualfindProps);
        if (findSupport.find(actualfindProps, !next) || empty) {
            this.incSearchTextField.setForeground(DEFAULT_FG_COLOR);
        } else {
            this.incSearchTextField.setForeground(NOT_FOUND);
            Toolkit.getDefaultToolkit().beep();
        }
    }

    void initBlockSearch() {
        JTextComponent c = this.getActualTextComponent();
        boolean blockSearchVisible = false;
        if (c != null) {
            int startSelection = c.getSelectionStart();
            int endSelection = c.getSelectionEnd();
            Document doc = c.getDocument();
            if (doc instanceof BaseDocument) {
                BaseDocument bdoc = (BaseDocument)doc;
                try {
                    int startLine = Utilities.getLineOffset((BaseDocument)bdoc, (int)startSelection);
                    int endLine = Utilities.getLineOffset((BaseDocument)bdoc, (int)endSelection);
                    if (endLine > startLine) {
                        blockSearchVisible = true;
                    }
                }
                catch (BadLocationException ble) {
                    // empty catch block
                }
            }
            if (!blockSearchVisible) {
                String findWhat;
                String selText = c.getSelectedText();
                if (selText != null && selText.length() > 0) {
                    int n = selText.indexOf(10);
                    if (n >= 0) {
                        selText = selText.substring(0, n);
                    }
                    this.incSearchTextField.setText(selText);
                } else if (SearchBar.isClosingSearchType() && (findWhat = (String)EditorFindSupport.getInstance().getFindProperty("find-what")) != null && findWhat.length() > 0) {
                    this.incSearchTextField.getDocument().removeDocumentListener(this.incSearchTextFieldListener);
                    this.incSearchTextField.setText(findWhat);
                    this.incSearchTextField.getDocument().addDocumentListener(this.incSearchTextFieldListener);
                }
            }
            int blockSearchStartOffset = blockSearchVisible ? startSelection : 0;
            int blockSearchEndOffset = blockSearchVisible ? endSelection : 0;
            try {
                this.searchProps.setProperty("find-block-search", blockSearchVisible);
                this.searchProps.setProperty("find-block-search-start", doc.createPosition(blockSearchStartOffset));
                this.searchProps.setProperty("find-block-search-end", doc.createPosition(blockSearchEndOffset));
                EditorFindSupport.getInstance().setBlockSearchHighlight(blockSearchStartOffset, blockSearchEndOffset);
            }
            catch (BadLocationException ble) {
                this.searchProps.setProperty("find-block-search", Boolean.FALSE);
                this.searchProps.setProperty("find-block-search-start", null);
                this.searchProps.setProperty("find-block-search-end", null);
            }
            EditorFindSupport.getInstance().putFindProperties(this.searchProps.getProperties());
        }
    }

    boolean getFindSupportValue(String findConstant) {
        Boolean b = (Boolean)this.searchProps.getProperty(findConstant);
        return b != null ? b : false;
    }

    private void switchFindSupportValue(String findConstant) {
        this.searchProps.setProperty(findConstant, !this.getFindSupportValue(findConstant));
    }

    boolean getRegExp() {
        return this.getFindSupportValue("find-reg-exp");
    }

    boolean hadFocusOnTextField() {
        return this.hadFocusOnIncSearchTextField;
    }

    void lostFocusOnTextField() {
        this.hadFocusOnIncSearchTextField = false;
    }

    void setActualTextComponent(JTextComponent component) {
        if (this.getActualTextComponent() != null) {
            this.getActualTextComponent().removeFocusListener(this.focusAdapterForComponent);
            this.getActualTextComponent().removePropertyChangeListener(this.propertyChangeListenerForComponent);
        }
        if (this.focusAdapterForComponent == null) {
            this.focusAdapterForComponent = this.createFocusAdapterForComponent();
        }
        if (this.propertyChangeListenerForComponent == null) {
            this.propertyChangeListenerForComponent = this.createPropertyChangeListenerForComponent();
        }
        component.addFocusListener(this.focusAdapterForComponent);
        component.addPropertyChangeListener(this.propertyChangeListenerForComponent);
        for (PropertyChangeListener pcl : this.actualComponentListeners) {
            pcl.propertyChange(new PropertyChangeEvent(this, "actualTextComponent", this.getActualTextComponent(), component));
        }
        this.actualTextComponent = new WeakReference<JTextComponent>(component);
        EditorFindSupport.getInstance().setFocusedTextComponent(this.getActualTextComponent());
    }

    void addActualComponentListener(PropertyChangeListener propertyChangeListener) {
        this.actualComponentListeners.add(propertyChangeListener);
    }

    public JTextComponent getActualTextComponent() {
        return this.actualTextComponent != null ? (JTextComponent)this.actualTextComponent.get() : null;
    }

    JTextComponent getIncSearchTextField() {
        return this.incSearchTextField;
    }

    JButton getCloseButton() {
        return this.closeButton;
    }

    JLabel getFindLabel() {
        return this.findLabel;
    }

    JButton getFindNextButton() {
        return this.findNextButton;
    }

    JButton getFindPreviousButton() {
        return this.findPreviousButton;
    }

    public Map<String, Object> getSearchProperties() {
        this.searchProps.setProperty("find-what", this.incSearchTextField.getText());
        this.searchProps.setProperty("find-match-case", this.matchCaseCheckBox.isSelected());
        this.searchProps.setProperty("find-whole-words", this.wholeWordsCheckBox.isSelected());
        this.searchProps.setProperty("find-reg-exp", this.regexpCheckBox.isSelected());
        this.searchProps.setProperty("find-backward-search", Boolean.FALSE);
        this.searchProps.setProperty("find-inc-search", Boolean.TRUE);
        this.searchProps.setProperty("find-highlight-search", this.highlightCheckBox.isSelected());
        this.searchProps.setProperty("find-wrap-search", this.wrapAroundCheckBox.isSelected());
        return this.searchProps.getProperties();
    }

    public void setSearchProperties(SearchPropertiesSupport.SearchProperties searchProperties) {
        this.searchProps = searchProperties;
        this.selectCheckBoxes();
    }

    JCheckBox getMatchCaseCheckBox() {
        return this.matchCaseCheckBox;
    }

    JCheckBox getRegexpCheckBox() {
        return this.regexpCheckBox;
    }

    JComponent getExpandButton() {
        return this.expandMenu.getExpandButton();
    }

    public boolean isPopupMenuWasCanceled() {
        return this.popupMenuWasCanceled;
    }

    public void setPopupMenuWasCanceled(boolean popupMenuWasCanceled) {
        this.popupMenuWasCanceled = popupMenuWasCanceled;
    }

    public JComboBox getIncSearchComboBox() {
        return this.incSearchComboBox;
    }

    private class SearchPopupMenuListener
    implements PopupMenuListener {
        private boolean canceled = false;

        private SearchPopupMenuListener() {
        }

        @Override
        public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
        }

        @Override
        public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            if (!this.canceled) {
                Object selectedItem = SearchBar.this.getIncSearchComboBox().getModel().getSelectedItem();
                if (selectedItem instanceof String) {
                    String findWhat = (String)selectedItem;
                    for (EditorFindSupport.SPW spw : EditorFindSupport.getInstance().getHistory()) {
                        if (!findWhat.equals(spw.getSearchExpression())) continue;
                        SearchBar.getInstance().getRegexpCheckBox().setSelected(spw.isRegExp());
                        break;
                    }
                }
            } else {
                this.canceled = false;
            }
        }

        @Override
        public void popupMenuCanceled(PopupMenuEvent e) {
            this.canceled = true;
            SearchBar.getInstance().setPopupMenuWasCanceled(true);
        }
    }
}

