/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ejbjarproject;

import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.debugger.jpda.AttachingDICookie;
import org.netbeans.api.j2ee.core.Profile;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.common.project.ui.J2EEProjectProperties;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.j2ee.deployment.plugins.api.ServerDebugInfo;
import org.netbeans.modules.j2ee.ejbjarproject.EjbJarProject;
import org.netbeans.modules.j2ee.ejbjarproject.ui.customizer.EjbJarProjectProperties;
import org.netbeans.modules.java.api.common.ant.UpdateHelper;
import org.netbeans.modules.java.api.common.project.BaseActionProvider;
import org.netbeans.spi.java.classpath.ClassPathFactory;
import org.netbeans.spi.java.classpath.ClassPathImplementation;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.netbeans.spi.java.project.classpath.support.ProjectClassPathSupport;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

class EjbJarActionProvider
extends BaseActionProvider {
    private static final String DIRECTORY_DEPLOYMENT_SUPPORTED = "directory.deployment.supported";
    private static final String COMMAND_VERIFY = "verify";
    private static final String[] supportedActions = new String[]{"build", "clean", "rebuild", "compile.single", "run", "run.single", "debug", "debug.single", "profile", "profile.single", "redeploy", "javadoc", "test", "test.single", "debug.test.single", "profile.test.single", "run.single.method", "debug.single.method", "debug.fix", "verify", "delete", "copy", "move", "rename"};
    private static final String[] platformSensitiveActions = new String[]{"build", "rebuild", "compile.single", "run.single", "debug.single", "profile.single", "javadoc", "test", "test.single", "debug.test.single", "profile.test.single", "run.single.method", "debug.single.method"};
    private final EjbJarProject project;
    private Set<String> bkgScanSensitiveActions;
    private Set<String> needJavaModelActions;
    private static final String[] actionsDisabledForQuickRun = new String[]{"compile.single", "debug.fix"};
    private Map<String, String[]> commands;

    public EjbJarActionProvider(EjbJarProject ejbJarProject, UpdateHelper updateHelper) {
        super((Project)ejbJarProject, updateHelper, ejbJarProject.evaluator(), ejbJarProject.getSourceRoots(), ejbJarProject.getTestSourceRoots(), ejbJarProject.getAntProjectHelper(), (BaseActionProvider.Callback)new CallbackImpl(new BaseActionProvider.CallbackImpl(ejbJarProject.getClassPathProvider()), ejbJarProject.getEjbModule()));
        this.project = ejbJarProject;
        this.commands = new HashMap<String, String[]>();
        this.commands.put("build", new String[]{"dist"});
        this.commands.put("clean", new String[]{"clean"});
        this.commands.put("rebuild", new String[]{"clean", "dist"});
        this.commands.put("compile.single", new String[]{"compile-single"});
        this.commands.put("run", new String[]{"run"});
        this.commands.put("run.single", new String[]{"run-main"});
        this.commands.put("redeploy", new String[]{"run"});
        this.commands.put("debug", new String[]{"debug"});
        this.commands.put("profile", new String[]{"profile"});
        this.commands.put("javadoc", new String[]{"javadoc"});
        this.commands.put("test", new String[]{"test"});
        this.commands.put("test.single", new String[]{"test-single"});
        this.commands.put("debug.test.single", new String[]{"debug-test"});
        this.commands.put("debug.fix", new String[]{"debug-fix"});
        this.commands.put(COMMAND_VERIFY, new String[]{COMMAND_VERIFY});
        this.commands.put("debug.single", new String[]{"debug-single"});
        this.commands.put("profile.single", new String[]{"profile-single"});
        this.bkgScanSensitiveActions = new HashSet<String>(Arrays.asList("run.single"));
        this.needJavaModelActions = new HashSet<String>(Arrays.asList("debug.fix"));
        this.setServerExecution(true);
    }

    protected String[] getPlatformSensitiveActions() {
        return platformSensitiveActions;
    }

    protected String[] getActionsDisabledForQuickRun() {
        return actionsDisabledForQuickRun;
    }

    public Map<String, String[]> getCommands() {
        return this.commands;
    }

    protected Set<String> getScanSensitiveActions() {
        return this.bkgScanSensitiveActions;
    }

    protected Set<String> getJavaModelActions() {
        return this.needJavaModelActions;
    }

    protected boolean isCompileOnSaveEnabled() {
        return Boolean.parseBoolean(this.getEvaluator().getProperty("j2ee.compile.on.save"));
    }

    public String[] getSupportedActions() {
        return supportedActions;
    }

    protected void updateJavaRunnerClasspath(String string, Map<String, Object> map) {
        if ("test.single".equals(string) || "debug.test.single".equals(string) || "debug.single.method".equals(string) || "run.single.method".equals(string) || "run.single".equals(string) || "debug.single".equals(string) || "profile.single".equals(string) || "profile.test.single".equals(string)) {
            String string2;
            FileObject fileObject = (FileObject)map.get("execute.file");
            ClassPath classPath = this.getCallback().findClassPath(fileObject, "classpath/execute");
            ClassPath classPath2 = ClassPathFactory.createClassPath((ClassPathImplementation)ProjectClassPathSupport.createPropertyBasedClassPathImplementation((File)FileUtil.toFile((FileObject)this.getProject().getProjectDirectory()), (PropertyEvaluator)this.getEvaluator(), (String[])new String[]{"j2ee.platform.classpath", "j2ee.platform.embeddableejb.classpath"}));
            classPath = ClassPathSupport.createProxyClassPath((ClassPath[])new ClassPath[]{classPath, classPath2});
            map.put("execute.classpath", classPath);
            LinkedList<String> linkedList = (LinkedList<String>)map.get("run.jvmargs");
            if (linkedList == null) {
                linkedList = new LinkedList<String>();
                map.put("run.jvmargs", linkedList);
            }
            if ((string2 = this.getEvaluator().getProperty("runmain.jvmargs")) != null && string2.trim().length() > 0) {
                linkedList.add(string2);
            }
            if ((string2 = this.getEvaluator().getProperty("endorsed.classpath")) != null && string2.trim().length() > 0) {
                ClassPath classPath3 = ClassPathFactory.createClassPath((ClassPathImplementation)ProjectClassPathSupport.createPropertyBasedClassPathImplementation((File)FileUtil.toFile((FileObject)this.getProject().getProjectDirectory()), (PropertyEvaluator)this.getEvaluator(), (String[])new String[]{"endorsed.classpath"}));
                linkedList.add("-Xbootclasspath/p:\"" + classPath3.toString(ClassPath.PathConversionMode.WARN) + "\"");
            }
        }
    }

    public String[] getTargetNames(String string, Lookup lookup, Properties properties, boolean bl) throws IllegalArgumentException {
        if (string.equals("run.single") || string.equals("run") || string.equals("redeploy") || string.equals("debug") || string.equals("debug.single") || string.equals("debug.fix") || string.equals("test.single") || string.equals("debug.test.single") || string.equals("profile") || string.equals("profile.single") || string.equals("profile.test.single")) {
            this.setDirectoryDeploymentProperty(properties);
        }
        if (string.equals("run") || string.equals("redeploy")) {
            if (!this.isSelectedServer()) {
                return null;
            }
            if (this.isDebugged()) {
                properties.setProperty("is.debugged", "true");
            }
            if (string.equals("redeploy")) {
                properties.setProperty("forceRedeploy", "true");
            } else {
                properties.setProperty("forceRedeploy", "false");
            }
            return this.commands.get(string);
        }
        return super.getTargetNames(string, lookup, properties, bl);
    }

    private void setDirectoryDeploymentProperty(Properties properties) {
        String string = this.getAntProjectHelper().getStandardPropertyEvaluator().getProperty("j2ee.server.instance");
        if (string != null) {
            J2eeModuleProvider j2eeModuleProvider = (J2eeModuleProvider)this.getProject().getLookup().lookup(J2eeModuleProvider.class);
            String string2 = j2eeModuleProvider.getServerInstanceID();
            J2eeModule j2eeModule = j2eeModuleProvider.getJ2eeModule();
            if (string2 != null && j2eeModule != null) {
                boolean bl = Deployment.getDefault().canFileDeploy(string, j2eeModule);
                properties.setProperty(DIRECTORY_DEPLOYMENT_SUPPORTED, "" + bl);
            }
        }
    }

    public boolean isActionEnabled(String string, Lookup lookup) {
        boolean bl = super.isActionEnabled(string, lookup);
        if (bl && string.equals(COMMAND_VERIFY)) {
            return ((EjbJarProject)this.getProject()).getEjbModule().hasVerifierSupport();
        }
        return bl;
    }

    private boolean isDebugged() {
        J2eeModuleProvider j2eeModuleProvider = (J2eeModuleProvider)this.getProject().getLookup().lookup(J2eeModuleProvider.class);
        ServerDebugInfo serverDebugInfo = j2eeModuleProvider.getServerDebugInfo();
        if (serverDebugInfo == null) {
            return false;
        }
        Session[] sessionArray = DebuggerManager.getDebuggerManager().getSessions();
        for (int i = 0; i < sessionArray.length; ++i) {
            Object object;
            Session session = sessionArray[i];
            if (session == null || (object = session.lookupFirst(null, AttachingDICookie.class)) == null) continue;
            AttachingDICookie attachingDICookie = (AttachingDICookie)object;
            if (!("dt_shmem".equals(serverDebugInfo.getTransport()) ? attachingDICookie.getSharedMemoryName().equalsIgnoreCase(serverDebugInfo.getShmemName()) : serverDebugInfo.getHost() != null && serverDebugInfo.getHost().equalsIgnoreCase(attachingDICookie.getHostName()) && attachingDICookie.getPortNumber() == serverDebugInfo.getPort())) continue;
            return true;
        }
        return false;
    }

    private boolean isSelectedServer() {
        String string;
        String string2;
        String string3 = this.getAntProjectHelper().getStandardPropertyEvaluator().getProperty("j2ee.server.instance");
        if (string3 != null && (string2 = Deployment.getDefault().getServerID(string3)) != null) {
            return true;
        }
        string2 = this.getAntProjectHelper().getStandardPropertyEvaluator().getProperty("j2ee.server.type");
        if (string2 != null && (string = J2EEProjectProperties.getMatchingInstance((String)string2, (J2eeModule.Type)J2eeModule.Type.EJB, (Profile)this.project.getAPIEjbJar().getJ2eeProfile())) != null) {
            this.setServerInstance(string);
            return true;
        }
        string = NbBundle.getMessage(EjbJarActionProvider.class, (String)"MSG_No_Server_Selected");
        DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)string, 2));
        return false;
    }

    private void setServerInstance(String string) {
        EjbJarProjectProperties.setServerInstance((EjbJarProject)this.getProject(), this.getAntProjectHelper(), string);
    }

    private static class CallbackImpl
    implements BaseActionProvider.Callback2 {
        private final BaseActionProvider.CallbackImpl impl;
        private final J2eeModuleProvider provider;

        public CallbackImpl(BaseActionProvider.CallbackImpl callbackImpl, J2eeModuleProvider j2eeModuleProvider) {
            this.impl = callbackImpl;
            this.provider = j2eeModuleProvider;
        }

        public ClassPath getProjectSourcesClassPath(String string) {
            return this.impl.getProjectSourcesClassPath(string);
        }

        public ClassPath findClassPath(FileObject fileObject, String string) {
            return this.impl.findClassPath(fileObject, string);
        }

        public void antTargetInvocationFailed(String string, Lookup lookup) {
            Deployment.getDefault().resumeDeployOnSave(this.provider);
        }

        public void antTargetInvocationFinished(String string, Lookup lookup, int n) {
            Deployment.getDefault().resumeDeployOnSave(this.provider);
        }

        public void antTargetInvocationStarted(String string, Lookup lookup) {
            Deployment.getDefault().suspendDeployOnSave(this.provider);
        }
    }
}

