/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.openfile;

import java.awt.Component;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.netbeans.modules.openfile.OpenFile;
import org.netbeans.modules.openfile.RecentFiles;
import org.openide.awt.DynamicMenuContent;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.actions.Presenter;

public class RecentFileAction
extends AbstractAction
implements Presenter.Menu,
PopupMenuListener,
ChangeListener {
    private static final String PATH_PROP = "RecentFileAction.Recent_File_Path";
    private static final String OFMSG_PATH_IS_NOT_DEFINED = NbBundle.getMessage(RecentFileAction.class, (String)"OFMSG_PATH_IS_NOT_DEFINED");
    private static final String OFMSG_FILE_NOT_EXISTS = NbBundle.getMessage(RecentFileAction.class, (String)"OFMSG_FILE_NOT_EXISTS");
    private static final String OFMSG_NO_RECENT_FILE = NbBundle.getMessage(RecentFileAction.class, (String)"OFMSG_NO_RECENT_FILE");
    private JMenu menu;

    public RecentFileAction() {
        super(NbBundle.getMessage(RecentFileAction.class, (String)"LBL_RecentFileAction_Name"));
    }

    public JMenuItem getMenuPresenter() {
        if (this.menu == null) {
            this.menu = new UpdatingMenu(this);
            this.menu.setMnemonic(NbBundle.getMessage(RecentFileAction.class, (String)"MNE_RecentFileAction_Name").charAt(0));
            if (!Utilities.isMac()) {
                this.menu.getPopupMenu().addPopupMenuListener(this);
            } else {
                this.menu.addChangeListener(this);
            }
        }
        return this.menu;
    }

    @Override
    public void popupMenuWillBecomeVisible(PopupMenuEvent arg0) {
        this.fillSubMenu();
    }

    @Override
    public void popupMenuWillBecomeInvisible(PopupMenuEvent arg0) {
        this.menu.removeAll();
    }

    @Override
    public void popupMenuCanceled(PopupMenuEvent arg0) {
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (this.menu.isSelected()) {
            this.popupMenuWillBecomeVisible(null);
        } else {
            this.popupMenuWillBecomeInvisible(null);
        }
    }

    private void fillSubMenu() {
        List<RecentFiles.HistoryItem> files = RecentFiles.getRecentFiles();
        boolean first = true;
        for (RecentFiles.HistoryItem hItem : files) {
            try {
                JMenuItem jmi = this.newSubMenuItem(hItem);
                this.menu.add(jmi);
                if (!first) continue;
                Object accel = this.getValue("AcceleratorKey");
                if (accel instanceof KeyStroke) {
                    jmi.setAccelerator((KeyStroke)accel);
                }
                first = false;
            }
            catch (Exception ex) {}
        }
        this.ensureSelected();
    }

    private JMenuItem newSubMenuItem(RecentFiles.HistoryItem hItem) throws DataObjectNotFoundException {
        Icon icon = this.getIcon(hItem);
        final String path = hItem.getPath();
        JMenuItem jmi = new JMenuItem(hItem.getFileName()){

            @Override
            public void menuSelectionChanged(boolean isIncluded) {
                super.menuSelectionChanged(isIncluded);
                if (isIncluded) {
                    StatusDisplayer.getDefault().setStatusText(path);
                }
            }
        };
        jmi.putClientProperty(PATH_PROP, path);
        jmi.addActionListener(this);
        jmi.setIcon(icon);
        return jmi;
    }

    private Icon getIcon(RecentFiles.HistoryItem hItem) throws DataObjectNotFoundException {
        String path = hItem.getPath();
        return this.getIcon(path);
    }

    private Icon getIcon(String path) throws DataObjectNotFoundException {
        FileObject fo = RecentFiles.convertPath2File(path);
        if (fo == null) {
            throw new NullPointerException();
        }
        DataObject dObj = DataObject.find((FileObject)fo);
        return new ImageIcon(dObj.getNodeDelegate().getIcon(1));
    }

    private void ensureSelected() {
        if (this.menu.getMenuComponentCount() <= 0) {
            return;
        }
        Component first = this.menu.getMenuComponent(0);
        if (!(first instanceof JMenuItem)) {
            return;
        }
        Point loc = MouseInfo.getPointerInfo().getLocation();
        SwingUtilities.convertPointFromScreen(loc, this.menu);
        MenuElement[] selPath = MenuSelectionManager.defaultManager().getSelectedPath();
        if (!this.menu.contains(loc) && selPath.length > 0 && this.menu.getPopupMenu() == selPath[selPath.length - 1]) {
            MenuElement[] newPath = new MenuElement[selPath.length + 1];
            System.arraycopy(selPath, 0, newPath, 0, selPath.length);
            JMenuItem firstItem = (JMenuItem)first;
            newPath[selPath.length] = firstItem;
            MenuSelectionManager.defaultManager().setSelectedPath(newPath);
        }
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        Object source = evt.getSource();
        String path = null;
        String msg = null;
        if (source instanceof JMenuItem) {
            JMenuItem menuItem = (JMenuItem)source;
            path = (String)menuItem.getClientProperty(PATH_PROP);
        } else {
            List<RecentFiles.HistoryItem> items = RecentFiles.getRecentFiles();
            if (!items.isEmpty()) {
                RecentFiles.HistoryItem item = RecentFiles.getRecentFiles().get(0);
                path = item.getPath();
            } else {
                msg = OFMSG_NO_RECENT_FILE;
            }
        }
        if (null == msg) {
            msg = this.openFile(path);
        }
        if (msg != null) {
            StatusDisplayer.getDefault().setStatusText(msg);
            Toolkit.getDefaultToolkit().beep();
            RecentFiles.pruneHistory();
        }
    }

    private String openFile(String path) {
        if (path == null || path.length() == 0) {
            return OFMSG_PATH_IS_NOT_DEFINED;
        }
        File f = new File(path);
        if (!f.exists()) {
            return OFMSG_FILE_NOT_EXISTS;
        }
        File nf = FileUtil.normalizeFile((File)f);
        return OpenFile.open(FileUtil.toFileObject((File)nf), -1);
    }

    private class UpdatingMenu
    extends JMenu
    implements DynamicMenuContent {
        private final JComponent[] content;

        public UpdatingMenu(Action action) {
            super(action);
            this.content = new JComponent[]{this};
        }

        public JComponent[] getMenuPresenters() {
            this.setEnabled(RecentFiles.hasRecentFiles());
            return this.content;
        }

        public JComponent[] synchMenuPresenters(JComponent[] items) {
            return this.getMenuPresenters();
        }
    }
}

