/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.openfile;

import java.awt.Container;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import javax.swing.text.Element;
import javax.swing.text.StyledDocument;
import org.netbeans.modules.openfile.OpenFileImpl;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.actions.FileSystemAction;
import org.openide.actions.ToolsAction;
import org.openide.awt.StatusDisplayer;
import org.openide.cookies.EditCookie;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.OpenCookie;
import org.openide.cookies.ViewCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openide.nodes.NodeOperation;
import org.openide.text.NbDocument;
import org.openide.util.ContextAwareAction;
import org.openide.util.Exceptions;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public class DefaultOpenFileImpl
implements OpenFileImpl,
Runnable {
    private final Logger log = Logger.getLogger(this.getClass().getName());
    private final FileObject fileObject;
    private final int line;

    private DefaultOpenFileImpl(FileObject fileObject, int line) {
        this.fileObject = fileObject;
        this.line = line;
    }

    public DefaultOpenFileImpl() {
        this.fileObject = null;
        this.line = -1;
    }

    protected final void setStatusLine(String text) {
        StatusDisplayer.getDefault().setStatusText(text);
    }

    protected void notifyCannotOpen(String fileName) {
        assert (EventQueue.isDispatchThread());
        DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(DefaultOpenFileImpl.class, (String)"MSG_cannotOpenWillClose", (Object)fileName)));
    }

    private boolean openEditor(final EditorCookie editorCookie, final int line) {
        StyledDocument doc;
        JEditorPane[] openPanes;
        assert (EventQueue.isDispatchThread());
        if (this.log.isLoggable(Level.FINER)) {
            this.log.log(Level.FINER, "openEditor(EditorCookie, line={0})", line);
        }
        if ((openPanes = editorCookie.getOpenedPanes()) != null) {
            Container c;
            this.log.finest("open pane(s) found");
            if (line >= 0) {
                int cursorOffset = DefaultOpenFileImpl.getCursorOffset(editorCookie.getDocument(), line);
                openPanes[0].setCaretPosition(cursorOffset);
            }
            if ((c = SwingUtilities.getAncestorOfClass(TopComponent.class, openPanes[0])) != null) {
                WindowManager.getDefault().invokeWhenUIReady(new Runnable(){

                    @Override
                    public void run() {
                        ((TopComponent)c).requestActive();
                    }
                });
            } else assert (false);
            return true;
        }
        try {
            doc = editorCookie.openDocument();
        }
        catch (IOException ex) {
            String msg = NbBundle.getMessage(DefaultOpenFileImpl.class, (String)"MSG_cannotOpenWillClose");
            ErrorManager.getDefault().notify(4096, ErrorManager.getDefault().annotate((Throwable)ex, msg));
            return false;
        }
        WindowManager.getDefault().invokeWhenUIReady(new Runnable(){

            @Override
            public void run() {
                editorCookie.open();
                if (line >= 0) {
                    DefaultOpenFileImpl.this.openDocAtLine(editorCookie, doc, line);
                }
            }
        });
        return true;
    }

    private void openDocAtLine(EditorCookie editorCookie, StyledDocument doc, int line) {
        assert (EventQueue.isDispatchThread());
        assert (line >= 0);
        assert (editorCookie.getDocument() == doc);
        if (this.log.isLoggable(Level.FINER)) {
            this.log.log(Level.FINER, "openDocAtLine(EditorCookie, Document, line={0})", line);
        }
        int offset = DefaultOpenFileImpl.getCursorOffset(doc, line);
        new SetCursorTask(editorCookie, offset).perform();
    }

    private static int getCursorOffset(StyledDocument doc, int line) {
        assert (EventQueue.isDispatchThread());
        assert (line >= 0);
        try {
            return NbDocument.findLineOffset((StyledDocument)doc, (int)line);
        }
        catch (IndexOutOfBoundsException ex) {
            Element lineRootElement = NbDocument.findLineRootElement((StyledDocument)doc);
            int lineCount = lineRootElement.getElementCount();
            if (line >= lineCount) {
                return NbDocument.findLineOffset((StyledDocument)doc, (int)(lineCount - 1));
            }
            throw ex;
        }
    }

    protected boolean openByCookie(Node.Cookie cookie, Class cookieClass, int line) {
        assert (EventQueue.isDispatchThread());
        if (cookieClass == EditorCookie.Observable.class || cookieClass == EditorCookie.class) {
            return this.openEditor((EditorCookie)cookie, line);
        }
        if (cookieClass == OpenCookie.class) {
            ((OpenCookie)cookie).open();
        } else if (cookieClass == EditCookie.class) {
            ((EditCookie)cookie).edit();
        } else if (cookieClass == ViewCookie.class) {
            ((ViewCookie)cookie).view();
        } else {
            throw new IllegalArgumentException();
        }
        return true;
    }

    private boolean openDataObjectByCookie(DataObject dataObject, int line) {
        block3: {
            Node.Cookie cookie;
            Class<OpenCookie> cookieClass;
            block2: {
                cookieClass = OpenCookie.class;
                cookie = dataObject.getCookie(OpenCookie.class);
                if (cookie != null) break block2;
                cookieClass = EditCookie.class;
                cookie = dataObject.getCookie(EditCookie.class);
                if (cookie != null) break block2;
                cookieClass = ViewCookie.class;
                cookie = dataObject.getCookie(ViewCookie.class);
                if (cookie == null) break block3;
            }
            return this.openByCookie(cookie, cookieClass, line);
        }
        return false;
    }

    @Override
    public void run() {
        assert (EventQueue.isDispatchThread());
        this.open(this.fileObject, this.line);
    }

    @Override
    public boolean open(FileObject fileObject, int line) {
        Node dataNode;
        Action action;
        DataObject dataObject;
        String fileName;
        block15: {
            Node.Cookie cookie;
            Class<EditorCookie.Observable> cookieClass;
            block16: {
                if (this.log.isLoggable(Level.FINER)) {
                    this.log.log(Level.FINER, "open({0}, line={1}) called from thread {2}", new Object[]{fileObject.getNameExt(), line, Thread.currentThread().getName()});
                }
                if (!EventQueue.isDispatchThread()) {
                    this.log.finest(" - rescheduling to EDT using invokeLater(...)");
                    EventQueue.invokeLater(new DefaultOpenFileImpl(fileObject, line));
                    return true;
                }
                assert (EventQueue.isDispatchThread());
                this.log.finest(" - yes, it is an EDT");
                fileName = fileObject.getNameExt();
                try {
                    dataObject = DataObject.find((FileObject)fileObject);
                }
                catch (DataObjectNotFoundException ex) {
                    ErrorManager.getDefault().notify((Throwable)ex);
                    return false;
                }
                if (line == -1) break block15;
                cookieClass = EditorCookie.Observable.class;
                cookie = dataObject.getCookie(EditorCookie.Observable.class);
                if (cookie != null) break block16;
                cookieClass = EditorCookie.class;
                cookie = dataObject.getCookie(EditorCookie.class);
                if (cookie == null) break block15;
            }
            boolean ret = this.openByCookie(cookie, cookieClass, line);
            return ret;
        }
        if ((action = (dataNode = dataObject.getNodeDelegate()).getPreferredAction()) != null && !(action instanceof FileSystemAction) && !(action instanceof ToolsAction)) {
            if (this.log.isLoggable(Level.FINEST)) {
                this.log.log(Level.FINEST, " - using preferred action (\"{0}\" - {1}) for opening the file", new Object[]{action.getValue("Name"), action.getClass().getName()});
            }
            if (action instanceof ContextAwareAction) {
                action = ((ContextAwareAction)action).createContextAwareInstance(dataNode.getLookup());
                if (this.log.isLoggable(Level.FINEST)) {
                    this.log.finest("    - it is a ContextAwareAction");
                    this.log.log(Level.FINEST, "    - using a context-aware instance instead (\"{0}\" - {1})", new Object[]{action.getValue("Name"), action.getClass().getName()});
                }
            }
            this.log.finest("   - will call action.actionPerformed(...)");
            final Action a = action;
            final Node n = dataNode;
            WindowManager.getDefault().invokeWhenUIReady(new Runnable(){

                @Override
                public void run() {
                    a.actionPerformed(new ActionEvent(n, 0, ""));
                }
            });
            return true;
        }
        StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(DefaultOpenFileImpl.class, (String)"MSG_opening", (Object)fileName));
        boolean success = this.openDataObjectByCookie(dataObject, line);
        if (success) {
            return true;
        }
        if (fileObject.isFolder() || FileUtil.isArchiveFile((FileObject)fileObject)) {
            final Node node = dataObject.getNodeDelegate();
            if (node != null) {
                WindowManager.getDefault().invokeWhenUIReady(new Runnable(){

                    @Override
                    public void run() {
                        NodeOperation.getDefault().explore(node);
                    }
                });
                return true;
            }
            return false;
        }
        return false;
    }

    final class SetCursorTask
    implements Runnable,
    PropertyChangeListener {
        private static final int OPEN_EDITOR_WAIT_PERIOD_MS = 200;
        private static final int OPEN_EDITOR_TOTAL_TIMEOUT_MS = 10000;
        private static final int MAX_TRIES = 50;
        private final EditorCookie editorCookie;
        private final EditorCookie.Observable observable;
        private final int offset;
        private volatile boolean success = false;

        private SetCursorTask(EditorCookie editorCookie, int offset) {
            this.editorCookie = editorCookie;
            this.observable = editorCookie instanceof EditorCookie.Observable ? (EditorCookie.Observable)editorCookie : null;
            this.offset = offset;
            if (DefaultOpenFileImpl.this.log.isLoggable(Level.FINEST)) {
                DefaultOpenFileImpl.this.log.finest("SetCursorTask.<init>");
                DefaultOpenFileImpl.this.log.log(Level.FINEST, " - observable: {0}", this.observable != null);
            }
        }

        private void perform() {
            DefaultOpenFileImpl.this.log.finer("SetCursorTask: perform()");
            DefaultOpenFileImpl.this.log.finest("SetCursorTask: Calling tryNow() for the first time...");
            if (this.tryNow()) {
                DefaultOpenFileImpl.this.log.finest("SetCursorTask:    SUCCESS!");
                return;
            }
            if (this.observable != null) {
                DefaultOpenFileImpl.this.log.finest("SetCursorTask: addPropertyChangeListener...");
                this.observable.addPropertyChangeListener((PropertyChangeListener)this);
                DefaultOpenFileImpl.this.log.finest("SetCursorTask: tryNow() after adding the listener...");
                if (this.tryNow()) {
                    DefaultOpenFileImpl.this.log.finest("SetCursorTask:    SUCCESS!");
                }
            } else {
                this.trySeveralTimes();
            }
        }

        private boolean tryNow() {
            assert (!this.success);
            JEditorPane[] panes = this.editorCookie.getOpenedPanes();
            if (panes != null) {
                this.success = true;
                panes[0].setCaretPosition(this.offset);
                return true;
            }
            return false;
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            DefaultOpenFileImpl.this.log.finer("SetCursorTask: propertyChange()");
            assert ("openedPanes".equals(e.getPropertyName()));
            this.observable.removePropertyChangeListener((PropertyChangeListener)this);
            Mutex.EVENT.writeAccess((Runnable)this);
        }

        private void trySeveralTimes() {
            DefaultOpenFileImpl.this.log.finest("SetCursorTask: trySeveralTimes()");
            RequestProcessor.getDefault().post((Runnable)new ScheduledOpenTask(), 200);
        }

        @Override
        public void run() {
            assert (EventQueue.isDispatchThread());
            DefaultOpenFileImpl.this.log.finer("SetCursorTask: run()");
            if (this.success) {
                DefaultOpenFileImpl.this.log.finest("SetCursorTask:   - already done");
                return;
            }
            DefaultOpenFileImpl.this.log.finest("SetCursorTask:   tryNow() from run()");
            this.tryNow();
            if (this.observable != null && !this.success) {
                assert (false);
                this.notifyCouldNotOpen();
            }
        }

        private void notifyCouldNotOpen() {
            DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(DefaultOpenFileImpl.class, (String)"MSG_couldNotOpenAt"), 1));
        }

        class ScheduledOpenTask
        implements Runnable {
            private volatile int remainingTries = 50;

            ScheduledOpenTask() {
            }

            @Override
            public void run() {
                try {
                    EventQueue.invokeAndWait(SetCursorTask.this);
                }
                catch (InterruptedException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                catch (InvocationTargetException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                if (!SetCursorTask.this.success) {
                    if (--this.remainingTries != 0) {
                        RequestProcessor.getDefault().post((Runnable)this, 200);
                    } else {
                        SetCursorTask.this.notifyCouldNotOpen();
                    }
                }
            }
        }
    }
}

