/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.jemmy.operators;

import java.awt.Component;
import java.lang.reflect.InvocationTargetException;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import org.netbeans.jemmy.Action;
import org.netbeans.jemmy.ActionProducer;
import org.netbeans.jemmy.CharBindingMap;
import org.netbeans.jemmy.ClassReference;
import org.netbeans.jemmy.ComponentChooser;
import org.netbeans.jemmy.ComponentSearcher;
import org.netbeans.jemmy.JemmyException;
import org.netbeans.jemmy.JemmyProperties;
import org.netbeans.jemmy.Outputable;
import org.netbeans.jemmy.QueueTool;
import org.netbeans.jemmy.TestOut;
import org.netbeans.jemmy.Timeoutable;
import org.netbeans.jemmy.Timeouts;
import org.netbeans.jemmy.Waitable;
import org.netbeans.jemmy.Waiter;
import org.netbeans.jemmy.operators.ComponentOperator;
import org.netbeans.jemmy.util.DefaultVisualizer;
import org.netbeans.jemmy.util.MouseVisualizer;

public abstract class Operator
implements Timeoutable,
Outputable {
    public static final String CLASS_DPROP = "Class";
    public static final String TO_STRING_DPROP = "toString";
    private static Vector operatorPkgs;
    private Timeouts timeouts;
    private TestOut output;
    private ClassReference codeDefiner;
    private int model;
    private CharBindingMap map;
    private ComponentVisualizer visualizer;
    private StringComparator comparator;
    private PathParser parser;
    private QueueTool queueTool;
    private boolean verification = false;
    private JemmyProperties properties;

    public Operator() {
        this.initEnvironment();
    }

    public static ComponentVisualizer setDefaultComponentVisualizer(ComponentVisualizer visualizer) {
        return (ComponentVisualizer)JemmyProperties.setCurrentProperty("ComponentOperator.ComponentVisualizer", visualizer);
    }

    public static ComponentVisualizer getDefaultComponentVisualizer() {
        return (ComponentVisualizer)JemmyProperties.getCurrentProperty("ComponentOperator.ComponentVisualizer");
    }

    public static StringComparator setDefaultStringComparator(StringComparator comparator) {
        return (StringComparator)JemmyProperties.setCurrentProperty("ComponentOperator.StringComparator", comparator);
    }

    public static StringComparator getDefaultStringComparator() {
        return (StringComparator)JemmyProperties.getCurrentProperty("ComponentOperator.StringComparator");
    }

    public static PathParser setDefaultPathParser(PathParser parser) {
        return (PathParser)JemmyProperties.setCurrentProperty("ComponentOperator.PathParser", parser);
    }

    public static PathParser getDefaultPathParser() {
        return (PathParser)JemmyProperties.getCurrentProperty("ComponentOperator.PathParser");
    }

    public static boolean setDefaultVerification(boolean verification) {
        Boolean oldValue = (Boolean)JemmyProperties.setCurrentProperty("Operator.Verification", verification ? Boolean.TRUE : Boolean.FALSE);
        return oldValue != null ? oldValue : false;
    }

    public static boolean getDefaultVerification() {
        return (Boolean)JemmyProperties.getCurrentProperty("Operator.Verification");
    }

    public static boolean isCaptionEqual(String caption, String match, boolean ce, boolean ccs) {
        return new DefaultStringComparator(ce, ccs).equals(caption, match);
    }

    public static boolean isCaptionEqual(String caption, String match, StringComparator comparator) {
        return comparator.equals(caption, match);
    }

    public static int getDefaultMouseButton() {
        return 16;
    }

    public static int getPopupMouseButton() {
        return 4;
    }

    public static ComponentOperator createOperator(Component comp) {
        try {
            Class<?> cclass = Class.forName("java.awt.Component");
            Class<?> compClass = comp.getClass();
            do {
                ComponentOperator result;
                if ((result = Operator.createOperator(comp, compClass)) == null) continue;
                return result;
            } while (cclass.isAssignableFrom(compClass = compClass.getSuperclass()));
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return null;
    }

    public static void addOperatorPackage(String pkgName) {
        operatorPkgs.add(pkgName);
    }

    public static Operator getEnvironmentOperator() {
        return new NullOperator();
    }

    public abstract Component getSource();

    public QueueTool getQueueTool() {
        return this.queueTool;
    }

    public void copyEnvironment(Operator anotherOperator) {
        this.setTimeouts(anotherOperator.getTimeouts());
        this.setOutput(anotherOperator.getOutput());
        this.setVisualizer(anotherOperator.getVisualizer());
        this.setComparator(anotherOperator.getComparator());
        this.setVerification(anotherOperator.getVerification());
        this.setCharBindingMap(anotherOperator.getCharBindingMap());
        this.setProperties(anotherOperator.getProperties());
    }

    public void setTimeouts(Timeouts timeouts) {
        this.timeouts = timeouts;
        this.queueTool.setTimeouts(timeouts);
    }

    public Timeouts getTimeouts() {
        return this.timeouts;
    }

    public ComponentVisualizer getVisualizer() {
        return this.visualizer;
    }

    public void setVisualizer(ComponentVisualizer vo) {
        this.visualizer = vo;
    }

    public JemmyProperties getProperties() {
        return this.properties;
    }

    public JemmyProperties setProperties(JemmyProperties properties) {
        JemmyProperties oldProperties = this.getProperties();
        this.properties = properties;
        return oldProperties;
    }

    public void setCharBindingMap(CharBindingMap map) {
        this.map = map;
    }

    public CharBindingMap getCharBindingMap() {
        return this.map;
    }

    public void setOutput(TestOut out) {
        this.output = out;
        this.queueTool.setOutput(this.output.createErrorOutput());
    }

    public TestOut getOutput() {
        return this.output;
    }

    public StringComparator getComparator() {
        return this.comparator;
    }

    public void setComparator(StringComparator comparator) {
        this.comparator = comparator;
    }

    public PathParser getPathParser() {
        return this.parser;
    }

    public void setPathParser(PathParser parser) {
        this.parser = parser;
    }

    public boolean setVerification(boolean verification) {
        boolean oldValue = this.verification;
        this.verification = verification;
        return oldValue;
    }

    public boolean getVerification() {
        return this.verification;
    }

    public String[] getParentPath(String[] path) {
        if (path.length > 1) {
            String[] ppath = new String[path.length - 1];
            for (int i = 0; i < ppath.length; ++i) {
                ppath[i] = path[i];
            }
            return ppath;
        }
        return new String[0];
    }

    public ComponentChooser[] getParentPath(ComponentChooser[] path) {
        if (path.length > 1) {
            ComponentChooser[] ppath = new ComponentChooser[path.length - 1];
            for (int i = 0; i < ppath.length; ++i) {
                ppath[i] = path[i];
            }
            return ppath;
        }
        return new ComponentChooser[0];
    }

    public String[] parseString(String path) {
        return this.getPathParser().parse(path);
    }

    public String[] parseString(String path, String delim) {
        return new DefaultPathParser(delim).parse(path);
    }

    public int getCharKey(char c) {
        return this.map.getCharKey(c);
    }

    public int getCharModifiers(char c) {
        return this.map.getCharModifiers(c);
    }

    public int[] getCharsKeys(char[] c) {
        int[] result = new int[c.length];
        for (int i = 0; i < c.length; ++i) {
            result[i] = this.getCharKey(c[i]);
        }
        return result;
    }

    public int[] getCharsModifiers(char[] c) {
        int[] result = new int[c.length];
        for (int i = 0; i < c.length; ++i) {
            result[i] = this.getCharModifiers(c[i]);
        }
        return result;
    }

    public int[] getCharsKeys(String s) {
        return this.getCharsKeys(s.toCharArray());
    }

    public int[] getCharsModifiers(String s) {
        return this.getCharsModifiers(s.toCharArray());
    }

    public boolean isCaptionEqual(String caption, String match) {
        return this.comparator.equals(caption, match);
    }

    public void printDump() {
        Hashtable result = this.getDump();
        Object[] keys = result.keySet().toArray();
        for (int i = 0; i < result.size(); ++i) {
            this.output.printLine((String)keys[i] + " = " + (String)result.get(keys[i]));
        }
    }

    public Hashtable getDump() {
        Hashtable<String, String> result = new Hashtable<String, String>();
        result.put(CLASS_DPROP, this.getSource().getClass().getName());
        result.put(TO_STRING_DPROP, this.getSource().toString());
        return result;
    }

    public void waitState(final ComponentChooser state) {
        Waiter stateWaiter = new Waiter(new Waitable(){

            public Object actionProduced(Object obj) {
                return state.checkComponent(Operator.this.getSource()) ? "" : null;
            }

            public String getDescription() {
                return "Wait \"" + state.getDescription() + "\" state to be reached";
            }
        });
        stateWaiter.setTimeouts(this.getTimeouts().cloneThis());
        stateWaiter.getTimeouts().setTimeout("Waiter.WaitingTime", this.getTimeouts().getTimeout("ComponentOperator.WaitStateTimeout"));
        stateWaiter.setOutput(this.getOutput().createErrorOutput());
        try {
            stateWaiter.waitAction(null);
        }
        catch (InterruptedException e) {
            throw new JemmyException("Waiting of \"" + state.getDescription() + "\" state has been interrupted!");
        }
    }

    protected Object produceTimeRestricted(Action action, Object param, long wholeTime) {
        ActionProducer producer = new ActionProducer(action);
        producer.setOutput(this.getOutput().createErrorOutput());
        producer.setTimeouts(this.getTimeouts().cloneThis());
        producer.getTimeouts().setTimeout("ActionProducer.MaxActionTime", wholeTime);
        try {
            Object result = producer.produceAction(param);
            Throwable exception = producer.getException();
            if (exception != null) {
                if (exception instanceof JemmyException) {
                    throw (JemmyException)exception;
                }
                throw new JemmyException("Exception during " + action.getDescription(), exception);
            }
            return result;
        }
        catch (InterruptedException e) {
            throw new JemmyException("Interrupted!", e);
        }
    }

    protected Object produceTimeRestricted(Action action, long wholeTime) {
        return this.produceTimeRestricted(action, null, wholeTime);
    }

    protected void produceNoBlocking(NoBlockingAction action, Object param) {
        try {
            ActionProducer noBlockingProducer = new ActionProducer(action, false);
            noBlockingProducer.setOutput(this.output.createErrorOutput());
            noBlockingProducer.setTimeouts(this.timeouts);
            noBlockingProducer.produceAction(param);
        }
        catch (InterruptedException e) {
            throw new JemmyException("Exception during \"" + action.getDescription() + "\" execution", e);
        }
        if (action.exception != null) {
            throw new JemmyException("Exception during nonblocking \"" + action.getDescription() + "\"", action.exception);
        }
    }

    protected void produceNoBlocking(NoBlockingAction action) {
        this.produceNoBlocking(action, null);
    }

    protected void lockQueue() {
        this.queueTool.lock();
    }

    protected void unlockQueue() {
        this.queueTool.unlock();
    }

    protected void unlockAndThrow(Exception e) {
        this.unlockQueue();
        throw new JemmyException("Exception during queue locking", e);
    }

    protected Object runMapping(MapAction action) {
        return this.runMappingPrimitive(action);
    }

    protected char runMapping(MapCharacterAction action) {
        return ((Character)this.runMappingPrimitive(action)).charValue();
    }

    protected byte runMapping(MapByteAction action) {
        return (Byte)this.runMappingPrimitive(action);
    }

    protected int runMapping(MapIntegerAction action) {
        return (Integer)this.runMappingPrimitive(action);
    }

    protected long runMapping(MapLongAction action) {
        return (Long)this.runMappingPrimitive(action);
    }

    protected float runMapping(MapFloatAction action) {
        return ((Float)this.runMappingPrimitive(action)).floatValue();
    }

    protected double runMapping(MapDoubleAction action) {
        return (Double)this.runMappingPrimitive(action);
    }

    protected boolean runMapping(MapBooleanAction action) {
        return (Boolean)this.runMappingPrimitive(action);
    }

    protected void runMapping(MapVoidAction action) {
        this.runMappingPrimitive(action);
    }

    protected String[] addToDump(Hashtable table, String title, Object[] items) {
        String[] names = this.createNames(title + "_", items.length);
        for (int i = 0; i < items.length; ++i) {
            table.put(names[i], items[i].toString());
        }
        return names;
    }

    protected String[] addToDump(Hashtable table, String title, Object[][] items) {
        String[] names = this.createNames(title + "_", items.length);
        for (int i = 0; i < items.length; ++i) {
            this.addToDump(table, names[i], items[i]);
        }
        return names;
    }

    private Object runMappingPrimitive(QueueTool.QueueAction action) {
        return this.queueTool.invokeSmoothly(action);
    }

    private String[] createNames(String title, int count) {
        String[] result = new String[count];
        int indexLength = Integer.toString(count).length();
        String zeroString = "";
        for (int i = 0; i < indexLength; ++i) {
            zeroString = zeroString + "0";
        }
        for (int i = 0; i < count; ++i) {
            String indexString = Integer.toString(i);
            result[i] = title + zeroString.substring(0, indexLength - indexString.length()) + indexString;
        }
        return result;
    }

    private static ComponentOperator createOperator(Component comp, Class compClass) {
        StringTokenizer token = new StringTokenizer(compClass.getName(), ".");
        String className = "";
        while (token.hasMoreTokens()) {
            className = token.nextToken();
        }
        Object[] params = new Object[]{comp};
        Class[] param_classes = new Class[]{compClass};
        for (int i = 0; i < operatorPkgs.size(); ++i) {
            String operatorPackage = (String)operatorPkgs.get(i);
            try {
                return (ComponentOperator)new ClassReference(operatorPackage + "." + className + "Operator").newInstance(params, param_classes);
            }
            catch (ClassNotFoundException e) {
                continue;
            }
            catch (InvocationTargetException e) {
                continue;
            }
            catch (NoSuchMethodException e) {
                continue;
            }
            catch (IllegalAccessException e) {
                continue;
            }
            catch (InstantiationException e) {
                // empty catch block
            }
        }
        return null;
    }

    private void initEnvironment() {
        try {
            this.codeDefiner = new ClassReference("java.awt.event.KeyEvent");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        this.queueTool = new QueueTool();
        this.setTimeouts(JemmyProperties.getProperties().getTimeouts());
        this.setOutput(JemmyProperties.getProperties().getOutput());
        this.setCharBindingMap(JemmyProperties.getProperties().getCharBindingMap());
        this.setVisualizer(Operator.getDefaultComponentVisualizer());
        this.setComparator(Operator.getDefaultStringComparator());
        this.setVerification(Operator.getDefaultVerification());
        this.setProperties(JemmyProperties.getProperties());
        this.setPathParser(Operator.getDefaultPathParser());
    }

    private int nextDelimIndex(String path, String delim) {
        String restPath = path;
        int ind = 0;
        while ((ind = restPath.indexOf(delim)) != -1) {
            if (ind != 0 && restPath.substring(ind - 1, ind).equals("\\")) continue;
            return ind;
        }
        return -1;
    }

    public String toStringSource() {
        return (String)this.runMapping(new MapAction("getSource().toString()"){

            public Object map() {
                return Operator.this.getSource().toString();
            }
        });
    }

    static {
        String os = System.getProperty("os.name").toUpperCase();
        if (os.startsWith("LINUX")) {
            Operator.setDefaultComponentVisualizer(new MouseVisualizer(MouseVisualizer.TOP, 0.5, 10, false));
        } else if (os.startsWith("SUNOS")) {
            Operator.setDefaultComponentVisualizer(new MouseVisualizer());
        } else {
            Operator.setDefaultComponentVisualizer(new DefaultVisualizer());
        }
        operatorPkgs = new Vector();
        Operator.setDefaultStringComparator(new DefaultStringComparator(false, false));
        Operator.setDefaultPathParser(new DefaultPathParser("|"));
        Operator.addOperatorPackage("org.netbeans.jemmy.operators");
        Operator.setDefaultVerification(true);
    }

    public static interface ComponentVisualizer {
        public void makeVisible(ComponentOperator var1);
    }

    public static class DefaultPathParser
    implements PathParser {
        String separator;

        public DefaultPathParser(String separator) {
            this.separator = separator;
        }

        public String[] parse(String path) {
            if (path.length() > 0) {
                Vector<String> parsed = new Vector<String>();
                int position = 0;
                int sepIndex = 0;
                while ((sepIndex = path.indexOf(this.separator, position)) != -1) {
                    parsed.add(path.substring(position, sepIndex));
                    position = sepIndex + this.separator.length();
                }
                parsed.add(path.substring(position));
                String[] result = new String[parsed.size()];
                for (int i = 0; i < parsed.size(); ++i) {
                    result[i] = (String)parsed.get(i);
                }
                return result;
            }
            return new String[0];
        }
    }

    public static class DefaultStringComparator
    implements StringComparator {
        boolean ce;
        boolean ccs;

        public DefaultStringComparator(boolean ce, boolean ccs) {
            this.ce = ce;
            this.ccs = ccs;
        }

        public boolean equals(String caption, String match) {
            String t;
            String c;
            if (match == null) {
                return true;
            }
            if (caption == null) {
                return false;
            }
            if (!this.ccs) {
                c = caption.toUpperCase();
                t = match.toUpperCase();
            } else {
                c = caption;
                t = match;
            }
            if (this.ce) {
                return c.equals(t);
            }
            return c.indexOf(t) != -1;
        }
    }

    public static class Finder
    implements ComponentChooser {
        Class clz;
        ComponentChooser subchooser;

        public Finder(Class clz, ComponentChooser subchooser) {
            this.clz = clz;
            this.subchooser = subchooser;
        }

        public Finder(Class clz) {
            this(clz, ComponentSearcher.getTrueChooser("Any " + clz.getName()));
        }

        public boolean checkComponent(Component comp) {
            if (this.clz.isInstance(comp)) {
                return this.subchooser.checkComponent(comp);
            }
            return false;
        }

        public String getDescription() {
            return this.subchooser.getDescription();
        }
    }

    protected abstract class MapAction
    extends QueueTool.QueueAction {
        public MapAction(String description) {
            super(description);
        }

        public final Object launch() throws Exception {
            return this.map();
        }

        public abstract Object map() throws Exception;
    }

    protected abstract class MapBooleanAction
    extends QueueTool.QueueAction {
        public MapBooleanAction(String description) {
            super(description);
        }

        public final Object launch() throws Exception {
            return this.map() ? Boolean.TRUE : Boolean.FALSE;
        }

        public abstract boolean map() throws Exception;
    }

    protected abstract class MapByteAction
    extends QueueTool.QueueAction {
        public MapByteAction(String description) {
            super(description);
        }

        public final Object launch() throws Exception {
            return new Byte(this.map());
        }

        public abstract byte map() throws Exception;
    }

    protected abstract class MapCharacterAction
    extends QueueTool.QueueAction {
        public MapCharacterAction(String description) {
            super(description);
        }

        public final Object launch() throws Exception {
            return new Character(this.map());
        }

        public abstract char map() throws Exception;
    }

    protected abstract class MapDoubleAction
    extends QueueTool.QueueAction {
        public MapDoubleAction(String description) {
            super(description);
        }

        public final Object launch() throws Exception {
            return new Double(this.map());
        }

        public abstract double map() throws Exception;
    }

    protected abstract class MapFloatAction
    extends QueueTool.QueueAction {
        public MapFloatAction(String description) {
            super(description);
        }

        public final Object launch() throws Exception {
            return new Float(this.map());
        }

        public abstract float map() throws Exception;
    }

    protected abstract class MapIntegerAction
    extends QueueTool.QueueAction {
        public MapIntegerAction(String description) {
            super(description);
        }

        public final Object launch() throws Exception {
            return new Integer(this.map());
        }

        public abstract int map() throws Exception;
    }

    protected abstract class MapLongAction
    extends QueueTool.QueueAction {
        public MapLongAction(String description) {
            super(description);
        }

        public final Object launch() throws Exception {
            return new Long(this.map());
        }

        public abstract long map() throws Exception;
    }

    protected abstract class MapVoidAction
    extends QueueTool.QueueAction {
        public MapVoidAction(String description) {
            super(description);
        }

        public final Object launch() throws Exception {
            this.map();
            return null;
        }

        public abstract void map() throws Exception;
    }

    protected abstract class NoBlockingAction
    implements Action {
        String description;
        Exception exception;
        boolean finished;

        public NoBlockingAction(String description) {
            this.description = description;
            this.exception = null;
            this.finished = false;
        }

        public final Object launch(Object param) {
            Object result = null;
            try {
                result = this.doAction(param);
            }
            catch (Exception e) {
                this.exception = e;
            }
            this.finished = true;
            return result;
        }

        public abstract Object doAction(Object var1);

        public String getDescription() {
            return this.description;
        }

        protected void setException(Exception e) {
            this.exception = e;
        }

        public Exception getException() {
            return this.exception;
        }
    }

    private static class NullOperator
    extends Operator {
        public Component getSource() {
            return null;
        }
    }

    public static interface PathParser {
        public String[] parse(String var1);
    }

    public static interface StringComparator {
        public boolean equals(String var1, String var2);
    }
}

