/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.jemmy.operators;

import java.awt.Component;
import java.awt.Container;
import java.util.Hashtable;
import javax.swing.JButton;
import javax.swing.JSplitPane;
import javax.swing.plaf.SplitPaneUI;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import org.netbeans.jemmy.Action;
import org.netbeans.jemmy.ComponentChooser;
import org.netbeans.jemmy.ComponentSearcher;
import org.netbeans.jemmy.Outputable;
import org.netbeans.jemmy.TestOut;
import org.netbeans.jemmy.Timeoutable;
import org.netbeans.jemmy.Timeouts;
import org.netbeans.jemmy.drivers.DriverManager;
import org.netbeans.jemmy.drivers.ScrollDriver;
import org.netbeans.jemmy.drivers.scrolling.ScrollAdjuster;
import org.netbeans.jemmy.operators.ContainerOperator;
import org.netbeans.jemmy.operators.JButtonOperator;
import org.netbeans.jemmy.operators.JComponentOperator;
import org.netbeans.jemmy.operators.Operator;
import org.netbeans.jemmy.util.EmptyVisualizer;

public class JSplitPaneOperator
extends JComponentOperator
implements Timeoutable,
Outputable {
    public static final String MINIMUM_DPROP = "Minimum";
    public static final String MAXIMUM_DPROP = "Maximum";
    public static final String VALUE_DPROP = "Value";
    public static final String ORIENTATION_DPROP = "Orientation";
    public static final String HORIZONTAL_ORIENTATION_DPROP_VALUE = "HORIZONTAL";
    public static final String VERTICAL_ORIENTATION_DPROP_VALUE = "VERTICAL";
    public static final String IS_ONE_TOUCH_EXPANDABLE_DPROP = "One touch expandable";
    private static final long SCROLL_CLICK_TIMEOUT = 0L;
    private static final long BETWEEN_CLICK_TIMEOUT = 0L;
    private static final long WHOLE_SCROLL_TIMEOUT = 60000L;
    private Timeouts timeouts;
    private TestOut output;
    private ContainerOperator divider;
    private ScrollDriver driver = DriverManager.getScrollDriver(this.getClass());

    public JSplitPaneOperator(JSplitPane b) {
        super(b);
    }

    public JSplitPaneOperator(ContainerOperator cont, ComponentChooser chooser, int index) {
        this((JSplitPane)cont.waitSubComponent(new JSplitPaneFinder(chooser), index));
        this.copyEnvironment(cont);
    }

    public JSplitPaneOperator(ContainerOperator cont, ComponentChooser chooser) {
        this(cont, chooser, 0);
    }

    public JSplitPaneOperator(ContainerOperator cont, int index) {
        this((JSplitPane)JSplitPaneOperator.waitComponent(cont, (ComponentChooser)new JSplitPaneFinder(), index));
        this.copyEnvironment(cont);
    }

    public JSplitPaneOperator(ContainerOperator cont) {
        this(cont, 0);
    }

    public static JSplitPane findJSplitPane(Container cont, ComponentChooser chooser, int index) {
        return (JSplitPane)JSplitPaneOperator.findComponent(cont, new JSplitPaneFinder(chooser), index);
    }

    public static JSplitPane findJSplitPane(Container cont, ComponentChooser chooser) {
        return JSplitPaneOperator.findJSplitPane(cont, chooser, 0);
    }

    public static JSplitPane findJSplitPane(Container cont, int index) {
        return JSplitPaneOperator.findJSplitPane(cont, ComponentSearcher.getTrueChooser(Integer.toString(index) + "'th JSplitPane instance"), index);
    }

    public static JSplitPane findJSplitPane(Container cont) {
        return JSplitPaneOperator.findJSplitPane(cont, 0);
    }

    public static JSplitPane findJSplitPaneUnder(Component comp, ComponentChooser chooser) {
        return (JSplitPane)JSplitPaneOperator.findContainerUnder(comp, new JSplitPaneFinder(chooser));
    }

    public static JSplitPane findJSplitPaneUnder(Component comp) {
        return JSplitPaneOperator.findJSplitPaneUnder(comp, new JSplitPaneFinder());
    }

    public static JSplitPane waitJSplitPane(Container cont, ComponentChooser chooser, int index) {
        return (JSplitPane)JSplitPaneOperator.waitComponent(cont, (ComponentChooser)new JSplitPaneFinder(chooser), index);
    }

    public static JSplitPane waitJSplitPane(Container cont, ComponentChooser chooser) {
        return JSplitPaneOperator.waitJSplitPane(cont, chooser, 0);
    }

    public static JSplitPane waitJSplitPane(Container cont, int index) {
        return JSplitPaneOperator.waitJSplitPane(cont, ComponentSearcher.getTrueChooser(Integer.toString(index) + "'th JSplitPane instance"), index);
    }

    public static JSplitPane waitJSplitPane(Container cont) {
        return JSplitPaneOperator.waitJSplitPane(cont, 0);
    }

    public void setTimeouts(Timeouts timeouts) {
        this.timeouts = timeouts;
        Timeouts times = timeouts;
        times.setTimeout("ComponentOperator.BeforeDragTimeout", 0L);
        times.setTimeout("ComponentOperator.AfterDragTimeout", times.getTimeout("JSplitPaneOperator.ScrollClickTimeout"));
        super.setTimeouts(times);
    }

    public Timeouts getTimeouts() {
        return this.timeouts;
    }

    public void setOutput(TestOut out) {
        this.output = out;
        super.setOutput(this.output.createErrorOutput());
    }

    public TestOut getOutput() {
        return this.output;
    }

    public void copyEnvironment(Operator anotherOperator) {
        super.copyEnvironment(anotherOperator);
        this.driver = (ScrollDriver)DriverManager.getDriver("drivers.scroll", this.getClass(), anotherOperator.getProperties());
    }

    public BasicSplitPaneDivider findDivider() {
        return (BasicSplitPaneDivider)this.waitSubComponent(new ComponentChooser(){

            public boolean checkComponent(Component comp) {
                return comp instanceof BasicSplitPaneDivider;
            }

            public String getDescription() {
                return "";
            }
        });
    }

    public ContainerOperator getDivider() {
        if (this.divider == null) {
            this.divider = new ContainerOperator(this.findDivider());
            this.divider.copyEnvironment(this);
            this.divider.setOutput(this.getOutput().createErrorOutput());
        }
        return this.divider;
    }

    public void scrollTo(final ScrollAdjuster adj) {
        this.produceTimeRestricted(new Action(){

            public Object launch(Object obj) {
                JSplitPaneOperator.this.driver.scroll(JSplitPaneOperator.this, adj);
                return null;
            }

            public String getDescription() {
                return "Moving a divider";
            }
        }, this.getTimeouts().getTimeout("JSplitPaneOperator.WholeScrollTimeout"));
    }

    public void moveDivider(int dividerLocation) {
        this.output.printTrace("Move JSplitPane divider to " + Integer.toString(dividerLocation) + " location. JSplitPane :    \n" + this.toStringSource());
        this.output.printGolden("Move JSplitPane divider to " + Integer.toString(dividerLocation) + " location");
        this.scrollTo(new ValueScrollAdjuster(dividerLocation));
    }

    public void moveDivider(double proportionalLocation) {
        this.output.printTrace("Move JSplitPane divider to " + Double.toString(proportionalLocation) + " proportional location. JSplitPane :    \n" + this.toStringSource());
        this.output.printGolden("Move JSplitPane divider to " + Double.toString(proportionalLocation) + " proportional location");
        this.scrollTo(new ValueScrollAdjuster(this.getMinimumDividerLocation() + (int)(proportionalLocation * (double)(this.getMaximumDividerLocation() - this.getMinimumDividerLocation()))));
    }

    public void moveToMinimum() {
        this.output.printTrace("Scroll JSplitPane to minimum. JSplitPane :    \n" + this.toStringSource());
        this.output.printGolden("Scroll JSplitPane to minimum.");
        this.produceTimeRestricted(new Action(){

            public Object launch(Object obj) {
                JSplitPaneOperator.this.driver.scrollToMinimum(JSplitPaneOperator.this, JSplitPaneOperator.this.getOrientation());
                return null;
            }

            public String getDescription() {
                return "Scrolling";
            }
        }, this.getTimeouts().getTimeout("JSplitPaneOperator.WholeScrollTimeout"));
    }

    public void moveToMaximum() {
        this.output.printTrace("Scroll JSplitPane to maximum. JSplitPane :    \n" + this.toStringSource());
        this.output.printGolden("Scroll JSplitPane to maximum.");
        this.produceTimeRestricted(new Action(){

            public Object launch(Object obj) {
                JSplitPaneOperator.this.driver.scrollToMaximum(JSplitPaneOperator.this, JSplitPaneOperator.this.getOrientation());
                return null;
            }

            public String getDescription() {
                return "Scrolling";
            }
        }, this.getTimeouts().getTimeout("JSplitPaneOperator.WholeScrollTimeout"));
    }

    public void expandRight() {
        String mess = "Expand ";
        mess = this.getOrientation() == 1 ? mess + "right" : mess + "bottom";
        this.output.printTrace(mess + " JSplitPane side. JSplitPane :    \n" + this.toStringSource());
        this.output.printGolden(mess + " JSplitPane side.");
        this.expandTo(0);
    }

    public void expandLeft() {
        String mess = "Expand ";
        mess = this.getOrientation() == 1 ? mess + "left" : mess + "top";
        this.output.printTrace(mess + " JSplitPane side. JSplitPane :    \n" + this.toStringSource());
        this.output.printGolden(mess + " JSplitPane side.");
        this.expandTo(1);
    }

    public Hashtable getDump() {
        Hashtable result = super.getDump();
        result.put(MINIMUM_DPROP, Integer.toString(((JSplitPane)this.getSource()).getMinimumDividerLocation()));
        result.put(MAXIMUM_DPROP, Integer.toString(((JSplitPane)this.getSource()).getMaximumDividerLocation()));
        result.put(ORIENTATION_DPROP, ((JSplitPane)this.getSource()).getOrientation() == 1 ? HORIZONTAL_ORIENTATION_DPROP_VALUE : VERTICAL_ORIENTATION_DPROP_VALUE);
        result.put(VALUE_DPROP, Integer.toString(((JSplitPane)this.getSource()).getDividerLocation()));
        result.put(IS_ONE_TOUCH_EXPANDABLE_DPROP, ((JSplitPane)this.getSource()).isOneTouchExpandable() ? "true" : "false");
        return result;
    }

    public Component getBottomComponent() {
        return (Component)this.runMapping(new Operator.MapAction("getBottomComponent"){

            public Object map() {
                return ((JSplitPane)JSplitPaneOperator.this.getSource()).getBottomComponent();
            }
        });
    }

    public int getDividerLocation() {
        return this.runMapping(new Operator.MapIntegerAction("getDividerLocation"){

            public int map() {
                return ((JSplitPane)JSplitPaneOperator.this.getSource()).getDividerLocation();
            }
        });
    }

    public int getDividerSize() {
        return this.runMapping(new Operator.MapIntegerAction("getDividerSize"){

            public int map() {
                return ((JSplitPane)JSplitPaneOperator.this.getSource()).getDividerSize();
            }
        });
    }

    public int getLastDividerLocation() {
        return this.runMapping(new Operator.MapIntegerAction("getLastDividerLocation"){

            public int map() {
                return ((JSplitPane)JSplitPaneOperator.this.getSource()).getLastDividerLocation();
            }
        });
    }

    public Component getLeftComponent() {
        return (Component)this.runMapping(new Operator.MapAction("getLeftComponent"){

            public Object map() {
                return ((JSplitPane)JSplitPaneOperator.this.getSource()).getLeftComponent();
            }
        });
    }

    public int getMaximumDividerLocation() {
        return this.runMapping(new Operator.MapIntegerAction("getMaximumDividerLocation"){

            public int map() {
                return ((JSplitPane)JSplitPaneOperator.this.getSource()).getMaximumDividerLocation();
            }
        });
    }

    public int getMinimumDividerLocation() {
        return this.runMapping(new Operator.MapIntegerAction("getMinimumDividerLocation"){

            public int map() {
                return ((JSplitPane)JSplitPaneOperator.this.getSource()).getMinimumDividerLocation();
            }
        });
    }

    public int getOrientation() {
        return this.runMapping(new Operator.MapIntegerAction("getOrientation"){

            public int map() {
                return ((JSplitPane)JSplitPaneOperator.this.getSource()).getOrientation();
            }
        });
    }

    public Component getRightComponent() {
        return (Component)this.runMapping(new Operator.MapAction("getRightComponent"){

            public Object map() {
                return ((JSplitPane)JSplitPaneOperator.this.getSource()).getRightComponent();
            }
        });
    }

    public Component getTopComponent() {
        return (Component)this.runMapping(new Operator.MapAction("getTopComponent"){

            public Object map() {
                return ((JSplitPane)JSplitPaneOperator.this.getSource()).getTopComponent();
            }
        });
    }

    public SplitPaneUI getUI() {
        return (SplitPaneUI)this.runMapping(new Operator.MapAction("getUI"){

            public Object map() {
                return ((JSplitPane)JSplitPaneOperator.this.getSource()).getUI();
            }
        });
    }

    public boolean isContinuousLayout() {
        return this.runMapping(new Operator.MapBooleanAction("isContinuousLayout"){

            public boolean map() {
                return ((JSplitPane)JSplitPaneOperator.this.getSource()).isContinuousLayout();
            }
        });
    }

    public boolean isOneTouchExpandable() {
        return this.runMapping(new Operator.MapBooleanAction("isOneTouchExpandable"){

            public boolean map() {
                return ((JSplitPane)JSplitPaneOperator.this.getSource()).isOneTouchExpandable();
            }
        });
    }

    public void resetToPreferredSizes() {
        this.runMapping(new Operator.MapVoidAction("resetToPreferredSizes"){

            public void map() {
                ((JSplitPane)JSplitPaneOperator.this.getSource()).resetToPreferredSizes();
            }
        });
    }

    public void setBottomComponent(final Component component) {
        this.runMapping(new Operator.MapVoidAction("setBottomComponent"){

            public void map() {
                ((JSplitPane)JSplitPaneOperator.this.getSource()).setBottomComponent(component);
            }
        });
    }

    public void setContinuousLayout(final boolean b) {
        this.runMapping(new Operator.MapVoidAction("setContinuousLayout"){

            public void map() {
                ((JSplitPane)JSplitPaneOperator.this.getSource()).setContinuousLayout(b);
            }
        });
    }

    public void setDividerLocation(final double d) {
        this.runMapping(new Operator.MapVoidAction("setDividerLocation"){

            public void map() {
                ((JSplitPane)JSplitPaneOperator.this.getSource()).setDividerLocation(d);
            }
        });
    }

    public void setDividerLocation(final int i) {
        this.runMapping(new Operator.MapVoidAction("setDividerLocation"){

            public void map() {
                ((JSplitPane)JSplitPaneOperator.this.getSource()).setDividerLocation(i);
            }
        });
    }

    public void setDividerSize(final int i) {
        this.runMapping(new Operator.MapVoidAction("setDividerSize"){

            public void map() {
                ((JSplitPane)JSplitPaneOperator.this.getSource()).setDividerSize(i);
            }
        });
    }

    public void setLastDividerLocation(final int i) {
        this.runMapping(new Operator.MapVoidAction("setLastDividerLocation"){

            public void map() {
                ((JSplitPane)JSplitPaneOperator.this.getSource()).setLastDividerLocation(i);
            }
        });
    }

    public void setLeftComponent(final Component component) {
        this.runMapping(new Operator.MapVoidAction("setLeftComponent"){

            public void map() {
                ((JSplitPane)JSplitPaneOperator.this.getSource()).setLeftComponent(component);
            }
        });
    }

    public void setOneTouchExpandable(final boolean b) {
        this.runMapping(new Operator.MapVoidAction("setOneTouchExpandable"){

            public void map() {
                ((JSplitPane)JSplitPaneOperator.this.getSource()).setOneTouchExpandable(b);
            }
        });
    }

    public void setOrientation(final int i) {
        this.runMapping(new Operator.MapVoidAction("setOrientation"){

            public void map() {
                ((JSplitPane)JSplitPaneOperator.this.getSource()).setOrientation(i);
            }
        });
    }

    public void setRightComponent(final Component component) {
        this.runMapping(new Operator.MapVoidAction("setRightComponent"){

            public void map() {
                ((JSplitPane)JSplitPaneOperator.this.getSource()).setRightComponent(component);
            }
        });
    }

    public void setTopComponent(final Component component) {
        this.runMapping(new Operator.MapVoidAction("setTopComponent"){

            public void map() {
                ((JSplitPane)JSplitPaneOperator.this.getSource()).setTopComponent(component);
            }
        });
    }

    public void setUI(final SplitPaneUI splitPaneUI) {
        this.runMapping(new Operator.MapVoidAction("setUI"){

            public void map() {
                ((JSplitPane)JSplitPaneOperator.this.getSource()).setUI(splitPaneUI);
            }
        });
    }

    private void expandTo(int index) {
        this.makeComponentVisible();
        JButtonOperator bo = new JButtonOperator((JButton)this.getDivider().waitSubComponent(new JButtonOperator.JButtonFinder(ComponentSearcher.getTrueChooser("JButton")), index));
        bo.copyEnvironment(this.getDivider());
        bo.setVisualizer(new EmptyVisualizer());
        bo.push();
    }

    static {
        Timeouts.initDefault("JSplitPaneOperator.ScrollClickTimeout", 0L);
        Timeouts.initDefault("JSplitPaneOperator.BetweenClickTimeout", 0L);
        Timeouts.initDefault("JSplitPaneOperator.WholeScrollTimeout", 60000L);
    }

    public static class JSplitPaneFinder
    extends Operator.Finder {
        public JSplitPaneFinder(ComponentChooser sf) {
            super(JSplitPane.class, sf);
        }

        public JSplitPaneFinder() {
            super(JSplitPane.class);
        }
    }

    private class ValueScrollAdjuster
    implements ScrollAdjuster {
        int value;

        public ValueScrollAdjuster(int value) {
            this.value = value;
        }

        public int getScrollDirection() {
            if (JSplitPaneOperator.this.getDividerLocation() == this.value) {
                return 0;
            }
            return JSplitPaneOperator.this.getDividerLocation() < this.value ? 1 : -1;
        }

        public int getScrollOrientation() {
            return JSplitPaneOperator.this.getOrientation();
        }

        public String getDescription() {
            return "Scroll to " + Integer.toString(this.value) + " value";
        }
    }
}

