/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.jemmy.operators;

import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.plaf.ScrollPaneUI;
import org.netbeans.jemmy.ComponentChooser;
import org.netbeans.jemmy.ComponentSearcher;
import org.netbeans.jemmy.Outputable;
import org.netbeans.jemmy.TestOut;
import org.netbeans.jemmy.Timeoutable;
import org.netbeans.jemmy.Timeouts;
import org.netbeans.jemmy.operators.ContainerOperator;
import org.netbeans.jemmy.operators.JComponentOperator;
import org.netbeans.jemmy.operators.JScrollBarOperator;
import org.netbeans.jemmy.operators.Operator;
import org.netbeans.jemmy.util.EmptyVisualizer;

public class JScrollPaneOperator
extends JComponentOperator
implements Timeoutable,
Outputable {
    private static int X_POINT_RECT_SIZE = 6;
    private static int Y_POINT_RECT_SIZE = 4;
    private Timeouts timeouts;
    private TestOut output;
    private JScrollBarOperator hScrollBarOper = null;
    private JScrollBarOperator vScrollBarOper = null;

    public JScrollPaneOperator(JScrollPane b) {
        super(b);
    }

    public JScrollPaneOperator(ContainerOperator cont, ComponentChooser chooser, int index) {
        this((JScrollPane)cont.waitSubComponent(new JScrollPaneFinder(chooser), index));
        this.copyEnvironment(cont);
    }

    public JScrollPaneOperator(ContainerOperator cont, ComponentChooser chooser) {
        this(cont, chooser, 0);
    }

    public JScrollPaneOperator(ContainerOperator cont, int index) {
        this((JScrollPane)JScrollPaneOperator.waitComponent(cont, (ComponentChooser)new JScrollPaneFinder(), index));
        this.copyEnvironment(cont);
    }

    public JScrollPaneOperator(ContainerOperator cont) {
        this(cont, 0);
    }

    public static JScrollPane findJScrollPane(Container cont, ComponentChooser chooser, int index) {
        return (JScrollPane)JScrollPaneOperator.findComponent(cont, new JScrollPaneFinder(chooser), index);
    }

    public static JScrollPane findJScrollPane(Container cont, ComponentChooser chooser) {
        return JScrollPaneOperator.findJScrollPane(cont, chooser, 0);
    }

    public static JScrollPane findJScrollPane(Container cont, int index) {
        return JScrollPaneOperator.findJScrollPane(cont, ComponentSearcher.getTrueChooser(Integer.toString(index) + "'th JScrollPane instance"), index);
    }

    public static JScrollPane findJScrollPane(Container cont) {
        return JScrollPaneOperator.findJScrollPane(cont, 0);
    }

    public static JScrollPane findJScrollPaneUnder(Component comp, ComponentChooser chooser) {
        return (JScrollPane)JScrollPaneOperator.findContainerUnder(comp, new JScrollPaneFinder(chooser));
    }

    public static JScrollPane findJScrollPaneUnder(Component comp) {
        return JScrollPaneOperator.findJScrollPaneUnder(comp, new JScrollPaneFinder());
    }

    public static JScrollPane waitJScrollPane(Container cont, ComponentChooser chooser, int index) {
        return (JScrollPane)JScrollPaneOperator.waitComponent(cont, (ComponentChooser)new JScrollPaneFinder(chooser), index);
    }

    public static JScrollPane waitJScrollPane(Container cont, ComponentChooser chooser) {
        return JScrollPaneOperator.waitJScrollPane(cont, chooser, 0);
    }

    public static JScrollPane waitJScrollPane(Container cont, int index) {
        return JScrollPaneOperator.waitJScrollPane(cont, ComponentSearcher.getTrueChooser(Integer.toString(index) + "'th JScrollPane instance"), index);
    }

    public static JScrollPane waitJScrollPane(Container cont) {
        return JScrollPaneOperator.waitJScrollPane(cont, 0);
    }

    public void setValues(int hValue, int vValue) {
        this.initOperators();
        this.hScrollBarOper.setValue(hValue);
        this.vScrollBarOper.setValue(vValue);
    }

    public void setTimeouts(Timeouts timeouts) {
        super.setTimeouts(timeouts);
        this.timeouts = timeouts;
    }

    public Timeouts getTimeouts() {
        return this.timeouts;
    }

    public void setOutput(TestOut out) {
        this.output = out;
        super.setOutput(this.output.createErrorOutput());
    }

    public TestOut getOutput() {
        return this.output;
    }

    public void scrollToHorizontalValue(int value) {
        this.output.printTrace("Scroll JScrollPane to " + Integer.toString(value) + " horizontal value \n" + this.toStringSource());
        this.output.printGolden("Scroll JScrollPane to " + Integer.toString(value) + " horizontal value");
        this.initOperators();
        this.makeComponentVisible();
        if (this.hScrollBarOper != null && this.hScrollBarOper.getSource().isVisible()) {
            this.hScrollBarOper.scrollToValue(value);
        }
    }

    public void scrollToHorizontalValue(double proportionalValue) {
        this.output.printTrace("Scroll JScrollPane to " + Double.toString(proportionalValue) + " proportional horizontal value \n" + this.toStringSource());
        this.output.printGolden("Scroll JScrollPane to " + Double.toString(proportionalValue) + " proportional horizontal value");
        this.initOperators();
        this.makeComponentVisible();
        if (this.hScrollBarOper != null && this.hScrollBarOper.getSource().isVisible()) {
            this.hScrollBarOper.scrollToValue(proportionalValue);
        }
    }

    public void scrollToVerticalValue(int value) {
        this.output.printTrace("Scroll JScrollPane to " + Integer.toString(value) + " vertical value \n" + this.toStringSource());
        this.output.printGolden("Scroll JScrollPane to " + Integer.toString(value) + " vertical value");
        this.initOperators();
        this.makeComponentVisible();
        if (this.vScrollBarOper != null && this.vScrollBarOper.getSource().isVisible()) {
            this.vScrollBarOper.scrollToValue(value);
        }
    }

    public void scrollToVerticalValue(double proportionalValue) {
        this.output.printTrace("Scroll JScrollPane to " + Double.toString(proportionalValue) + " proportional vertical value \n" + this.toStringSource());
        this.output.printGolden("Scroll JScrollPane to " + Double.toString(proportionalValue) + " proportional vertical value");
        this.initOperators();
        this.makeComponentVisible();
        if (this.vScrollBarOper != null && this.vScrollBarOper.getSource().isVisible()) {
            this.vScrollBarOper.scrollToValue(proportionalValue);
        }
    }

    public void scrollToValues(int valueX, int valueY) {
        this.scrollToVerticalValue(valueX);
        this.scrollToHorizontalValue(valueX);
    }

    public void scrollToValues(double proportionalValueX, double proportionalValueY) {
        this.scrollToVerticalValue(proportionalValueX);
        this.scrollToHorizontalValue(proportionalValueY);
    }

    public void scrollToTop() {
        this.output.printTrace("Scroll JScrollPane to top\n" + this.toStringSource());
        this.output.printGolden("Scroll JScrollPane to top");
        this.initOperators();
        this.makeComponentVisible();
        if (this.vScrollBarOper != null && this.vScrollBarOper.getSource().isVisible()) {
            this.vScrollBarOper.scrollToMinimum();
        }
    }

    public void scrollToBottom() {
        this.output.printTrace("Scroll JScrollPane to bottom\n" + this.toStringSource());
        this.output.printGolden("Scroll JScrollPane to bottom");
        this.initOperators();
        this.makeComponentVisible();
        if (this.vScrollBarOper != null && this.vScrollBarOper.getSource().isVisible()) {
            this.vScrollBarOper.scrollToMaximum();
        }
    }

    public void scrollToLeft() {
        this.output.printTrace("Scroll JScrollPane to left\n" + this.toStringSource());
        this.output.printGolden("Scroll JScrollPane to left");
        this.initOperators();
        this.makeComponentVisible();
        if (this.hScrollBarOper != null && this.hScrollBarOper.getSource().isVisible()) {
            this.hScrollBarOper.scrollToMinimum();
        }
    }

    public void scrollToRight() {
        this.output.printTrace("Scroll JScrollPane to right\n" + this.toStringSource());
        this.output.printGolden("Scroll JScrollPane to right");
        this.initOperators();
        this.makeComponentVisible();
        if (this.hScrollBarOper != null && this.hScrollBarOper.getSource().isVisible()) {
            this.hScrollBarOper.scrollToMaximum();
        }
    }

    public void scrollToComponentRectangle(Component comp, int x, int y, int width, int height) {
        this.initOperators();
        this.makeComponentVisible();
        if (this.hScrollBarOper != null && this.hScrollBarOper.getSource().isVisible()) {
            this.hScrollBarOper.scrollTo(new ComponentRectChecker(comp, x, y, width, height, 0));
        }
        if (this.vScrollBarOper != null && this.vScrollBarOper.getSource().isVisible()) {
            this.vScrollBarOper.scrollTo(new ComponentRectChecker(comp, x, y, width, height, 1));
        }
    }

    public void scrollToComponentPoint(Component comp, int x, int y) {
        this.scrollToComponentRectangle(comp, x - X_POINT_RECT_SIZE, y - Y_POINT_RECT_SIZE, 2 * X_POINT_RECT_SIZE, 2 * Y_POINT_RECT_SIZE);
    }

    public void scrollToComponent(final Component comp) {
        String componentToString = (String)this.runMapping(new Operator.MapAction("comp.toString()"){

            public Object map() {
                return comp.toString();
            }
        });
        this.output.printTrace("Scroll JScrollPane " + this.toStringSource() + "\nto component " + componentToString);
        this.output.printGolden("Scroll JScrollPane to " + comp.getClass().getName() + " component.");
        this.scrollToComponentRectangle(comp, 0, 0, comp.getWidth(), comp.getHeight());
    }

    public JScrollBarOperator getHScrollBarOperator() {
        this.initOperators();
        return this.hScrollBarOper;
    }

    public JScrollBarOperator getVScrollBarOperator() {
        this.initOperators();
        return this.vScrollBarOper;
    }

    public boolean checkInside(Component comp, int x, int y, int width, int height) {
        Component view = this.getViewport().getView();
        Point toPoint = SwingUtilities.convertPoint(comp, x, y, this.getViewport().getView());
        this.initOperators();
        if (this.hScrollBarOper != null && this.hScrollBarOper.getSource().isVisible()) {
            if (toPoint.x < this.hScrollBarOper.getValue()) {
                return false;
            }
            if (comp.getWidth() > view.getWidth()) {
                return toPoint.x > 0;
            }
            return toPoint.x + comp.getWidth() > this.hScrollBarOper.getValue() + view.getWidth();
        }
        if (this.vScrollBarOper != null && this.vScrollBarOper.getSource().isVisible()) {
            if (toPoint.y < this.vScrollBarOper.getValue()) {
                return false;
            }
            if (comp.getHeight() > view.getHeight()) {
                return toPoint.y > 0;
            }
            return toPoint.y + comp.getHeight() > this.vScrollBarOper.getValue() + view.getHeight();
        }
        return true;
    }

    public boolean checkInside(Component comp) {
        return this.checkInside(comp, 0, 0, comp.getWidth(), comp.getHeight());
    }

    public JScrollBar createHorizontalScrollBar() {
        return (JScrollBar)this.runMapping(new Operator.MapAction("createHorizontalScrollBar"){

            public Object map() {
                return ((JScrollPane)JScrollPaneOperator.this.getSource()).createHorizontalScrollBar();
            }
        });
    }

    public JScrollBar createVerticalScrollBar() {
        return (JScrollBar)this.runMapping(new Operator.MapAction("createVerticalScrollBar"){

            public Object map() {
                return ((JScrollPane)JScrollPaneOperator.this.getSource()).createVerticalScrollBar();
            }
        });
    }

    public JViewport getColumnHeader() {
        return (JViewport)this.runMapping(new Operator.MapAction("getColumnHeader"){

            public Object map() {
                return ((JScrollPane)JScrollPaneOperator.this.getSource()).getColumnHeader();
            }
        });
    }

    public Component getCorner(final String string) {
        return (Component)this.runMapping(new Operator.MapAction("getCorner"){

            public Object map() {
                return ((JScrollPane)JScrollPaneOperator.this.getSource()).getCorner(string);
            }
        });
    }

    public JScrollBar getHorizontalScrollBar() {
        return (JScrollBar)this.runMapping(new Operator.MapAction("getHorizontalScrollBar"){

            public Object map() {
                return ((JScrollPane)JScrollPaneOperator.this.getSource()).getHorizontalScrollBar();
            }
        });
    }

    public int getHorizontalScrollBarPolicy() {
        return this.runMapping(new Operator.MapIntegerAction("getHorizontalScrollBarPolicy"){

            public int map() {
                return ((JScrollPane)JScrollPaneOperator.this.getSource()).getHorizontalScrollBarPolicy();
            }
        });
    }

    public JViewport getRowHeader() {
        return (JViewport)this.runMapping(new Operator.MapAction("getRowHeader"){

            public Object map() {
                return ((JScrollPane)JScrollPaneOperator.this.getSource()).getRowHeader();
            }
        });
    }

    public ScrollPaneUI getUI() {
        return (ScrollPaneUI)this.runMapping(new Operator.MapAction("getUI"){

            public Object map() {
                return ((JScrollPane)JScrollPaneOperator.this.getSource()).getUI();
            }
        });
    }

    public JScrollBar getVerticalScrollBar() {
        return (JScrollBar)this.runMapping(new Operator.MapAction("getVerticalScrollBar"){

            public Object map() {
                return ((JScrollPane)JScrollPaneOperator.this.getSource()).getVerticalScrollBar();
            }
        });
    }

    public int getVerticalScrollBarPolicy() {
        return this.runMapping(new Operator.MapIntegerAction("getVerticalScrollBarPolicy"){

            public int map() {
                return ((JScrollPane)JScrollPaneOperator.this.getSource()).getVerticalScrollBarPolicy();
            }
        });
    }

    public JViewport getViewport() {
        return (JViewport)this.runMapping(new Operator.MapAction("getViewport"){

            public Object map() {
                return ((JScrollPane)JScrollPaneOperator.this.getSource()).getViewport();
            }
        });
    }

    public Border getViewportBorder() {
        return (Border)this.runMapping(new Operator.MapAction("getViewportBorder"){

            public Object map() {
                return ((JScrollPane)JScrollPaneOperator.this.getSource()).getViewportBorder();
            }
        });
    }

    public Rectangle getViewportBorderBounds() {
        return (Rectangle)this.runMapping(new Operator.MapAction("getViewportBorderBounds"){

            public Object map() {
                return ((JScrollPane)JScrollPaneOperator.this.getSource()).getViewportBorderBounds();
            }
        });
    }

    public void setColumnHeader(final JViewport jViewport) {
        this.runMapping(new Operator.MapVoidAction("setColumnHeader"){

            public void map() {
                ((JScrollPane)JScrollPaneOperator.this.getSource()).setColumnHeader(jViewport);
            }
        });
    }

    public void setColumnHeaderView(final Component component) {
        this.runMapping(new Operator.MapVoidAction("setColumnHeaderView"){

            public void map() {
                ((JScrollPane)JScrollPaneOperator.this.getSource()).setColumnHeaderView(component);
            }
        });
    }

    public void setCorner(final String string, final Component component) {
        this.runMapping(new Operator.MapVoidAction("setCorner"){

            public void map() {
                ((JScrollPane)JScrollPaneOperator.this.getSource()).setCorner(string, component);
            }
        });
    }

    public void setHorizontalScrollBar(final JScrollBar jScrollBar) {
        this.runMapping(new Operator.MapVoidAction("setHorizontalScrollBar"){

            public void map() {
                ((JScrollPane)JScrollPaneOperator.this.getSource()).setHorizontalScrollBar(jScrollBar);
            }
        });
    }

    public void setHorizontalScrollBarPolicy(final int i) {
        this.runMapping(new Operator.MapVoidAction("setHorizontalScrollBarPolicy"){

            public void map() {
                ((JScrollPane)JScrollPaneOperator.this.getSource()).setHorizontalScrollBarPolicy(i);
            }
        });
    }

    public void setRowHeader(final JViewport jViewport) {
        this.runMapping(new Operator.MapVoidAction("setRowHeader"){

            public void map() {
                ((JScrollPane)JScrollPaneOperator.this.getSource()).setRowHeader(jViewport);
            }
        });
    }

    public void setRowHeaderView(final Component component) {
        this.runMapping(new Operator.MapVoidAction("setRowHeaderView"){

            public void map() {
                ((JScrollPane)JScrollPaneOperator.this.getSource()).setRowHeaderView(component);
            }
        });
    }

    public void setUI(final ScrollPaneUI scrollPaneUI) {
        this.runMapping(new Operator.MapVoidAction("setUI"){

            public void map() {
                ((JScrollPane)JScrollPaneOperator.this.getSource()).setUI(scrollPaneUI);
            }
        });
    }

    public void setVerticalScrollBar(final JScrollBar jScrollBar) {
        this.runMapping(new Operator.MapVoidAction("setVerticalScrollBar"){

            public void map() {
                ((JScrollPane)JScrollPaneOperator.this.getSource()).setVerticalScrollBar(jScrollBar);
            }
        });
    }

    public void setVerticalScrollBarPolicy(final int i) {
        this.runMapping(new Operator.MapVoidAction("setVerticalScrollBarPolicy"){

            public void map() {
                ((JScrollPane)JScrollPaneOperator.this.getSource()).setVerticalScrollBarPolicy(i);
            }
        });
    }

    public void setViewport(final JViewport jViewport) {
        this.runMapping(new Operator.MapVoidAction("setViewport"){

            public void map() {
                ((JScrollPane)JScrollPaneOperator.this.getSource()).setViewport(jViewport);
            }
        });
    }

    public void setViewportBorder(final Border border) {
        this.runMapping(new Operator.MapVoidAction("setViewportBorder"){

            public void map() {
                ((JScrollPane)JScrollPaneOperator.this.getSource()).setViewportBorder(border);
            }
        });
    }

    public void setViewportView(final Component component) {
        this.runMapping(new Operator.MapVoidAction("setViewportView"){

            public void map() {
                ((JScrollPane)JScrollPaneOperator.this.getSource()).setViewportView(component);
            }
        });
    }

    private void initOperators() {
        if (this.hScrollBarOper == null && this.getHorizontalScrollBar() != null && this.getHorizontalScrollBar().isVisible()) {
            this.hScrollBarOper = new JScrollBarOperator(this.getHorizontalScrollBar());
            this.hScrollBarOper.copyEnvironment(this);
            this.hScrollBarOper.setVisualizer(new EmptyVisualizer());
        }
        if (this.vScrollBarOper == null && this.getVerticalScrollBar() != null && this.getVerticalScrollBar().isVisible()) {
            this.vScrollBarOper = new JScrollBarOperator(this.getVerticalScrollBar());
            this.vScrollBarOper.copyEnvironment(this);
            this.vScrollBarOper.setVisualizer(new EmptyVisualizer());
        }
    }

    private class ComponentRectChecker
    implements JScrollBarOperator.ScrollChecker {
        Component comp;
        int x;
        int y;
        int width;
        int height;
        int orientation;

        public ComponentRectChecker(Component comp, int x, int y, int width, int height, int orientation) {
            this.comp = comp;
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
            this.orientation = orientation;
        }

        public int getScrollDirection(JScrollBarOperator oper) {
            Point toPoint = SwingUtilities.convertPoint(this.comp, this.x, this.y, JScrollPaneOperator.this.getViewport().getView());
            int to = this.orientation == 0 ? toPoint.x : toPoint.y;
            int ln = this.orientation == 0 ? this.width : this.height;
            int lv = this.orientation == 0 ? JScrollPaneOperator.this.getViewport().getWidth() : JScrollPaneOperator.this.getViewport().getHeight();
            int vl = oper.getValue();
            if (to < vl) {
                return -1;
            }
            if (to + ln - 1 > vl + lv && to > vl) {
                return 1;
            }
            return 0;
        }

        public String getDescription() {
            return "";
        }
    }

    public static class JScrollPaneFinder
    extends Operator.Finder {
        public JScrollPaneFinder(ComponentChooser sf) {
            super(JScrollPane.class, sf);
        }

        public JScrollPaneFinder() {
            super(JScrollPane.class);
        }
    }
}

