/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.jemmy.image;

import java.awt.image.BufferedImage;
import org.netbeans.jemmy.image.ImageComparator;
import org.netbeans.jemmy.image.StrictImageComparator;

public class ColorImageComparator
extends StrictImageComparator {
    ColorMap leftMap;
    ColorMap rightMap;
    ImageComparator comparator = null;

    public ColorImageComparator(ColorMap map) {
        this.leftMap = map;
        this.rightMap = map;
    }

    public ColorImageComparator(ColorMap map, ImageComparator subComparator) {
        this(map);
        this.comparator = subComparator;
    }

    public ColorImageComparator(ColorMap leftMap, ColorMap rightMap) {
        this.leftMap = leftMap;
        this.rightMap = rightMap;
    }

    public ColorImageComparator(ColorMap leftMap, ColorMap rightMap, ImageComparator subComparator) {
        this(leftMap, rightMap);
        this.comparator = subComparator;
    }

    public boolean compare(BufferedImage image1, BufferedImage image2) {
        if (this.comparator != null) {
            return this.comparator.compare(this.recolor(image1, this.leftMap), this.recolor(image2, this.rightMap));
        }
        return super.compare(image1, image2);
    }

    private BufferedImage recolor(BufferedImage src, ColorMap map) {
        BufferedImage result = new BufferedImage(src.getWidth(), src.getHeight(), src.getType());
        for (int x = 0; x < src.getWidth(); ++x) {
            for (int y = 0; y < src.getWidth(); ++y) {
                result.setRGB(x, y, map.mapColor(src.getRGB(x, y)));
            }
        }
        return result;
    }

    protected final boolean compareColors(int rgb1, int rgb2) {
        return this.leftMap.mapColor(rgb1) == this.rightMap.mapColor(rgb2);
    }

    public static class BackgroundColorMap
    implements ColorMap {
        int background;

        public BackgroundColorMap(int background) {
            this.background = background;
        }

        public int mapColor(int rgb) {
            return rgb == this.background ? 0 : rgb;
        }
    }

    public static interface ColorMap {
        public int mapColor(int var1);
    }

    public static class ForegroundColorMap
    implements ColorMap {
        int foreground;

        public ForegroundColorMap(int foreground) {
            this.foreground = foreground;
        }

        public int mapColor(int rgb) {
            return rgb == this.foreground ? 0xFFFFFF : 0;
        }
    }
}

