/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.grammar;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.metadata.Metadata;
import org.apache.maven.artifact.repository.metadata.Versioning;
import org.apache.maven.artifact.repository.metadata.io.xpp3.MetadataXpp3Reader;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.jdom.Document;
import org.jdom.JDOMException;
import org.jdom.filter.Filter;
import org.jdom.input.SAXBuilder;
import org.netbeans.modules.maven.embedder.EmbedderFactory;
import org.netbeans.modules.maven.embedder.MavenEmbedder;
import org.netbeans.modules.maven.grammar.MavenSettingsGrammar;
import org.netbeans.modules.maven.grammar.spi.AbstractSchemaBasedGrammar;
import org.netbeans.modules.maven.grammar.spi.GrammarExtensionProvider;
import org.netbeans.modules.maven.indexer.api.NBVersionInfo;
import org.netbeans.modules.maven.indexer.api.PluginIndexManager;
import org.netbeans.modules.maven.indexer.api.RepositoryInfo;
import org.netbeans.modules.maven.indexer.api.RepositoryPreferences;
import org.netbeans.modules.maven.indexer.api.RepositoryQueries;
import org.netbeans.modules.xml.api.model.GrammarEnvironment;
import org.netbeans.modules.xml.api.model.GrammarResult;
import org.netbeans.modules.xml.api.model.HintContext;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MavenProjectGrammar
extends AbstractSchemaBasedGrammar {
    private static final Logger LOG = Logger.getLogger(MavenProjectGrammar.class.getName());
    private static final String[] SCOPES = new String[]{"compile", "test", "runtime", "provided", "system"};
    private Set<String> groupCache;
    private boolean groupCachePartial = false;
    private RequestProcessor.Task groupTask;
    private Map<String, RequestProcessor.Task> artifactTasks = new HashMap<String, RequestProcessor.Task>();
    private Map<String, Set<String>> artifactCache = new HashMap<String, Set<String>>();
    private Set<String> artifactsPartialCache = new HashSet<String>();
    private Map<String, RequestProcessor.Task> versionTasks = new HashMap<String, RequestProcessor.Task>();
    private Map<String, Set<String>> versionCache = new HashMap<String, Set<String>>();
    private Set<String> versionPartialCache = new HashSet<String>();
    private final Map<String, RequestProcessor.Task> classifierTasks = new HashMap<String, RequestProcessor.Task>();
    private final Map<String, Set<String>> classifierCache = new HashMap<String, Set<String>>();
    private Set<String> classifierPartialCache = new HashSet<String>();
    private final Object GROUP_LOCK = new Object();
    private final Object ARTIFACT_LOCK = new Object();
    private final Object VERSION_LOCK = new Object();
    private final Object CLASSIFIER_LOCK = new Object();
    private static RequestProcessor RP = new RequestProcessor(MavenProjectGrammar.class.getName(), 3);

    public MavenProjectGrammar(GrammarEnvironment env) {
        super(env);
        this.groupTask = RP.create((Runnable)new GroupTask());
    }

    @Override
    protected InputStream getSchemaStream() {
        return this.getClass().getResourceAsStream("/org/netbeans/modules/maven/grammar/maven-4.0.0.xsd");
    }

    @Override
    protected List<GrammarResult> getDynamicCompletion(String path, HintContext hintCtx, org.jdom.Element parent) {
        GrammarExtensionProvider extProvider;
        Document pluginDoc;
        MavenEmbedder embedder;
        Node previous;
        ArtifactInfoHolder info;
        List<GrammarResult> result = null;
        if ((path.endsWith("plugins/plugin/configuration") || path.endsWith("plugins/plugin/executions/execution/configuration")) && (result = this.collectPluginParams(info = this.findPluginInfo(previous = path.indexOf("execution") > 0 ? hintCtx.getParentNode().getParentNode().getParentNode().getPreviousSibling() : hintCtx.getParentNode().getPreviousSibling(), embedder = EmbedderFactory.getOnlineEmbedder(), true), hintCtx)) == null && (pluginDoc = this.loadDocument(info, embedder)) != null) {
            result = this.collectPluginParams(pluginDoc, hintCtx);
        }
        if ((extProvider = (GrammarExtensionProvider)Lookup.getDefault().lookup(GrammarExtensionProvider.class)) != null) {
            List<GrammarResult> extResult = extProvider.getDynamicCompletion(path, hintCtx, parent);
            if (result == null) {
                result = extResult;
            } else {
                result.addAll(extResult);
            }
        }
        return result;
    }

    private ArtifactInfoHolder findArtifactInfo(Node previous) {
        ArtifactInfoHolder holder = new ArtifactInfoHolder();
        while (previous != null) {
            Element el;
            NodeList lst;
            if (previous instanceof Element && (lst = (el = (Element)previous).getChildNodes()).getLength() > 0) {
                if ("artifactId".equals(el.getNodeName())) {
                    holder.setArtifactId(lst.item(0).getNodeValue());
                }
                if ("groupId".equals(el.getNodeName())) {
                    holder.setGroupId(lst.item(0).getNodeValue());
                }
                if ("version".equals(el.getNodeName())) {
                    holder.setVersion(lst.item(0).getNodeValue());
                }
            }
            previous = previous.getPreviousSibling();
        }
        return holder;
    }

    private ArtifactInfoHolder findPluginInfo(Node previous, MavenEmbedder embedder, boolean checkLocalRepo) {
        File lev1;
        File dir;
        File fil;
        ArtifactInfoHolder holder = this.findArtifactInfo(previous);
        if (holder.getGroupId() == null) {
            holder.setGroupId("org.apache.maven.plugins");
        }
        if (checkLocalRepo && (holder.getVersion() == null || "LATEST".equals(holder.getVersion()) || "RELEASE".equals(holder.getVersion())) && holder.getArtifactId() != null && holder.getGroupId() != null && (fil = new File(dir = new File(lev1 = new File(embedder.getLocalRepositoryFile(), holder.getGroupId().replace('.', File.separatorChar)), holder.getArtifactId()), "maven-metadata-local.xml")).exists()) {
            MetadataXpp3Reader reader = new MetadataXpp3Reader();
            try {
                Metadata data = reader.read((Reader)new InputStreamReader(new FileInputStream(fil)));
                if (data.getVersion() != null) {
                    holder.setVersion(data.getVersion());
                } else {
                    Versioning vers = data.getVersioning();
                    if (vers != null) {
                        if ("LATEST".equals(holder.getVersion())) {
                            holder.setVersion(vers.getLatest());
                        }
                        if ("RELEASE".equals(holder.getVersion())) {
                            holder.setVersion(vers.getRelease());
                        }
                    }
                }
            }
            catch (FileNotFoundException ex) {
                LOG.log(Level.FINER, "", ex);
            }
            catch (XmlPullParserException ex) {
                LOG.log(Level.FINER, "", ex);
            }
            catch (IOException ex) {
                LOG.log(Level.FINER, "", ex);
            }
        }
        if (holder.getVersion() == null) {
            holder.setVersion("RELEASE");
        }
        return holder;
    }

    private List<GrammarResult> collectPluginParams(Document pluginDoc, HintContext hintCtx) {
        Iterator it = pluginDoc.getRootElement().getDescendants(new Filter(){

            public boolean matches(Object object) {
                org.jdom.Element el;
                return object instanceof org.jdom.Element && "parameter".equals((el = (org.jdom.Element)object).getName()) && el.getParentElement() != null && "parameters".equals(el.getParentElement().getName()) && el.getParentElement().getParentElement() != null && "mojo".equals(el.getParentElement().getParentElement().getName());
            }
        });
        ArrayList<GrammarResult> toReturn = new ArrayList<GrammarResult>();
        HashSet<String> params = new HashSet<String>();
        while (it.hasNext()) {
            String name;
            org.jdom.Element el = (org.jdom.Element)it.next();
            String editable = el.getChildText("editable");
            if (!"true".equalsIgnoreCase(editable) || !(name = el.getChildText("name")).startsWith(hintCtx.getCurrentPrefix()) || params.contains(name)) continue;
            params.add(name);
            toReturn.add(new AbstractSchemaBasedGrammar.MyElement(name));
        }
        return toReturn;
    }

    private List<GrammarResult> collectPluginParams(ArtifactInfoHolder info, HintContext hintCtx) {
        Set params;
        try {
            params = PluginIndexManager.getPluginParameters((String)info.getGroupId(), (String)info.getArtifactId(), (String)info.getVersion(), null);
            if (params == null) {
                return null;
            }
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return null;
        }
        ArrayList<GrammarResult> toReturn = new ArrayList<GrammarResult>();
        for (PluginIndexManager.ParameterDetail plg : params) {
            if (!plg.getName().startsWith(hintCtx.getCurrentPrefix())) continue;
            AbstractSchemaBasedGrammar.MyElement me = new AbstractSchemaBasedGrammar.MyElement(plg.getName());
            me.setDescription(plg.getHtmlDetails(true));
            toReturn.add(me);
        }
        return toReturn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Enumeration<GrammarResult> getDynamicValueCompletion(String path, HintContext virtualTextCtx, org.jdom.Element el) {
        FileObject fo;
        String currprefix;
        ArrayList<AbstractSchemaBasedGrammar.AbstractResultNode> texts;
        Set<String> elems;
        ArrayList<AbstractSchemaBasedGrammar.AbstractResultNode> texts2;
        ArtifactInfoHolder hold;
        Node previous;
        if (path.endsWith("executions/execution/goals/goal")) {
            MavenEmbedder embedder;
            previous = virtualTextCtx.getCurrentPrefix().length() == 0 ? virtualTextCtx.getParentNode().getParentNode().getParentNode() : virtualTextCtx.getParentNode().getParentNode().getParentNode().getParentNode();
            ArtifactInfoHolder info = this.findPluginInfo(previous = previous.getPreviousSibling(), embedder = EmbedderFactory.getOnlineEmbedder(), true);
            Enumeration<GrammarResult> res = this.collectGoals(info, virtualTextCtx);
            if (res == null) {
                Document pluginDoc = this.loadDocument(info, embedder);
                if (pluginDoc != null) {
                    return this.collectGoals(pluginDoc, virtualTextCtx);
                }
            } else {
                return res;
            }
        }
        if (path.endsWith("executions/execution/phase")) {
            MavenEmbedder embedder = EmbedderFactory.getOnlineEmbedder();
            List phases = embedder.getLifecyclePhases();
            return super.createTextValueList(phases.toArray(new String[phases.size()]), virtualTextCtx);
        }
        if ((path.endsWith("dependencies/dependency/version") || path.endsWith("plugins/plugin/version") || path.endsWith("extensions/extension/version") || path.endsWith("/project/parent/version")) && (hold = this.findPluginInfo(previous = virtualTextCtx.getCurrentPrefix().length() == 0 ? virtualTextCtx.getPreviousSibling() : virtualTextCtx.getParentNode().getPreviousSibling(), null, false)).getGroupId() != null && hold.getArtifactId() != null) {
            Set<String> verStrings = this.getVersions(hold.getGroupId(), hold.getArtifactId());
            ArrayList<AbstractSchemaBasedGrammar.AbstractResultNode> elems2 = new ArrayList<AbstractSchemaBasedGrammar.AbstractResultNode>();
            for (String vers : verStrings) {
                if (!vers.startsWith(virtualTextCtx.getCurrentPrefix())) continue;
                elems2.add(new AbstractSchemaBasedGrammar.MyTextElement(vers, virtualTextCtx.getCurrentPrefix()));
            }
            Iterator i$ = this.VERSION_LOCK;
            synchronized (i$) {
                if (this.versionPartialCache.contains(hold.getGroupId() + ":" + hold.getArtifactId())) {
                    elems2.add(new AbstractSchemaBasedGrammar.PartialTextElement());
                }
            }
            return Collections.enumeration(elems2);
        }
        if (path.endsWith("dependencies/dependency/groupId") || path.endsWith("extensions/extension/groupId")) {
            Set<String> elems3 = this.getGroupIds();
            texts2 = new ArrayList<AbstractSchemaBasedGrammar.AbstractResultNode>();
            for (String elem : elems3) {
                if (!elem.startsWith(virtualTextCtx.getCurrentPrefix())) continue;
                texts2.add(new AbstractSchemaBasedGrammar.MyTextElement(elem, virtualTextCtx.getCurrentPrefix()));
            }
            Iterator i$ = this.GROUP_LOCK;
            synchronized (i$) {
                if (this.groupCachePartial) {
                    texts2.add(new AbstractSchemaBasedGrammar.PartialTextElement());
                }
            }
            return Collections.enumeration(texts2);
        }
        if (path.endsWith("plugins/plugin/groupId")) {
            RepositoryQueries.Result result = RepositoryQueries.filterPluginGroupIdsResult((String)virtualTextCtx.getCurrentPrefix(), (List)RepositoryPreferences.getInstance().getRepositoryInfos());
            texts2 = new ArrayList();
            for (String elem : result.getResults()) {
                texts2.add(new AbstractSchemaBasedGrammar.MyTextElement(elem, virtualTextCtx.getCurrentPrefix()));
            }
            if (result.isPartial()) {
                texts2.add(new AbstractSchemaBasedGrammar.PartialTextElement());
            }
            return Collections.enumeration(texts2);
        }
        if ((path.endsWith("dependencies/dependency/artifactId") || path.endsWith("extensions/extension/artifactId")) && (hold = this.findArtifactInfo(previous = virtualTextCtx.getCurrentPrefix().length() == 0 ? virtualTextCtx.getPreviousSibling() : virtualTextCtx.getParentNode().getPreviousSibling())).getGroupId() != null) {
            elems = this.getArtifactIds(hold.getGroupId());
            texts = new ArrayList<AbstractSchemaBasedGrammar.AbstractResultNode>();
            currprefix = virtualTextCtx.getCurrentPrefix();
            for (String elem : elems) {
                if (!elem.startsWith(currprefix)) continue;
                texts.add(new AbstractSchemaBasedGrammar.MyTextElement(elem, currprefix));
            }
            Object i$ = this.ARTIFACT_LOCK;
            synchronized (i$) {
                if (this.artifactsPartialCache.contains(hold.getGroupId())) {
                    texts.add(new AbstractSchemaBasedGrammar.PartialTextElement());
                }
            }
            return Collections.enumeration(texts);
        }
        if (path.endsWith("dependencies/dependency/classifier") && (hold = this.findArtifactInfo(previous = virtualTextCtx.getCurrentPrefix().length() == 0 ? virtualTextCtx.getPreviousSibling() : virtualTextCtx.getParentNode().getPreviousSibling())).getGroupId() != null && hold.getArtifactId() != null && hold.getVersion() != null) {
            elems = this.getClassifiers(hold.getGroupId(), hold.getArtifactId(), hold.getVersion());
            texts = new ArrayList();
            currprefix = virtualTextCtx.getCurrentPrefix();
            for (String elem : elems) {
                if (!elem.startsWith(currprefix)) continue;
                texts.add(new AbstractSchemaBasedGrammar.MyTextElement(elem, currprefix));
            }
            Object i$ = this.CLASSIFIER_LOCK;
            synchronized (i$) {
                String id = hold.getGroupId() + ':' + hold.getArtifactId() + ':' + hold.getVersion();
                if (this.classifierPartialCache.contains(id)) {
                    texts.add(new AbstractSchemaBasedGrammar.PartialTextElement());
                }
            }
            return Collections.enumeration(texts);
        }
        if (path.endsWith("plugins/plugin/artifactId") && (hold = this.findArtifactInfo(previous = virtualTextCtx.getCurrentPrefix().length() == 0 ? virtualTextCtx.getPreviousSibling() : virtualTextCtx.getParentNode().getPreviousSibling())).getGroupId() != null) {
            RepositoryQueries.Result result = RepositoryQueries.filterPluginArtifactIdsResult((String)hold.getGroupId(), (String)virtualTextCtx.getCurrentPrefix(), (List)RepositoryPreferences.getInstance().getRepositoryInfos());
            texts = new ArrayList();
            for (String elem : result.getResults()) {
                texts.add(new AbstractSchemaBasedGrammar.MyTextElement(elem, virtualTextCtx.getCurrentPrefix()));
            }
            if (result.isPartial()) {
                texts.add(new AbstractSchemaBasedGrammar.PartialTextElement());
            }
            return Collections.enumeration(texts);
        }
        if (path.endsWith("dependencies/dependency/scope")) {
            return super.createTextValueList(SCOPES, virtualTextCtx);
        }
        if (path.endsWith("repositories/repository/releases/updatePolicy") || path.endsWith("repositories/repository/snapshots/updatePolicy") || path.endsWith("pluginRepositories/pluginRepository/releases/updatePolicy") || path.endsWith("pluginRepositories/pluginRepository/snapshots/updatePolicy")) {
            return super.createTextValueList(MavenSettingsGrammar.UPDATE_POLICIES, virtualTextCtx);
        }
        if (path.endsWith("repository/releases/checksumPolicy") || path.endsWith("repository/snapshots/checksumPolicy") || path.endsWith("pluginRepository/releases/checksumPolicy") || path.endsWith("pluginRepository/snapshots/checksumPolicy")) {
            return super.createTextValueList(MavenSettingsGrammar.CHECKSUM_POLICIES, virtualTextCtx);
        }
        if (path.endsWith("repositories/repository/layout") || path.endsWith("pluginRepositories/pluginRepository/layout") || path.endsWith("distributionManagement/repository/layout")) {
            return super.createTextValueList(MavenSettingsGrammar.LAYOUTS, virtualTextCtx);
        }
        if (path.endsWith("repositories/repository/url") || path.endsWith("pluginRepositories/pluginRepository/url") || path.endsWith("distributionManagement/repository/url")) {
            List<String> repoIds = this.getRepoUrls();
            return super.createTextValueList(repoIds.toArray(new String[0]), virtualTextCtx);
        }
        if (path.endsWith("modules/module") && (fo = this.getEnvironment().getFileObject()) != null) {
            File dir = FileUtil.toFile((FileObject)fo).getParentFile();
            String prefix = virtualTextCtx.getCurrentPrefix();
            boolean endingSlash = prefix.endsWith("/");
            String[] elms = StringUtils.split((String)prefix, (String)"/");
            String lastElement = "";
            for (int i = 0; i < elms.length; ++i) {
                if ("..".equals(elms[i])) {
                    dir = dir != null ? dir.getParentFile() : null;
                    continue;
                }
                if (i < elms.length - (endingSlash ? 0 : 1)) {
                    dir = dir != null ? new File(dir, elms[i]) : null;
                    continue;
                }
                lastElement = elms[i];
            }
            String string = prefix = lastElement != null ? lastElement : prefix;
            if (dir == null || !dir.exists() || !dir.isDirectory()) {
                return null;
            }
            File[] modules = dir.listFiles(new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    return pathname.isDirectory() && new File(pathname, "pom.xml").exists();
                }
            });
            ArrayList<AbstractSchemaBasedGrammar.MyTextElement> elems4 = new ArrayList<AbstractSchemaBasedGrammar.MyTextElement>();
            for (int i = 0; i < modules.length; ++i) {
                if (!modules[i].getName().startsWith(prefix)) continue;
                elems4.add(new AbstractSchemaBasedGrammar.MyTextElement(modules[i].getName(), prefix));
            }
            return Collections.enumeration(elems4);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> getGroupIds() {
        Set<String> elems = null;
        Object object = this.GROUP_LOCK;
        synchronized (object) {
            if (this.groupCache != null) {
                elems = this.groupCache;
                if (this.groupCachePartial) {
                    this.groupTask.schedule(500);
                }
            } else if (!this.groupTask.isFinished()) {
                this.groupTask.run();
            }
        }
        if (elems == null) {
            this.groupTask.waitFinished();
        }
        object = this.GROUP_LOCK;
        synchronized (object) {
            elems = this.groupCache != null ? this.groupCache : Collections.emptySet();
        }
        return elems;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> getArtifactIds(String groupId) {
        Set<String> c;
        RequestProcessor.Task tsk;
        Set<String> elems = null;
        Object object = this.ARTIFACT_LOCK;
        synchronized (object) {
            tsk = this.artifactTasks.get(groupId);
            if (tsk == null) {
                tsk = RP.create((Runnable)new ArtifactTask(groupId));
                this.artifactTasks.put(groupId, tsk);
            }
            if ((c = this.artifactCache.get(groupId)) != null) {
                elems = c;
                if (this.artifactsPartialCache.contains(groupId)) {
                    tsk.schedule(200);
                }
            } else if (!tsk.isFinished()) {
                tsk.run();
            }
        }
        if (elems == null) {
            tsk.waitFinished();
        }
        object = this.ARTIFACT_LOCK;
        synchronized (object) {
            c = this.artifactCache.get(groupId);
            elems = c != null ? c : Collections.emptySet();
        }
        return elems;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> getVersions(String groupId, String artifactId) {
        Set<String> c;
        RequestProcessor.Task tsk;
        Set<String> elems = null;
        String id = groupId + ":" + artifactId;
        Object object = this.VERSION_LOCK;
        synchronized (object) {
            tsk = this.versionTasks.get(id);
            if (tsk == null) {
                tsk = RP.create((Runnable)new VersionTask(groupId, artifactId));
                this.versionTasks.put(id, tsk);
            }
            if ((c = this.versionCache.get(id)) != null) {
                elems = c;
                if (this.versionPartialCache.contains(groupId)) {
                    tsk.schedule(200);
                }
            } else if (!tsk.isFinished()) {
                tsk.run();
            }
        }
        if (elems == null) {
            tsk.waitFinished();
        }
        object = this.VERSION_LOCK;
        synchronized (object) {
            c = this.versionCache.get(id);
            elems = c != null ? c : Collections.emptySet();
        }
        return elems;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> getClassifiers(String groupId, String artifactId, String version) {
        Set<String> c;
        RequestProcessor.Task tsk;
        Set<String> elems = null;
        String id = groupId + ':' + artifactId + ':' + version;
        Object object = this.CLASSIFIER_LOCK;
        synchronized (object) {
            tsk = this.classifierTasks.get(id);
            if (tsk == null) {
                tsk = RP.create((Runnable)new ClassifierTask(groupId, artifactId, version));
                this.classifierTasks.put(id, tsk);
            }
            if ((c = this.classifierCache.get(id)) != null) {
                elems = c;
                if (this.classifierPartialCache.contains(groupId)) {
                    tsk.schedule(200);
                }
            } else if (!tsk.isFinished()) {
                tsk.run();
            }
        }
        if (elems == null) {
            tsk.waitFinished();
        }
        object = this.CLASSIFIER_LOCK;
        synchronized (object) {
            c = this.classifierCache.get(id);
            elems = c != null ? c : Collections.emptySet();
        }
        return elems;
    }

    private List<String> getRepoUrls() {
        ArrayList<String> repos = new ArrayList<String>();
        List ris = RepositoryPreferences.getInstance().getRepositoryInfos();
        for (RepositoryInfo ri : ris) {
            if (ri.getRepositoryUrl() == null) continue;
            repos.add(ri.getRepositoryUrl());
        }
        return repos;
    }

    private Document loadDocument(ArtifactInfoHolder info, MavenEmbedder embedder) {
        if (info.getArtifactId() != null && info.getGroupId() != null && info.getVersion() != null) {
            Artifact art = embedder.createArtifact(info.getGroupId(), info.getArtifactId(), info.getVersion(), null, "jar");
            String repopath = embedder.getLocalRepository().pathOf(art);
            File fil = new File(embedder.getLocalRepositoryFile(), repopath);
            if (fil.exists()) {
                try {
                    JarFile jf = new JarFile(fil);
                    JarEntry entry = jf.getJarEntry("META-INF/maven/plugin.xml");
                    if (entry != null) {
                        InputStream str = jf.getInputStream(entry);
                        SAXBuilder builder = new SAXBuilder();
                        return builder.build(str);
                    }
                }
                catch (IOException ex) {
                    LOG.log(Level.FINER, "", ex);
                }
                catch (JDOMException ex) {
                    LOG.log(Level.FINER, "", ex);
                }
            }
        }
        return null;
    }

    private Enumeration<GrammarResult> collectGoals(Document pluginDoc, HintContext virtualTextCtx) {
        Iterator it = pluginDoc.getRootElement().getDescendants(new Filter(){

            public boolean matches(Object object) {
                org.jdom.Element el;
                return object instanceof org.jdom.Element && "goal".equals((el = (org.jdom.Element)object).getName()) && el.getParentElement() != null && "mojo".equals(el.getParentElement().getName());
            }
        });
        ArrayList<AbstractSchemaBasedGrammar.MyTextElement> toReturn = new ArrayList<AbstractSchemaBasedGrammar.MyTextElement>();
        while (it.hasNext()) {
            org.jdom.Element el = (org.jdom.Element)it.next();
            String name = el.getText();
            if (!name.startsWith(virtualTextCtx.getCurrentPrefix())) continue;
            toReturn.add(new AbstractSchemaBasedGrammar.MyTextElement(name, virtualTextCtx.getCurrentPrefix()));
        }
        return Collections.enumeration(toReturn);
    }

    private Enumeration<GrammarResult> collectGoals(ArtifactInfoHolder info, HintContext virtualTextCtx) {
        Set goals;
        if (info.getGroupId() == null || info.getArtifactId() == null || info.getVersion() == null) {
            return null;
        }
        try {
            goals = PluginIndexManager.getPluginGoals((String)info.getGroupId(), (String)info.getArtifactId(), (String)info.getVersion());
            if (goals == null) {
                return null;
            }
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return null;
        }
        ArrayList<AbstractSchemaBasedGrammar.MyTextElement> toReturn = new ArrayList<AbstractSchemaBasedGrammar.MyTextElement>();
        for (String name : goals) {
            if (!name.startsWith(virtualTextCtx.getCurrentPrefix())) continue;
            toReturn.add(new AbstractSchemaBasedGrammar.MyTextElement(name, virtualTextCtx.getCurrentPrefix()));
        }
        return Collections.enumeration(toReturn);
    }

    private static class ArtifactInfoHolder {
        private String artifactId;
        private String groupId;
        private String version;

        private ArtifactInfoHolder() {
        }

        public String getArtifactId() {
            return this.artifactId;
        }

        public void setArtifactId(String artifactId) {
            this.artifactId = artifactId;
        }

        public String getGroupId() {
            return this.groupId;
        }

        public void setGroupId(String groupId) {
            this.groupId = groupId;
        }

        public String getVersion() {
            return this.version;
        }

        public void setVersion(String version) {
            this.version = version;
        }
    }

    private class ArtifactTask
    implements Runnable {
        private String groupId;

        ArtifactTask(String groupId) {
            this.groupId = groupId;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            RepositoryQueries.Result result = RepositoryQueries.getArtifactsResult((String)this.groupId, (List)RepositoryPreferences.getInstance().getRepositoryInfos());
            TreeSet elems = new TreeSet(result.getResults());
            Object object = MavenProjectGrammar.this.ARTIFACT_LOCK;
            synchronized (object) {
                MavenProjectGrammar.this.artifactCache.put(this.groupId, elems);
                if (result.isPartial()) {
                    MavenProjectGrammar.this.artifactsPartialCache.add(this.groupId);
                } else {
                    MavenProjectGrammar.this.artifactsPartialCache.remove(this.groupId);
                }
            }
        }
    }

    private class ClassifierTask
    implements Runnable {
        private final String groupId;
        private final String artifactId;
        private final String version;

        ClassifierTask(String groupId, String artifactId, String version) {
            this.groupId = groupId;
            this.artifactId = artifactId;
            this.version = version;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            RepositoryQueries.Result result = RepositoryQueries.getRecordsResult((String)this.groupId, (String)this.artifactId, (String)this.version, (List)RepositoryPreferences.getInstance().getRepositoryInfos());
            LinkedHashSet<String> elems = new LinkedHashSet<String>();
            for (NBVersionInfo inf : result.getResults()) {
                if (inf.getClassifier() == null) continue;
                elems.add(inf.getClassifier());
            }
            Object object = MavenProjectGrammar.this.CLASSIFIER_LOCK;
            synchronized (object) {
                String key = this.groupId + ':' + this.artifactId + ':' + this.version;
                MavenProjectGrammar.this.classifierCache.put(key, elems);
                if (result.isPartial()) {
                    MavenProjectGrammar.this.classifierPartialCache.add(key);
                } else {
                    MavenProjectGrammar.this.classifierPartialCache.remove(key);
                }
            }
        }
    }

    private class GroupTask
    implements Runnable {
        private GroupTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            RepositoryQueries.Result result = RepositoryQueries.getGroupsResult((List)RepositoryPreferences.getInstance().getRepositoryInfos());
            TreeSet set = new TreeSet(result.getResults());
            Object object = MavenProjectGrammar.this.GROUP_LOCK;
            synchronized (object) {
                MavenProjectGrammar.this.groupCache = set;
                MavenProjectGrammar.this.groupCachePartial = result.isPartial();
            }
        }
    }

    private class VersionTask
    implements Runnable {
        private String groupId;
        private String artifactId;

        VersionTask(String groupId, String art) {
            this.groupId = groupId;
            this.artifactId = art;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            RepositoryQueries.Result result = RepositoryQueries.getVersionsResult((String)this.groupId, (String)this.artifactId, (List)RepositoryPreferences.getInstance().getRepositoryInfos());
            LinkedHashSet<String> elems = new LinkedHashSet<String>();
            for (NBVersionInfo inf : result.getResults()) {
                elems.add(inf.getVersion());
            }
            Object object = MavenProjectGrammar.this.VERSION_LOCK;
            synchronized (object) {
                String key = this.groupId + ":" + this.artifactId;
                MavenProjectGrammar.this.versionCache.put(key, elems);
                if (result.isPartial()) {
                    MavenProjectGrammar.this.versionPartialCache.add(key);
                } else {
                    MavenProjectGrammar.this.versionPartialCache.remove(key);
                }
            }
        }
    }
}

