/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.javaee.core.deployment;

import com.sun.enterprise.config.serverbeans.DasConfig;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Module;
import com.sun.enterprise.deploy.shared.ArchiveFactory;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.RootDeploymentDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.archivist.ApplicationArchivist;
import com.sun.enterprise.deployment.archivist.ApplicationFactory;
import com.sun.enterprise.deployment.archivist.Archivist;
import com.sun.enterprise.deployment.archivist.ArchivistFactory;
import com.sun.enterprise.deployment.archivist.DescriptorArchivist;
import com.sun.enterprise.deployment.deploy.shared.DeploymentPlanArchive;
import com.sun.enterprise.deployment.util.DOLUtils;
import com.sun.enterprise.deployment.util.ModuleDescriptor;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.deployment.ApplicationMetaDataProvider;
import org.glassfish.api.deployment.DeployCommandParameters;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.api.deployment.MetaData;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.api.deployment.archive.WritableArchive;
import org.glassfish.deployment.common.DeploymentUtils;
import org.glassfish.hk2.classmodel.reflect.Parser;
import org.glassfish.hk2.classmodel.reflect.Types;
import org.glassfish.internal.deployment.ApplicationInfoProvider;
import org.glassfish.internal.deployment.DeploymentTracing;
import org.glassfish.javaee.core.deployment.ApplicationHolder;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.xml.sax.SAXParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
public class DolProvider
implements ApplicationMetaDataProvider<Application>,
ApplicationInfoProvider {
    @Inject
    ArchivistFactory archivistFactory;
    @Inject
    protected ApplicationFactory applicationFactory;
    @Inject
    protected ArchiveFactory archiveFactory;
    @Inject
    protected DescriptorArchivist descriptorArchivist;
    @Inject
    protected ApplicationArchivist applicationArchivist;
    @Inject
    Habitat habitat;
    @Inject
    Domain domain;
    @Inject
    DasConfig dasConfig;
    private static String WRITEOUT_XML = System.getProperty("writeout.xml");
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(DolProvider.class);

    public MetaData getMetaData() {
        return new MetaData(false, new Class[]{Application.class, WebBundleDescriptor.class}, null);
    }

    public Application load(DeploymentContext dc) throws IOException {
        ModuleDescriptor md;
        ReadableArchive sourceArchive = dc.getSource();
        sourceArchive.setExtraData(Types.class, dc.getTransientAppMetaData(Types.class.getName(), Types.class));
        sourceArchive.setExtraData(Parser.class, dc.getTransientAppMetaData(Parser.class.getName(), Parser.class));
        ClassLoader cl = dc.getClassLoader();
        DeployCommandParameters params = (DeployCommandParameters)dc.getCommandParameters(DeployCommandParameters.class);
        String name = params.name();
        Archivist archivist = this.archivistFactory.getArchivist(sourceArchive, cl);
        if (archivist == null) {
            throw new RuntimeException(localStrings.getLocalString("invalid.javaee.archive", "Archive [{0}] was deployed as a Java EE archive while it does not contain any valid Java EE components. Please check the packaging of the archive.", new Object[]{name}));
        }
        archivist.setAnnotationProcessingRequested(true);
        String xmlValidationLevel = this.dasConfig.getDeployXmlValidation();
        archivist.setXMLValidationLevel(xmlValidationLevel);
        if (xmlValidationLevel.equals("none")) {
            archivist.setXMLValidation(false);
        }
        archivist.setRuntimeXMLValidation(false);
        ApplicationHolder holder = (ApplicationHolder)dc.getModuleMetaData(ApplicationHolder.class);
        File deploymentPlan = params.deploymentplan;
        this.handleDeploymentPlan(deploymentPlan, archivist, sourceArchive, holder);
        long start = System.currentTimeMillis();
        Application application = null;
        if (holder != null) {
            application = holder.app;
            application.setAppName(name);
            application.setClassLoader(cl);
            if (application.isVirtual()) {
                md = application.getStandaloneBundleDescriptor().getModuleDescriptor();
                md.setModuleName(name);
            }
            try {
                this.applicationFactory.openWith(application, sourceArchive, archivist);
            }
            catch (SAXParseException e) {
                throw new IOException(e);
            }
        }
        try {
            application = this.applicationFactory.openArchive(name, archivist, sourceArchive, true);
            application.setAppName(name);
            md = application.getStandaloneBundleDescriptor().getModuleDescriptor();
            md.setModuleName(name);
        }
        catch (SAXParseException e) {
            throw new IOException(e);
        }
        application.setRegistrationName(name);
        sourceArchive.removeExtraData(Types.class);
        sourceArchive.removeExtraData(Parser.class);
        if (Boolean.valueOf(WRITEOUT_XML).booleanValue()) {
            this.saveAppDescriptor(application, dc);
        }
        Logger.getAnonymousLogger().log(Level.FINE, "DOL Loading time" + (System.currentTimeMillis() - start));
        if (application.isVirtual()) {
            dc.addModuleMetaData((Object)application.getStandaloneBundleDescriptor());
            for (RootDeploymentDescriptor extension : application.getStandaloneBundleDescriptor().getExtensionsDescriptors()) {
                dc.addModuleMetaData((Object)extension);
            }
        }
        this.addModuleConfig(dc, application);
        this.validateKeepStateOption(dc, params, application);
        return application;
    }

    public String getNameFor(ReadableArchive archive, DeploymentContext context) {
        Application application = null;
        try {
            if (archive.exists("META-INF/application.xml") || archive.exists("WEB-INF/web.xml") || archive.exists("META-INF/ejb-jar.xml") || archive.exists("META-INF/application-client.xml") || archive.exists("META-INF/ra.xml")) {
                application = this.applicationFactory.createApplicationFromStandardDD(archive);
                DeploymentTracing tracing = null;
                if (context != null) {
                    tracing = (DeploymentTracing)context.getModuleMetaData(DeploymentTracing.class);
                }
                if (tracing != null) {
                    tracing.addMark(DeploymentTracing.Mark.DOL_LOADED);
                }
                ApplicationHolder holder = new ApplicationHolder(application);
                if (context != null) {
                    context.addModuleMetaData((Object)holder);
                }
                return application.getAppName();
            }
        }
        catch (Exception e) {
            Logger.getAnonymousLogger().log(Level.WARNING, "Error occurred", e);
        }
        return null;
    }

    public List<URL> getLibraryJars(DeploymentContext context) {
        ArrayList<URL> libraryURLs = new ArrayList<URL>();
        try {
            ReadableArchive archive = context.getSource();
            BundleDescriptor bundleDesc = (BundleDescriptor)context.getModuleMetaData(BundleDescriptor.class);
            libraryURLs.addAll(DOLUtils.getLibraryJars((BundleDescriptor)bundleDesc, (ReadableArchive)archive));
            libraryURLs.addAll(DeploymentUtils.getModuleLibraryJars((DeploymentContext)context));
        }
        catch (Exception e) {
            Logger.getAnonymousLogger().log(Level.WARNING, "failed to get library jar: ", e);
        }
        return libraryURLs;
    }

    protected void handleDeploymentPlan(File deploymentPlan, Archivist archivist, ReadableArchive sourceArchive, ApplicationHolder holder) throws IOException {
        if (deploymentPlan != null) {
            DeploymentPlanArchive dpa = new DeploymentPlanArchive();
            dpa.open(deploymentPlan.toURI());
            WritableArchive targetArchive = this.archiveFactory.createArchive(sourceArchive.getURI());
            if (archivist instanceof ApplicationArchivist) {
                ((ApplicationArchivist)archivist).copyInto(holder.app, (ReadableArchive)dpa, targetArchive, false);
            } else {
                archivist.copyInto((ReadableArchive)dpa, targetArchive, false);
            }
        }
    }

    protected void saveAppDescriptor(Application application, DeploymentContext context) throws IOException {
        if (application != null) {
            ReadableArchive archive = this.archiveFactory.openArchive(context.getSourceDir());
            boolean isMkdirs = context.getScratchDir("xml").mkdirs();
            if (isMkdirs) {
                WritableArchive archive2 = this.archiveFactory.createArchive(context.getScratchDir("xml"));
                this.descriptorArchivist.write(application, archive, archive2);
                this.applicationArchivist.copyExtraElements(archive, archive2);
            } else {
                context.getLogger().log(Level.WARNING, "Error in creating directory " + context.getScratchDir("xml").getAbsolutePath());
            }
        }
    }

    private void addModuleConfig(DeploymentContext dc, Application application) {
        DeployCommandParameters params = (DeployCommandParameters)dc.getCommandParameters(DeployCommandParameters.class);
        if (!params.origin.isDeploy()) {
            return;
        }
        try {
            com.sun.enterprise.config.serverbeans.Application app_w = (com.sun.enterprise.config.serverbeans.Application)dc.getTransientAppMetaData("application", com.sun.enterprise.config.serverbeans.Application.class);
            if (app_w != null) {
                if (application.isVirtual()) {
                    Module modConfig = (Module)app_w.createChild(Module.class);
                    app_w.getModule().add(modConfig);
                    modConfig.setName(application.getRegistrationName());
                } else {
                    for (ModuleDescriptor moduleDesc : application.getModules()) {
                        Module modConfig = (Module)app_w.createChild(Module.class);
                        app_w.getModule().add(modConfig);
                        modConfig.setName(moduleDesc.getArchiveUri());
                    }
                }
            }
        }
        catch (Exception e) {
            Logger.getAnonymousLogger().log(Level.WARNING, "failed to add the module config", e);
        }
    }

    private void validateKeepStateOption(DeploymentContext context, DeployCommandParameters params, Application app) {
        if ((params.keepstate != null && params.keepstate.booleanValue() || app.getKeepState()) && !this.isDASTarget(context, params)) {
            params.keepstate = false;
            String warningMsg = localStrings.getLocalString("not.support.keepstate.in.cluster", "Ignoring the keepstate setting: the keepstate option is only supported in developer profile and not cluster profile.");
            ActionReport subReport = context.getActionReport().addSubActionsReport();
            subReport.setActionExitCode(ActionReport.ExitCode.WARNING);
            subReport.setMessage(warningMsg);
            context.getLogger().log(Level.WARNING, warningMsg);
        }
    }

    private boolean isDASTarget(DeploymentContext context, DeployCommandParameters params) {
        if (DeploymentUtils.isDASTarget((String)params.target)) {
            return true;
        }
        if (DeploymentUtils.isDomainTarget((String)params.target)) {
            List targets = (List)context.getTransientAppMetaData("previousTargets", List.class);
            if (targets == null) {
                targets = this.domain.getAllReferencedTargetsForApplication(params.name);
            }
            if (targets.size() == 1 && DeploymentUtils.isDASTarget((String)((String)targets.get(0)))) {
                return true;
            }
        }
        return false;
    }
}

