/*
 * Decompiled with CFR 0.152.
 */
package org.nbheaven.sqe.informations.ui.view;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.EventQueue;
import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import org.nbheaven.sqe.informations.ui.spi.SQEInformationProvider;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.ui.OpenProjects;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.util.ImageUtilities;
import org.openide.util.lookup.Lookups;
import org.openide.windows.TopComponent;

public class InformationTopComponent
extends TopComponent
implements PropertyChangeListener {
    private static Map<Project, TopComponent> instances = new WeakHashMap<Project, TopComponent>();
    private final Project project;

    private InformationTopComponent(Project project) {
        this.associateLookup(Lookups.fixed((Object[])new Object[]{new AbstractNode(Children.LEAF, Lookups.fixed((Object[])new Object[]{project}))}));
        this.project = project;
        this.initComponent();
        OpenProjects.getDefault().addPropertyChangeListener((PropertyChangeListener)this);
    }

    public static synchronized TopComponent getInstance(Project project) {
        assert (EventQueue.isDispatchThread()) : "Call this from EventQueue";
        TopComponent tc = instances.get(project);
        if (null == tc) {
            tc = new InformationTopComponent(project);
            instances.put(project, tc);
        }
        return tc;
    }

    private void initComponent() {
        this.setBackground(Color.WHITE);
        this.setOpaque(true);
        this.setLayout(new BorderLayout());
        ProjectInformation information = ProjectUtils.getInformation((Project)this.project);
        JLabel label = new JLabel(information.getDisplayName() + " [" + information.getName() + "]", information.getIcon(), 10);
        label.setFont(label.getFont().deriveFont(1, 15.0f));
        label.setBackground(Color.WHITE);
        label.setOpaque(true);
        label.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.add(label, "North");
        SQEInformationProvider provider = (SQEInformationProvider)this.project.getLookup().lookup(SQEInformationProvider.class);
        if (provider != null) {
            this.add(provider.getInformationComponent().getComponent(), "Center");
        }
    }

    protected void componentClosed() {
        OpenProjects.getDefault().removePropertyChangeListener((PropertyChangeListener)this);
        instances.remove(this.project);
    }

    public String getDisplayName() {
        return "Quality Information [" + ProjectUtils.getInformation((Project)this.project).getDisplayName() + "]";
    }

    public Image getIcon() {
        return ImageUtilities.loadImage((String)"org/nbheaven/sqe/informations/ui/resources/info.png");
    }

    public int getPersistenceType() {
        return 2;
    }

    protected String preferredID() {
        return this.getClass().getName() + this.project.hashCode();
    }

    public void propertyChange(PropertyChangeEvent event) {
        List<Project> projects;
        if ("openProjects".equals(event.getPropertyName()) && !(projects = Arrays.asList(OpenProjects.getDefault().getOpenProjects())).contains(this.project)) {
            this.close();
        }
    }
}

