/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.sql.visualeditor.querymodel;

import java.util.Collection;
import org.netbeans.api.db.sql.support.SQLIdentifiers;
import org.netbeans.modules.db.sql.visualeditor.querymodel.Identifier;
import org.netbeans.modules.db.sql.visualeditor.querymodel.Table;

public class TableNode
implements Table {
    private Identifier _tableName;
    private Identifier _corrName;
    private Identifier _schemaName;

    public TableNode(String tableName, String corrName, String schemaName) {
        this._tableName = new Identifier(tableName);
        this._corrName = corrName == null ? null : new Identifier(corrName);
        this._schemaName = schemaName == null ? null : new Identifier(schemaName);
    }

    public TableNode(String tableName, String corrName) {
        this(tableName, corrName, null);
    }

    public TableNode(String tableName) {
        this(tableName, null, null);
    }

    public TableNode() {
    }

    public static TableNode make(Identifier tableName, Identifier corrName, Identifier schemaName) {
        TableNode t = new TableNode();
        t._tableName = tableName;
        t._corrName = corrName;
        t._schemaName = schemaName;
        return t;
    }

    @Override
    public String genText(SQLIdentifiers.Quoter quoter) {
        return this.genText(quoter, false);
    }

    public String genText(SQLIdentifiers.Quoter quoter, boolean from) {
        if (from) {
            return (this._schemaName == null ? "" : this._schemaName.genText(quoter) + ".") + this._tableName.genText(quoter) + (this._corrName == null ? "" : " " + this._corrName.genText(quoter));
        }
        return this._corrName != null ? this._corrName.genText(quoter) : (this._schemaName == null ? "" : this._schemaName.genText(quoter) + ".") + this._tableName.genText(quoter);
    }

    public String getTableName() {
        return this._tableName.getName();
    }

    @Override
    public String getFullTableName() {
        return (this._schemaName == null ? "" : this._schemaName.getName() + ".") + this._tableName.getName();
    }

    public String getCorrName() {
        return this._corrName == null ? null : this._corrName.getName();
    }

    public String getSchemaName() {
        return this._schemaName == null ? null : this._schemaName.getName();
    }

    public String getTableSpec() {
        return this._corrName != null ? this._corrName.getName() : this.getFullTableName();
    }

    public void renameTableSpec(String oldTableSpec, String corrName) {
        if (oldTableSpec == null) {
            String[] table = corrName.split("\\.");
            if (table.length > 1) {
                this._schemaName = new Identifier(table[0]);
                this._tableName = new Identifier(table[1]);
            } else {
                this._tableName = new Identifier(table[0]);
            }
        } else if (this.getTableSpec().equals(oldTableSpec)) {
            this._corrName = corrName == null ? null : new Identifier(corrName);
        }
    }

    void setTableName(String tableName) {
        String[] table = tableName.split("\\.");
        if (table.length > 1) {
            this._schemaName = new Identifier(table[0]);
            this._tableName = new Identifier(table[1]);
        } else {
            this._tableName = new Identifier(table[0]);
        }
    }

    void setCorrName(String corrName) {
        this._corrName = new Identifier(corrName);
    }

    void setTableSpec(String oldTableSpec, String newTableSpec) {
        if (this.getTableSpec().equals(oldTableSpec)) {
            String[] table = newTableSpec.split("\\.");
            if (table.length > 1) {
                this._schemaName = new Identifier(table[0]);
                this._tableName = new Identifier(table[1]);
            } else {
                this._tableName = new Identifier(table[0]);
            }
        }
    }

    @Override
    public void getReferencedColumns(Collection columns) {
    }
}

