/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.components;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.plaf.basic.BasicComboBoxEditor;
import javax.swing.plaf.basic.BasicComboBoxRenderer;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.modules.profiler.api.icons.Icons;
import org.openide.util.Lookup;

public abstract class ProfilerToolbar {
    public static ProfilerToolbar create(boolean showSeparator) {
        Provider provider = (Provider)Lookup.getDefault().lookup(Provider.class);
        return provider != null ? provider.create(showSeparator) : new Impl(showSeparator);
    }

    public abstract JComponent getComponent();

    public abstract Component add(Action var1);

    public abstract Component add(Component var1);

    public abstract Component add(Component var1, int var2);

    public abstract void addSeparator();

    public abstract void addSpace(int var1);

    public abstract void addFiller();

    public abstract void remove(Component var1);

    public abstract void remove(int var1);

    public abstract int getComponentCount();

    protected ProfilerToolbar() {
    }

    public static class Impl
    extends ProfilerToolbar {
        protected static int preferredHeight = -1;
        protected final JComponent component;
        protected final JToolBar toolbar = new JToolBar(){

            @Override
            public Component add(Component comp) {
                if (comp instanceof JButton) {
                    UIUtils.fixButtonUI((JButton)comp);
                }
                return super.add(comp);
            }

            @Override
            public Dimension getPreferredSize() {
                Dimension dim = super.getPreferredSize();
                if (preferredHeight == -1) {
                    JToolBar tb = new JToolBar();
                    tb.setBorder(Impl.this.toolbar.getBorder());
                    tb.setBorderPainted(Impl.this.toolbar.isBorderPainted());
                    tb.setRollover(Impl.this.toolbar.isRollover());
                    tb.setFloatable(Impl.this.toolbar.isFloatable());
                    Icon icon = Icons.getIcon((String)"GeneralIcons.Save");
                    JButton b = new JButton("Button", icon);
                    tb.add(b);
                    JToggleButton t = new JToggleButton("Button", icon);
                    tb.add(t);
                    JComboBox<Object> c = new JComboBox<Object>();
                    c.setEditor(new BasicComboBoxEditor());
                    c.setRenderer(new BasicComboBoxRenderer());
                    tb.add(c);
                    tb.addSeparator();
                    preferredHeight = tb.getPreferredSize().height;
                }
                dim.height = Math.max(dim.height, preferredHeight);
                return dim;
            }
        };

        protected Impl(boolean showSeparator) {
            this.toolbar.setBorder(BorderFactory.createEmptyBorder(1, 2, 1, 2));
            this.toolbar.setBorderPainted(false);
            this.toolbar.setRollover(true);
            this.toolbar.setFloatable(false);
            if (showSeparator) {
                this.component = new JPanel(new BorderLayout(0, 0));
                this.component.setOpaque(false);
                this.component.add((Component)this.toolbar, "Center");
                this.component.add((Component)UIUtils.createHorizontalLine(this.toolbar.getBackground()), "South");
            } else {
                this.component = this.toolbar;
            }
        }

        @Override
        public JComponent getComponent() {
            return this.component;
        }

        @Override
        public Component add(Action action) {
            return this.toolbar.add(action);
        }

        @Override
        public Component add(Component component) {
            return this.toolbar.add(component);
        }

        @Override
        public Component add(Component component, int index) {
            return this.toolbar.add(component, index);
        }

        @Override
        public void addSeparator() {
            this.toolbar.addSeparator();
        }

        @Override
        public void addSpace(int width) {
            this.toolbar.addSeparator(new Dimension(width, 0));
        }

        @Override
        public void addFiller() {
            JPanel toolbarFiller = new JPanel(new FlowLayout(3, 0, 0)){

                @Override
                public Dimension getPreferredSize() {
                    if (UIUtils.isGTKLookAndFeel() || UIUtils.isNimbusLookAndFeel()) {
                        int currentWidth = Impl.this.toolbar.getSize().width;
                        int minimumWidth = Impl.this.toolbar.getMinimumSize().width;
                        int extraWidth = currentWidth - minimumWidth;
                        return new Dimension(Math.max(extraWidth, 0), 0);
                    }
                    return super.getPreferredSize();
                }
            };
            toolbarFiller.setOpaque(false);
            this.toolbar.add(toolbarFiller);
        }

        @Override
        public void remove(Component component) {
            this.toolbar.remove(component);
        }

        @Override
        public void remove(int index) {
            this.toolbar.remove(index);
        }

        @Override
        public int getComponentCount() {
            return this.toolbar.getComponentCount();
        }
    }

    public static abstract class Provider {
        public abstract ProfilerToolbar create(boolean var1);
    }
}

