/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.ui.update;

import java.io.File;
import java.util.List;
import org.netbeans.modules.mercurial.HgException;
import org.netbeans.modules.mercurial.HgProgressSupport;
import org.netbeans.modules.mercurial.Mercurial;
import org.netbeans.modules.mercurial.OutputLogger;
import org.netbeans.modules.mercurial.ui.actions.ContextAction;
import org.netbeans.modules.mercurial.ui.log.HgLogMessage;
import org.netbeans.modules.mercurial.ui.update.Update;
import org.netbeans.modules.mercurial.util.HgCommand;
import org.netbeans.modules.mercurial.util.HgUtils;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class UpdateAction
extends ContextAction {
    @Override
    protected boolean enable(Node[] nodes) {
        return HgUtils.isFromHgRepository(HgUtils.getCurrentContext(nodes));
    }

    @Override
    protected String getBaseName(Node[] nodes) {
        return "CTL_MenuItem_Update";
    }

    @Override
    protected void performContextAction(Node[] nodes) {
        UpdateAction.update(HgUtils.getCurrentContext(nodes), null);
    }

    protected String iconResource() {
        return "org/netbeans/modules/mercurial/resources/icons/update.png";
    }

    public static void update(final VCSContext ctx, HgLogMessage rev) {
        File[] roots = HgUtils.getActionRoots(ctx);
        if (roots == null || roots.length == 0) {
            return;
        }
        final File root = Mercurial.getInstance().getRepositoryRoot(roots[0]);
        Update update = new Update(root, rev);
        if (!update.showDialog()) {
            return;
        }
        final String revStr = update.getSelectionRevision();
        final boolean doForcedUpdate = update.isForcedUpdateRequested();
        RequestProcessor rp = Mercurial.getInstance().getRequestProcessor(root);
        HgProgressSupport support = new HgProgressSupport(){

            @Override
            public void perform() {
                boolean bNoUpdates = true;
                OutputLogger logger = this.getLogger();
                try {
                    List<String> list;
                    logger.outputInRed(NbBundle.getMessage(UpdateAction.class, (String)"MSG_UPDATE_TITLE"));
                    logger.outputInRed(NbBundle.getMessage(UpdateAction.class, (String)"MSG_UPDATE_TITLE_SEP"));
                    logger.output(NbBundle.getMessage(UpdateAction.class, (String)"MSG_UPDATE_INFO_SEP", (Object)(revStr == null ? NbBundle.getMessage(UpdateAction.class, (String)"MSG_UPDATE_REVISION_PARENT") : revStr), (Object)root.getAbsolutePath()));
                    if (doForcedUpdate) {
                        NotifyDescriptor.Confirmation descriptor = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(UpdateAction.class, (String)"MSG_UPDATE_CONFIRM_QUERY"));
                        descriptor.setTitle(NbBundle.getMessage(UpdateAction.class, (String)"MSG_UPDATE_CONFIRM"));
                        descriptor.setMessageType(2);
                        descriptor.setOptionType(0);
                        Object res = DialogDisplayer.getDefault().notify((NotifyDescriptor)descriptor);
                        if (res == NotifyDescriptor.NO_OPTION) {
                            logger.outputInRed(NbBundle.getMessage(UpdateAction.class, (String)"MSG_UPDATE_CANCELED", (Object)root.getAbsolutePath()));
                            logger.output("");
                            return;
                        }
                        logger.output(NbBundle.getMessage(UpdateAction.class, (String)"MSG_UPDATE_FORCED", (Object)root.getAbsolutePath()));
                    }
                    if ((list = HgCommand.doUpdateAll(root, doForcedUpdate, revStr)) != null && !list.isEmpty()) {
                        bNoUpdates = HgCommand.isNoUpdates(list.get(0));
                        if (!bNoUpdates) {
                            HgUtils.notifyUpdatedFiles(root, list);
                            HgUtils.forceStatusRefreshProject(ctx);
                        }
                        logger.output(list);
                        logger.output("");
                    }
                }
                catch (HgException.HgCommandCanceledException ex) {
                }
                catch (HgException ex) {
                    HgUtils.notifyException(ex);
                }
                logger.outputInRed(NbBundle.getMessage(UpdateAction.class, (String)"MSG_UPDATE_DONE"));
                logger.output("");
            }
        };
        support.start(rp, root, NbBundle.getMessage(UpdateAction.class, (String)"MSG_Update_Progress"));
    }
}

