/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.ui.queues;

import java.io.File;
import java.util.List;
import java.util.Set;
import org.netbeans.modules.mercurial.HgException;
import org.netbeans.modules.mercurial.HgModuleConfig;
import org.netbeans.modules.mercurial.OutputLogger;
import org.netbeans.modules.mercurial.ui.log.HgLogMessage;
import org.netbeans.modules.mercurial.ui.queues.CreateRefreshAction;
import org.netbeans.modules.mercurial.ui.queues.QCommitPanel;
import org.netbeans.modules.mercurial.ui.queues.QCreatePatchParameters;
import org.netbeans.modules.mercurial.ui.queues.QPatch;
import org.netbeans.modules.mercurial.util.HgCommand;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.nodes.Node;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;

public class QRefreshPatchAction
extends CreateRefreshAction {
    static final String KEY_CANCELED_MESSAGE = "qrefresh.";

    public QRefreshPatchAction() {
        super("refresh");
    }

    @Override
    protected String getBaseName(Node[] nodes) {
        return "CTL_MenuItem_QRefreshPatch";
    }

    @Override
    QCommitPanel createPanel(final File root, final File[] roots) {
        QPatch currentPatch = null;
        try {
            for (QPatch p : HgCommand.qListSeries(root)) {
                if (!p.isApplied()) break;
                currentPatch = p;
            }
            if (currentPatch != null) {
                List<HgLogMessage> msgs;
                final HgLogMessage.HgRevision parent = HgCommand.getParent(root, null, currentPatch.getId());
                String commitMessage = HgModuleConfig.getDefault().getLastCanceledCommitMessage(KEY_CANCELED_MESSAGE + currentPatch.getId());
                if (commitMessage.isEmpty() && (commitMessage = HgModuleConfig.getDefault().getLastUsedQPatchMessage(currentPatch.getId())).isEmpty() && !(msgs = HgCommand.getParents(root, null, null)).isEmpty()) {
                    commitMessage = msgs.get(0).getMessage();
                }
                final String message = commitMessage;
                final QPatch patch = currentPatch;
                return (QCommitPanel)((Object)Mutex.EVENT.readAccess((Mutex.Action)new Mutex.Action<QCommitPanel>(){

                    public QCommitPanel run() {
                        return QCommitPanel.createRefreshPanel(roots, root, message, patch, parent, QRefreshPatchAction.class.getName());
                    }
                }));
            }
            NotifyDescriptor.Message e = new NotifyDescriptor.Message((Object)NbBundle.getMessage(QRefreshPatchAction.class, (String)"MSG_QRefreshPatchAction.err.noPatchApplied"));
            DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)e);
        }
        catch (HgException.HgCommandCanceledException ex) {
        }
        catch (HgException ex) {
            NotifyDescriptor.Message e = new NotifyDescriptor.Message((Object)ex.getMessage());
            DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)e);
        }
        return null;
    }

    @Override
    CreateRefreshAction.Cmd.CreateRefreshPatchCmd createHgCommand(File root, List<File> candidates, OutputLogger logger, String message, String patchName, String bundleKeyPostfix, List<File> roots, Set<File> excludedFiles, Set<File> filesToRefresh) {
        return new CreateRefreshAction.Cmd.CreateRefreshPatchCmd(root, candidates, logger, message, patchName, bundleKeyPostfix, roots, excludedFiles, filesToRefresh){

            @Override
            protected void runHgCommand(File repository, List<File> candidates, Set<File> excludedFiles, String patchId, String msg, OutputLogger logger) throws HgException {
                HgCommand.qRefreshPatch(repository, candidates, excludedFiles, msg, logger);
            }
        };
    }

    @Override
    void persistCanceledCommitMessage(QCreatePatchParameters params, String canceledCommitMessage) {
        HgModuleConfig.getDefault().setLastCanceledCommitMessage(KEY_CANCELED_MESSAGE + params.getPatch().getId(), canceledCommitMessage);
    }
}

