/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.ui.queues;

import java.io.File;
import java.util.List;
import org.netbeans.modules.mercurial.HgException;
import org.netbeans.modules.mercurial.HgProgressSupport;
import org.netbeans.modules.mercurial.Mercurial;
import org.netbeans.modules.mercurial.OutputLogger;
import org.netbeans.modules.mercurial.ui.actions.ContextAction;
import org.netbeans.modules.mercurial.ui.log.HgLogMessage;
import org.netbeans.modules.mercurial.ui.queues.FailedPatchResolver;
import org.netbeans.modules.mercurial.ui.queues.GoToPatch;
import org.netbeans.modules.mercurial.util.HgCommand;
import org.netbeans.modules.mercurial.util.HgUtils;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

public class QGoToPatchAction
extends ContextAction {
    @Override
    protected boolean enable(Node[] nodes) {
        return HgUtils.isFromHgRepository(HgUtils.getCurrentContext(nodes));
    }

    @Override
    protected String getBaseName(Node[] nodes) {
        return "CTL_MenuItem_QGoToPatch";
    }

    @Override
    protected void performContextAction(Node[] nodes) {
        String patchName;
        VCSContext ctx = HgUtils.getCurrentContext(nodes);
        File[] roots = HgUtils.getActionRoots(ctx);
        if (roots == null || roots.length == 0) {
            return;
        }
        File root = Mercurial.getInstance().getRepositoryRoot(roots[0]);
        GoToPatch goToPatch = new GoToPatch(root);
        if (goToPatch.showDialog() && (patchName = goToPatch.getSelectedPatch()) != null) {
            this.goToPatch(root, patchName == GoToPatch.POP_ALL_PATCHES ? null : patchName);
        }
    }

    public void goToPatch(final File root, final String patchName) {
        new HgProgressSupport(){

            @Override
            protected void perform() {
                OutputLogger logger = this.getLogger();
                try {
                    logger.outputInRed(NbBundle.getMessage(QGoToPatchAction.class, (String)"MSG_GOTO_TITLE"));
                    logger.outputInRed(NbBundle.getMessage(QGoToPatchAction.class, (String)"MSG_GOTO_TITLE_SEP"));
                    if (patchName == null) {
                        logger.output(NbBundle.getMessage(QGoToPatchAction.class, (String)"MSG_GOTO_EMPTY_INFO_SEP", (Object)root.getAbsolutePath()));
                        HgCommand.qPopPatches(root, null, logger);
                    } else {
                        logger.output(NbBundle.getMessage(QGoToPatchAction.class, (String)"MSG_GOTO_INFO_SEP", (Object)patchName, (Object)root.getAbsolutePath()));
                        List<String> output = HgCommand.qGoToPatch(root, patchName, logger);
                        FailedPatchResolver resolver = new FailedPatchResolver(root, output, logger);
                        resolver.resolveFailure();
                        logger.output(output);
                    }
                    Mercurial.getInstance().refreshOpenedFiles(root);
                    HgLogMessage parent = HgCommand.getParents(root, null, null).get(0);
                    logger.output("");
                    HgUtils.logHgLog(parent, logger);
                    logger.outputInRed(NbBundle.getMessage(QGoToPatchAction.class, (String)"MSG_GOTO_DONE"));
                    logger.output("");
                }
                catch (HgException.HgCommandCanceledException ex) {
                }
                catch (HgException ex) {
                    HgUtils.notifyException(ex);
                }
            }
        }.start(Mercurial.getInstance().getRequestProcessor(root), root, NbBundle.getMessage(QGoToPatchAction.class, (String)"LBL_QGoToPatchAction.progress"));
    }
}

