/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.ui.pull;

import java.io.File;
import java.net.URISyntaxException;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import org.netbeans.modules.mercurial.HgException;
import org.netbeans.modules.mercurial.HgProgressSupport;
import org.netbeans.modules.mercurial.Mercurial;
import org.netbeans.modules.mercurial.OutputLogger;
import org.netbeans.modules.mercurial.config.HgConfigFiles;
import org.netbeans.modules.mercurial.ui.actions.ContextAction;
import org.netbeans.modules.mercurial.ui.merge.MergeAction;
import org.netbeans.modules.mercurial.ui.repository.HgURL;
import org.netbeans.modules.mercurial.util.HgCommand;
import org.netbeans.modules.mercurial.util.HgUtils;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class FetchAction
extends ContextAction {
    @Override
    protected boolean enable(Node[] nodes) {
        VCSContext context = HgUtils.getCurrentContext(nodes);
        return HgUtils.isFromHgRepository(context);
    }

    @Override
    protected String getBaseName(Node[] nodes) {
        return "CTL_MenuItem_FetchLocal";
    }

    @Override
    public String getName(String role, Node[] activatedNodes) {
        VCSContext ctx = HgUtils.getCurrentContext(activatedNodes);
        Set<File> roots = HgUtils.getRepositoryRoots(ctx);
        String name = roots.size() == 1 ? "CTL_MenuItem_FetchRoot" : "CTL_MenuItem_FetchLocal";
        return roots.size() == 1 ? NbBundle.getMessage(FetchAction.class, (String)name, (Object)roots.iterator().next().getName()) : NbBundle.getMessage(FetchAction.class, (String)name);
    }

    @Override
    protected void performContextAction(Node[] nodes) {
        VCSContext context = HgUtils.getCurrentContext(nodes);
        final Set<File> repositoryRoots = HgUtils.getRepositoryRoots(context);
        Mercurial.getInstance().getRequestProcessor().post(new Runnable(){

            @Override
            public void run() {
                Iterator i$ = repositoryRoots.iterator();
                while (i$.hasNext()) {
                    File repositoryRoot;
                    final File root = repositoryRoot = (File)i$.next();
                    final boolean[] canceled = new boolean[1];
                    RequestProcessor rp = Mercurial.getInstance().getRequestProcessor(root);
                    HgProgressSupport support = new HgProgressSupport(){

                        @Override
                        public void perform() {
                            FetchAction.performFetch(root, this.getLogger());
                            canceled[0] = this.isCanceled();
                        }
                    };
                    support.start(rp, root, NbBundle.getMessage(FetchAction.class, (String)"MSG_FETCH_PROGRESS")).waitFinished();
                    if (!canceled[0]) continue;
                    break;
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void performFetch(File root, OutputLogger logger) {
        HgURL pullSource = null;
        try {
            boolean enableFetch;
            logger.outputInRed(NbBundle.getMessage(FetchAction.class, (String)"MSG_FETCH_TITLE"));
            logger.outputInRed(NbBundle.getMessage(FetchAction.class, (String)"MSG_FETCH_TITLE_SEP"));
            HgConfigFiles config = new HgConfigFiles(root);
            String pullSourceString = config.getDefaultPull(true);
            if (HgUtils.isNullOrEmpty(pullSourceString)) {
                FetchAction.notifyDefaultPullUrlNotSpecified(logger);
                return;
            }
            boolean bl = enableFetch = !config.containsProperty("extensions", "fetch");
            if (enableFetch) {
                HgConfigFiles sysConfig = HgConfigFiles.getSysInstance();
                sysConfig.doReload();
                enableFetch = !sysConfig.containsProperty("extensions", "fetch");
            }
            logger.outputInRed(NbBundle.getMessage(FetchAction.class, (String)"MSG_FETCH_LAUNCH_INFO", (Object)root.getAbsolutePath()));
            try {
                pullSource = new HgURL(pullSourceString);
            }
            catch (URISyntaxException ex) {
                File sourceRoot = new File(root, pullSourceString);
                if (sourceRoot.isDirectory()) {
                    pullSource = new HgURL(FileUtil.normalizeFile((File)sourceRoot));
                }
                String msg = NbBundle.getMessage(FetchAction.class, (String)"MSG_DEFAULT_PULL_INVALID", (Object)pullSourceString);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)msg));
                Mercurial.LOG.log(Level.INFO, null, ex);
                logger.outputInRed(NbBundle.getMessage(FetchAction.class, (String)"MSG_FETCH_DONE"));
                logger.output("");
                if (pullSource != null) {
                    pullSource.clearPassword();
                }
                return;
            }
            List<String> list = HgCommand.doFetch(root, pullSource, enableFetch, logger);
            if (list != null && !list.isEmpty()) {
                logger.output(HgUtils.replaceHttpPassword(list));
                MergeAction.handleMergeOutput(root, list, false, logger);
                HgUtils.notifyUpdatedFiles(root, list);
                HgUtils.forceStatusRefresh(root);
            }
        }
        catch (HgException.HgCommandCanceledException ex) {
        }
        catch (HgException ex) {
            HgUtils.notifyException(ex);
        }
        finally {
            logger.outputInRed(NbBundle.getMessage(FetchAction.class, (String)"MSG_FETCH_DONE"));
            logger.output("");
            if (pullSource != null) {
                pullSource.clearPassword();
            }
        }
    }

    private static void notifyDefaultPullUrlNotSpecified(OutputLogger logger) {
        logger.output(NbBundle.getMessage(FetchAction.class, (String)"MSG_NO_DEFAULT_PULL_SET_MSG"));
        logger.output("");
        DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(FetchAction.class, (String)"MSG_NO_DEFAULT_PULL_SET")));
    }
}

