/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.ui.branch;

import java.io.File;
import org.netbeans.modules.mercurial.HgException;
import org.netbeans.modules.mercurial.HgProgressSupport;
import org.netbeans.modules.mercurial.Mercurial;
import org.netbeans.modules.mercurial.OutputLogger;
import org.netbeans.modules.mercurial.WorkingCopyInfo;
import org.netbeans.modules.mercurial.ui.actions.ContextAction;
import org.netbeans.modules.mercurial.ui.branch.CreateBranch;
import org.netbeans.modules.mercurial.util.HgCommand;
import org.netbeans.modules.mercurial.util.HgUtils;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class CreateBranchAction
extends ContextAction {
    @Override
    protected boolean enable(Node[] nodes) {
        return HgUtils.isFromHgRepository(HgUtils.getCurrentContext(nodes));
    }

    @Override
    protected String getBaseName(Node[] nodes) {
        return "CTL_MenuItem_CreateBranch";
    }

    @Override
    protected void performContextAction(Node[] nodes) {
        VCSContext ctx = HgUtils.getCurrentContext(nodes);
        File[] roots = HgUtils.getActionRoots(ctx);
        if (roots == null || roots.length == 0) {
            return;
        }
        final File root = Mercurial.getInstance().getRepositoryRoot(roots[0]);
        CreateBranch createBranch = new CreateBranch();
        if (!createBranch.showDialog()) {
            return;
        }
        final String branchName = createBranch.getBranchName();
        RequestProcessor rp = Mercurial.getInstance().getRequestProcessor(root);
        HgProgressSupport support = new HgProgressSupport(){

            @Override
            public void perform() {
                OutputLogger logger = this.getLogger();
                try {
                    logger.outputInRed(NbBundle.getMessage(CreateBranchAction.class, (String)"MSG_CREATE_TITLE"));
                    logger.outputInRed(NbBundle.getMessage(CreateBranchAction.class, (String)"MSG_CREATE_TITLE_SEP"));
                    logger.output(NbBundle.getMessage(CreateBranchAction.class, (String)"MSG_CREATE_INFO_SEP", (Object)branchName, (Object)root.getAbsolutePath()));
                    HgCommand.markBranch(root, branchName, logger);
                    WorkingCopyInfo.refreshAsync(root);
                    logger.output(NbBundle.getMessage(CreateBranchAction.class, (String)"MSG_CREATE_WC_MARKED", (Object)branchName));
                }
                catch (HgException.HgCommandCanceledException ex) {
                }
                catch (HgException ex) {
                    HgUtils.notifyException(ex);
                }
                logger.outputInRed(NbBundle.getMessage(CreateBranchAction.class, (String)"MSG_CREATE_DONE"));
                logger.output("");
            }
        };
        support.start(rp, root, NbBundle.getMessage(CreateBranchAction.class, (String)"MSG_CreateBranch_Progress", (Object)branchName));
    }
}

