/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.ui.add;

import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.mercurial.HgException;
import org.netbeans.modules.mercurial.HgProgressSupport;
import org.netbeans.modules.mercurial.Mercurial;
import org.netbeans.modules.mercurial.OutputLogger;
import org.netbeans.modules.mercurial.ui.actions.ContextAction;
import org.netbeans.modules.mercurial.util.HgCommand;
import org.netbeans.modules.mercurial.util.HgUtils;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class AddAction
extends ContextAction {
    @Override
    protected boolean enable(Node[] nodes) {
        VCSContext ctx = HgUtils.getCurrentContext(nodes);
        return Mercurial.getInstance().getFileStatusCache().containsFileOfStatus(ctx, 4, true);
    }

    @Override
    protected String getBaseName(Node[] nodes) {
        return "CTL_MenuItem_Add";
    }

    @Override
    protected void performContextAction(final Node[] nodes) {
        new HgProgressSupport(){

            @Override
            public void perform() {
                VCSContext ctx = HgUtils.getCurrentContext(nodes);
                File[] allFilesToAdd = HgUtils.getModifiedFiles(ctx, 4, true);
                Map<File, List<File>> candidates = this.filterUnderRepository(allFilesToAdd);
                AddAction.this.addFiles(candidates);
            }

            private Map<File, List<File>> filterUnderRepository(File[] allFilesToAdd) {
                HashMap<File, List<File>> filtered = new HashMap<File, List<File>>(5);
                Mercurial hg = Mercurial.getInstance();
                for (File file : allFilesToAdd) {
                    File repository = hg.getRepositoryRoot(file);
                    LinkedList<File> repoFiles = (LinkedList<File>)filtered.get(repository);
                    if (repoFiles == null) {
                        repoFiles = new LinkedList<File>();
                        filtered.put(repository, repoFiles);
                    }
                    repoFiles.add(file);
                }
                return filtered;
            }
        }.start(Mercurial.getInstance().getParallelRequestProcessor(), NbBundle.getMessage(AddAction.class, (String)"MSG_Add_Progress_Init"));
    }

    private void addFiles(final Map<File, List<File>> candidates) {
        Mercurial.getInstance().getParallelRequestProcessor().post(new Runnable(){

            @Override
            public void run() {
                for (Map.Entry e : candidates.entrySet()) {
                    final File root = (File)e.getKey();
                    final List files = (List)e.getValue();
                    RequestProcessor rp = Mercurial.getInstance().getRequestProcessor(root);
                    HgProgressSupport support = new HgProgressSupport(){

                        @Override
                        public void perform() {
                            OutputLogger logger = this.getLogger();
                            try {
                                logger.outputInRed(NbBundle.getMessage(AddAction.class, (String)"MSG_ADD_TITLE"));
                                logger.outputInRed(NbBundle.getMessage(AddAction.class, (String)"MSG_ADD_TITLE_SEP"));
                                HgCommand.doAdd(root, files, logger);
                                logger.output(NbBundle.getMessage(AddAction.class, (String)"MSG_ADD_FILES"));
                                for (File file : files) {
                                    logger.output(file.getAbsolutePath());
                                }
                                Mercurial.getInstance().getFileStatusCache().refreshAllRoots(Collections.singletonMap(root, new HashSet(files)));
                            }
                            catch (HgException.HgCommandCanceledException ex) {
                            }
                            catch (HgException ex) {
                                HgUtils.notifyException(ex);
                            }
                            logger.outputInRed(NbBundle.getMessage(AddAction.class, (String)"MSG_ADD_DONE"));
                            logger.output("");
                        }
                    };
                    support.start(rp, root, NbBundle.getMessage(AddAction.class, (String)"MSG_Add_Progress", (Object)root.getName())).waitFinished();
                }
            }
        });
    }
}

