/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.SwingUtilities;
import org.netbeans.modules.mercurial.FileInformation;
import org.netbeans.modules.mercurial.HgException;
import org.netbeans.modules.mercurial.HgModuleConfig;
import org.netbeans.modules.mercurial.HgProgressSupport;
import org.netbeans.modules.mercurial.HistoryRegistry;
import org.netbeans.modules.mercurial.Mercurial;
import org.netbeans.modules.mercurial.VersionsCache;
import org.netbeans.modules.mercurial.ui.log.HgLogMessage;
import org.netbeans.modules.mercurial.ui.log.LogAction;
import org.netbeans.modules.mercurial.ui.update.RevertModificationsAction;
import org.netbeans.modules.mercurial.util.HgUtils;
import org.netbeans.modules.versioning.history.HistoryAction;
import org.netbeans.modules.versioning.spi.VCSHistoryProvider;
import org.netbeans.modules.versioning.util.FileUtils;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class HgHistoryProvider
implements VCSHistoryProvider {
    private final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private final List<VCSHistoryProvider.HistoryChangeListener> listeners = new LinkedList<VCSHistoryProvider.HistoryChangeListener>();
    private Action[] actions;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addHistoryChangeListener(VCSHistoryProvider.HistoryChangeListener l) {
        List<VCSHistoryProvider.HistoryChangeListener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeHistoryChangeListener(VCSHistoryProvider.HistoryChangeListener l) {
        List<VCSHistoryProvider.HistoryChangeListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(l);
        }
    }

    public synchronized VCSHistoryProvider.HistoryEntry[] getHistory(File[] files, Date fromDate) {
        String toRevision;
        String fromRevision;
        assert (!SwingUtilities.isEventDispatchThread()) : "Accessing remote repository. Do not call in awt!";
        if (!HgHistoryProvider.isClientAvailable()) {
            Mercurial.LOG.log(Level.WARNING, "Mercurial client is unavailable");
            return null;
        }
        Set<File> repositories = HgHistoryProvider.getRepositoryRoots(files);
        if (repositories == null) {
            return null;
        }
        LinkedList<VCSHistoryProvider.HistoryEntry> ret = new LinkedList<VCSHistoryProvider.HistoryEntry>();
        HashMap<String, HashSet<File>> rev2FileMap = new HashMap<String, HashSet<File>>();
        HashMap<String, HgLogMessage> rev2LMMap = new HashMap<String, HgLogMessage>();
        if (fromDate == null) {
            fromRevision = "0";
            toRevision = "BASE";
        } else {
            fromRevision = this.dateFormat.format(fromDate);
            toRevision = this.dateFormat.format(new Date(System.currentTimeMillis()));
        }
        File repositoryRoot = repositories.iterator().next();
        for (File file : files) {
            HgLogMessage[] history;
            FileInformation info = Mercurial.getInstance().getFileStatusCache().refresh(file);
            int status = info.getStatus();
            if ((status & 0x1DF8) == 0) continue;
            for (HgLogMessage h : history = HistoryRegistry.getInstance().getLogs(repositoryRoot, files, fromRevision, toRevision)) {
                String r = h.getHgRevision().getRevisionNumber();
                rev2LMMap.put(r, h);
                HashSet<File> s = (HashSet<File>)rev2FileMap.get(r);
                if (s == null) {
                    s = new HashSet<File>();
                    rev2FileMap.put(r, s);
                }
                s.add(file);
            }
        }
        for (HgLogMessage h : rev2LMMap.values()) {
            Set s = (Set)rev2FileMap.get(h.getHgRevision().getRevisionNumber());
            File[] involvedFiles = s.toArray(new File[s.size()]);
            ret.add(this.createHistoryEntry(h, repositoryRoot, involvedFiles));
        }
        return ret.toArray(new VCSHistoryProvider.HistoryEntry[ret.size()]);
    }

    public Action createShowHistoryAction(File[] files) {
        return new OpenHistoryAction(files);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireHistoryChange(final File[] files) {
        VCSHistoryProvider.HistoryChangeListener[] la;
        List<VCSHistoryProvider.HistoryChangeListener> list = this.listeners;
        synchronized (list) {
            la = this.listeners.toArray(new VCSHistoryProvider.HistoryChangeListener[this.listeners.size()]);
        }
        Mercurial.getInstance().getRequestProcessor().post(new Runnable(){

            @Override
            public void run() {
                for (VCSHistoryProvider.HistoryChangeListener l : la) {
                    l.fireHistoryChanged(new VCSHistoryProvider.HistoryEvent((VCSHistoryProvider)HgHistoryProvider.this, files));
                }
            }
        });
    }

    private VCSHistoryProvider.HistoryEntry createHistoryEntry(HgLogMessage h, File repository, File[] files) {
        String username = h.getUsername();
        String author = h.getAuthor();
        if (username == null || "".equals(username.trim())) {
            username = author;
        }
        return new VCSHistoryProvider.HistoryEntry(files, h.getDate(), h.getMessage(), author, username, h.getHgRevision().getRevisionNumber() + ":" + h.getHgRevision().getChangesetId(), h.getHgRevision().getRevisionNumber(), this.getActions(), (VCSHistoryProvider.RevisionProvider)new RevisionProviderImpl(h.getHgRevision()), null, (VCSHistoryProvider.ParentProvider)new ParentProviderImpl(h, files, repository));
    }

    private synchronized Action[] getActions() {
        if (this.actions == null) {
            this.actions = new Action[]{new HistoryAction(){

                protected void perform(final VCSHistoryProvider.HistoryEntry entry, final Set<File> files) {
                    final File root = Mercurial.getInstance().getRepositoryRoot(files.iterator().next());
                    RequestProcessor rp = Mercurial.getInstance().getRequestProcessor(root);
                    HgProgressSupport support = new HgProgressSupport(){

                        @Override
                        public void perform() {
                            RevertModificationsAction.performRevert(root, HgHistoryProvider.this.getHgRevision(entry).getRevisionNumber(), new LinkedList<File>(files), HgModuleConfig.getDefault().getBackupOnRevertModifications(), false, this.getLogger());
                        }
                    };
                    support.start(rp, root, NbBundle.getMessage(LogAction.class, (String)"MSG_Revert_Progress"));
                }

                protected boolean isMultipleHistory() {
                    return false;
                }

                public String getName() {
                    VCSHistoryProvider.HistoryEntry he = this.getHistoryEntry();
                    return NbBundle.getMessage(LogAction.class, (String)"CTL_SummaryView_RollbackTo", (Object)he.getRevisionShort());
                }
            }, new HistoryAction(NbBundle.getMessage(LogAction.class, (String)"CTL_SummaryView_View")){

                protected void perform(VCSHistoryProvider.HistoryEntry entry, Set<File> files) {
                    HgHistoryProvider.this.view(entry, false, files);
                }
            }, new HistoryAction(NbBundle.getMessage(LogAction.class, (String)"CTL_SummaryView_ShowAnnotations")){

                protected void perform(VCSHistoryProvider.HistoryEntry entry, Set<File> files) {
                    HgHistoryProvider.this.view(entry, true, files);
                }
            }};
        }
        return this.actions;
    }

    private void view(final VCSHistoryProvider.HistoryEntry entry, final boolean showAnnotations, final Set<File> files) {
        File root = Mercurial.getInstance().getRepositoryRoot(files.iterator().next());
        RequestProcessor rp = Mercurial.getInstance().getRequestProcessor(root);
        rp.post(new Runnable(){

            @Override
            public void run() {
                for (File f : files) {
                    try {
                        HgUtils.openInRevision(f, -1, HgHistoryProvider.this.getHgRevision(entry), showAnnotations);
                    }
                    catch (IOException iOException) {}
                }
            }
        });
    }

    private HgLogMessage.HgRevision getHgRevision(VCSHistoryProvider.HistoryEntry entry) {
        String[] revs = entry.getRevision().split(":");
        HgLogMessage.HgRevision revision = new HgLogMessage.HgRevision(revs[1], revs[0]);
        return revision;
    }

    private static boolean isClientAvailable() {
        return HgHistoryProvider.isClientAvailable(false);
    }

    private static boolean isClientAvailable(boolean notifyUI) {
        return Mercurial.getInstance().isAvailable(true, notifyUI);
    }

    private static Set<File> getRepositoryRoots(File ... files) {
        Set<File> repositories = HgUtils.getRepositoryRoots(new HashSet<File>(Arrays.asList(files)));
        if (repositories.size() != 1) {
            Mercurial.LOG.log(Level.WARNING, "History requested for {0} repositories", repositories.size());
            return null;
        }
        return repositories;
    }

    private static class OpenHistoryAction
    extends AbstractAction {
        private final File[] files;

        public OpenHistoryAction(File[] files) {
            this.files = files;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.openHistory(this.files);
        }

        private void openHistory(File[] files) {
            if (!HgHistoryProvider.isClientAvailable()) {
                Mercurial.LOG.log(Level.WARNING, "Mercurial client is unavailable");
                return;
            }
            if (files == null || files.length == 0) {
                return;
            }
            Set repositories = HgHistoryProvider.getRepositoryRoots(files);
            if (repositories == null) {
                return;
            }
            LogAction.openHistory((File)repositories.iterator().next(), files);
        }
    }

    private class ParentProviderImpl
    implements VCSHistoryProvider.ParentProvider {
        private HgLogMessage logMessage;
        private File[] files;
        private File repository;

        public ParentProviderImpl(HgLogMessage logMessage, File[] files, File repository) {
            this.logMessage = logMessage;
            this.files = files;
            this.repository = repository;
        }

        public VCSHistoryProvider.HistoryEntry getParentEntry(File file) {
            File originalFile;
            HgLogMessage.HgRevision ancestor = this.logMessage.getAncestor(file);
            if (ancestor.equals(HgLogMessage.HgRevision.EMPTY) && (originalFile = HistoryRegistry.getInstance().getHistoryFile(this.repository, file, this.logMessage.getCSetShortID(), false)) != null) {
                ancestor = this.logMessage.getAncestor(originalFile);
            }
            if (ancestor.equals(HgLogMessage.HgRevision.EMPTY)) {
                return null;
            }
            HgLogMessage history = HistoryRegistry.getInstance().getLog(this.repository, file, ancestor.getChangesetId());
            if (history == null) {
                return null;
            }
            return HgHistoryProvider.this.createHistoryEntry(history, this.repository, this.files);
        }
    }

    private class RevisionProviderImpl
    implements VCSHistoryProvider.RevisionProvider {
        private HgLogMessage.HgRevision hgRevision;

        public RevisionProviderImpl(HgLogMessage.HgRevision hgRevision) {
            this.hgRevision = hgRevision;
        }

        public void getRevisionFile(File originalFile, File revisionFile) {
            assert (!SwingUtilities.isEventDispatchThread()) : "Accessing remote repository. Do not call in awt!";
            if (!HgHistoryProvider.isClientAvailable()) {
                Mercurial.LOG.log(Level.WARNING, "Mercurial client is unavailable");
                return;
            }
            try {
                File file;
                Set repositories;
                FileInformation info = Mercurial.getInstance().getFileStatusCache().refresh(originalFile);
                if (info != null && (info.getStatus() & 0x1000) != 0 && info.getStatus(null) != null && info.getStatus(null).getOriginalFile() != null) {
                    originalFile = info.getStatus(null).getOriginalFile();
                }
                if ((repositories = HgHistoryProvider.getRepositoryRoots(new File[]{originalFile})) == null || repositories.isEmpty()) {
                    Mercurial.LOG.log(Level.WARNING, "Repository root not found for file {0}", originalFile);
                    return;
                }
                File repository = (File)repositories.iterator().next();
                File historyFile = HistoryRegistry.getInstance().getHistoryFile(repository, originalFile, this.hgRevision.getChangesetId(), true);
                if (historyFile != null) {
                    originalFile = historyFile;
                }
                if ((file = VersionsCache.getInstance().getFileRevision(originalFile, this.hgRevision, false)) != null) {
                    FileUtils.copyFile((File)file, (File)revisionFile);
                } else if (historyFile == null) {
                    Mercurial.LOG.log(Level.WARNING, "File {0} not found in revision {1}. Will make a guess ...", new Object[]{originalFile, this.hgRevision});
                    historyFile = HistoryRegistry.getInstance().getHistoryFile(repository, originalFile, this.hgRevision.getChangesetId(), false);
                    if (historyFile != null && (file = VersionsCache.getInstance().getFileRevision(historyFile, this.hgRevision, false)) != null) {
                        FileUtils.copyFile((File)file, (File)revisionFile);
                    }
                }
            }
            catch (IOException e) {
                if (e.getCause() instanceof HgException.HgCommandCanceledException) {
                    Mercurial.LOG.log(Level.FINE, null, e);
                }
                Mercurial.LOG.log(Level.WARNING, null, e);
            }
        }
    }
}

