/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.howl.log;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.util.Properties;
import junit.framework.TestCase;
import org.objectweb.howl.log.Barrier;
import org.objectweb.howl.log.Configuration;
import org.objectweb.howl.log.LogException;
import org.objectweb.howl.log.Logger;
import org.objectweb.howl.log.TestWorker;

public class TestDriver
extends TestCase {
    protected Logger log = null;
    protected File baseDir;
    protected File outDir;
    protected Configuration cfg = null;
    protected PrintStream out = null;
    protected Properties prop = null;
    protected final Barrier startBarrier = new Barrier();
    protected final Barrier stopBarrier = new Barrier();
    protected int workers = 0;
    protected int delayedWorkers = 0;
    protected long delayBeforeDone = 500L;
    protected boolean autoMarkMode = true;
    protected int totalTransactions = 0;
    protected long elapsedTime = 0L;
    protected float avgLatency = 0.0f;
    protected float txPerSecond = 0.0f;

    public final Properties getProperties() {
        return this.prop;
    }

    public final Barrier getStartBarrier() {
        return this.startBarrier;
    }

    public final Barrier getStopBarrier() {
        return this.stopBarrier;
    }

    public final Logger getLogger() {
        return this.log;
    }

    protected void parseProperties() throws FileNotFoundException, IOException {
        String val = null;
        String key = null;
        this.prop = new Properties();
        this.prop.load(new FileInputStream(new File(this.baseDir, "src/test-resources/test.properties")));
        key = "test.workers";
        val = this.prop.getProperty("test.workers", "200");
        this.workers = Integer.parseInt(val);
        if (this.workers <= 0) {
            throw new IllegalArgumentException(key);
        }
        key = "test.delayedWorkers";
        val = this.prop.getProperty("test.delayedWorkers", "0");
        this.delayedWorkers = Integer.parseInt(val);
        if (this.delayedWorkers < 0) {
            throw new IllegalArgumentException(key);
        }
        key = "test.delayBeforeDone";
        val = this.prop.getProperty("test.delayBeforeDone", "500");
        this.delayBeforeDone = Long.parseLong(val);
        if (this.delayBeforeDone < 0L) {
            throw new IllegalArgumentException(key);
        }
    }

    protected void setUp() throws Exception {
        super.setUp();
        String baseDirName = System.getProperty("basedir", ".");
        this.baseDir = new File(baseDirName);
        this.outDir = new File(this.baseDir, "target/test-resources");
        this.outDir.mkdirs();
        this.parseProperties();
        this.cfg = new Configuration(new File(this.baseDir, "src/test-resources/log.properties"));
        String reportDir = this.prop.getProperty("test.report.dir", "reports");
        if (!reportDir.endsWith("/")) {
            reportDir = reportDir + "/";
        }
        File outDir = new File(reportDir);
        outDir.mkdirs();
        String testName = this.getName();
        File outFile = new File(reportDir + testName + ".xml");
        this.out = new PrintStream(new FileOutputStream(outFile));
    }

    protected void deleteLogFiles() {
        String logDir = this.cfg.getLogFileDir();
        File dir = new File(logDir);
        File[] logs = dir.listFiles();
        String logFileName = this.cfg.getLogFileName();
        String logFileExt = this.cfg.getLogFileExt();
        String pattern = "^" + logFileName + "_" + "\\d+\\." + logFileExt;
        for (int i = 0; i < logs.length; ++i) {
            File f = logs[i];
            if (!f.getName().matches(pattern)) continue;
            f.delete();
        }
    }

    private String propertyAsXml(String key) {
        return "<" + key + ">" + System.getProperty(key) + "</" + key + ">";
    }

    protected void saveStats() {
        StringBuffer stats = new StringBuffer("<?xml version='1.0' ?>\n<TestResults>");
        stats.append("\n<VMInfo>\n  " + this.propertyAsXml("java.vm.info") + "\n  " + this.propertyAsXml("java.vm.name") + "\n  " + this.propertyAsXml("java.vm.vendor") + "\n  " + this.propertyAsXml("java.vm.version") + "\n</VMInfo>");
        stats.append("\n<TestMetrics name='" + this.getName() + "'>" + "\n  <elapsedTime value='" + this.elapsedTime + "'>Elapsed time (ms) for run</elapsedTime>" + "\n  <totalTransactions value='" + this.totalTransactions + "'>Total number of transactions</totalTransactions>" + "\n  <txPerSecond value='" + this.txPerSecond + "'>Number of transactions per second</txPerSecond>" + "\n  <avgLatency value='" + this.avgLatency + "'>Average Latency</avgLatency>" + "\n  <workers value='" + this.workers + "'>Number of worker threads</workers>" + "\n  <delayedWorkers value='" + this.delayedWorkers + "'>Number of worker threads using delay between COMMIT and DONE" + "</delayedWorkers>" + "\n</TestMetrics>");
        stats.append(this.log.getStats());
        stats.append("\n</TestResults>");
        this.out.println(stats.toString());
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.log.close();
    }

    public TestDriver(String name) {
        super(name);
    }

    protected TestWorker getWorker(Class workerClass) throws Exception {
        Class<?> cls = ((Object)((Object)this)).getClass().getClassLoader().loadClass(workerClass.getName());
        Constructor<?> ctor = cls.getDeclaredConstructor(TestDriver.class);
        return (TestWorker)ctor.newInstance(new Object[]{this});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runWorkers(Class workerClass) throws LogException, Exception {
        TestException exception = null;
        if (this.workers <= 0) {
            throw new IllegalArgumentException();
        }
        TestWorker[] worker = new TestWorker[this.workers];
        this.startBarrier.setCount(this.workers + 1);
        this.stopBarrier.setCount(this.workers + 1);
        for (int i = 0; i < this.workers; ++i) {
            try {
                TestWorker w;
                worker[i] = w = this.getWorker(workerClass);
                if (i < this.delayedWorkers) {
                    w.setDelayBeforeDone(this.delayBeforeDone);
                }
                w.setWorkerIndex(i);
                w.start();
                continue;
            }
            catch (OutOfMemoryError e) {
                System.err.println(e.toString() + ": " + i + " threads created");
                throw e;
            }
        }
        Barrier i = this.startBarrier;
        synchronized (i) {
            while (this.startBarrier.getCount() > 1) {
                this.startBarrier.wait();
            }
        }
        long startTime = System.currentTimeMillis();
        this.startBarrier.barrier();
        this.stopBarrier.barrier();
        long stopTime = System.currentTimeMillis();
        this.log.close();
        long totalBytesLogged = 0L;
        int totalLatency = 0;
        this.totalTransactions = 0;
        for (int i2 = 0; i2 < this.workers; ++i2) {
            TestWorker w = worker[i2];
            totalBytesLogged += w.bytesLogged;
            totalLatency = (int)((long)totalLatency + w.latency);
            this.totalTransactions += w.transactions;
            if (w.exception == null) continue;
            exception = new TestException((Throwable)w.exception);
        }
        this.elapsedTime = stopTime - startTime;
        this.avgLatency = (float)totalLatency / (float)this.totalTransactions;
        this.txPerSecond = (float)((double)this.totalTransactions / ((double)this.elapsedTime / 1000.0));
        this.saveStats();
        if (exception != null) {
            throw exception;
        }
    }

    public class TestException
    extends Exception {
        public TestException() {
        }

        public TestException(String s) {
            super(s);
        }

        public TestException(Throwable cause) {
            super(cause);
        }

        public TestException(String s, Throwable cause) {
            super(s, cause);
        }
    }
}

