/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.carol.rmi.multi;

import java.lang.reflect.Method;
import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import javax.rmi.CORBA.PortableRemoteObjectDelegate;
import org.objectweb.carol.util.configuration.CarolCurrentConfiguration;
import org.objectweb.carol.util.configuration.CarolDefaultValues;

public class JeremiePRODelegate
implements PortableRemoteObjectDelegate {
    private static final String JEREMIE_STUB_EXTENSION = "_OWStub";
    private int port;
    private static String className = "org.objectweb.jeremie.binding.moa.UnicastRemoteObject";
    private static Class unicastClass = null;
    private static int nbProtocols = 0;
    static /* synthetic */ Class class$java$rmi$Remote;

    public JeremiePRODelegate() throws Exception {
        unicastClass = Thread.currentThread().getContextClassLoader().loadClass(className);
        this.port = new Integer(System.getProperty(CarolDefaultValues.PORT_NUMBER_PROPERTY, "0"));
    }

    public void exportObject(Remote obj) throws RemoteException {
        if (!this.containsJeremieStub(obj)) {
            return;
        }
        try {
            Method exportO = unicastClass.getMethod("exportObject", class$java$rmi$Remote == null ? (class$java$rmi$Remote = JeremiePRODelegate.class$("java.rmi.Remote")) : class$java$rmi$Remote, Integer.TYPE);
            exportO.invoke((Object)unicastClass, obj, new Integer(this.port));
        }
        catch (Exception e) {
            throw new RemoteException(e.toString(), e);
        }
    }

    public void unexportObject(Remote obj) throws NoSuchObjectException {
        if (!this.containsJeremieStub(obj)) {
            return;
        }
        try {
            Method unexportO = unicastClass.getMethod("unexportObject", class$java$rmi$Remote == null ? (class$java$rmi$Remote = JeremiePRODelegate.class$("java.rmi.Remote")) : class$java$rmi$Remote, Boolean.TYPE);
            unexportO.invoke((Object)unicastClass, obj, Boolean.TRUE);
        }
        catch (Exception e) {
            throw new NoSuchObjectException(e.toString());
        }
    }

    public void connect(Remote target, Remote source) throws RemoteException {
    }

    public Object narrow(Object obj, Class newClass) throws ClassCastException {
        if (newClass.isAssignableFrom(obj.getClass())) {
            return obj;
        }
        throw new ClassCastException("Can't cast " + obj.getClass().getName() + " in " + newClass.getName());
    }

    public Remote toStub(Remote obj) throws NoSuchObjectException {
        try {
            Method exportO = unicastClass.getMethod("toStub", class$java$rmi$Remote == null ? (class$java$rmi$Remote = JeremiePRODelegate.class$("java.rmi.Remote")) : class$java$rmi$Remote);
            return (Remote)exportO.invoke((Object)unicastClass, obj);
        }
        catch (Exception e) {
            throw new NoSuchObjectException(e.toString());
        }
    }

    private boolean containsJeremieStub(Remote r) {
        if (nbProtocols == 0) {
            nbProtocols = CarolCurrentConfiguration.getCurrent().getPortableRemoteObjectHashtable().size();
        }
        if (nbProtocols == 1) {
            return true;
        }
        String stubName = r.getClass().getName() + JEREMIE_STUB_EXTENSION;
        return Thread.currentThread().getContextClassLoader().getResource(stubName) != null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

