/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.carol.jndi.spi;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import org.objectweb.carol.util.configuration.CarolCurrentConfiguration;
import org.objectweb.carol.util.configuration.TraceCarol;

public class MultiContext
implements Context {
    private CarolCurrentConfiguration cccf = null;
    private Hashtable activesInitialsContexts = null;
    private String rmiName = null;

    public MultiContext(Hashtable env) throws NamingException {
        if (TraceCarol.isDebugJndiCarol()) {
            TraceCarol.debugJndiCarol("MultiContext.MultiContext(env)");
            TraceCarol.debugJndiCarol("MultiContext.MultiContext(env), env = " + env);
        }
        try {
            this.cccf = CarolCurrentConfiguration.getCurrent();
            this.activesInitialsContexts = this.cccf.getNewContextHashtable(env);
        }
        catch (Exception e) {
            String msg = "MultiContext.MultiContext() failed: " + e;
            throw new NamingException(msg);
        }
    }

    public Object lookup(String name) throws NamingException {
        if (TraceCarol.isDebugJndiCarol()) {
            TraceCarol.debugJndiCarol("MultiContext.lookup(\"" + name + "\")/rmi name=\"" + this.cccf.getCurrentRMIName() + "\"");
        }
        try {
            return this.cccf.getCurrentInitialContext().lookup(name);
        }
        catch (NamingException e) {
            if (TraceCarol.isDebugJndiCarol()) {
                String msg = "MultiContext.lookup(\"" + name + "\") failed: " + e;
                TraceCarol.debugJndiCarol("Error: " + msg);
            }
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            pw.flush();
            throw new NamingException(e.toString() + "\nCaused by: " + sw.toString() + "\n<End of Cause>");
        }
    }

    public Object lookup(Name name) throws NamingException {
        if (TraceCarol.isDebugJndiCarol()) {
            TraceCarol.debugJndiCarol("MultiContext.lookup(\"" + name + "\")/rmi name=\"" + this.cccf.getCurrentRMIName() + "\"");
        }
        try {
            return this.cccf.getCurrentInitialContext().lookup(name);
        }
        catch (NamingException e) {
            if (TraceCarol.isDebugJndiCarol()) {
                String msg = "MultiContext.lookup(Name name) failed: " + e;
                TraceCarol.debugJndiCarol("Error: " + msg + " " + e);
            }
            throw e;
        }
    }

    public void bind(String name, Object obj) throws NamingException {
        if (TraceCarol.isDebugJndiCarol()) {
            TraceCarol.debugJndiCarol("MultiContext.bind(String, Object)");
        }
        try {
            Enumeration e = this.activesInitialsContexts.keys();
            while (e.hasMoreElements()) {
                this.rmiName = (String)e.nextElement();
                this.cccf.setRMI(this.rmiName);
                ((Context)this.activesInitialsContexts.get(this.rmiName)).bind(name, obj);
                this.cccf.setDefault();
            }
        }
        catch (NamingException e) {
            if (TraceCarol.isDebugJndiCarol()) {
                String msg = "MultiContext.bind()";
                TraceCarol.debugJndiCarol("Error: " + msg + " " + e);
            }
            throw e;
        }
    }

    public void bind(Name name, Object obj) throws NamingException {
        if (TraceCarol.isDebugJndiCarol()) {
            TraceCarol.debugJndiCarol("MultiContext.bind()");
        }
        try {
            Enumeration e = this.activesInitialsContexts.keys();
            while (e.hasMoreElements()) {
                this.rmiName = (String)e.nextElement();
                this.cccf.setRMI(this.rmiName);
                ((Context)this.activesInitialsContexts.get(this.rmiName)).bind(name, obj);
                this.cccf.setDefault();
            }
        }
        catch (NamingException e) {
            if (TraceCarol.isDebugJndiCarol()) {
                String msg = "MultiContext.bind(Name name, Object obj) failed: " + e;
                TraceCarol.debugJndiCarol("Error: " + msg + " " + e);
            }
            throw e;
        }
    }

    public void rebind(String name, Object obj) throws NamingException {
        if (TraceCarol.isDebugJndiCarol()) {
            TraceCarol.debugJndiCarol("MultiContext.rebind()");
        }
        try {
            Enumeration e = this.activesInitialsContexts.keys();
            while (e.hasMoreElements()) {
                this.rmiName = (String)e.nextElement();
                this.cccf.setRMI(this.rmiName);
                ((Context)this.activesInitialsContexts.get(this.rmiName)).rebind(name, obj);
                this.cccf.setDefault();
            }
        }
        catch (NamingException e) {
            if (TraceCarol.isDebugJndiCarol()) {
                String msg = "MultiContext.rebind(String name, Object obj) failed: " + e;
                TraceCarol.debugJndiCarol("Error: " + msg + " " + e);
            }
            throw e;
        }
    }

    public void rebind(Name name, Object obj) throws NamingException {
        if (TraceCarol.isDebugJndiCarol()) {
            TraceCarol.debugJndiCarol("MultiContext.rebind()");
        }
        try {
            Enumeration e = this.activesInitialsContexts.keys();
            while (e.hasMoreElements()) {
                this.rmiName = (String)e.nextElement();
                this.cccf.setRMI(this.rmiName);
                ((Context)this.activesInitialsContexts.get(this.rmiName)).rebind(name, obj);
                this.cccf.setDefault();
            }
        }
        catch (NamingException e) {
            if (TraceCarol.isDebugJndiCarol()) {
                String msg = "MultiContext.rebind(Name name, Object obj) failed: " + e;
                TraceCarol.debugJndiCarol("Error: " + msg + " " + e);
            }
            throw e;
        }
    }

    public void unbind(String name) throws NamingException {
        if (TraceCarol.isDebugJndiCarol()) {
            TraceCarol.debugJndiCarol("MultiContext.unbind(\"" + name + "\")");
        }
        try {
            Enumeration e = this.activesInitialsContexts.keys();
            while (e.hasMoreElements()) {
                this.rmiName = (String)e.nextElement();
                this.cccf.setRMI(this.rmiName);
                ((Context)this.activesInitialsContexts.get(this.rmiName)).unbind(name);
                this.cccf.setDefault();
            }
        }
        catch (NamingException e) {
            if (TraceCarol.isDebugJndiCarol()) {
                String msg = "MultiContext.unbind(String name) failed: " + e;
                TraceCarol.debugJndiCarol("Error: " + msg + " " + e);
            }
            throw e;
        }
    }

    public void unbind(Name name) throws NamingException {
        if (TraceCarol.isDebugJndiCarol()) {
            TraceCarol.debugJndiCarol("MultiContext.unbind(\"" + name + "\")");
        }
        try {
            Enumeration e = this.activesInitialsContexts.keys();
            while (e.hasMoreElements()) {
                this.rmiName = (String)e.nextElement();
                this.cccf.setRMI(this.rmiName);
                ((Context)this.activesInitialsContexts.get(this.rmiName)).unbind(name);
                this.cccf.setDefault();
            }
        }
        catch (NamingException e) {
            if (TraceCarol.isDebugJndiCarol()) {
                String msg = "MultiContext.unbind(Name name) failed: " + e;
                TraceCarol.debugJndiCarol("Error: " + msg + " " + e);
            }
            throw e;
        }
    }

    public void rename(String oldName, String newName) throws NamingException {
        if (TraceCarol.isDebugJndiCarol()) {
            TraceCarol.debugJndiCarol("MultiContext.rename(\"" + oldName + "\",\"" + newName + "\")");
        }
        try {
            Enumeration e = this.activesInitialsContexts.keys();
            while (e.hasMoreElements()) {
                this.rmiName = (String)e.nextElement();
                this.cccf.setRMI(this.rmiName);
                ((Context)this.activesInitialsContexts.get(this.rmiName)).rename(oldName, newName);
                this.cccf.setDefault();
            }
        }
        catch (NamingException e) {
            if (TraceCarol.isDebugJndiCarol()) {
                String msg = "MultiContext.rename(String oldName, String newName) failed: " + e;
                TraceCarol.debugJndiCarol("Error: " + msg + " " + e);
            }
            throw e;
        }
    }

    public void rename(Name oldName, Name newName) throws NamingException {
        if (TraceCarol.isDebugJndiCarol()) {
            TraceCarol.debugJndiCarol("MultiContext.rename(\"" + oldName + "\",\"" + newName + "\")");
        }
        try {
            Enumeration e = this.activesInitialsContexts.keys();
            while (e.hasMoreElements()) {
                this.rmiName = (String)e.nextElement();
                this.cccf.setRMI(this.rmiName);
                ((Context)this.activesInitialsContexts.get(this.rmiName)).rename(oldName, newName);
                this.cccf.setDefault();
            }
        }
        catch (NamingException e) {
            if (TraceCarol.isDebugJndiCarol()) {
                String msg = "MultiContext.rename(Name oldName, Name newName) failed: " + e;
                TraceCarol.debugJndiCarol("Error: " + msg + " " + e);
            }
            throw e;
        }
    }

    public NamingEnumeration list(String name) throws NamingException {
        if (TraceCarol.isDebugJndiCarol()) {
            TraceCarol.debugJndiCarol("MultiContext.list(\"" + name + "\")/rmi name=\"" + this.cccf.getCurrentRMIName() + "\"");
        }
        try {
            return this.cccf.getCurrentInitialContext().list(name);
        }
        catch (NamingException e) {
            if (TraceCarol.isDebugJndiCarol()) {
                String msg = "MultiContext.list(String name) failed: " + e;
                TraceCarol.debugJndiCarol("Error: " + msg + " " + e);
            }
            throw e;
        }
    }

    public NamingEnumeration list(Name name) throws NamingException {
        if (TraceCarol.isDebugJndiCarol()) {
            TraceCarol.debugJndiCarol("MultiContext.list(\"" + name + "\")/rmi name=\"" + this.cccf.getCurrentRMIName() + "\"");
        }
        try {
            return this.cccf.getCurrentInitialContext().list(name);
        }
        catch (NamingException e) {
            if (TraceCarol.isDebugJndiCarol()) {
                String msg = "MultiContext.list(Name name) failed: " + e;
                TraceCarol.debugJndiCarol("Error: " + msg + " " + e);
            }
            throw e;
        }
    }

    public NamingEnumeration listBindings(String name) throws NamingException {
        if (TraceCarol.isDebugJndiCarol()) {
            TraceCarol.debugJndiCarol("MultiContext.listBindings(\"" + name + "\")/rmi name=\"" + this.cccf.getCurrentRMIName() + "\"");
        }
        try {
            return this.cccf.getCurrentInitialContext().listBindings(name);
        }
        catch (NamingException e) {
            if (TraceCarol.isDebugJndiCarol()) {
                String msg = "MultiContext.listBindings(String name) failed: " + e;
                TraceCarol.debugJndiCarol("Error: " + msg + " " + e);
            }
            throw e;
        }
    }

    public NamingEnumeration listBindings(Name name) throws NamingException {
        if (TraceCarol.isDebugJndiCarol()) {
            TraceCarol.debugJndiCarol("MultiContext.listBindings(\"" + name + "\")/rmi name=\"" + this.cccf.getCurrentRMIName() + "\"");
        }
        try {
            return this.cccf.getCurrentInitialContext().listBindings(name);
        }
        catch (NamingException e) {
            if (TraceCarol.isDebugJndiCarol()) {
                String msg = "MultiContext.listBindings(Name name) failed: " + e;
                TraceCarol.debugJndiCarol("Error: " + msg + " " + e);
            }
            throw e;
        }
    }

    public void destroySubcontext(String name) throws NamingException {
        if (TraceCarol.isDebugJndiCarol()) {
            TraceCarol.debugJndiCarol("MultiContext.destroySubcontext(\"" + name + "\")");
        }
        try {
            Enumeration e = this.activesInitialsContexts.keys();
            while (e.hasMoreElements()) {
                this.rmiName = (String)e.nextElement();
                this.cccf.setRMI(this.rmiName);
                ((Context)this.activesInitialsContexts.get(this.rmiName)).destroySubcontext(name);
                this.cccf.setDefault();
            }
        }
        catch (NamingException e) {
            if (TraceCarol.isDebugJndiCarol()) {
                String msg = "MultiContext.destroySubcontext(String name) failed: " + e;
                TraceCarol.debugJndiCarol("Error: " + msg + " " + e);
            }
            throw e;
        }
    }

    public void destroySubcontext(Name name) throws NamingException {
        if (TraceCarol.isDebugJndiCarol()) {
            TraceCarol.debugJndiCarol("MultiContext.destroySubcontext(\"" + name + "\")");
        }
        try {
            Enumeration e = this.activesInitialsContexts.keys();
            while (e.hasMoreElements()) {
                this.rmiName = (String)e.nextElement();
                this.cccf.setRMI(this.rmiName);
                ((Context)this.activesInitialsContexts.get(this.rmiName)).destroySubcontext(name);
                this.cccf.setDefault();
            }
        }
        catch (NamingException e) {
            if (TraceCarol.isDebugJndiCarol()) {
                String msg = "MultiContext.destroySubcontext(Name name) failed: " + e;
                TraceCarol.debugJndiCarol("Error: " + msg + " " + e);
            }
            throw e;
        }
    }

    public Context createSubcontext(String name) throws NamingException {
        if (TraceCarol.isDebugJndiCarol()) {
            TraceCarol.debugJndiCarol("MultiContext.createSubcontext(\"" + name + "\")");
        }
        try {
            return this.cccf.getCurrentInitialContext().createSubcontext(name);
        }
        catch (NamingException e) {
            if (TraceCarol.isDebugJndiCarol()) {
                String msg = "MultiContext.createSubcontext(String name) failed: " + e;
                TraceCarol.debugJndiCarol("Error: " + msg + " " + e);
            }
            throw e;
        }
    }

    public Context createSubcontext(Name name) throws NamingException {
        if (TraceCarol.isDebugJndiCarol()) {
            TraceCarol.debugJndiCarol("MultiContext.createSubcontext(\"" + name + "\")");
        }
        try {
            return this.cccf.getCurrentInitialContext().createSubcontext(name);
        }
        catch (NamingException e) {
            if (TraceCarol.isDebugJndiCarol()) {
                String msg = "MultiContext.createSubcontext(Name name) failed: " + e;
                TraceCarol.debugJndiCarol("Error: " + msg + " " + e);
            }
            throw e;
        }
    }

    public Object lookupLink(String name) throws NamingException {
        if (TraceCarol.isDebugJndiCarol()) {
            TraceCarol.debugJndiCarol("MultiContext.lookupLink(\"" + name + "\")/rmi name=\"" + this.cccf.getCurrentRMIName() + "\"");
        }
        try {
            return this.cccf.getCurrentInitialContext().lookupLink(name);
        }
        catch (NamingException e) {
            if (TraceCarol.isDebugJndiCarol()) {
                String msg = "MultiContext.lookupLink(String name) failed: " + e;
                TraceCarol.debugJndiCarol("Error: " + msg + " " + e);
            }
            throw e;
        }
    }

    public Object lookupLink(Name name) throws NamingException {
        if (TraceCarol.isDebugJndiCarol()) {
            TraceCarol.debugJndiCarol("MultiContext.lookupLink(\"" + name + "\")/rmi name=\"" + this.cccf.getCurrentRMIName() + "\"");
        }
        try {
            return this.cccf.getCurrentInitialContext().lookupLink(name);
        }
        catch (NamingException e) {
            if (TraceCarol.isDebugJndiCarol()) {
                String msg = "MultiContext.lookupLink(Name name) failed: " + e;
                TraceCarol.debugJndiCarol("Error: " + msg + " " + e);
            }
            throw e;
        }
    }

    public NameParser getNameParser(String name) throws NamingException {
        if (TraceCarol.isDebugJndiCarol()) {
            TraceCarol.debugJndiCarol("MultiContext.getNameParser(\"" + name + "\")/rmi name=\"" + this.cccf.getCurrentRMIName() + "\"");
        }
        try {
            return this.cccf.getCurrentInitialContext().getNameParser(name);
        }
        catch (NamingException e) {
            if (TraceCarol.isDebugJndiCarol()) {
                String msg = "MultiContext.getNameParser(String name) failed: " + e;
                TraceCarol.debugJndiCarol("Error: " + msg + " " + e);
            }
            throw e;
        }
    }

    public NameParser getNameParser(Name name) throws NamingException {
        if (TraceCarol.isDebugJndiCarol()) {
            TraceCarol.debugJndiCarol("MultiContext.getNameParser(\"" + name + "\")/rmi name=\"" + this.cccf.getCurrentRMIName() + "\"");
        }
        try {
            return this.cccf.getCurrentInitialContext().getNameParser(name);
        }
        catch (NamingException e) {
            if (TraceCarol.isDebugJndiCarol()) {
                String msg = "MultiContext.getNameParser(Name name) failed: " + e;
                TraceCarol.debugJndiCarol("Error: " + msg + " " + e);
            }
            throw e;
        }
    }

    public String composeName(String name, String prefix) throws NamingException {
        if (TraceCarol.isDebugJndiCarol()) {
            TraceCarol.debugJndiCarol("MultiContext.composeName(" + name + "," + prefix + ")/rmi name=" + this.cccf.getCurrentRMIName());
        }
        return name;
    }

    public Name composeName(Name name, Name prefix) throws NamingException {
        if (TraceCarol.isDebugJndiCarol()) {
            TraceCarol.debugJndiCarol("MultiContext.composeName(\"" + name + "," + prefix + "\")/rmi name=\"" + this.cccf.getCurrentRMIName() + "\"");
        }
        return this.cccf.getCurrentInitialContext().composeName(name, prefix);
    }

    public Object addToEnvironment(String propName, Object propVal) throws NamingException {
        try {
            if (TraceCarol.isDebugJndiCarol()) {
                TraceCarol.debugJndiCarol("MultiContext.addToEnvironment()");
            }
            return this.cccf.getCurrentInitialContext().addToEnvironment(propName, propVal);
        }
        catch (NamingException e) {
            if (TraceCarol.isDebugJndiCarol()) {
                String msg = "MultiContext.addToEnvironment(String propName, Object propVal)  failed: " + e;
                TraceCarol.debugJndiCarol("Error: " + msg + " " + e);
            }
            throw e;
        }
    }

    public Object removeFromEnvironment(String propName) throws NamingException {
        if (TraceCarol.isDebugJndiCarol()) {
            TraceCarol.debugJndiCarol("MultiContext.removeFromEnvironment(\"" + propName + "\")");
        }
        try {
            return this.cccf.getCurrentInitialContext().removeFromEnvironment(propName);
        }
        catch (NamingException e) {
            if (TraceCarol.isDebugJndiCarol()) {
                String msg = "MultiContext.removeFromEnvironment(String propName) failed: " + e;
                TraceCarol.debugJndiCarol("Error: " + msg + " " + e);
            }
            throw e;
        }
    }

    public Hashtable getEnvironment() throws NamingException {
        if (TraceCarol.isDebugJndiCarol()) {
            TraceCarol.debugJndiCarol("MultiContext.getEnvironment()/rmi name=\"" + this.cccf.getCurrentRMIName() + "\"");
        }
        try {
            return this.cccf.getCurrentInitialContext().getEnvironment();
        }
        catch (NamingException e) {
            if (TraceCarol.isDebugJndiCarol()) {
                String msg = "MultiContext.getEnvironment() failed: " + e;
                TraceCarol.debugJndiCarol("Error: " + msg + " " + e);
            }
            throw e;
        }
    }

    public void close() throws NamingException {
        if (TraceCarol.isDebugJndiCarol()) {
            TraceCarol.debugJndiCarol("MultiContext.close()");
        }
        try {
            Enumeration e = this.activesInitialsContexts.keys();
            while (e.hasMoreElements()) {
                this.rmiName = (String)e.nextElement();
                this.cccf.setRMI(this.rmiName);
                ((Context)this.activesInitialsContexts.get(this.rmiName)).close();
                this.cccf.setDefault();
            }
        }
        catch (NamingException e) {
            if (TraceCarol.isDebugJndiCarol()) {
                String msg = "MultiContext.close() failed: " + e;
                TraceCarol.debugJndiCarol("Error: " + msg + " " + e);
            }
            throw e;
        }
    }

    public String getNameInNamespace() throws NamingException {
        if (TraceCarol.isDebugJndiCarol()) {
            TraceCarol.debugJndiCarol("MultiContext.getNameInNamespace()/rmi name=" + this.cccf.getCurrentRMIName() + "\"");
        }
        try {
            return this.cccf.getCurrentInitialContext().getNameInNamespace();
        }
        catch (NamingException e) {
            if (TraceCarol.isDebugJndiCarol()) {
                String msg = "MultiContext.getNameInNamespace() failed: " + e;
                TraceCarol.debugJndiCarol("Error: " + msg + " " + e);
            }
            throw e;
        }
    }
}

