/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.carol.jndi.spi;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Hashtable;
import java.util.Properties;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameClassPair;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import org.objectweb.carol.jndi.spi.MultiContext;
import org.objectweb.carol.util.configuration.CarolCurrentConfiguration;
import org.objectweb.carol.util.configuration.CarolDefaultValues;
import org.objectweb.carol.util.configuration.TraceCarol;

public class ContextWrapper
implements Context {
    private Context ac = null;
    private Hashtable envpar = null;
    private boolean isSingle;

    public ContextWrapper(Hashtable env) throws NamingException {
        if (TraceCarol.isDebugJndiCarol()) {
            TraceCarol.debugJndiCarol("ContextWrapper.ContextWrapper()");
        }
        try {
            this.envpar = env;
            String jndiURL = (String)env.get(CarolDefaultValues.JNDI_URL_PREFIX);
            boolean bl = this.isSingle = env != null && jndiURL != null;
            if (this.isSingle) {
                String rmiName = CarolDefaultValues.getRMIProtocol((String)env.get(CarolDefaultValues.JNDI_URL_PREFIX));
                Properties prop = CarolCurrentConfiguration.getCurrent().getRMIProperties(rmiName);
                env.put(CarolDefaultValues.JNDI_FACTORY_PREFIX, prop.get(CarolDefaultValues.JNDI_FACTORY_PREFIX));
                this.ac = new InitialContext(env);
            } else {
                this.ac = new MultiContext(env);
            }
        }
        catch (Exception e) {
            String msg = "ContextWrapper.ContextWrapper() failed: " + e;
            throw new NamingException(msg);
        }
    }

    public Object lookup(String name) throws NamingException {
        if (TraceCarol.isDebugJndiCarol()) {
            TraceCarol.debugJndiCarol("ContextWrapper.lookup(" + name + ")");
        }
        try {
            return this.ac.lookup(this.encode(name));
        }
        catch (NamingException e) {
            if (TraceCarol.isDebugJndiCarol()) {
                String msg = "ContextWrapper.lookup(" + name + ") failed: " + e;
                TraceCarol.debugJndiCarol("Error: " + msg);
            }
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            pw.flush();
            throw new NamingException(e.toString() + "\nCaused by: " + sw.toString() + "\n<End of Cause>");
        }
    }

    public Object lookup(Name name) throws NamingException {
        if (TraceCarol.isDebugJndiCarol()) {
            TraceCarol.debugJndiCarol("ContextWrapper.lookup(" + name + ")");
        }
        try {
            return this.ac.lookup(this.encode(name));
        }
        catch (NamingException e) {
            if (TraceCarol.isDebugJndiCarol()) {
                String msg = "ContextWrapper.lookup(Name name) failed: " + e;
                TraceCarol.debugJndiCarol("Error: " + msg + " " + e);
            }
            throw e;
        }
    }

    public void bind(String name, Object obj) throws NamingException {
        if (TraceCarol.isDebugJndiCarol()) {
            TraceCarol.debugJndiCarol("ContextWrapper.bind(" + name + "," + this.simpleClass(obj.getClass().getName()) + " object)");
        }
        try {
            this.ac.bind(this.encode(name), obj);
        }
        catch (NamingException e) {
            if (TraceCarol.isDebugJndiCarol()) {
                String msg = "ContextWrapper.bind(" + name + "," + this.simpleClass(obj.getClass().getName()) + " object) failed: " + e;
                TraceCarol.debugJndiCarol("Error: " + msg + " " + e);
            }
            throw e;
        }
    }

    public void bind(Name name, Object obj) throws NamingException {
        if (TraceCarol.isDebugJndiCarol()) {
            TraceCarol.debugJndiCarol("ContextWrapper.bind(" + name + "," + this.simpleClass(obj.getClass().getName()) + " object)");
        }
        try {
            this.ac.bind(this.encode(name), obj);
        }
        catch (NamingException e) {
            if (TraceCarol.isDebugJndiCarol()) {
                String msg = "ContextWrapper.bind(Name name, Object obj) failed: " + e;
                TraceCarol.debugJndiCarol("Error: " + msg + " " + e);
            }
            throw e;
        }
    }

    public void rebind(String name, Object obj) throws NamingException {
        if (TraceCarol.isDebugJndiCarol()) {
            TraceCarol.debugJndiCarol("ContextWrapper.rebind(" + name + "," + this.simpleClass(obj.getClass().getName()) + " object)");
        }
        try {
            this.ac.rebind(this.encode(name), obj);
        }
        catch (NamingException e) {
            if (TraceCarol.isDebugJndiCarol()) {
                String msg = "ContextWrapper.rebind(String name, Object obj) failed: " + e;
                TraceCarol.debugJndiCarol("Error: " + msg + " " + e);
            }
            throw e;
        }
    }

    public void rebind(Name name, Object obj) throws NamingException {
        if (TraceCarol.isDebugJndiCarol()) {
            TraceCarol.debugJndiCarol("ContextWrapper.rebind(" + name + "," + this.simpleClass(obj.getClass().getName()) + " object)");
        }
        try {
            this.ac.rebind(this.encode(name), obj);
        }
        catch (NamingException e) {
            if (TraceCarol.isDebugJndiCarol()) {
                String msg = "ContextWrapper.rebind(Name name, Object obj) failed: " + e;
                TraceCarol.debugJndiCarol("Error: " + msg + " " + e);
            }
            throw e;
        }
    }

    public void unbind(String name) throws NamingException {
        if (TraceCarol.isDebugJndiCarol()) {
            TraceCarol.debugJndiCarol("ContextWrapper.unbind(" + name + ")");
        }
        try {
            this.ac.unbind(this.encode(name));
        }
        catch (NamingException e) {
            if (TraceCarol.isDebugJndiCarol()) {
                String msg = "ContextWrapper.unbind(String name) failed: " + e;
                TraceCarol.debugJndiCarol("Error: " + msg + " " + e);
            }
            throw e;
        }
    }

    public void unbind(Name name) throws NamingException {
        if (TraceCarol.isDebugJndiCarol()) {
            TraceCarol.debugJndiCarol("ContextWrapper.unbind(" + name + ")");
        }
        try {
            this.ac.unbind(this.encode(name));
        }
        catch (NamingException e) {
            if (TraceCarol.isDebugJndiCarol()) {
                String msg = "ContextWrapper.unbind(Name name) failed: " + e;
                TraceCarol.debugJndiCarol("Error: " + msg + " " + e);
            }
            throw e;
        }
    }

    public void rename(String oldName, String newName) throws NamingException {
        if (TraceCarol.isDebugJndiCarol()) {
            TraceCarol.debugJndiCarol("ContextWrapper.rename(" + oldName + "," + newName + ")");
        }
        try {
            this.ac.rename(this.encode(oldName), this.encode(newName));
        }
        catch (NamingException e) {
            if (TraceCarol.isDebugJndiCarol()) {
                String msg = "ContextWrapper.rename(String oldName, String newName) failed: " + e;
                TraceCarol.debugJndiCarol("Error: " + msg + " " + e);
            }
            throw e;
        }
    }

    public void rename(Name oldName, Name newName) throws NamingException {
        if (TraceCarol.isDebugJndiCarol()) {
            TraceCarol.debugJndiCarol("ContextWrapper.rename(" + oldName + "," + newName + ")");
        }
        try {
            this.ac.rename(this.encode(oldName), this.encode(newName));
        }
        catch (NamingException e) {
            if (TraceCarol.isDebugJndiCarol()) {
                String msg = "ContextWrapper.rename(Name oldName, Name newName) failed: " + e;
                TraceCarol.debugJndiCarol("Error: " + msg + " " + e);
            }
            throw e;
        }
    }

    public NamingEnumeration list(String name) throws NamingException {
        if (TraceCarol.isDebugJndiCarol()) {
            TraceCarol.debugJndiCarol("ContextWrapper.list(" + name + ")");
        }
        try {
            return new WrapEnum(this.ac.list(this.encode(name)));
        }
        catch (NamingException e) {
            if (TraceCarol.isDebugJndiCarol()) {
                String msg = "ContextWrapper.list(String name) failed: " + e;
                TraceCarol.debugJndiCarol("Error: " + msg + " " + e);
            }
            throw e;
        }
    }

    public NamingEnumeration list(Name name) throws NamingException {
        if (TraceCarol.isDebugJndiCarol()) {
            TraceCarol.debugJndiCarol("ContextWrapper.list(" + name + ")");
        }
        try {
            return new WrapEnum(this.ac.list(this.encode(name)));
        }
        catch (NamingException e) {
            if (TraceCarol.isDebugJndiCarol()) {
                String msg = "ContextWrapper.list(Name name) failed: " + e;
                TraceCarol.debugJndiCarol("Error: " + msg + " " + e);
            }
            throw e;
        }
    }

    public NamingEnumeration listBindings(String name) throws NamingException {
        if (TraceCarol.isDebugJndiCarol()) {
            TraceCarol.debugJndiCarol("ContextWrapper.listBindings(" + name + ")");
        }
        try {
            return new WrapEnum(this.ac.listBindings(this.encode(name)));
        }
        catch (NamingException e) {
            if (TraceCarol.isDebugJndiCarol()) {
                String msg = "ContextWrapper.listBindings(String name) failed: " + e;
                TraceCarol.debugJndiCarol("Error: " + msg + " " + e);
            }
            throw e;
        }
    }

    public NamingEnumeration listBindings(Name name) throws NamingException {
        if (TraceCarol.isDebugJndiCarol()) {
            TraceCarol.debugJndiCarol("ContextWrapper.listBindings(" + name + ")");
        }
        try {
            return new WrapEnum(this.ac.listBindings(this.encode(name)));
        }
        catch (NamingException e) {
            if (TraceCarol.isDebugJndiCarol()) {
                String msg = "ContextWrapper.listBindings(Name name) failed: " + e;
                TraceCarol.debugJndiCarol("Error: " + msg + " " + e);
            }
            throw e;
        }
    }

    public void destroySubcontext(String name) throws NamingException {
        if (TraceCarol.isDebugJndiCarol()) {
            TraceCarol.debugJndiCarol("ContextWrapper.destroySubcontext(" + name + ")");
        }
        try {
            this.ac.destroySubcontext(this.encode(name));
        }
        catch (NamingException e) {
            if (TraceCarol.isDebugJndiCarol()) {
                String msg = "ContextWrapper.destroySubcontext(String name) failed: " + e;
                TraceCarol.debugJndiCarol("Error: " + msg + " " + e);
            }
            throw e;
        }
    }

    public void destroySubcontext(Name name) throws NamingException {
        if (TraceCarol.isDebugJndiCarol()) {
            TraceCarol.debugJndiCarol("ContextWrapper.destroySubcontext(" + name + ")");
        }
        try {
            this.ac.destroySubcontext(this.encode(name));
        }
        catch (NamingException e) {
            if (TraceCarol.isDebugJndiCarol()) {
                String msg = "ContextWrapper.destroySubcontext(Name name) failed: " + e;
                TraceCarol.debugJndiCarol("Error: " + msg + " " + e);
            }
            throw e;
        }
    }

    public Context createSubcontext(String name) throws NamingException {
        if (TraceCarol.isDebugJndiCarol()) {
            TraceCarol.debugJndiCarol("ContextWrapper.createSubcontext(" + name + ")");
        }
        try {
            return this.ac.createSubcontext(this.encode(name));
        }
        catch (NamingException e) {
            if (TraceCarol.isDebugJndiCarol()) {
                String msg = "ContextWrapper.createSubcontext(String name) failed: " + e;
                TraceCarol.debugJndiCarol("Error: " + msg + " " + e);
            }
            throw e;
        }
    }

    public Context createSubcontext(Name name) throws NamingException {
        if (TraceCarol.isDebugJndiCarol()) {
            TraceCarol.debugJndiCarol("ContextWrapper.createSubcontext(" + name + ")");
        }
        try {
            return this.ac.createSubcontext(this.encode(name));
        }
        catch (NamingException e) {
            if (TraceCarol.isDebugJndiCarol()) {
                String msg = "ContextWrapper.createSubcontext(Name name) failed: " + e;
                TraceCarol.debugJndiCarol("Error: " + msg + " " + e);
            }
            throw e;
        }
    }

    public Object lookupLink(String name) throws NamingException {
        if (TraceCarol.isDebugJndiCarol()) {
            TraceCarol.debugJndiCarol("ContextWrapper.lookupLink(" + name + ")");
        }
        try {
            return this.ac.lookupLink(this.encode(name));
        }
        catch (NamingException e) {
            if (TraceCarol.isDebugJndiCarol()) {
                String msg = "ContextWrapper.lookupLink(String name) failed: " + e;
                TraceCarol.debugJndiCarol("Error: " + msg + " " + e);
            }
            throw e;
        }
    }

    public Object lookupLink(Name name) throws NamingException {
        if (TraceCarol.isDebugJndiCarol()) {
            TraceCarol.debugJndiCarol("ContextWrapper.lookupLink(" + name + ")");
        }
        try {
            return this.ac.lookupLink(this.encode(name));
        }
        catch (NamingException e) {
            if (TraceCarol.isDebugJndiCarol()) {
                String msg = "ContextWrapper.lookupLink(Name name) failed: " + e;
                TraceCarol.debugJndiCarol("Error: " + msg + " " + e);
            }
            throw e;
        }
    }

    public NameParser getNameParser(String name) throws NamingException {
        if (TraceCarol.isDebugJndiCarol()) {
            TraceCarol.debugJndiCarol("ContextWrapper.getNameParser(" + name + ")");
        }
        try {
            return this.ac.getNameParser(name);
        }
        catch (NamingException e) {
            if (TraceCarol.isDebugJndiCarol()) {
                String msg = "ContextWrapper.getNameParser(String name) failed: " + e;
                TraceCarol.debugJndiCarol("Error: " + msg + " " + e);
            }
            throw e;
        }
    }

    public NameParser getNameParser(Name name) throws NamingException {
        if (TraceCarol.isDebugJndiCarol()) {
            TraceCarol.debugJndiCarol("ContextWrapper.getNameParser(" + name + ")");
        }
        try {
            return this.ac.getNameParser(name);
        }
        catch (NamingException e) {
            if (TraceCarol.isDebugJndiCarol()) {
                String msg = "ContextWrapper.getNameParser(Name name) failed: " + e;
                TraceCarol.debugJndiCarol("Error: " + msg + " " + e);
            }
            throw e;
        }
    }

    public String composeName(String name, String prefix) throws NamingException {
        if (TraceCarol.isDebugJndiCarol()) {
            TraceCarol.debugJndiCarol("ContextWrapper.composeName(" + name + "," + prefix + ")");
        }
        return name;
    }

    public Name composeName(Name name, Name prefix) throws NamingException {
        if (TraceCarol.isDebugJndiCarol()) {
            TraceCarol.debugJndiCarol("ContextWrapper.composeName(" + name + "," + prefix + ")");
        }
        return this.ac.composeName(name, prefix);
    }

    public Object addToEnvironment(String propName, Object propVal) throws NamingException {
        try {
            if (TraceCarol.isDebugJndiCarol()) {
                TraceCarol.debugJndiCarol("ContextWrapper.addToEnvironment(" + propName + "," + this.simpleClass(propVal.getClass().getName()) + " object)");
            }
            return this.ac.addToEnvironment(propName, propVal);
        }
        catch (NamingException e) {
            if (TraceCarol.isDebugJndiCarol()) {
                String msg = "ContextWrapper.addToEnvironment(String propName, Object propVal)  failed: " + e;
                TraceCarol.debugJndiCarol("Error: " + msg + " " + e);
            }
            throw e;
        }
    }

    public Object removeFromEnvironment(String propName) throws NamingException {
        if (TraceCarol.isDebugJndiCarol()) {
            TraceCarol.debugJndiCarol("ContextWrapper.removeFromEnvironment(" + propName + ")");
        }
        try {
            return this.ac.removeFromEnvironment(propName);
        }
        catch (NamingException e) {
            if (TraceCarol.isDebugJndiCarol()) {
                String msg = "ContextWrapper.removeFromEnvironment(String propName) failed: " + e;
                TraceCarol.debugJndiCarol("Error: " + msg + " " + e);
            }
            throw e;
        }
    }

    public Hashtable getEnvironment() throws NamingException {
        if (TraceCarol.isDebugJndiCarol()) {
            TraceCarol.debugJndiCarol("ContextWrapper.getEnvironment()");
        }
        try {
            return this.ac.getEnvironment();
        }
        catch (NamingException e) {
            if (TraceCarol.isDebugJndiCarol()) {
                String msg = "ContextWrapper.getEnvironment() failed: " + e;
                TraceCarol.debugJndiCarol("Error: " + msg + " " + e);
            }
            throw e;
        }
    }

    public void close() throws NamingException {
        if (TraceCarol.isDebugJndiCarol()) {
            TraceCarol.debugJndiCarol("ContextWrapper.close()");
        }
        try {
            this.ac.close();
        }
        catch (NamingException e) {
            if (TraceCarol.isDebugJndiCarol()) {
                String msg = "ContextWrapper.close() failed: " + e;
                TraceCarol.debugJndiCarol("Error: " + msg + " " + e);
            }
            throw e;
        }
    }

    public String getNameInNamespace() throws NamingException {
        if (TraceCarol.isDebugJndiCarol()) {
            TraceCarol.debugJndiCarol("ContextWrapper.getNameInNamespace()");
        }
        try {
            return this.ac.getNameInNamespace();
        }
        catch (NamingException e) {
            if (TraceCarol.isDebugJndiCarol()) {
                String msg = "ContextWrapper.getNameInNamespace() failed: " + e;
                TraceCarol.debugJndiCarol("Error: " + msg + " " + e);
            }
            throw e;
        }
    }

    private String simpleClass(String c) {
        return c.substring(c.lastIndexOf(46) + 1);
    }

    private String encode(String name) {
        if (name.length() < 1) {
            return name;
        }
        StringBuffer newname = new StringBuffer(name);
        for (int i = 0; i < newname.length(); ++i) {
            char c = newname.charAt(i);
            if (c != '/' && c != '\\') continue;
            newname.insert(i, '\\');
            ++i;
        }
        if (newname.charAt(0) == '\"' || newname.charAt(0) == '\'') {
            newname.insert(0, '\\');
        }
        return newname.toString();
    }

    private String decode(String name) {
        StringBuffer newname = new StringBuffer(name);
        if (newname.length() >= 2 && (newname.charAt(0) == '\"' || newname.charAt(0) == '\'') && newname.charAt(0) == newname.charAt(newname.length() - 1)) {
            newname.deleteCharAt(0);
            newname.deleteCharAt(newname.length() - 1);
        } else {
            if (name.indexOf(92) < 0) {
                return name;
            }
            int i = 0;
            while (i < newname.length()) {
                if (newname.charAt(i) == '\\') {
                    newname.deleteCharAt(i);
                    ++i;
                    continue;
                }
                ++i;
            }
        }
        return newname.toString();
    }

    private Name encode(Name name) {
        try {
            return new CompositeName(this.encode(name.toString()));
        }
        catch (InvalidNameException e) {
            return name;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class WrapEnum
    implements NamingEnumeration {
        NamingEnumeration enum;

        WrapEnum(NamingEnumeration names) {
            this.enum = names;
        }

        public boolean hasMoreElements() {
            return this.enum.hasMoreElements();
        }

        public boolean hasMore() throws NamingException {
            return this.enum.hasMore();
        }

        public Object nextElement() {
            NameClassPair ncp = (NameClassPair)this.enum.nextElement();
            ncp.setName(ContextWrapper.this.decode(ncp.getName()));
            return ncp;
        }

        public Object next() throws NamingException {
            NameClassPair ncp = (NameClassPair)this.enum.next();
            ncp.setName(ContextWrapper.this.decode(ncp.getName()));
            return ncp;
        }

        public void close() throws NamingException {
            this.enum = null;
        }
    }
}

