/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.carol.cmi;

import java.net.MalformedURLException;
import java.util.ArrayList;
import org.objectweb.carol.cmi.NamingContextHostPort;

public class NamingContext {
    public String scheme = "";
    public NamingContextHostPort[] hp;
    public String name = "";

    public NamingContext(String input) throws MalformedURLException {
        if (input == null || input.length() == 0) {
            throw new MalformedURLException("null or empty registry URL");
        }
        if (input.indexOf("//") == -1) {
            throw new MalformedURLException("badly formed registry URL " + input);
        }
        try {
            this.parseScheme(input.substring(0, input.indexOf("//")));
            this.parseName(input.substring(input.indexOf("//")));
        }
        catch (MalformedURLException e) {
            throw new MalformedURLException("badly formed registry URL " + input + " - " + e.getMessage());
        }
        catch (Exception e) {
            throw new MalformedURLException("badly formed registry URL " + input);
        }
    }

    private void parseScheme(String inputscheme) throws MalformedURLException {
        if (inputscheme.length() == 0) {
            this.scheme = "";
        } else {
            if (inputscheme.length() <= 1 || !inputscheme.endsWith(":")) {
                throw new MalformedURLException("badly formed protocol");
            }
            this.scheme = inputscheme.substring(0, inputscheme.length() - 1);
            if (!this.scheme.equals("cmi")) {
                throw new MalformedURLException("Invalid protocol : " + this.scheme);
            }
        }
    }

    private void parseName(String inputurl) throws MalformedURLException {
        String inputname = "";
        String inputhostport = "";
        int n = inputurl.indexOf("/", 2);
        if (n == -1 && inputurl.length() > 2) {
            inputhostport = inputurl.substring(2);
        }
        if (n == 2) {
            if (inputurl.length() > 3) {
                inputname = inputurl.substring(3);
            } else {
                throw new MalformedURLException("non-empty name expected after third /");
            }
        }
        if (n > 2) {
            if (inputurl.length() <= n + 1) {
                throw new MalformedURLException("non-empty name expected after third /");
            }
            inputname = inputurl.substring(n + 1);
            inputhostport = inputurl.substring(2, n);
        }
        this.name = inputname;
        this.parseHostsPorts(inputhostport);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void parseHostPort(String inputhostport, ArrayList hp) throws MalformedURLException {
        String inputhost = "";
        String inputport = "";
        int m = inputhostport.indexOf(58);
        if (m == -1) {
            inputhost = inputhostport;
        } else if (m == 0) {
            if (inputhostport.length() <= 1) throw new MalformedURLException("non-empty port expected after :");
            inputport = inputhostport.substring(1);
        } else {
            inputhost = inputhostport.substring(0, m);
            if (inputhostport.length() <= m + 1) throw new MalformedURLException("non-empty port expected after :");
            inputport = inputhostport.substring(m + 1);
        }
        NamingContextHostPort nchp = new NamingContextHostPort();
        if (!inputhost.equals("")) {
            nchp.host = inputhost;
        }
        if (!inputport.equals("")) {
            try {
                nchp.port = Integer.parseInt(inputport);
            }
            catch (NumberFormatException e) {
                throw new MalformedURLException("port must be a number");
            }
        }
        hp.add(nchp);
    }

    private void parseHostsPorts(String inputhostsports) throws MalformedURLException {
        int end;
        int start = 0;
        ArrayList hostsports = new ArrayList();
        do {
            if ((end = inputhostsports.indexOf(44, start)) < 0) {
                this.parseHostPort(inputhostsports.substring(start), hostsports);
                continue;
            }
            this.parseHostPort(inputhostsports.substring(start, end), hostsports);
        } while ((start = end + 1) > 0);
        int n = hostsports.size();
        this.hp = new NamingContextHostPort[n];
        for (int i = 0; i < n; ++i) {
            this.hp[i] = (NamingContextHostPort)hostsports.get(i);
        }
    }
}

