/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.util;

import com.sun.grizzly.util.SelectorFactory;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.Selector;
import java.nio.charset.Charset;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Utils {
    private static final ConcurrentHashMap<String, Charset> ALIAS_MAP = new ConcurrentHashMap();
    public static boolean VERBOSE_TESTS = false;
    private static final byte[] toLower = new byte[256];

    public static Charset lookupCharset(String charsetName) {
        Charset charset = ALIAS_MAP.get(charsetName);
        if (charset == null) {
            charset = Charset.forName(charsetName);
            ALIAS_MAP.putIfAbsent(charsetName, charset);
        }
        return charset;
    }

    public static Selector openSelector() throws IOException {
        try {
            return Selector.open();
        }
        catch (NullPointerException e) {
            for (int i = 0; i < 5; ++i) {
                try {
                    return Selector.open();
                }
                catch (NullPointerException nullPointerException) {
                    continue;
                }
            }
            String msg = e.getMessage();
            throw new IOException("Can not open Selector" + (msg == null ? "" : msg));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public static Result readWithTemporarySelector(SelectableChannel channel, ByteBuffer byteBuffer, long readTimeout) throws IOException {
        block18: {
            block19: {
                block16: {
                    block17: {
                        count = 1;
                        byteRead = 0;
                        preReadInputBBPos = byteBuffer.position();
                        readSelector = null;
                        tmpKey = null;
                        r = new Result(0, false);
                        readableChannel = (ReadableByteChannel)channel;
                        while (count > 0) {
                            count = readableChannel.read(byteBuffer);
                            if (count > -1) {
                                byteRead += count;
                                continue;
                            }
                            if (count != -1 || byteRead != 0) continue;
                            byteRead = -1;
                        }
                        if (byteRead < 0 || byteBuffer.position() != preReadInputBBPos) ** GOTO lbl55
                        readSelector = SelectorFactory.getSelector();
                        if (readSelector != null) break block16;
                        var11_10 = r;
                        if (tmpKey != null) {
                            tmpKey.cancel();
                        }
                        if (readSelector == null) break block17;
                        SelectorFactory.selectNowAndReturnSelector(readSelector);
                    }
                    return var11_10;
                }
                count = 1;
                tmpKey = channel.register(readSelector, 1);
                tmpKey.interestOps(tmpKey.interestOps() | 1);
                code = readSelector.select(readTimeout);
                tmpKey.interestOps(tmpKey.interestOps() & -2);
                if (code != 0) break block18;
                var12_12 = r;
                if (tmpKey != null) {
                    tmpKey.cancel();
                }
                if (readSelector == null) break block19;
                SelectorFactory.selectNowAndReturnSelector(readSelector);
            }
            return var12_12;
        }
        try {
            block20: {
                while (count > 0) {
                    count = readableChannel.read(byteBuffer);
                    if (count > -1) {
                        byteRead += count;
                        continue;
                    }
                    if (count != -1 || byteRead != 0) continue;
                    byteRead = -1;
                }
                break block20;
lbl55:
                // 1 sources

                if (byteRead == 0 && byteBuffer.position() != preReadInputBBPos) {
                    byteRead += byteBuffer.position() - preReadInputBBPos;
                }
            }
            if (tmpKey != null) {
                tmpKey.cancel();
            }
            ** if (readSelector == null) goto lbl-1000
        }
        catch (Throwable var13_13) {
            if (tmpKey != null) {
                tmpKey.cancel();
            }
            if (readSelector != null) {
                SelectorFactory.selectNowAndReturnSelector(readSelector);
            }
            throw var13_13;
        }
lbl-1000:
        // 1 sources

        {
            SelectorFactory.selectNowAndReturnSelector(readSelector);
        }
lbl-1000:
        // 2 sources

        {
        }
        if (count == -1 || byteRead == -1) {
            r.isClosed = true;
        }
        r.bytesRead = byteRead;
        return r;
    }

    public static byte[] extractBytes(ByteBuffer byteBuffer, byte startByte, byte endByte) {
        int curPosition = byteBuffer.position();
        int curLimit = byteBuffer.limit();
        if (byteBuffer.position() == 0) {
            throw new IllegalStateException("Invalid state");
        }
        byteBuffer.position(0);
        byteBuffer.limit(curPosition);
        int state = 0;
        int start = 0;
        try {
            block8: while (byteBuffer.hasRemaining()) {
                byte c = byteBuffer.get();
                switch (state) {
                    case 0: {
                        if (c != startByte) continue block8;
                        state = 1;
                        start = byteBuffer.position();
                        continue block8;
                    }
                    case 1: {
                        if (c != endByte) continue block8;
                        int end = byteBuffer.position();
                        byte[] bytes = new byte[end - start];
                        byteBuffer.position(start);
                        byteBuffer.limit(end);
                        byteBuffer.get(bytes);
                        byte[] byArray = bytes;
                        return byArray;
                    }
                }
                throw new IllegalArgumentException("Unexpected state");
            }
            throw new IllegalStateException("Unexpected state");
        }
        finally {
            byteBuffer.limit(curLimit);
            byteBuffer.position(curPosition);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int findBytes(ByteBuffer byteBuffer, byte[] b) {
        int curPosition = byteBuffer.position();
        int curLimit = byteBuffer.limit();
        if (byteBuffer.position() == 0) {
            throw new IllegalStateException("Invalid state");
        }
        byteBuffer.position(0);
        byteBuffer.limit(curPosition);
        try {
            byte first = b[0];
            int start = 0;
            int end = curPosition;
            int srcEnd = b.length;
            for (int i = start; i <= end - srcEnd; ++i) {
                if ((toLower[byteBuffer.get(i) & 0xFF] & 0xFF) != first) continue;
                int myPos = i + 1;
                int srcPos = 1;
                while (srcPos < srcEnd && (toLower[byteBuffer.get(myPos++) & 0xFF] & 0xFF) == b[srcPos++]) {
                    if (srcPos != srcEnd) continue;
                    int n = i - start;
                    return n;
                }
            }
            int n = -1;
            return n;
        }
        finally {
            byteBuffer.limit(curLimit);
            byteBuffer.position(curPosition);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int findBytes(ByteBuffer bb, Pattern pattern) {
        int curPosition = bb.position();
        int curLimit = bb.limit();
        bb.position(0);
        bb.limit(curPosition);
        try {
            Matcher matcher = pattern.matcher(new MyCharSequence(curPosition, bb));
            if (matcher.find()) {
                int n = matcher.start();
                return n;
            }
            int n = -1;
            return n;
        }
        finally {
            bb.limit(curLimit);
            bb.position(curPosition);
        }
    }

    public static boolean isDebugVM() {
        boolean debugMode = false;
        List<String> l = ManagementFactory.getRuntimeMXBean().getInputArguments();
        for (String s : l) {
            if (!s.trim().startsWith("-Xrunjdwp:") && !s.contains("jdwp")) continue;
            debugMode = true;
            break;
        }
        return debugMode;
    }

    public static void dumpOut(Object text) {
        if (VERBOSE_TESTS) {
            System.out.println(text);
        }
    }

    public static void dumpErr(Object text) {
        if (VERBOSE_TESTS) {
            System.err.println(text);
        }
    }

    public static byte[] copy(byte[] src) {
        byte[] copy = null;
        if (src != null) {
            copy = new byte[src.length];
            System.arraycopy(src, 0, copy, 0, src.length);
        }
        return copy;
    }

    static {
        for (int i = 0; i < 256; ++i) {
            Utils.toLower[i] = (byte)i;
        }
        for (int lc = 97; lc <= 122; ++lc) {
            int uc = lc + 65 - 97;
            Utils.toLower[uc] = (byte)lc;
        }
    }

    private static class MyCharSequence
    implements CharSequence {
        private final int curPosition;
        private final ByteBuffer bb;

        public MyCharSequence(int curPosition, ByteBuffer bb) {
            this.curPosition = curPosition;
            this.bb = bb;
        }

        public int length() {
            return this.curPosition;
        }

        public char charAt(int index) {
            return (char)this.bb.get(index);
        }

        public CharSequence subSequence(int start, int end) {
            throw new UnsupportedOperationException();
        }
    }

    public static class Result {
        public int bytesRead = 0;
        public boolean isClosed = false;

        public Result(int i, boolean b) {
            this.bytesRead = i;
            this.isClosed = b;
        }
    }
}

