/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javafx2.scenebuilder.options;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.LayoutStyle;
import org.netbeans.modules.javafx2.scenebuilder.Home;
import org.netbeans.modules.javafx2.scenebuilder.impl.SBHomeFactory;
import org.netbeans.modules.javafx2.scenebuilder.options.Bundle;
import org.netbeans.modules.javafx2.scenebuilder.options.GrowingComboBox;
import org.netbeans.modules.javafx2.scenebuilder.options.SBOptionsPanelController;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

final class SBOptionsPanel
extends JPanel {
    private final SBOptionsPanelController controller;
    private final List<HomeDef> userDefinedSBHomes = new ArrayList<HomeDef>();
    private final List<HomeDef> predefinedSBHomes = new ArrayList<HomeDef>();
    private JCheckBox saveAllModified;
    private GrowingComboBox sbHome;
    private JLabel sbHomeInfo;
    private JLabel sbHomeLabel;
    private JSeparator sep;
    private JLabel sepLabel;
    private JPanel sepPanel;

    SBOptionsPanel(SBOptionsPanelController controller) {
        this.controller = controller;
        this.initComponents();
        this.sbHome.setNullSelectionMessage(Bundle.MSG_InvalidHome());
        this.sbHome.setGrowAction(new AbstractAction(Bundle.LBL_Browse()){

            @Override
            public void actionPerformed(ActionEvent e) {
                SBOptionsPanel.this.browseAddNewRuntime();
            }
        });
        this.sbHomeInfo.setVisible(false);
    }

    private void initComponents() {
        this.sbHomeLabel = new JLabel();
        this.sbHomeInfo = new JLabel();
        this.saveAllModified = new JCheckBox();
        this.sbHome = new GrowingComboBox();
        this.sepPanel = new JPanel();
        this.sepLabel = new JLabel();
        this.sep = new JSeparator();
        this.sbHomeLabel.setLabelFor(this.sbHome);
        Mnemonics.setLocalizedText((JLabel)this.sbHomeLabel, (String)NbBundle.getMessage(SBOptionsPanel.class, (String)"SBOptionsPanel.sbHomeLabel.text"));
        this.sbHomeInfo.setFont(this.sbHomeInfo.getFont().deriveFont(this.sbHomeInfo.getFont().getStyle() | 2, this.sbHomeInfo.getFont().getSize() - 3));
        Mnemonics.setLocalizedText((JLabel)this.sbHomeInfo, (String)NbBundle.getMessage(SBOptionsPanel.class, (String)"SBOptionsPanel.sbHomeInfo.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.saveAllModified, (String)NbBundle.getMessage(SBOptionsPanel.class, (String)"SBOptionsPanel.saveAllModified.text"));
        this.saveAllModified.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SBOptionsPanel.this.saveAllModifiedActionPerformed(evt);
            }
        });
        this.sbHome.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                SBOptionsPanel.this.sbHomeItemStateChanged(evt);
            }
        });
        this.sepPanel.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((JLabel)this.sepLabel, (String)NbBundle.getMessage(SBOptionsPanel.class, (String)"SBOptionsPanel.sepLabel.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.sepPanel.add((Component)this.sepLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.sepPanel.add((Component)this.sep, gridBagConstraints);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.sepPanel, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.sbHomeLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.sbHomeInfo, -1, -1, Short.MAX_VALUE).addComponent(this.sbHome, -1, -1, Short.MAX_VALUE).addComponent(this.saveAllModified, -1, 560, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.sepPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.sbHomeLabel).addComponent(this.sbHome, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.sbHomeInfo).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.saveAllModified).addContainerGap(264, Short.MAX_VALUE)));
    }

    private void saveAllModifiedActionPerformed(ActionEvent evt) {
        this.controller.setSaveBeforeLaunch(this.saveAllModified.isSelected());
    }

    private void sbHomeItemStateChanged(ItemEvent evt) {
    }

    void load() {
        this.predefinedSBHomes.clear();
        this.userDefinedSBHomes.clear();
        Home selected = this.controller.getSbHome();
        Home defaultHome = this.controller.getDefaultSBHome();
        HomeDef hd = null;
        HomeDef selectedHd = null;
        if (defaultHome != null) {
            hd = new HomeDef(defaultHome, Bundle.LBL_Default() + " (" + defaultHome.getPath() + ")");
            if (selected != null && selected.equals(hd.home)) {
                selectedHd = hd;
            }
            this.predefinedSBHomes.add(hd);
        }
        for (Home s : this.controller.getUserDefinedHomes()) {
            hd = new HomeDef(s);
            this.userDefinedSBHomes.add(hd);
            if (selected == null || selectedHd != null || !selected.equals(hd.home)) continue;
            selectedHd = hd;
        }
        this.saveAllModified.setSelected(this.controller.isSaveBeforeLaunch());
        GrowingComboBox.GrowingListModel<HomeDef> model = this.sbHome.getModel();
        model.setPredefined(this.predefinedSBHomes);
        model.setUserDefined(this.userDefinedSBHomes);
        if (selectedHd != null) {
            model.setSelectedItem(selectedHd);
        }
    }

    void store() {
        ArrayList<Home> userDefs = new ArrayList<Home>();
        GrowingComboBox.GrowingListModel model = this.sbHome.getModel();
        for (HomeDef hd : model.getUserDefined()) {
            userDefs.add(hd.home);
        }
        this.controller.setUserDefinedHomes(userDefs);
        HomeDef selectedHome = (HomeDef)this.sbHome.getSelectedItem();
        this.controller.setSbHome(selectedHome != null ? selectedHome.home : null);
    }

    boolean valid() {
        return true;
    }

    private void browseAddNewRuntime() {
        File f;
        JFileChooser chooser = new JFileChooser();
        chooser.setDialogTitle(Bundle.LBL_BrowseSBHome());
        chooser.setFileSelectionMode(1);
        chooser.setFileHidingEnabled(false);
        String path = new File(System.getProperty("user.home")).getAbsolutePath();
        if (path.length() > 0 && (f = new File(path)).exists()) {
            chooser.setSelectedFile(f);
        }
        if (0 == chooser.showOpenDialog(this)) {
            f = chooser.getSelectedFile();
            String newRuntimePath = f.getAbsolutePath();
            Home h = SBHomeFactory.getDefault().loadHome(newRuntimePath);
            if (h != null) {
                HomeDef newHd = new HomeDef(h);
                this.sbHome.getModel().addUserDefined(newHd);
                this.sbHome.getModel().setSelectedItem(newHd);
            } else {
                NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)Bundle.MSG_InvalidSBHome(newRuntimePath), 0);
                DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)nd);
            }
        }
    }

    private class HomeDef {
        private Home home;
        private String displayname;

        public HomeDef(Home home, String displayname) {
            this.home = home;
            this.displayname = displayname;
        }

        public HomeDef(Home home) {
            this.home = home;
            this.displayname = home.getPath();
        }

        public String toString() {
            return this.displayname;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            HomeDef other = (HomeDef)obj;
            return !(this.home == null ? other.home != null : !this.home.equals(other.home));
        }

        public int hashCode() {
            int hash = 5;
            hash = 23 * hash + (this.home != null ? this.home.hashCode() : 0);
            return hash;
        }
    }
}

