/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.webservices.transport.tcp;

import com.sun.grizzly.BaseSelectionKeyHandler;
import com.sun.grizzly.Context;
import com.sun.grizzly.ProtocolFilter;
import com.sun.grizzly.SelectionKeyHandler;
import com.sun.grizzly.TCPSelectorHandler;
import com.sun.grizzly.util.ConnectionCloseHandler;
import com.sun.grizzly.util.WorkerThread;
import com.sun.logging.LogDomains;
import com.sun.xml.ws.transport.tcp.server.TCPMessageListener;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.webservices.transport.tcp.Connector;
import org.glassfish.webservices.transport.tcp.V3Module;

public class WSTCPProtocolFilter
implements ProtocolFilter {
    private static Logger logger = LogDomains.getLogger(WSTCPProtocolFilter.class, (String)"javax.enterprise.webservices");
    private volatile Connector connector;
    private final ConnectionCloseHandler closeHandler = new WSTCPConnectionCloseHandler();
    private final Object sync = new Object();
    private static final V3Module module = new V3Module();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(Context ctx) throws IOException {
        if (this.connector == null) {
            Object object = this.sync;
            synchronized (object) {
                if (this.connector == null) {
                    TCPSelectorHandler handler = (TCPSelectorHandler)ctx.getSelectorHandler();
                    String host = handler.getInet().getHostName();
                    int port = handler.getPort();
                    logger.log(Level.INFO, "Initialize SOAP/TCP protocol for port: " + port);
                    this.connector = new Connector(host, port, (TCPMessageListener)module.getDelegate());
                    SelectionKeyHandler keyHandler = handler.getSelectionKeyHandler();
                    if (keyHandler instanceof BaseSelectionKeyHandler) {
                        ((BaseSelectionKeyHandler)keyHandler).setConnectionCloseHandler(this.closeHandler);
                    }
                }
            }
        }
        ByteBuffer byteBuffer = ((WorkerThread)Thread.currentThread()).getByteBuffer();
        byteBuffer.flip();
        SocketChannel channel = (SocketChannel)ctx.getSelectionKey().channel();
        this.connector.process(byteBuffer, channel);
        return false;
    }

    public boolean postExecute(Context ctx) throws IOException {
        return true;
    }

    protected class WSTCPConnectionCloseHandler
    implements ConnectionCloseHandler {
        protected WSTCPConnectionCloseHandler() {
        }

        public void locallyClosed(SelectionKey key) {
            this.notifyConnectionClosed(key);
        }

        public void remotelyClosed(SelectionKey key) {
            this.notifyConnectionClosed(key);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void notifyConnectionClosed(SelectionKey key) {
            block7: {
                try {
                    if (WSTCPProtocolFilter.this.connector != null) {
                        WSTCPProtocolFilter.this.connector.notifyConnectionClosed((SocketChannel)key.channel());
                        break block7;
                    }
                    Object object = WSTCPProtocolFilter.this.sync;
                    synchronized (object) {
                        if (WSTCPProtocolFilter.this.connector != null) {
                            WSTCPProtocolFilter.this.connector.notifyConnectionClosed((SocketChannel)key.channel());
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }
}

