/*
 * Decompiled with CFR 0.152.
 */
package org.nbheaven.sqe.core.java.utils;

import java.util.EnumSet;
import java.util.Set;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import org.nbheaven.sqe.core.java.utils.JavaSourceProvider;
import org.nbheaven.sqe.core.java.utils.ProjectUtilities;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.openide.filesystems.FileObject;

public final class TypeUtilities {
    public static String convertTypeMirrorToBinaryRepresentation(TypeMirror typeMirror) {
        StringBuilder builder = new StringBuilder();
        switch (typeMirror.getKind()) {
            case ARRAY: {
                builder.append("[");
                return builder.append(TypeUtilities.convertTypeMirrorToBinaryRepresentation(((ArrayType)typeMirror).getComponentType())).toString();
            }
            case BOOLEAN: {
                builder.append("Z");
                break;
            }
            case BYTE: {
                builder.append("B");
                break;
            }
            case CHAR: {
                builder.append("C");
                break;
            }
            case DOUBLE: {
                builder.append("D");
                break;
            }
            case FLOAT: {
                builder.append("F");
                break;
            }
            case INT: {
                builder.append("I");
                break;
            }
            case LONG: {
                builder.append("J");
                break;
            }
            case SHORT: {
                builder.append("S");
                break;
            }
            case VOID: {
                builder.append("V");
                break;
            }
            case TYPEVAR: {
                builder.append(TypeUtilities.convertTypeMirrorToBinaryRepresentation(((TypeVariable)typeMirror).getUpperBound()));
                break;
            }
            case DECLARED: {
                builder.append("L");
                builder.append(((DeclaredType)typeMirror).asElement().toString().replaceAll("\\.", "/"));
                return builder.append(";").toString();
            }
            default: {
                builder.append("");
            }
        }
        return builder.toString();
    }

    public static JavaSourceProvider getJavaTypeElement(String findIt, Project project) {
        String outerClass = findIt;
        if (-1 != outerClass.indexOf(36)) {
            outerClass = outerClass.substring(0, outerClass.indexOf(36));
        }
        String javaClassName = outerClass.substring(outerClass.lastIndexOf(".") + 1);
        for (SourceGroup g : ProjectUtilities.getJavaSourceGroups(project)) {
            FileObject root = g.getRootFolder();
            ClasspathInfo ci = ClasspathInfo.create((ClassPath)ClassPath.getClassPath((FileObject)root, (String)"classpath/boot"), (ClassPath)ClassPath.getClassPath((FileObject)root, (String)"classpath/compile"), (ClassPath)ClassPath.getClassPath((FileObject)root, (String)"classpath/source"));
            Set declaredTypes = ci.getClassIndex().getDeclaredTypes(javaClassName, ClassIndex.NameKind.SIMPLE_NAME, EnumSet.of(ClassIndex.SearchScope.SOURCE, ClassIndex.SearchScope.DEPENDENCIES));
            for (ElementHandle typeElementHandle : declaredTypes) {
                if (!typeElementHandle.getQualifiedName().equals(outerClass)) continue;
                return new JavaSourceProvider(ci, (ElementHandle<TypeElement>)typeElementHandle);
            }
        }
        return null;
    }
}

