/*
 * Decompiled with CFR 0.152.
 */
package org.nbheaven.sqe.core.java.utils;

import java.util.EnumSet;
import java.util.Set;
import org.nbheaven.sqe.core.java.utils.ProjectUtilities;
import org.nbheaven.sqe.core.java.utils.Scope;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.filesystems.FileObject;

public class ScopeUtilities {
    private static final ClassPath EMPTY_CLASSPATH = ClassPathSupport.createClassPath((FileObject[])new FileObject[0]);

    public static Scope findScope(String fqnClassName, Project project) {
        if (ScopeUtilities.isProjectClass(fqnClassName, project)) {
            return Scope.PROJECT;
        }
        if (ScopeUtilities.isJDKClass(fqnClassName, project)) {
            return Scope.JDK;
        }
        return Scope.EXTERNAL;
    }

    public static boolean isJDKClass(String fqnClassName, Project project) {
        String outerClass = fqnClassName;
        if (-1 != outerClass.indexOf(36)) {
            outerClass = outerClass.substring(0, outerClass.indexOf(36));
        }
        String javaClassName = outerClass.substring(outerClass.lastIndexOf(".") + 1);
        for (SourceGroup g : ProjectUtilities.getJavaSourceGroups(project)) {
            ClasspathInfo ci = ClasspathInfo.create((ClassPath)ClassPath.getClassPath((FileObject)g.getRootFolder(), (String)"classpath/boot"), (ClassPath)EMPTY_CLASSPATH, (ClassPath)EMPTY_CLASSPATH);
            Set declaredTypes = ci.getClassIndex().getDeclaredTypes(javaClassName, ClassIndex.NameKind.SIMPLE_NAME, EnumSet.of(ClassIndex.SearchScope.DEPENDENCIES));
            for (ElementHandle typeElementHandle : declaredTypes) {
                if (!typeElementHandle.getQualifiedName().equals(outerClass)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean is3rdPartyClass(String fqnClassName, Project project) {
        return !ScopeUtilities.isProjectClass(fqnClassName, project) && !ScopeUtilities.isJDKClass(fqnClassName, project);
    }

    public static boolean isProjectClass(String fqnClassName, Project project) {
        String outerClass = fqnClassName;
        if (-1 != outerClass.indexOf(36)) {
            outerClass = outerClass.substring(0, outerClass.indexOf(36));
        }
        String javaClassName = outerClass.substring(outerClass.lastIndexOf(".") + 1);
        for (SourceGroup g : ProjectUtilities.getJavaSourceGroups(project)) {
            ClasspathInfo ci = ClasspathInfo.create((ClassPath)EMPTY_CLASSPATH, (ClassPath)EMPTY_CLASSPATH, (ClassPath)ClassPath.getClassPath((FileObject)g.getRootFolder(), (String)"classpath/source"));
            Set declaredTypes = ci.getClassIndex().getDeclaredTypes(javaClassName, ClassIndex.NameKind.SIMPLE_NAME, EnumSet.of(ClassIndex.SearchScope.SOURCE));
            for (ElementHandle typeElementHandle : declaredTypes) {
                if (!typeElementHandle.getQualifiedName().equals(outerClass)) continue;
                return true;
            }
        }
        return false;
    }
}

