/*
 * Decompiled with CFR 0.152.
 */
package org.nbheaven.sqe.core.java.utils;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.java.queries.BinaryForSourceQuery;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ProjectUtilities {
    private ProjectUtilities() {
    }

    public static FileObject[] getJavaSourceRoots(Project project) {
        SourceGroup[] groups = ProjectUtilities.getJavaSourceGroups(project);
        FileObject[] fileObjects = new FileObject[groups.length];
        int i = 0;
        for (SourceGroup g : groups) {
            fileObjects[i] = g.getRootFolder();
            ++i;
        }
        return fileObjects;
    }

    public static SourceGroup[] getJavaSourceGroups(Project project) {
        Sources s = ProjectUtils.getSources((Project)project);
        return s.getSourceGroups("java");
    }

    public static List<String> findBinaryRoots(Project project) {
        ArrayList<String> binaries = new ArrayList<String>();
        for (SourceGroup sg : ProjectUtilities.getJavaSourceGroups(project)) {
            try {
                for (URL url : BinaryForSourceQuery.findBinaryRoots((URL)sg.getRootFolder().getURL()).getRoots()) {
                    File checkFile = FileUtil.archiveOrDirForURL((URL)url);
                    if (checkFile == null || !checkFile.exists()) continue;
                    binaries.add(checkFile.getAbsolutePath());
                }
            }
            catch (FileStateInvalidException x) {
                Logger.getLogger(ProjectUtilities.class.getName()).log(Level.INFO, null, x);
            }
        }
        binaries.trimToSize();
        return binaries;
    }

    public static boolean areJavaSourcePackages(Node[] nodes) {
        Node node;
        boolean enable = false;
        Node[] arr$ = nodes;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$ && !(enable = ProjectUtilities.isJavaSourcePackage(node = arr$[i$])); ++i$) {
        }
        return enable;
    }

    public static boolean isJavaSourcePackage(Node node) {
        DataFolder dataFolder = (DataFolder)node.getLookup().lookup(DataFolder.class);
        if (null == dataFolder) {
            return false;
        }
        return ProjectUtilities.isJavaSourcePackage((DataObject)dataFolder);
    }

    private static boolean isJavaSourcePackage(DataObject dataObject) {
        if (null == dataObject || !(dataObject instanceof DataFolder)) {
            return false;
        }
        return ProjectUtilities.isJavaSourcePackage(dataObject.getPrimaryFile());
    }

    private static boolean isJavaSourcePackage(FileObject fileObject) {
        SourceGroup sourceGroup;
        int i$;
        if (null == fileObject) {
            return false;
        }
        Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
        if (null == project) {
            return false;
        }
        SourceGroup[] sourceGroups = ProjectUtilities.getJavaSourceGroups(project);
        boolean isPackage = false;
        SourceGroup[] arr$ = sourceGroups;
        int len$ = arr$.length;
        for (i$ = 0; i$ < len$ && !(isPackage = (sourceGroup = arr$[i$]).getRootFolder().equals(fileObject)); ++i$) {
        }
        if (!isPackage) {
            arr$ = sourceGroups;
            len$ = arr$.length;
            for (i$ = 0; i$ < len$ && !(isPackage = FileUtil.isParentOf((FileObject)(sourceGroup = arr$[i$]).getRootFolder(), (FileObject)fileObject)); ++i$) {
            }
        }
        return isPackage;
    }
}

