/*
 * Decompiled with CFR 0.152.
 */
package org.nbheaven.sqe.core.java.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.CRC32;
import org.netbeans.api.java.queries.BinaryForSourceQuery;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.util.Parameters;

public final class CompileOnSaveHelper {
    private static final Logger LOG = Logger.getLogger(CompileOnSaveHelper.class.getName());
    private static final Method getClassFolder;
    private static final Object taskCache;
    private static final Method isInError;
    private final FileObject sources;
    private final URL publicBinaries;

    private CompileOnSaveHelper(FileObject sources, URL publicBinaries) {
        assert (sources != null || publicBinaries != null);
        this.sources = sources;
        this.publicBinaries = publicBinaries;
        LOG.log(Level.FINE, "created from {0} and {1}", new Object[]{sources, publicBinaries});
    }

    public static CompileOnSaveHelper forSourceRoot(FileObject root) {
        Parameters.notNull((CharSequence)"root", (Object)root);
        try {
            URL[] binaryRoots = BinaryForSourceQuery.findBinaryRoots((URL)root.getURL()).getRoots();
            return new CompileOnSaveHelper(root, binaryRoots.length > 0 ? binaryRoots[0] : null);
        }
        catch (FileStateInvalidException x) {
            throw new IllegalArgumentException(x);
        }
    }

    public static CompileOnSaveHelper forClassPathEntry(URL entry) {
        Parameters.notNull((CharSequence)"entry", (Object)entry);
        SourceForBinaryQuery.Result2 result = SourceForBinaryQuery.findSourceRoots2((URL)entry);
        FileObject[] roots = result.getRoots();
        FileObject sources = result.preferSources() && roots.length > 0 ? roots[0] : null;
        return new CompileOnSaveHelper(sources, entry);
    }

    public URL binaryRoot(boolean tolerateErrors) throws IOException {
        File sigDir;
        if (this.sources == null) {
            return this.publicBinaries;
        }
        if (!tolerateErrors && taskCache != null && isInError != null) {
            try {
                if (((Boolean)isInError.invoke(taskCache, this.sources, true)).booleanValue()) {
                    LOG.log(Level.FINE, "skipping {0} since it is in error", this.sources);
                    return this.publicBinaries;
                }
            }
            catch (Exception x) {
                LOG.log(Level.INFO, null, x);
            }
        }
        if (this.publicBinaries != null && this.publicBinaries.getProtocol().equals("file")) {
            try {
                File tag = new File(new File(this.publicBinaries.toURI()), ".netbeans_automatic_build");
                if (tag.isFile()) {
                    LOG.log(Level.FINE, "found tag {0}", tag);
                    return this.publicBinaries;
                }
            }
            catch (URISyntaxException x) {
                LOG.log(Level.INFO, null, x);
            }
        }
        if (getClassFolder == null) {
            return this.publicBinaries;
        }
        URL sourcesURL = this.sources.getURL();
        try {
            sigDir = (File)getClassFolder.invoke(null, sourcesURL, true);
        }
        catch (Exception x) {
            throw (IOException)new IOException(x.toString()).initCause(x);
        }
        if (sigDir == null) {
            LOG.log(Level.FINE, "no sigdir for {0}", sourcesURL);
            return this.publicBinaries;
        }
        CRC32 crc = new CRC32();
        crc.update(sourcesURL.toString().getBytes("UTF-8"));
        String key = String.format("%08X", crc.getValue());
        File classDir = new File(this.getCacheDir(), key);
        LOG.log(Level.FINE, "synchronizing {0} to {1}", new Object[]{sigDir, classDir});
        CompileOnSaveHelper.copySigToClass(sigDir, classDir);
        return classDir.toURI().toURL();
    }

    private File getCacheDir() throws IOException {
        Project owner;
        File tmp = null;
        if (this.sources != null && (owner = FileOwnerQuery.getOwner((FileObject)this.sources)) != null) {
            tmp = FileUtil.toFile((FileObject)ProjectUtils.getCacheDirectory((Project)owner, CompileOnSaveHelper.class));
        }
        if (tmp == null) {
            tmp = new File(System.getProperty("netbeans.user"), "var/cache/CompileOnSaveHelper");
        }
        return new File(tmp, "CompileOnSaveHelper");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copySigToClass(File sigDir, File clazzDir) throws IOException {
        String n;
        if (!clazzDir.isDirectory() && !clazzDir.mkdirs()) {
            throw new IOException("could not create: " + clazzDir);
        }
        for (File child : clazzDir.listFiles()) {
            File orig;
            n = child.getName();
            if (!child.isFile() || !n.endsWith(".class") || (orig = new File(sigDir, n.substring(0, n.length() - 6) + ".sig")).isFile()) continue;
            LOG.log(Level.FINER, "removing {0} since {1} does not exist", new Object[]{child, orig});
            if (child.delete()) continue;
            throw new IOException("could not delete: " + child);
        }
        for (File child : sigDir.listFiles()) {
            File copy;
            n = child.getName();
            if (child.isDirectory()) {
                CompileOnSaveHelper.copySigToClass(child, new File(clazzDir, n));
                continue;
            }
            if (!n.endsWith(".sig") || (copy = new File(clazzDir, n.substring(0, n.length() - 4) + ".class")).lastModified() > child.lastModified()) continue;
            LOG.log(Level.FINER, "copying {0} to {1}", new Object[]{child, copy});
            try {
                FileInputStream is = new FileInputStream(child);
                try {
                    FileOutputStream os = new FileOutputStream(copy);
                    try {
                        FileUtil.copy((InputStream)is, (OutputStream)os);
                    }
                    finally {
                        ((OutputStream)os).close();
                    }
                }
                finally {
                    ((InputStream)is).close();
                }
            }
            catch (IOException x) {
                throw (IOException)new IOException("could not copy " + child + " to " + copy + ": " + x).initCause(x);
            }
        }
    }

    static {
        ClassLoader loader = JavaSource.class.getClassLoader();
        Method _getClassFolder = null;
        Object _taskCache = null;
        Method _isInError = null;
        try {
            Class<?> taskCacheClass;
            _getClassFolder = Class.forName("org.netbeans.modules.java.source.indexing.JavaIndex", true, loader).getMethod("getClassFolder", URL.class, Boolean.TYPE);
            try {
                taskCacheClass = Class.forName("org.netbeans.modules.parsing.impl.indexing.errors.TaskCache", true, loader);
            }
            catch (ClassNotFoundException x) {
                taskCacheClass = Class.forName("org.netbeans.modules.java.source.tasklist.TaskCache", true, loader);
            }
            _taskCache = taskCacheClass.getMethod("getDefault", new Class[0]).invoke(null, new Object[0]);
            _isInError = taskCacheClass.getMethod("isInError", FileObject.class, Boolean.TYPE);
        }
        catch (Exception x) {
            LOG.log(Level.INFO, null, x);
        }
        getClassFolder = _getClassFolder;
        taskCache = _taskCache;
        isInError = _isInError;
    }
}

