/*
 * Decompiled with CFR 0.152.
 */
package org.nbheaven.sqe.core.java.search.impl;

import com.sun.source.tree.MethodTree;
import com.sun.source.util.TreePath;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import org.nbheaven.sqe.core.java.search.MethodElementDescriptor;
import org.nbheaven.sqe.core.java.search.impl.SearchClassVisitor;
import org.nbheaven.sqe.core.java.utils.TypeUtilities;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.TreePathHandle;

public class SearchMethodVisitor
extends SearchClassVisitor {
    private MethodElementDescriptor descriptor;

    public SearchMethodVisitor(CompilationInfo info, MethodElementDescriptor descriptor) {
        super(info, descriptor.getClassElementDescriptor());
        this.descriptor = descriptor;
    }

    private boolean checkMethod(MethodTree methodTree) {
        Element el;
        if (methodTree.getName().contentEquals(this.descriptor.getName()) && ((el = TreePathHandle.create((TreePath)this.getCurrentPath(), (CompilationInfo)this.getInfo()).resolveElement(this.getInfo())).getKind().equals((Object)ElementKind.METHOD) || el.getKind().equals((Object)ElementKind.CONSTRUCTOR))) {
            ExecutableElement method = (ExecutableElement)TreePathHandle.create((TreePath)this.getCurrentPath(), (CompilationInfo)this.getInfo()).resolveElement(this.getInfo());
            StringBuilder builder = new StringBuilder("(");
            for (VariableElement variableElement : method.getParameters()) {
                builder.append(TypeUtilities.convertTypeMirrorToBinaryRepresentation(variableElement.asType()));
            }
            builder.append(")");
            builder.append(TypeUtilities.convertTypeMirrorToBinaryRepresentation(method.getReturnType()));
            if (this.descriptor.getSignature().equals(builder.toString())) {
                return true;
            }
        }
        return false;
    }

    boolean needsFurtherVisiting() {
        return true;
    }

    public TreePathHandle visitMethod(MethodTree methodTree, Void voidArg) {
        if (this.isInScope()) {
            if (this.checkMethod(methodTree)) {
                this.setHandleFound(TreePathHandle.create((TreePath)this.getCurrentPath(), (CompilationInfo)this.getInfo()));
            }
            return this.getHandleFound();
        }
        TreePathHandle handle = (TreePathHandle)super.visitMethod(methodTree, voidArg);
        return handle;
    }
}

