/*
 * Decompiled with CFR 0.152.
 */
package org.nbheaven.sqe.core.java.search.impl;

import com.sun.source.tree.ClassTree;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreePathScanner;
import org.nbheaven.sqe.core.java.search.ClassElementDescriptor;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.TreePathHandle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchClassVisitor
extends TreePathScanner<TreePathHandle, Void> {
    private final CompilationInfo info;
    private final ClassElementDescriptor classElementDescriptor;
    private String[] classNameParts;
    private String actualName;
    private int classLevel = 0;
    private boolean inScope = false;
    private boolean anonymousMode = false;
    private int anonymousInnerCount = 0;
    private int anonymousInnerNumber = 0;
    private TreePathHandle handleFound;

    public SearchClassVisitor(CompilationInfo info, ClassElementDescriptor classElementDescriptor) {
        this.classElementDescriptor = classElementDescriptor;
        this.info = info;
        this.init();
    }

    private void init() {
        this.classNameParts = this.classElementDescriptor.getFQNClassName().split("[.$]");
        this.actualName = this.classNameParts[0];
    }

    private State advanceDepth() {
        if (this.classLevel == this.classNameParts.length - 1) {
            this.inScope = true;
            return State.FINISHED;
        }
        ++this.classLevel;
        this.actualName = this.classNameParts[this.classLevel];
        if (this.actualName.matches("\\d+")) {
            this.anonymousMode = true;
            this.anonymousInnerNumber = Integer.parseInt(this.actualName);
            this.anonymousInnerCount = 0;
        } else {
            this.anonymousMode = false;
        }
        return State.CONTINUE;
    }

    private State checkClass(ClassTree classTree) {
        if (this.anonymousMode) {
            ++this.anonymousInnerCount;
            if (this.anonymousInnerCount == this.anonymousInnerNumber) {
                return this.advanceDepth();
            }
        } else if (classTree.getSimpleName().contentEquals(this.actualName)) {
            return this.advanceDepth();
        }
        return State.DEAD_END;
    }

    boolean isInScope() {
        return this.inScope;
    }

    CompilationInfo getInfo() {
        return this.info;
    }

    void setHandleFound(TreePathHandle handleFound) {
        if (null == handleFound) {
            throw new IllegalArgumentException("Bad TreePathHandle - null is not an allowed value");
        }
        this.handleFound = handleFound;
    }

    TreePathHandle getHandleFound() {
        return this.handleFound;
    }

    boolean needsFurtherVisiting() {
        return false;
    }

    @Override
    public TreePathHandle visitClass(ClassTree classTree, Void arg1) {
        switch (this.checkClass(classTree)) {
            case CONTINUE: {
                return (TreePathHandle)super.visitClass(classTree, arg1);
            }
            case FINISHED: {
                this.setHandleFound(TreePathHandle.create((TreePath)this.getCurrentPath(), (CompilationInfo)this.info));
                if (this.needsFurtherVisiting()) {
                    TreePathHandle superHandle = (TreePathHandle)super.visitClass(classTree, arg1);
                    return null != superHandle ? superHandle : this.getHandleFound();
                }
                return this.getHandleFound();
            }
            case DEAD_END: {
                return this.getHandleFound();
            }
        }
        throw new IllegalStateException("Bad traversal state");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum State {
        DEAD_END,
        FINISHED,
        CONTINUE;

    }
}

