/*
 * Decompiled with CFR 0.152.
 */
package org.nbheaven.sqe.core.java.search.impl;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePathScanner;
import java.awt.EventQueue;
import java.io.IOException;
import javax.lang.model.element.Element;
import javax.swing.text.StyledDocument;
import org.nbheaven.sqe.core.java.search.ElementDescriptor;
import org.nbheaven.sqe.core.java.search.JavaElement;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.ui.ElementOpen;
import org.openide.ErrorManager;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.LineCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.Line;
import org.openide.text.NbDocument;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JavaElementImpl
implements JavaElement {
    private final FileObject fileObject;
    private final ElementHandle<?> elementHandle;
    private int beginColumn = -1;
    private int endColumn = -1;

    public JavaElementImpl(ElementDescriptor elementDescriptor, ElementHandle<?> elementHandle) {
        if (null == elementHandle) {
            throw new IllegalArgumentException("Null ElementHandle not supported for JavaElementImpl, ensure it is set for <" + String.valueOf(elementDescriptor) + ">!");
        }
        this.fileObject = elementDescriptor.getSourceProvider().getFileObject();
        this.elementHandle = elementHandle;
    }

    @Override
    public void open() {
        if (null != this.fileObject && null != this.elementHandle) {
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    ElementOpen.open((FileObject)JavaElementImpl.this.fileObject, (ElementHandle)JavaElementImpl.this.elementHandle);
                }
            });
        }
    }

    @Override
    public int getBeginColumn() {
        return this.beginColumn;
    }

    @Override
    public int getEndColumn() {
        return this.endColumn;
    }

    @Override
    public Line getLine() {
        try {
            StyledDocument doc;
            DataObject dao = DataObject.find((FileObject)this.fileObject);
            EditorCookie editorCookie = (EditorCookie)dao.getLookup().lookup(EditorCookie.class);
            LineCookie lineCookie = (LineCookie)dao.getLookup().lookup(LineCookie.class);
            int[] offset = this.getOffset();
            int startOffset = offset[0];
            int endOffset = offset[1];
            if (editorCookie != null && lineCookie != null && startOffset != -1 && (doc = editorCookie.openDocument()) != null) {
                int line = NbDocument.findLineNumber((StyledDocument)doc, (int)startOffset);
                int lineOffset = NbDocument.findLineOffset((StyledDocument)doc, (int)line);
                this.beginColumn = startOffset - lineOffset;
                if (endOffset != -1) {
                    int lineEnd = NbDocument.findLineNumber((StyledDocument)doc, (int)endOffset);
                    int lineOffsetEnd = NbDocument.findLineOffset((StyledDocument)doc, (int)lineEnd);
                    this.endColumn = endOffset - lineOffsetEnd;
                }
                if (line != -1) {
                    return lineCookie.getLineSet().getCurrent(line);
                }
            }
        }
        catch (DataObjectNotFoundException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return null;
        }
        catch (IOException ioe) {
            Exceptions.printStackTrace((Throwable)ioe);
            return null;
        }
        return null;
    }

    private int[] getOffset() throws IOException {
        final int[] result = new int[]{-1, -1};
        JavaSource js = JavaSource.forFileObject((FileObject)this.fileObject);
        if (js != null) {
            js.runUserActionTask((Task)new Task<CompilationController>(){

                public void run(CompilationController info) {
                    try {
                        info.toPhase(JavaSource.Phase.RESOLVED);
                    }
                    catch (IOException ioe) {
                        Exceptions.printStackTrace((Throwable)ioe);
                    }
                    Element el = JavaElementImpl.this.elementHandle.resolve((CompilationInfo)info);
                    if (el == null) {
                        ErrorManager.getDefault().log(65536, "Cannot resolve " + JavaElementImpl.this.elementHandle + ". " + info.getClasspathInfo());
                        return;
                    }
                    FindDeclarationVisitor v = new FindDeclarationVisitor(el, (CompilationInfo)info);
                    CompilationUnitTree cu = info.getCompilationUnit();
                    v.scan(cu, null);
                    Tree elTree = v.declTree;
                    if (elTree != null) {
                        result[0] = (int)info.getTrees().getSourcePositions().getStartPosition(cu, elTree);
                    }
                    result[1] = (int)info.getTrees().getSourcePositions().getEndPosition(cu, elTree);
                }
            }, true);
        }
        return result;
    }

    @Override
    public ElementHandle<?> getHandle() {
        return this.elementHandle;
    }

    public String toString() {
        return this.elementHandle + " in " + this.fileObject;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FindDeclarationVisitor
    extends TreePathScanner<Void, Void> {
        private Element element;
        private Tree declTree;
        private CompilationInfo info;

        public FindDeclarationVisitor(Element element, CompilationInfo info) {
            this.element = element;
            this.info = info;
        }

        @Override
        public Void visitClass(ClassTree tree, Void d) {
            this.handleDeclaration();
            super.visitClass(tree, d);
            return null;
        }

        @Override
        public Void visitMethod(MethodTree tree, Void d) {
            this.handleDeclaration();
            super.visitMethod(tree, d);
            return null;
        }

        @Override
        public Void visitVariable(VariableTree tree, Void d) {
            this.handleDeclaration();
            super.visitVariable(tree, d);
            return null;
        }

        public void handleDeclaration() {
            Element found = this.info.getTrees().getElement(this.getCurrentPath());
            if (((Object)this.element).equals(found)) {
                this.declTree = this.getCurrentPath().getLeaf();
            }
        }
    }
}

