/*
 * Decompiled with CFR 0.152.
 */
package org.nbheaven.sqe.core.java.search;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.util.TreePathScanner;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import org.nbheaven.sqe.core.java.search.ClassElementDescriptor;
import org.nbheaven.sqe.core.java.search.ElementDescriptor;
import org.nbheaven.sqe.core.java.search.JavaElement;
import org.nbheaven.sqe.core.java.search.MethodElementDescriptor;
import org.nbheaven.sqe.core.java.search.VariableElementDescriptor;
import org.nbheaven.sqe.core.java.search.impl.JavaElementImpl;
import org.nbheaven.sqe.core.java.search.impl.SearchClassVisitor;
import org.nbheaven.sqe.core.java.search.impl.SearchMethodVisitor;
import org.nbheaven.sqe.core.java.search.impl.SearchVariableVisitor;
import org.nbheaven.sqe.core.java.utils.JavaSourceProvider;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreePathHandle;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SearchUtilities {
    private SearchUtilities() {
    }

    public static JavaElement findClassElement(final ClassElementDescriptor descriptor) {
        return new Searcher(){

            @Override
            protected TreePathScanner<TreePathHandle, Void> makeVisitor(CompilationController controller) {
                return new SearchClassVisitor((CompilationInfo)controller, descriptor);
            }
        }.findElement(descriptor);
    }

    public static JavaElement findMethodElement(final MethodElementDescriptor descriptor) {
        return new Searcher(){

            @Override
            protected TreePathScanner<TreePathHandle, Void> makeVisitor(CompilationController controller) {
                return new SearchMethodVisitor((CompilationInfo)controller, descriptor);
            }
        }.findElement(descriptor);
    }

    public static JavaElement findVariableElement(final VariableElementDescriptor descriptor) {
        return new Searcher(){

            @Override
            protected TreePathScanner<TreePathHandle, Void> makeVisitor(CompilationController controller) {
                return new SearchVariableVisitor((CompilationInfo)controller, descriptor);
            }
        }.findElement(descriptor);
    }

    public static Collection<String> getFQNClassNames(FileObject fo) {
        if (fo == null || !fo.isValid() || fo.isVirtual()) {
            return Collections.emptyList();
        }
        JavaSource js = JavaSource.forFileObject((FileObject)fo);
        if (js == null) {
            return Collections.emptyList();
        }
        try {
            final ArrayList<String> result = new ArrayList<String>();
            js.runUserActionTask((Task)new CancellableTask<CompilationController>(){

                public void run(CompilationController control) throws Exception {
                    if (control.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED).compareTo((Enum)JavaSource.Phase.ELEMENTS_RESOLVED) >= 0) {
                        ClassVisitor visitor = new ClassVisitor((CompilationInfo)control);
                        visitor.scan(control.getCompilationUnit(), null);
                        result.addAll(visitor.getClassNames());
                    }
                }

                public void cancel() {
                }
            }, true);
            return result;
        }
        catch (IOException ioe) {
            Exceptions.printStackTrace((Throwable)ioe);
            return Collections.emptyList();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ClassVisitor
    extends TreePathScanner<Void, NameDesc> {
        private String packageName;
        private Collection<String> classNames;

        public ClassVisitor(CompilationInfo info) {
            ExpressionTree packageNameTree = info.getCompilationUnit().getPackageName();
            if (null != packageNameTree) {
                this.packageName = packageNameTree.toString();
            }
            this.classNames = new ArrayList<String>();
        }

        @Override
        public Void visitClass(ClassTree t, NameDesc name) {
            if (null == name) {
                name = new NameDesc(t.getSimpleName().toString());
            } else if (!t.getSimpleName().contentEquals("")) {
                name = new NameDesc(name.name + "$" + t.getSimpleName().toString());
            }
            this.classNames.add(null != this.packageName ? this.packageName + "." + name.name : name.name);
            return (Void)super.visitClass(t, name);
        }

        @Override
        public Void visitNewClass(NewClassTree newClassTree, NameDesc name) {
            ++name.inner;
            name = new NameDesc(name.name + "$" + String.valueOf(name.inner));
            return (Void)super.visitNewClass(newClassTree, name);
        }

        private Collection<String> getClassNames() {
            return this.classNames;
        }
    }

    private static class NameDesc {
        String name = "";
        int inner = 0;

        public NameDesc(String name) {
            this.name = name;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class Searcher
    implements CancellableTask<CompilationController> {
        private ElementHandle<?> elementHandle;

        private Searcher() {
        }

        protected abstract TreePathScanner<TreePathHandle, Void> makeVisitor(CompilationController var1);

        public JavaElement findElement(ElementDescriptor descriptor) {
            if (descriptor == null) {
                return null;
            }
            JavaSourceProvider sourceProvider = descriptor.getSourceProvider();
            if (sourceProvider == null) {
                return null;
            }
            FileObject fileObject = sourceProvider.getFileObject();
            if (fileObject == null) {
                return null;
            }
            try {
                JavaSource javaSource = JavaSource.forFileObject((FileObject)fileObject);
                if (javaSource == null) {
                    return null;
                }
                javaSource.runUserActionTask((Task)this, false);
                if (this.elementHandle != null) {
                    return new JavaElementImpl(descriptor, this.elementHandle);
                }
            }
            catch (IOException e) {
                Logger.getLogger(SearchUtilities.class.getName()).log(Level.INFO, "Bad search for class element", e);
            }
            return null;
        }

        public final void run(CompilationController controller) throws Exception {
            Element element;
            controller.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
            TreePathHandle handle = this.makeVisitor(controller).scan(controller.getCompilationUnit(), null);
            if (handle != null && (element = handle.resolveElement((CompilationInfo)controller)) != null) {
                this.elementHandle = ElementHandle.create((Element)element);
            }
        }

        public final void cancel() {
        }
    }
}

