/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.projects;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePath;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Future;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.StyledDocument;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.jpda.CallStackFrame;
import org.netbeans.api.debugger.jpda.InvalidExpressionException;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.api.debugger.jpda.ObjectVariable;
import org.netbeans.api.debugger.jpda.Super;
import org.netbeans.api.debugger.jpda.This;
import org.netbeans.api.debugger.jpda.Variable;
import org.netbeans.api.java.source.Comment;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.ElementUtilities;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.EditorUI;
import org.netbeans.editor.PopupManager;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.debugger.jpda.projects.ToolTipView;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.spi.debugger.jpda.EditorContext;
import org.netbeans.spi.debugger.ui.EditorContextDispatcher;
import org.openide.cookies.EditorCookie;
import org.openide.loaders.DataObject;
import org.openide.text.Annotation;
import org.openide.text.DataEditorSupport;
import org.openide.text.Line;
import org.openide.text.NbDocument;
import org.openide.util.RequestProcessor;

public class ToolTipAnnotation
extends Annotation
implements Runnable {
    private static final int TO_STRING_LENGTH_LIMIT = 10000;
    private static final Set<String> JAVA_KEYWORDS = new HashSet<String>(Arrays.asList("abstract", "continue", "for", "new", "switch", "assert", "default", "goto", "package", "synchronized", "boolean", "do", "if", "private", "break", "double", "implements", "protected", "throw", "byte", "else", "import", "public", "throws", "case", "enum", "instanceof", "return", "transient", "catch", "extends", "int", "short", "try", "char", "final", "interface", "static", "void", "finally", "long", "strictfp", "volatile", "const", "float", "native", "super", "while"));
    private Line.Part lp;
    private EditorCookie ec;

    public String getShortDescription() {
        if ("true".equals(System.getProperty("org.netbeans.modules.debugger.jpda.doNotShowTooltips"))) {
            return null;
        }
        DebuggerEngine currentEngine = DebuggerManager.getDebuggerManager().getCurrentEngine();
        if (currentEngine == null) {
            return null;
        }
        JPDADebugger d = (JPDADebugger)currentEngine.lookupFirst(null, JPDADebugger.class);
        if (d == null) {
            return null;
        }
        Line.Part lp = (Line.Part)this.getAttachedAnnotatable();
        if (lp == null) {
            return null;
        }
        Line line = lp.getLine();
        DataObject dob = DataEditorSupport.findDataObject((Line)line);
        if (dob == null) {
            return null;
        }
        EditorCookie ec = (EditorCookie)dob.getCookie(EditorCookie.class);
        if (ec == null) {
            return null;
        }
        this.lp = lp;
        this.ec = ec;
        RequestProcessor rp = (RequestProcessor)currentEngine.lookupFirst(null, RequestProcessor.class);
        if (rp == null) {
            rp = RequestProcessor.getDefault();
        }
        rp.post((Runnable)this);
        return null;
    }

    @Override
    public void run() {
        String toolTipText;
        String expression;
        JEditorPane ep;
        ObjectVariable tooltipVariable;
        block23: {
            StyledDocument doc;
            tooltipVariable = null;
            if (this.lp == null || this.ec == null) {
                return;
            }
            try {
                doc = this.ec.openDocument();
            }
            catch (IOException ex) {
                return;
            }
            ep = EditorContextDispatcher.getDefault().getMostRecentEditor();
            if (ep == null || ep.getDocument() != doc) {
                return;
            }
            DebuggerEngine currentEngine = DebuggerManager.getDebuggerManager().getCurrentEngine();
            if (currentEngine == null) {
                return;
            }
            JPDADebugger d = (JPDADebugger)currentEngine.lookupFirst(null, JPDADebugger.class);
            if (d == null) {
                return;
            }
            JPDAThread t = d.getCurrentThread();
            if (t == null || !t.isSuspended()) {
                return;
            }
            boolean[] isMethodPtr = new boolean[]{false};
            int offset = NbDocument.findLineOffset((StyledDocument)doc, (int)this.lp.getLine().getLineNumber()) + this.lp.getColumn();
            expression = ToolTipAnnotation.getIdentifier(d, doc, ep, offset, isMethodPtr);
            if (expression == null) {
                return;
            }
            toolTipText = null;
            try {
                Variable v = null;
                List operations = t.getLastOperations();
                if (operations != null) {
                    for (EditorContext.Operation operation : operations) {
                        if (!expression.endsWith(operation.getMethodName()) || operation.getMethodStartPosition().getOffset() > offset || offset > operation.getMethodEndPosition().getOffset()) continue;
                        v = operation.getReturnValue();
                    }
                }
                if (v == null) {
                    if (isMethodPtr[0]) {
                        return;
                    }
                    v = d.evaluate(expression);
                }
                if (v == null) {
                    return;
                }
                String type = v.getType();
                if (v instanceof ObjectVariable) {
                    tooltipVariable = (ObjectVariable)v;
                    try {
                        String toString = null;
                        try {
                            Method toStringMethod = v.getClass().getMethod("getToStringValue", Integer.TYPE);
                            toStringMethod.setAccessible(true);
                            toString = (String)toStringMethod.invoke((Object)v, 10000);
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                        if (toString == null) {
                            toString = ((ObjectVariable)v).getToStringValue();
                        }
                        toolTipText = expression + " = " + (type.length() == 0 ? "" : "(" + type + ") ") + toString;
                    }
                    catch (InvalidExpressionException ex) {
                        toolTipText = expression + " = " + (type.length() == 0 ? "" : "(" + type + ") ") + v.getValue();
                    }
                    break block23;
                }
                toolTipText = expression + " = " + (type.length() == 0 ? "" : "(" + type + ") ") + v.getValue();
            }
            catch (InvalidExpressionException e) {
                String typeName = this.resolveTypeName(offset, doc);
                toolTipText = typeName != null ? typeName : expression + " = >" + e.getMessage() + "<";
            }
        }
        if (tooltipVariable != null) {
            final ObjectVariable var = tooltipVariable;
            final String toolTip = toolTipText;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    final ToolTipView.ExpandableTooltip et = ToolTipView.createExpandableTooltip(toolTip);
                    et.addExpansionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            et.setBorder(BorderFactory.createLineBorder(et.getForeground()));
                            et.removeAll();
                            et.setWidthCheck(false);
                            final ToolTipView ttView = ToolTipView.getToolTipView(expression, var);
                            et.add(ttView);
                            et.revalidate();
                            et.repaint();
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    EditorUI eui = Utilities.getEditorUI((JTextComponent)ep);
                                    if (eui != null) {
                                        ttView.setToolTipSupport(eui.getToolTipSupport());
                                        eui.getToolTipSupport().setToolTip((JComponent)et, PopupManager.ViewPortBounds, PopupManager.AbovePreferred, 0, 0, 4);
                                    } else {
                                        ToolTipAnnotation.this.firePropertyChange("shortDescription", null, toolTip);
                                    }
                                }
                            });
                        }
                    });
                    EditorUI eui = Utilities.getEditorUI((JTextComponent)ep);
                    if (eui != null) {
                        eui.getToolTipSupport().setToolTip((JComponent)et);
                    } else {
                        ToolTipAnnotation.this.firePropertyChange("shortDescription", null, toolTip);
                    }
                }
            });
        } else {
            this.firePropertyChange("shortDescription", null, toolTipText);
        }
    }

    public String getAnnotationType() {
        return null;
    }

    private static String getIdentifier(JPDADebugger debugger, StyledDocument doc, JEditorPane ep, int offset, boolean[] isMethodPtr) {
        String t = null;
        if (ep.getSelectionStart() <= offset && offset <= ep.getSelectionEnd()) {
            t = ep.getSelectedText();
        }
        if (t != null) {
            return t;
        }
        int line = NbDocument.findLineNumber((StyledDocument)doc, (int)offset);
        int col = NbDocument.findLineColumn((StyledDocument)doc, (int)offset);
        try {
            int identEnd;
            int identStart;
            Element lineElem = NbDocument.findLineRootElement((StyledDocument)doc).getElement(line);
            if (lineElem == null) {
                return null;
            }
            int lineStartOffset = lineElem.getStartOffset();
            int lineLen = lineElem.getEndOffset() - lineStartOffset;
            t = doc.getText(lineStartOffset, lineLen);
            for (identStart = col; identStart > 0 && (Character.isJavaIdentifierPart(t.charAt(identStart - 1)) || t.charAt(identStart - 1) == '.'); --identStart) {
            }
            for (identEnd = col; identEnd < lineLen && Character.isJavaIdentifierPart(t.charAt(identEnd)); ++identEnd) {
            }
            if (identStart == identEnd) {
                return null;
            }
            int newOffset = NbDocument.findLineOffset((StyledDocument)doc, (int)line) + identStart + 1;
            if (!ToolTipAnnotation.isValidTooltipLocation(debugger, doc, newOffset)) {
                return null;
            }
            String ident = t.substring(identStart, identEnd);
            if (JAVA_KEYWORDS.contains(ident)) {
                return null;
            }
            while (identEnd < lineLen && Character.isWhitespace(t.charAt(identEnd))) {
                ++identEnd;
            }
            if (identEnd < lineLen && t.charAt(identEnd) == '(') {
                isMethodPtr[0] = true;
            }
            return ident;
        }
        catch (BadLocationException e) {
            return null;
        }
    }

    private static boolean isValidTooltipLocation(JPDADebugger debugger, final StyledDocument doc, final int offset) {
        CallStackFrame currentFrame = debugger.getCurrentCallStackFrame();
        if (currentFrame == null) {
            return false;
        }
        final boolean[] isValid = new boolean[]{true};
        final String[] className = new String[]{""};
        Future parsingTask = null;
        try {
            parsingTask = ParserManager.parseWhenScanFinished(Collections.singleton(Source.create((Document)doc)), (UserTask)new UserTask(){

                public void run(ResultIterator resultIterator) throws Exception {
                    ExpressionTree packgTree;
                    Parser.Result res = resultIterator.getParserResult(offset);
                    if (res == null) {
                        return;
                    }
                    CompilationController controller = CompilationController.get((Parser.Result)res);
                    if (controller == null || controller.toPhase(JavaSource.Phase.RESOLVED).compareTo((Enum)JavaSource.Phase.RESOLVED) < 0) {
                        return;
                    }
                    TreeUtilities treeUtilities = controller.getTreeUtilities();
                    SourcePositions positions = controller.getTrees().getSourcePositions();
                    TreePath mainPath = treeUtilities.pathFor(offset);
                    CompilationUnitTree unitTree = controller.getCompilationUnit();
                    if ((long)offset >= positions.getStartPosition(unitTree, packgTree = unitTree.getPackageName()) && (long)offset <= positions.getEndPosition(unitTree, packgTree)) {
                        isValid[0] = false;
                        return;
                    }
                    Tree tree = mainPath.getLeaf();
                    Tree.Kind kind = tree.getKind();
                    if (kind == Tree.Kind.STRING_LITERAL) {
                        isValid[0] = false;
                        return;
                    }
                    int startPos = (int)positions.getStartPosition(unitTree, tree);
                    int endPos = (int)positions.getEndPosition(unitTree, tree);
                    int startLine = Utilities.getLineOffset((BaseDocument)((BaseDocument)doc), (int)startPos);
                    int endLine = Utilities.getLineOffset((BaseDocument)((BaseDocument)doc), (int)endPos);
                    int line = Utilities.getLineOffset((BaseDocument)((BaseDocument)doc), (int)offset);
                    if (kind != Tree.Kind.VARIABLE && (startLine != line || endLine != line)) {
                        isValid[0] = false;
                        return;
                    }
                    for (Comment comm : treeUtilities.getComments(tree, true)) {
                        if (comm.pos() < 0 || comm.pos() > offset || offset > comm.endPos()) continue;
                        isValid[0] = false;
                        return;
                    }
                    for (Comment comm : treeUtilities.getComments(tree, false)) {
                        if (comm.pos() < 0 || comm.pos() > offset || offset > comm.endPos()) continue;
                        isValid[0] = false;
                        return;
                    }
                    for (TreePath path = mainPath; path != null; path = path.getParentPath()) {
                        tree = path.getLeaf();
                        kind = tree.getKind();
                        if (kind == Tree.Kind.IMPORT) {
                            isValid[0] = false;
                            return;
                        }
                        if (!TreeUtilities.CLASS_TREE_KINDS.contains((Object)kind) || className[0].length() != 0) continue;
                        TypeElement typeElement = (TypeElement)controller.getTrees().getElement(path);
                        className[0] = ElementUtilities.getBinaryName((TypeElement)typeElement);
                    }
                }
            });
        }
        catch (ParseException ex) {
            return false;
        }
        parsingTask.cancel(false);
        if (!isValid[0]) {
            return false;
        }
        if (className[0].length() > 0) {
            HashSet<String> superTypeNames = new HashSet<String>();
            This thisVar = currentFrame.getThisVariable();
            if (thisVar != null) {
                String fqn = thisVar.getType();
                ToolTipAnnotation.addClassNames(fqn, superTypeNames);
                for (Super superTypeVar = thisVar.getSuper(); superTypeVar != null; superTypeVar = superTypeVar.getSuper()) {
                    fqn = superTypeVar.getType();
                    superTypeNames.add(fqn);
                }
            } else {
                ToolTipAnnotation.addClassNames(currentFrame.getClassName(), superTypeNames);
            }
            if (!superTypeNames.contains(className[0])) {
                return false;
            }
        }
        return true;
    }

    private static void addClassNames(String fqn, Set<String> typeNames) {
        int i;
        do {
            typeNames.add(fqn);
        } while ((fqn = (i = fqn.lastIndexOf(36)) > 0 ? fqn.substring(0, i) : null) != null);
    }

    private String resolveTypeName(final int offset, Document doc) {
        final String[] result = new String[]{null};
        try {
            ParserManager.parse(Collections.singleton(Source.create((Document)doc)), (UserTask)new UserTask(){

                public void run(ResultIterator resultIterator) throws Exception {
                    Parser.Result res = resultIterator.getParserResult(offset);
                    if (res == null) {
                        return;
                    }
                    CompilationController controller = CompilationController.get((Parser.Result)res);
                    if (controller == null || controller.toPhase(JavaSource.Phase.RESOLVED).compareTo((Enum)JavaSource.Phase.RESOLVED) < 0) {
                        return;
                    }
                    TreePath path = controller.getTreeUtilities().pathFor(offset);
                    javax.lang.model.element.Element elem = controller.getTrees().getElement(path);
                    ElementKind kind = elem.getKind();
                    if (kind == ElementKind.CLASS || kind == ElementKind.ENUM || kind == ElementKind.ANNOTATION_TYPE) {
                        result[0] = ((Object)elem.asType()).toString();
                    }
                }
            });
        }
        catch (ParseException ex) {
            // empty catch block
        }
        return result[0];
    }
}

