/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.palette;

import java.awt.Component;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.MenuComponent;
import java.beans.BeanDescriptor;
import java.beans.BeanInfo;
import java.util.Collections;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.border.Border;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.modules.form.FormUtils;
import org.netbeans.modules.form.RADComponent;
import org.netbeans.modules.form.palette.BoxFillerInitializer;
import org.netbeans.modules.form.palette.ChooseBeanInitializer;
import org.netbeans.modules.form.palette.PaletteItemDataObject;
import org.netbeans.modules.form.palette.PaletteUtils;
import org.netbeans.modules.form.project.ClassPathUtils;
import org.netbeans.modules.form.project.ClassSource;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Node;

public final class PaletteItem
implements Node.Cookie {
    public static final String TYPE_CHOOSE_BEAN = "chooseBean";
    private PaletteItemDataObject itemDataObject;
    ClassSource componentClassSource;
    String componentType_explicit;
    Image icon;
    private FileObject cpRepresentative;
    private String componentInitializerId;
    private ComponentInitializer componentInitializer;
    private Class componentClass;
    private Throwable lastError;
    private int componentType = -1;
    private static final int LAYOUT = 1;
    private static final int BORDER = 2;
    private static final int VISUAL = 4;
    private static final int MENU = 8;
    private static final int TYPE_MASK = 15;

    PaletteItem(PaletteItemDataObject dobj) {
        this.itemDataObject = dobj;
    }

    public PaletteItem(ClassSource componentClassSource, Class componentClass) {
        this.componentClassSource = componentClassSource;
        this.componentClass = componentClass;
    }

    public void setComponentClassSource(ClassSource cs) {
        this.componentClass = null;
        this.lastError = null;
        this.componentType = -1;
        this.componentClassSource = cs;
    }

    void setComponentExplicitType(String type) {
        this.componentType_explicit = type;
    }

    void setComponentInitializerId(String initializerId) {
        this.componentInitializerId = initializerId;
        if (initializerId == null) {
            this.componentInitializer = null;
        }
    }

    String getComponentInitializerId() {
        return this.componentInitializerId;
    }

    void setClassFromCurrentProject(String className, FileObject fileInProject) {
        int index;
        String typeParameters = null;
        if (className != null && (index = className.indexOf(60)) != -1) {
            typeParameters = className.substring(index);
            className = className.substring(0, index);
        }
        this.setComponentClassSource(new ClassSource(className == null ? null : className.trim(), Collections.EMPTY_LIST, typeParameters));
        this.cpRepresentative = fileInProject;
    }

    public Node getNode() {
        return this.itemDataObject == null || !this.itemDataObject.isValid() ? null : this.itemDataObject.getNodeDelegate();
    }

    public String getId() {
        return this.getComponentClassName();
    }

    public String getComponentClassName() {
        return this.componentClassSource.getClassName();
    }

    public ClassSource getComponentClassSource() {
        return this.componentClassSource;
    }

    public Class getComponentClass() {
        if (this.componentClass == null && this.lastError == null) {
            this.componentClass = this.loadComponentClass();
        }
        return this.componentClass;
    }

    public Throwable getError() {
        return this.lastError;
    }

    public String getExplicitComponentType() {
        return this.componentType_explicit;
    }

    public boolean prepareComponentInitializer(FileObject classPathRep) {
        this.componentInitializer = null;
        if (this.componentInitializerId != null) {
            if (this.componentInitializerId.startsWith("Box.Filler")) {
                this.componentInitializer = new BoxFillerInitializer();
            } else if (this.componentInitializerId.equals(TYPE_CHOOSE_BEAN)) {
                this.componentInitializer = new ChooseBeanInitializer();
            }
        }
        if (this.componentInitializer != null) {
            return this.componentInitializer.prepare(this, classPathRep);
        }
        String className = this.getComponentClassName();
        if (className != null) {
            PaletteItem.checkDefaultPackage(className, classPathRep);
        }
        return true;
    }

    public void initializeComponent(RADComponent component) {
        if (this.componentInitializer != null) {
            this.componentInitializer.initializeComponent(component);
            this.componentInitializer = null;
        }
    }

    public boolean isVisual() {
        if (this.componentType == -1) {
            this.resolveComponentType();
        }
        return (this.componentType & 4) != 0;
    }

    public boolean isMenu() {
        if (this.componentType == -1) {
            this.resolveComponentType();
        }
        return (this.componentType & 8) != 0;
    }

    public boolean isLayout() {
        if (this.componentType == -1) {
            this.resolveComponentType();
        }
        return (this.componentType & 0xF) == 1;
    }

    public boolean isBorder() {
        if (this.componentType == -1) {
            this.resolveComponentType();
        }
        return (this.componentType & 0xF) == 2;
    }

    public String toString() {
        return PaletteUtils.getItemComponentDescription(this);
    }

    String getDisplayName() {
        BeanDescriptor bd = this.getBeanDescriptor();
        return bd != null ? bd.getDisplayName() : null;
    }

    String getTooltip() {
        BeanDescriptor bd = this.getBeanDescriptor();
        return bd != null ? bd.getShortDescription() : null;
    }

    public Image getIcon(int type) {
        if (this.icon != null) {
            return this.icon;
        }
        BeanInfo bi = this.getBeanInfo();
        return bi != null ? bi.getIcon(type) : null;
    }

    public void setIcon(Image icon) {
        this.icon = icon;
    }

    void reset() {
        this.componentClass = null;
        this.lastError = null;
        this.componentType = -1;
        this.itemDataObject.displayName = null;
        this.itemDataObject.tooltip = null;
        this.itemDataObject.icon16 = null;
        this.itemDataObject.icon32 = null;
    }

    static boolean checkDefaultPackage(String className, FileObject classPathRep) {
        if (className.indexOf(46) == -1) {
            String resName;
            ClassPath cp = ClassPath.getClassPath((FileObject)classPathRep, (String)"classpath/source");
            String string = resName = cp != null ? cp.getResourceName(classPathRep) : null;
            if (resName != null && resName.indexOf(47) > 0) {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)FormUtils.getBundleString("MSG_DefaultPackageBean"), 2));
                return false;
            }
        }
        return true;
    }

    private Class loadComponentClass() {
        try {
            if (this.cpRepresentative != null) {
                return ClassPathUtils.loadClass(this.getComponentClassSource().getClassName(), this.cpRepresentative);
            }
            return ClassPathUtils.loadClass(this.getComponentClassSource());
        }
        catch (Exception ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
            this.lastError = ex;
        }
        catch (LinkageError ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
            this.lastError = ex;
        }
        return null;
    }

    private BeanInfo getBeanInfo() {
        Class compClass = this.getComponentClass();
        if (compClass != null) {
            try {
                return FormUtils.getBeanInfo(compClass);
            }
            catch (Exception ex) {
            }
            catch (Error error) {
                // empty catch block
            }
        }
        return null;
    }

    private BeanDescriptor getBeanDescriptor() {
        Class compClass = this.getComponentClass();
        if (compClass != null) {
            try {
                return FormUtils.getBeanInfo(compClass).getBeanDescriptor();
            }
            catch (Exception ex) {
            }
            catch (Error error) {
                // empty catch block
            }
        }
        return null;
    }

    private void resolveComponentType() {
        if (this.componentType_explicit == null) {
            this.componentType = 0;
            Class compClass = this.getComponentClass();
            if (compClass == null) {
                return;
            }
            if (LayoutManager.class.isAssignableFrom(compClass)) {
                this.componentType = 1;
                return;
            }
            if (Border.class.isAssignableFrom(compClass)) {
                this.componentType = 2;
                return;
            }
            if (Component.class.isAssignableFrom(compClass)) {
                this.componentType |= 4;
            }
            if (MenuComponent.class.isAssignableFrom(compClass) || JMenuItem.class.isAssignableFrom(compClass) || JMenuBar.class.isAssignableFrom(compClass) || JPopupMenu.class.isAssignableFrom(compClass)) {
                this.componentType |= 8;
            }
        } else {
            this.componentType = "visual".equalsIgnoreCase(this.componentType_explicit) ? 4 : ("layout".equalsIgnoreCase(this.componentType_explicit) ? 1 : ("border".equalsIgnoreCase(this.componentType_explicit) ? 2 : ("menu".equalsIgnoreCase(this.componentType_explicit) ? 12 : 0)));
        }
    }

    static interface ComponentInitializer {
        public boolean prepare(PaletteItem var1, FileObject var2);

        public void initializeComponent(RADComponent var1);
    }
}

