/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.layoutdesign;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.netbeans.modules.form.layoutdesign.LayoutConstants;
import org.netbeans.modules.form.layoutdesign.LayoutInterval;
import org.netbeans.modules.form.layoutdesign.LayoutRegion;
import org.netbeans.modules.form.layoutdesign.LayoutUtils;

public class LayoutPosition
implements LayoutConstants {
    static OriginalPosition getOriginalPosition(List<LayoutInterval> components, List<LayoutInterval> inCommonParent, int dimension) {
        LayoutInterval first = inCommonParent.get(0);
        LayoutInterval last = inCommonParent.get(inCommonParent.size() - 1);
        LayoutInterval parent = first.getParent();
        LayoutInterval parParent = LayoutInterval.getFirstParent(first, 103);
        OriginalPosition pos = new OriginalPosition();
        pos.root = LayoutInterval.getRoot(first);
        OriginalPosition.access$102(pos, new InSequence[2]);
        for (int i = 0; i <= 1; ++i) {
            ((OriginalPosition)pos).inSequence[i] = LayoutPosition.getSequentialPosition(i == 0 ? first : last, dimension, i);
        }
        LayoutInterval parentSeq = LayoutPosition.getCommonSequence(pos);
        int definedAlign = -1;
        for (LayoutInterval li : inCommonParent) {
            if (li.getParent() != parParent) continue;
            int align = li.getAlignment();
            if (definedAlign == -1) {
                definedAlign = align;
                continue;
            }
            if (definedAlign == align) continue;
            definedAlign = Integer.MIN_VALUE;
            break;
        }
        if (definedAlign == Integer.MIN_VALUE) {
            definedAlign = -1;
        }
        int effAlign = -1;
        boolean discontinuousClosedAlign = false;
        if (parentSeq == null || parentSeq.isParentOf(parParent)) {
            OriginalPosition.access$202(pos, new InParallel[4]);
            if (parParent.getGroupAlignment() == 2 || parParent.getGroupAlignment() == 3) {
                effAlign = parParent.getGroupAlignment();
                ((OriginalPosition)pos).inParallel[effAlign] = LayoutPosition.getParallelPosition(inCommonParent, dimension, effAlign);
            } else {
                if (parent.isSequential()) {
                    int e2;
                    int e1 = LayoutInterval.getEffectiveAlignment(first, 0, false);
                    if (e1 == (e2 = LayoutInterval.getEffectiveAlignment(last, 1, false)) || e2 == -1) {
                        effAlign = e1;
                    } else if (e1 == -1) {
                        effAlign = e2;
                    }
                } else {
                    effAlign = LayoutInterval.getEffectiveAlignment(first);
                }
                for (int i = 0; i <= 1; ++i) {
                    ((OriginalPosition)pos).inParallel[i] = LayoutPosition.getParallelPosition(inCommonParent, dimension, i);
                }
                if (components.size() > 1 && !pos.inParallel[0].indent && !pos.inParallel[1].indent) {
                    boolean sameGroup = true;
                    LayoutInterval group = null;
                    for (LayoutInterval comp : components) {
                        int a = comp.getAlignment();
                        if (a == 2 || a == 3) {
                            discontinuousClosedAlign = true;
                        }
                        LayoutInterval p = comp.getParent();
                        if (sameGroup && (group == null || group == p)) {
                            group = p;
                            continue;
                        }
                        sameGroup = false;
                    }
                    if (sameGroup) {
                        discontinuousClosedAlign = false;
                    }
                }
            }
            pos.groupSpace = new LayoutRegion();
            pos.groupSpace.set(dimension, parParent.getCurrentSpace());
        }
        pos.definedAlignment = definedAlign;
        pos.effectiveAlignment = effAlign;
        pos.discontinuousClosedAlignment = discontinuousClosedAlign;
        boolean wholeResizing = inCommonParent.size() == 1 || parParent.isParallel();
        boolean suppResChecked = false;
        boolean suppressedResizing = false;
        for (LayoutInterval li : inCommonParent) {
            if (LayoutInterval.wantResize(li)) {
                if (suppResChecked) continue;
                suppressedResizing = !LayoutInterval.canResizeInLayout(li);
                suppResChecked = true;
                continue;
            }
            wholeResizing = false;
        }
        pos.wholeResizing = wholeResizing;
        pos.suppressedResizing = suppressedResizing;
        return pos;
    }

    /*
     * Enabled aggressive block sorting
     */
    static IncludeDesc getInclusionFromOriginal(OriginalPosition orig, int dimension, int alignment) {
        int index;
        LayoutInterval neighborInSeq;
        LayoutInterval parent;
        LayoutInterval parallelComp;
        InParallel par;
        LayoutInterval trailingNeighbor;
        LayoutInterval leadingNeighbor;
        IncludeDesc incl;
        block52: {
            LayoutInterval p;
            LayoutInterval parParent;
            block54: {
                int origAlign;
                block51: {
                    block53: {
                        block49: {
                            block47: {
                                block50: {
                                    block48: {
                                        if (alignment < 0) {
                                            alignment = LayoutPosition.getBaseAlignment(orig);
                                        }
                                        origAlign = orig.getAlignedEdges();
                                        incl = new IncludeDesc();
                                        leadingNeighbor = LayoutPosition.getNeighborInSequence(orig, 0);
                                        trailingNeighbor = LayoutPosition.getNeighborInSequence(orig, 1);
                                        LayoutInterval parentSeq = LayoutPosition.getCommonSequence(orig);
                                        par = orig.inParallel != null ? orig.inParallel[(origAlign == 2 || origAlign == 3) && alignment != origAlign ? origAlign : alignment] : null;
                                        LayoutInterval layoutInterval = parallelComp = par != null ? par.componentNeighbor : null;
                                        if (parallelComp != null) break block47;
                                        if (parentSeq == null) break block48;
                                        parent = parentSeq;
                                        break block49;
                                    }
                                    if (leadingNeighbor == null && trailingNeighbor == null) break block50;
                                    LayoutInterval oneNeighbor = leadingNeighbor != null ? leadingNeighbor : trailingNeighbor;
                                    LayoutInterval seqParent = null;
                                    for (parent = oneNeighbor.getParent(); parent != null; parent = parent.getParent()) {
                                        if (!parent.isSequential()) continue;
                                        seqParent = parent;
                                    }
                                    if (seqParent != null) {
                                        parent = seqParent;
                                        break block49;
                                    } else {
                                        parent = oneNeighbor.getParent();
                                        if (parent == null) {
                                            assert (oneNeighbor == orig.root);
                                            parent = oneNeighbor;
                                        }
                                    }
                                    break block49;
                                }
                                parent = orig.root;
                                break block49;
                            }
                            parent = parallelComp.getParent();
                            for (int d = par.componentNeighborDepth; !(d <= 0 || parent.getParent() == null || leadingNeighbor != null && parent.isParentOf(leadingNeighbor) || trailingNeighbor != null && parent.isParentOf(trailingNeighbor)); parent = parent.getParent(), --d) {
                            }
                            if (parent.isSequential()) {
                                incl.newSubGroup = true;
                            }
                        }
                        if (parent.isParallel()) {
                            int neighborDirection;
                            LayoutInterval neighborInSeq2;
                            if (trailingNeighbor != null && parent.isParentOf(trailingNeighbor)) {
                                neighborInSeq2 = trailingNeighbor;
                                neighborDirection = 1;
                            } else if (leadingNeighbor != null && parent.isParentOf(leadingNeighbor)) {
                                neighborInSeq2 = leadingNeighbor;
                                neighborDirection = 0;
                            } else {
                                neighborInSeq2 = null;
                                neighborDirection = -1;
                            }
                            if (neighborInSeq2 != null) {
                                List<LayoutInterval> allSeqNeighbors = LayoutPosition.getSequentialNeighbors(orig, neighborDirection);
                                boolean compact = neighborInSeq2.isParallel() || allSeqNeighbors.size() == 1;
                                LayoutInterval p2 = neighborInSeq2.getParent();
                                if (p2 == parent) {
                                    if (compact) {
                                        incl.neighbor = neighborInSeq2;
                                        incl.index = neighborDirection == 1 ? 0 : 1;
                                    }
                                } else {
                                    LayoutInterval pp;
                                    do {
                                        if (p2.isParallel()) {
                                            List<LayoutInterval> list = LayoutUtils.getSideComponents(p2, neighborDirection ^ 1, false, false);
                                            list.removeAll(allSeqNeighbors);
                                            if (!list.isEmpty()) {
                                                parent = p2;
                                                incl.neighbor = neighborInSeq2;
                                                incl.index = neighborDirection == 1 ? 0 : 1;
                                                break;
                                            }
                                        }
                                        if ((pp = p2.getParent()) != parent) continue;
                                        if (p2.isParallel()) {
                                            if (!compact) break;
                                            incl.neighbor = p2;
                                            incl.index = neighborDirection == 1 ? 0 : 1;
                                            break;
                                        }
                                        parent = p2;
                                        incl.index = neighborDirection == 1 ? 0 : p2.getSubIntervalCount();
                                        break;
                                    } while ((p2 = pp) != null);
                                }
                            }
                        }
                        incl.parent = parent;
                        if (parent.isSequential() && !incl.newSubGroup) {
                            int i;
                            LayoutInterval neighborInSeq3;
                            if (leadingNeighbor != null && parent.isParentOf(leadingNeighbor) && (neighborInSeq3 = LayoutInterval.getDirectNeighbor(parent.getSubInterval(i = LayoutInterval.getIndexInParent(leadingNeighbor, parent)), 1, true)) != null && neighborInSeq3 != trailingNeighbor && (trailingNeighbor == null || !neighborInSeq3.isParentOf(trailingNeighbor))) {
                                incl.newSubGroup = true;
                            }
                            if (trailingNeighbor != null && parent.isParentOf(trailingNeighbor) && (neighborInSeq3 = LayoutInterval.getDirectNeighbor(parent.getSubInterval(i = LayoutInterval.getIndexInParent(trailingNeighbor, parent)), 0, true)) != null && neighborInSeq3 != leadingNeighbor && (leadingNeighbor == null || !neighborInSeq3.isParentOf(leadingNeighbor))) {
                                incl.newSubGroup = true;
                            }
                        }
                        incl.alignment = alignment;
                        if (origAlign != 0 && origAlign != 1 && origAlign != Integer.MAX_VALUE) break block51;
                        if (par == null || !par.aligned) break block52;
                        LayoutInterval layoutInterval = parParent = parent.isParallel() ? parent : parent.getParent();
                        if (parallelComp != null) break block53;
                        if (parParent == orig.root) {
                            incl.snappedParallel = orig.root;
                            break block52;
                        } else if (LayoutInterval.isAlignedAtBorder(parParent, orig.root, alignment)) {
                            incl.snappedParallel = parParent;
                        }
                        break block52;
                    }
                    if (!par.componentNeighborAtBorder) break block52;
                    break block54;
                }
                if (origAlign == 2 || origAlign == 3) {
                    incl.alignment = origAlign;
                    incl.snappedParallel = parent.getGroupAlignment() == origAlign ? parent : par.componentNeighbor;
                }
                break block52;
            }
            LayoutInterval aligned = parallelComp;
            LayoutInterval prev = null;
            do {
                if ((p = aligned.getParent()).isSequential()) {
                    prev = aligned;
                    aligned = p;
                    p = p.getParent();
                }
                if (p == parParent) {
                    if (parent == parParent && (!aligned.isSequential() || LayoutInterval.isAlignedAtBorder(prev, parent, alignment))) {
                        incl.snappedParallel = parent;
                        break;
                    }
                    incl.snappedParallel = aligned.isSequential() ? prev : aligned;
                    break;
                }
                if (!LayoutInterval.isAlignedAtBorder(aligned, alignment) || p.getCurrentSpace().positions[dimension][alignment] != ((OriginalPosition)orig).groupSpace.positions[dimension][alignment]) break;
                prev = aligned;
            } while ((aligned = p).getParent() != null);
        }
        if (alignment == 0 || alignment == 1) {
            InSequence s;
            if (incl.snappedParallel == null && par != null && par.indent && parent.isSequential() && parallelComp != null && parallelComp.getParent() == parent) {
                incl.snappedParallel = parallelComp;
            }
            if (incl.snappedParallel == null) {
                for (int a = 0; a <= 1; ++a) {
                    s = orig.inSequence[a];
                    if (a != alignment || s == null || !s.snapped) continue;
                    LayoutInterval layoutInterval = neighborInSeq = a == 0 ? leadingNeighbor : trailingNeighbor;
                    if (neighborInSeq != null) {
                        if (parent.isParentOf(neighborInSeq)) {
                            index = LayoutInterval.getIndexInParent(neighborInSeq, parent);
                            if (index <= -1) continue;
                            incl.snappedNextTo = parent.getSubInterval(index);
                            incl.paddingType = s.paddingType;
                            continue;
                        }
                        if (!neighborInSeq.getParent().isParentOf(parent)) continue;
                        incl.snappedNextTo = neighborInSeq;
                        incl.paddingType = s.paddingType;
                        continue;
                    }
                    incl.snappedNextTo = orig.root;
                }
            }
            for (int a = 0; a <= 1; ++a) {
                s = orig.inSequence[a];
                if (a != alignment || s == null) continue;
                incl.fixedPosition = s.fixedRelativePosition;
            }
        }
        if (!parent.isSequential()) return incl;
        if (incl.index >= 0) return incl;
        if (parent.getSubIntervalCount() <= 0) return incl;
        int a = alignment;
        if (a != 0 && a != 1) {
            a = 0;
        }
        int n = 2;
        while (n > 0) {
            LayoutInterval layoutInterval = neighborInSeq = a == 0 ? leadingNeighbor : trailingNeighbor;
            if (neighborInSeq != null) {
                index = LayoutInterval.getIndexInParent(neighborInSeq, parent);
                if (index > -1) {
                    if (a == 0 && ++index + 1 <= parent.getSubIntervalCount()) {
                        ++index;
                    }
                    incl.index = index;
                    return incl;
                }
            } else if (incl.newSubGroup) {
                index = a == 0 ? 0 : parent.getSubIntervalCount();
                if (parent.getSubInterval(index - (a == 1 ? 1 : 0)).isEmptySpace() && orig.inParallel != null && orig.inParallel[a] != null && ((OriginalPosition)orig).inParallel[a].componentNeighborAtBorder) {
                    index += a == 0 ? 1 : -1;
                }
                incl.index = index;
                return incl;
            }
            a ^= 1;
            --n;
        }
        return incl;
    }

    private static InSequence getSequentialPosition(LayoutInterval interval, int dimension, int alignment) {
        List<LayoutInterval> neighbors;
        LayoutInterval prev;
        LayoutInterval neighbor = null;
        boolean snapped = false;
        LayoutConstants.PaddingType paddingType = null;
        LayoutInterval gap = LayoutInterval.getNeighbor(interval, alignment, false, true, false);
        if (gap != null && LayoutInterval.isFixedDefaultPadding(gap) && ((prev = LayoutInterval.getDirectNeighbor(gap, alignment ^ 1, true)) == interval || LayoutInterval.isPlacedAtBorder(interval, prev, dimension, alignment))) {
            LayoutInterval next = LayoutInterval.getNeighbor(gap, alignment, true, true, false);
            if (next != null) {
                if (next.getParent() == gap.getParent() || next.getCurrentSpace().positions[dimension][alignment ^ 1] == gap.getParent().getCurrentSpace().positions[dimension][alignment]) {
                    neighbor = next;
                    paddingType = gap.getPaddingType();
                }
            } else {
                next = LayoutInterval.getRoot(interval);
                if (LayoutInterval.isPlacedAtBorder(gap.getParent(), next, dimension, alignment)) {
                    neighbor = next;
                }
            }
        }
        if (neighbor != null) {
            snapped = true;
        } else {
            neighbor = LayoutInterval.getNeighbor(interval, alignment, true, true, false);
        }
        if (neighbor != null && !neighbor.isParentOf(interval)) {
            LayoutInterval first = LayoutUtils.getOutermostComponent(neighbor, dimension, alignment ^ 1);
            neighbors = LayoutUtils.getSideComponents(neighbor, alignment ^ 1, false, false);
            if (first != null) {
                neighbors.remove(first);
                neighbors.add(0, first);
            }
            if (neighbors.isEmpty()) {
                neighbors = null;
            }
        } else {
            neighbors = null;
        }
        InSequence seqPos = new InSequence();
        seqPos.componentNeighbors = neighbors;
        seqPos.snapped = snapped;
        seqPos.paddingType = paddingType;
        seqPos.fixedRelativePosition = LayoutPosition.isFixedRelativePosition(interval, alignment);
        return seqPos;
    }

    private static InParallel getParallelPosition(List<LayoutInterval> inCommonParent, int dimension, int alignment) {
        LayoutInterval indentGap;
        LayoutInterval one;
        LayoutInterval seq;
        InParallel par = new InParallel();
        LayoutInterval parParent = LayoutInterval.getFirstParent(inCommonParent.get(0), 103);
        if (alignment == 2 || alignment == 3) {
            par.aligned = true;
            par.closedGroupEdge = true;
        } else if (alignment == 0 || alignment == 1) {
            for (LayoutInterval interval : inCommonParent) {
                if (par.aligned || !LayoutInterval.isAlignedAtBorder(interval, parParent, alignment) || LayoutUtils.getSideComponents(interval, alignment, true, true).isEmpty()) continue;
                par.aligned = true;
                par.closedGroupEdge = true;
                break;
            }
        }
        if (parParent.getParent() == null) {
            par.closedGroupEdge = true;
        }
        LayoutInterval parallelComp = null;
        boolean parCompAligned = false;
        boolean parCompAtBorder = false;
        int parCompDepth = 0;
        Iterator<LayoutInterval> it = parParent.getSubIntervals();
        while (it.hasNext()) {
            LayoutInterval interval = it.next();
            boolean containsSelection = false;
            for (LayoutInterval sel : inCommonParent) {
                if (interval != sel && !interval.isParentOf(sel)) continue;
                containsSelection = true;
                break;
            }
            if (containsSelection) continue;
            Iterator<LayoutInterval> it2 = LayoutUtils.getComponentIterator(interval);
            while (it2.hasNext()) {
                boolean atBorder;
                boolean aligned;
                LayoutInterval li = it2.next();
                if (!li.isComponent()) continue;
                if (par.aligned) {
                    if (alignment == 0 || alignment == 1) {
                        aligned = LayoutInterval.isAlignedAtBorder(li, parParent, alignment);
                        atBorder = aligned || LayoutInterval.isPlacedAtBorder(li, parParent, dimension, alignment);
                    } else {
                        aligned = true;
                        atBorder = LayoutInterval.isPlacedAtBorder(li, parParent, dimension, 0) || LayoutInterval.isPlacedAtBorder(li, parParent, dimension, 1);
                    }
                } else {
                    aligned = false;
                    atBorder = false;
                }
                int depth = LayoutInterval.getDepthInParent(li, parParent);
                boolean better = false;
                if (parallelComp == null) {
                    better = true;
                } else if (aligned && !parCompAligned) {
                    better = true;
                } else if (aligned == parCompAligned) {
                    if (atBorder && !parCompAtBorder) {
                        better = true;
                    } else if (atBorder == parCompAtBorder && (depth < parCompDepth || depth == parCompDepth && alignment == 1)) {
                        better = true;
                    }
                }
                if (better) {
                    parallelComp = li;
                    parCompAligned = aligned;
                    parCompAtBorder = atBorder;
                    parCompDepth = depth;
                }
                if (!aligned || par.closedGroupEdge) continue;
                par.closedGroupEdge = true;
            }
        }
        par.componentNeighbor = parallelComp;
        par.componentNeighborDepth = parCompDepth - 1;
        par.componentNeighborAtBorder = parCompAtBorder;
        if ((alignment == 0 || alignment == 1) && inCommonParent.size() == 1 && !par.aligned && parallelComp != null && LayoutInterval.isAlignedAtBorder(parallelComp, parParent, alignment) && (seq = (one = inCommonParent.get(0)).getParent()).isSequential() && LayoutInterval.getCount(seq, -1, true) == 1 && (indentGap = LayoutInterval.getDirectNeighbor(one, alignment, false)) != null && indentGap.isEmptySpace() && !LayoutInterval.canResize(indentGap) && !LayoutInterval.isAlignedAtBorder(seq, LayoutInterval.getRoot(parParent), alignment) && indentGap.getPreferredSize() < parallelComp.getCurrentSpace().size(dimension)) {
            par.indent = true;
        }
        return par;
    }

    private static boolean isFixedRelativePosition(LayoutInterval interval, int edge) {
        assert (edge == 0 || edge == 1);
        LayoutInterval parent = interval.getParent();
        if (parent == null) {
            return true;
        }
        if (parent.isSequential()) {
            LayoutInterval li = LayoutInterval.getDirectNeighbor(interval, edge, false);
            if (li != null) {
                return !LayoutInterval.wantResize(li);
            }
            interval = parent;
            parent = interval.getParent();
        }
        if (!LayoutInterval.isAlignedAtBorder(interval, parent, edge) && LayoutInterval.contentWantResize(parent)) {
            return false;
        }
        return LayoutPosition.isFixedRelativePosition(parent, edge);
    }

    private static LayoutInterval getCommonSequence(OriginalPosition orig) {
        if (orig.inSequence != null) {
            InSequence s1 = orig.inSequence[0];
            InSequence s2 = orig.inSequence[1];
            if (s1 != null && s2 != null && s1.componentNeighbors != null && s2.componentNeighbors != null) {
                return LayoutInterval.getCommonParent(s1.componentNeighbors.get(0), s2.componentNeighbors.get(0));
            }
        }
        return null;
    }

    private static LayoutInterval getNeighborInSequence(OriginalPosition orig, int alignment) {
        InSequence s;
        InSequence inSequence = s = orig.inSequence != null ? orig.inSequence[alignment] : null;
        if (s != null && s.componentNeighbors != null) {
            List<LayoutInterval> sideComps;
            LayoutInterval[] intervals;
            LayoutInterval commonParent;
            int count = s.componentNeighbors.size();
            if (count > 1 && (commonParent = LayoutInterval.getCommonParent(intervals = s.componentNeighbors.toArray(new LayoutInterval[count]))) != null && commonParent.isParallel() && (sideComps = LayoutUtils.getSideComponents(commonParent, alignment ^ 1, false, false)) != null && sideComps.size() == count) {
                return commonParent;
            }
            return s.componentNeighbors.get(0);
        }
        return null;
    }

    private static List<LayoutInterval> getSequentialNeighbors(OriginalPosition orig, int alignment) {
        InSequence s;
        InSequence inSequence = s = orig.inSequence != null ? orig.inSequence[alignment] : null;
        if (s != null && s.componentNeighbors != null) {
            return s.componentNeighbors;
        }
        return Collections.EMPTY_LIST;
    }

    private static int getBaseAlignment(OriginalPosition orig) {
        int alignment = orig.getAlignedEdges();
        if (alignment == 0 || alignment == 1 || alignment == 2 || alignment == 3) {
            return alignment;
        }
        if (orig.definedAlignment != -1) {
            return orig.definedAlignment;
        }
        InSequence lPos = null;
        InSequence tPos = null;
        if (orig.inSequence != null) {
            for (int a = 0; a < orig.inSequence.length; ++a) {
                InSequence seqPos = orig.inSequence[a];
                InSequence other = orig.inSequence[a ^ 1];
                if (seqPos != null && seqPos.snapped && (other == null || !other.snapped)) {
                    return a;
                }
                if (lPos != null) continue;
                lPos = seqPos;
                tPos = other;
            }
        }
        if (orig.effectiveAlignment != -1) {
            return orig.effectiveAlignment;
        }
        if (lPos != null && tPos != null) {
            if (lPos.fixedRelativePosition) {
                return 0;
            }
            if (tPos.fixedRelativePosition) {
                return 1;
            }
        }
        return lPos != null || tPos == null ? 0 : 1;
    }

    private static class InParallel {
        boolean aligned;
        LayoutInterval componentNeighbor;
        int componentNeighborDepth;
        boolean componentNeighborAtBorder;
        boolean closedGroupEdge;
        private boolean indent;

        private InParallel() {
        }
    }

    private static class InSequence {
        List<LayoutInterval> componentNeighbors;
        boolean snapped;
        LayoutConstants.PaddingType paddingType;
        boolean fixedRelativePosition;

        private InSequence() {
        }
    }

    static final class IncludeDesc {
        LayoutInterval parent;
        int index = -1;
        boolean newSubGroup;
        LayoutInterval neighbor;
        LayoutInterval snappedParallel;
        LayoutInterval snappedNextTo;
        LayoutConstants.PaddingType paddingType;
        int alignment = -1;
        boolean fixedPosition;
        int distance = Integer.MAX_VALUE;
        int ortDistance = Integer.MAX_VALUE;

        IncludeDesc() {
        }

        boolean snapped() {
            return this.snappedNextTo != null || this.snappedParallel != null;
        }
    }

    static final class OriginalPosition {
        private LayoutInterval root;
        private InSequence[] inSequence;
        private InParallel[] inParallel;
        private int definedAlignment;
        private int effectiveAlignment;
        private boolean discontinuousClosedAlignment;
        private LayoutRegion groupSpace;
        private boolean suppressedResizing;
        private boolean wholeResizing;

        OriginalPosition() {
        }

        int getAlignment() {
            return this.definedAlignment;
        }

        boolean snapped(int alignment) {
            if ((alignment == 0 || alignment == 1) && this.inSequence != null && this.inSequence[alignment] != null && this.inSequence[alignment].snapped) {
                return true;
            }
            return (alignment == 0 || alignment == 1 || alignment == 2 || alignment == 3) && this.inParallel != null && this.inParallel[alignment] != null && this.inParallel[alignment].aligned;
        }

        private int getAlignedEdges() {
            int alignment = -1;
            if (this.inParallel != null) {
                for (int a = 0; a <= 3; ++a) {
                    if (this.inParallel[a] == null || !this.inParallel[a].aligned) continue;
                    if (alignment == -1) {
                        alignment = a;
                    } else if (a == 0 || a == 1) {
                        alignment = Integer.MAX_VALUE;
                    }
                    if (a != 0) break;
                }
            }
            return alignment;
        }

        void changeAlignment(int oldA, int newA) {
            this.inParallel[newA] = this.inParallel[oldA];
            this.inParallel[oldA] = null;
        }

        boolean isClosedAlignment() {
            return this.definedAlignment == 2 || this.definedAlignment == 3 || this.discontinuousClosedAlignment;
        }

        LayoutInterval getAlignedRep(int alignment) {
            InParallel parallel;
            InParallel inParallel = parallel = (alignment == 0 || alignment == 1 || alignment == 2 || alignment == 3) && this.inParallel != null ? this.inParallel[alignment] : null;
            if (parallel != null) {
                return parallel.componentNeighbor;
            }
            return null;
        }

        LayoutRegion getGroupSpace() {
            return this.groupSpace;
        }

        boolean isClosedSpace(int alignment) {
            return (alignment == 0 || alignment == 1 || alignment == 2 || alignment == 3) && this.inParallel != null && this.inParallel[alignment] != null && this.inParallel[alignment].closedGroupEdge;
        }

        boolean isSuppressedResizing() {
            return this.suppressedResizing;
        }

        boolean isWholeResizing() {
            return this.wholeResizing;
        }

        boolean atFixedPosition(int alignment) {
            return (alignment == 0 || alignment == 1) && this.inSequence != null && this.inSequence[alignment] != null && this.inSequence[alignment].fixedRelativePosition;
        }

        boolean wasInSequence(LayoutInterval interval, int dimension, boolean fully) {
            if (this.inSequence == null) {
                return false;
            }
            boolean somethingInSeq = false;
            Iterator<LayoutInterval> it = LayoutUtils.getComponentIterator(interval);
            while (it.hasNext()) {
                LayoutInterval comp = it.next();
                boolean inSeq = false;
                for (int i = 0; i <= 1; ++i) {
                    InSequence seq = this.inSequence[i];
                    if (seq == null || seq.componentNeighbors == null) continue;
                    for (LayoutInterval li : seq.componentNeighbors) {
                        LayoutInterval commonParent;
                        if (comp == li) {
                            inSeq = true;
                        } else if (LayoutRegion.distance(comp.getCurrentSpace(), li.getCurrentSpace(), dimension, i ^ 1, i) * (i == 0 ? 1 : -1) >= 0 && (commonParent = LayoutInterval.getCommonParent(comp, li)) != null && commonParent.isSequential()) {
                            inSeq = true;
                        }
                        if (!inSeq) continue;
                        somethingInSeq = true;
                        break;
                    }
                    if (inSeq) break;
                }
                if ((inSeq || !fully) && (!inSeq || fully)) continue;
                break;
            }
            return somethingInSeq;
        }

        static /* synthetic */ InSequence[] access$102(OriginalPosition x0, InSequence[] x1) {
            x0.inSequence = x1;
            return x1;
        }

        static /* synthetic */ InParallel[] access$202(OriginalPosition x0, InParallel[] x1) {
            x0.inParallel = x1;
            return x1;
        }
    }
}

